/*
 *  ADDR.H
 *
 *  Released to the public domain.
 *
 *  Prototypes for ADDR.C.
 */

#ifndef __ADDR_H__
#define __ADDR_H__

/*
 *  Structure defining a "five-dimensional" FidoNet address, or an
 *  Internet address (stored in the domain).
 */

typedef struct _address
{
    unsigned int zone;
    unsigned int net;
    unsigned int node;
    unsigned int point;
    char *domain;
    unsigned int notfound : 1;
    unsigned int fidonet  : 1;
    unsigned int internet : 1;
    unsigned int bangpath : 1;
}
ADDRESS;

char *show_address(ADDRESS * a);
char *show_4d(ADDRESS * a);
ADDRESS parsenode(char *t);

#endif
