/*
 *  ADDR.C
 *
 *  Released to the public domain.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include "addr.h"
#include "nedit.h"
#include "xmalloc.h"
#include "msged.h"

char *show_address(ADDRESS * a)
{
    static char s[80];
    char field[20];

    memset(s, 0, sizeof s);
    memset(field, 0, sizeof field);

    if (a->notfound)
    {
        strcpy(s, "0:0/0");
        return s;
    }
    if (a->fidonet)
    {
        if (a->zone)
        {
            sprintf(field, "%d", a->zone);
            strcat(s, field);
            strcat(s, ":");
        }
        sprintf(field, "%d", a->net);
        strcat(s, field);
        strcat(s, "/");
        sprintf(field, "%d", a->node);
        strcat(s, field);
        if (a->point)
        {
            strcat(s, ".");
            sprintf(field, "%d", a->point);
            strcat(s, field);
        }
        if (a->domain != NULL)
        {
            strcat(s, "@");
            strcat(s, a->domain);
        }
    }
    if (a->internet && a->domain != NULL)
    {
        strncpy(s, a->domain, 60);
    }
    if (a->bangpath)
    {
        char *t, *t1;

        t1 = strrchr(a->domain, '!');
        if (t1 == NULL)
        {
            strcpy(s, a->domain);
        }
        else
        {
            *t1 = '\0';
            t = strrchr(a->domain, '!');
            if (!t)
            {
                t = a->domain;
            }
            *t1 = '!';
            strcat(strcpy(s, "..."), t);
        }

    }
    return s;
}

char *show_4d(ADDRESS * a)
{
    static char s[80];
    char field[20];

    memset(s, 0, sizeof s);
    memset(field, 0, sizeof field);

    if (a->notfound)
    {
        strcpy(s, "0:0/0");
        return s;
    }
    if (a->fidonet)
    {
        if (a->zone)
        {
            sprintf(field, "%d", a->zone);
            strcat(s, field);
            strcat(s, ":");
        }
        sprintf(field, "%d", a->net);
        strcat(s, field);
        strcat(s, "/");
        sprintf(field, "%d", a->node);
        strcat(s, field);
        if (a->point)
        {
            strcat(s, ".");
            sprintf(field, "%d", a->point);
            strcat(s, field);
        }
    }
    if (a->internet)
    {
        strncpy(s, a->domain, 60);
    }
    if (a->bangpath)
    {
        char *t, *t1;

        t1 = strrchr(a->domain, '!');
        if (t1 == NULL)
        {
            strcpy(s, a->domain);
        }
        else
        {
            *t1 = '\0';
            t = strrchr(a->domain, '!');
            if (!t)
            {
                t = a->domain;
            }
            *t1 = '!';
            strcat(strcpy(s, "..."), t);
        }

    }
    return s;
}

static void resolve_address(ADDRESS * x)
{
    if (x->zone == 0)
    {
        x->zone = CurArea.addr.zone;
    }
    if (x->domain == NULL)
    {
        int i;
        for (i = 0; i < SW->aliascount; i++)
        {
            if (x->zone == alias[i].zone && x->net == alias[i].net &&
              x->node == alias[i].node && x->point == alias[i].point &&
              alias[i].domain && *(alias[i].domain))
            {
                x->domain = xstrdup(alias[i].domain);
                break;
            }
        }
    }
}

ADDRESS parsenode(char *t)
{
    ADDRESS tmp;
    int n, point = 0;
    char *s, ch;

    if (SW->areas)
    {
        tmp = CurArea.addr;
    }
    else
    {
        tmp = thisnode;
    }

    tmp.point = tmp.notfound = 0;
    tmp.fidonet = 1;
    tmp.internet = 0;
    tmp.bangpath = 0;
    tmp.domain = NULL;

    if (t == NULL)
    {
        tmp.notfound = 1;
        return tmp;
    }

    while (isspace(*t))
    {
        t++;
    }

    if (!isdigit(*t) && (*t != '.'))
    {
        tmp.notfound = 1;
        tmp.fidonet = 0;
        tmp.internet = 0;
        tmp.bangpath = 0;
        return tmp;
    }

    if (*t == '.')
    {
        tmp.net = CurArea.addr.net;
        point = 1;
        t++;
    }

    while (t)
    {
        n = (int)strtol(t, &t, 10);

        if (t == NULL)
        {
            if (point)
            {
                tmp.point = n;
            }
            else
            {
                tmp.node = n;
            }
            resolve_address(&tmp);
            return tmp;
        }

        switch (*t)
        {
        case ')':
        case ' ':
        case '\0':
            if (point)
            {
                tmp.point = n;
            }
            else
            {
                tmp.node = n;
            }
            resolve_address(&tmp);
            return tmp;

        case ':':
            tmp.zone = n;
            break;

        case '/':
            tmp.net = n;
            break;

        case '.':
            tmp.node = n;
            point = 1;
            break;

        case '@':
            if (point)
            {
                tmp.point = n;
            }
            else
            {
                tmp.node = n;
            }

            s = t + 1;
            while (*s && !isspace(*s) && *s != ')')
            {
                s++;
            }

            if (*s)
            {
                ch = *s;
                *s = '\0';
            }
            else
            {
                ch = 0;
            }

            if (tmp.domain != NULL)
            {
                xfree(tmp.domain);
            }
            tmp.domain = xstrdup(t + 1);

            if (ch)
            {
                *s = ch;
            }

            resolve_address(&tmp);
            return tmp;
        }
        t++;
    }

    resolve_address(&tmp);
    return tmp;
}
