(********************************************************)
(* 'C' Structures of FastEcho 1.41, File: FASTECHO.CFG  *)
(* (c)1994 by Tobias Burchhardt, Updated: 11 Apr 1994   *)
(********************************************************)
(* Pascal conversion by Hans Siemons                    *)
(* Last revision Juli 26, 1994                          *)
(*                                                      *)
(* Please refer to the original C structures for a more *)
(* detailed explanation on how to locate the different  *)
(* parts of the configuration file!                     *)
(********************************************************)

(********************************************************)
(* FASTECHO.CFG = <CONFIG>                              *)
(*                + <optional extensions>               *)
(*                + <CONFIG.BossCnt * Node>             *)
(*                + <CONFIG.AreaCnt * Area>             *)
(********************************************************)

Const REVISION=5;               (* current revision     *)

      MAX_AREAS=2048;                 (* max # of areas *)
      MAX_NODE=1024;                  (* max # of nodes *)
      MAX_GROUPS=26;                 (* max # of groups *)
      MAX_AKAS=16;                     (* max # of akas *)
      MAX_ROUTE=15;

(********************************************************)
(* CONFIG.flags                                         *)
(********************************************************)
Const
  RETEAR            =$00000001;
  AUTOCREATE        =$00000002;
  KILLEMPTY         =$00000004;
  KILLDUPES         =$00000008;
  FRONTDOOR         =$00000010;
  DBRIDGE           =$00000020;
  BINKLEY           =$00000040;
  INTERMAIL         =$00000080;
  SWAP_XMS          =$00000100;
  SWAP_EMS          =$00000200;
  SWAP_DISK         =$00000400;
  PURGE_PROCESSDATE =$00008000;
  MAILER_RESCAN     =$00010000;
  EXCLUDE_USERS     =$00020000;
  EXCLUDE_SYSOPS    =$00040000;
  CHECK_DESTINATION =$00080000;
  UPDATE_BBS_CONFIG =$00100000;
  KILL_GRUNGED_DATE =$00200000;
  NOT_BUFFER_EMS    =$00400000;
  KEEP_NETMAILS     =$00800000;
  NOT_UPDATE_MAILER =$01000000;
  NOT_CHECK_SEMAPHORES =$02000000;
  CREATE_SEMAPHORES    =$04000000;
  CHECK_COMPLETE       =$08000000;

(********************************************************)
(* CONFIG.BBSSoftware                                   *)
(********************************************************)

Type _BBSSoftware=(NoBBSSoft,RemoteAccess111,QuickBBS,SuperBBS,
                  ProBoard122,TagBBS,RemoteAccess200,ProBoard130);

(********************************************************)
(* CONFIG.CC.what                                       *)
(********************************************************)
Const FROMCC=1;
      TOCC=2;
      SUBJECTCC=3;


(********************************************************)
(* CONFIG.QuietLevel                                    *)
(********************************************************)
Const
  QUIET_PACK   =$0001;
  QUIET_UNPACK =$0002;
  QUIET_EXTERN =$0004;

(********************************************************)
(* CONFIG.Buffers                                       *)
(********************************************************)
Const
  BUF_LARGE  =$0000;
  BUF_MEDIUM =$0001;
  BUF_SMALL  =$0002;

(********************************************************)
(* CONFIG.arcext.inb/outb                               *)
(********************************************************)
Type ARCmailExt=(ARCDigits,ARChex,ARCAlpha);

(********************************************************)
(* CONFIG.AreaFixFlags                                  *)
(********************************************************)

Const ALLOWRESCAN=$01;
      KEEPREQUEST=$02;
      KEEPRECEIPT=$04;
      ALLOWREMOTE=$08;
      DETAILEDLIST=$10;
      ALLOWPASSWORD=$20;
      ALLOWPKTPWD=$40;

(********************************************************)
(* Area.board (1-200 = QBBS)                            *)
(********************************************************)
Const NO_BOARD=$4000;           (* everything but QBBS  *)
      DELETED=$8000;            (* never written        *)

(********************************************************)
(* Area.flags.type                                      *)
(********************************************************)
Const QBBS=0;
      FIDO=1;
      SQUISH=2;
      JAM=3;
      PT_BOARD=7;

(********************************************************)
(* Area.type                                            *)
(********************************************************)
Const AREA_ECHOMAIL=0;
      AREA_NETMAIL=1;
      AREA_LOCAL=2;
      AREA_BADMAILBOARD=3;
      AREA_DUPEBOARD=4;

(********************************************************)
(* Node.flags                                           *)
(********************************************************)
Const DDDD=$0001;
      TOSSCAN=$0002;
      DIRECT=$0004;
      CRASH=$0008;
      UMLAUT_NET=$0010;
      RESCANDISABLED=$0040;
      HOLD=$0080;
      DBUG=$0100;
      ARCMAIL060=$0200;
      PASSIVE=$0400;
      ALLOWAREACREATE=$0800;
      PACKER=$F000;

(********************************************************)
(* Index of used packer. $0f= .PKT, Don't pack          *)
(********************************************************)

(********************************************************)
(* Node.advflags                                        *)
(********************************************************)
Const
  EXPORTBYNAME =$0001;
  NOT_NOTIFY   =$0002;
  NOT_HELP     =$0004;
  NOATTACH     =$0008;
  NET_HOLD     =$0010;
  NET_CRASH    =$0020;
  NET_DIRECT   =$0040;

(********************************************************)
(* Structures                                           *)
(********************************************************)

Type Address=Record
               Zone,
               Net,
               Node,
               Point : Word;
             end;

Const _MAXPATH=56;

Type PathStr=Array[1.._MaxPath] of Char; { 0 terminated}
      Str2=array[1..2] of char;
      Str4=Array[1..4] of Char;
      Str9=Array[1..9] of char;
      Str10=Array[1..10] of Char;
      Str31=Array[1..31] of Char;
      Str28=Array[1..28] of Char;
      Str35=Array[1..35] of Char;
      Str36=Array[1..36] of Char;
      Str40=Array[1..40] of Char;
      Str41=Array[1..41] of Char;
      Str42=Array[1..42] of Char;

     PackerRecord=Record
              Tag : Str4;
              Name: array[1.._maxpath-2] of char;
              list: Str2;
            end;

     CCRecord=Record
         What : Byte;
         ObjectN : Str31;
         conference : word;
       end;

     AkasRecord=Record
            Main     : Address;
            Domain   : Str28;
            Pointnet : word;
            Flags    : LongInt;
          end;

     AreaDefaultsRecord=Record
                       Flags : Word; {0..4=Group
                                       5..7=Type, rest is reserved}

                       Read_Sec,
                       Write_Sec,
                       Days,
                       Messages : Integer;
                     end;
 
     SysopRecord=Record
                 Name:Str36;
                 Resv:LongInt;
               end;

     _rescan_def=Record
                   flags : word;
                   days : array[1..2] of word;
                   msgs : array[1..2] of word;
                 end;

     _arcext=record
                inb,
                outb : Byte;
              end;

     Configuration=Record
                    Revision : Integer;
                    Flags    : Longint;
                    NodeCnt,AreaCnt,Unused:Integer;
                    NetPath,
                    MsgBase,
                    Inbound,
                    Outbound,
                    Unpacker,
                    Logfile : PathStr;
                    OriginLine : Array[0..7] of PathStr;
                    StatFile,
                    SwapPath,
                    SemaphorePath,
                    BBSConfigPath,
                    DBQueuePath : PathStr;
                    UnUsed1:Array[1..32] of Char;
                    ReTearLine:Str40;
                    SecurePath : PathStr;
                    ExtAfter : array[1.._maxpath-4] of char;
                    ExtBefore : array[1.._maxpath-4] of char;
                    Packer:Array[1..8] of PackerRecord;
                    CC:Array[1..10] of CCRecord;
                    Security,
                    LogLevel:Byte;
                    Def_days,Def_Messages:Integer;
                    Akas:Array[1..11] of AkasRecord; (* obsolete but still
                                                             maintained *)
                    AutoRenum:word;
                    def_recvdays : integer;
                    openQQQs : word;
                    OldDupeRecords : Word;                  (* obsolete *)
                    MsgLen : Word;
                    Unused3 : Integer;
                    TempPath : PathStr;
                    Graphics : byte;
                    BBSsoftware : _BBSsoftware;
                    AreaFixHelp : PathStr;
                    UnPackers : Array[1..9] of PathStr;
                    AreaFixFlag : Word;
                    QuietLevel,
                    Buffers,
                    FWACnt,                 (* # of ForwardAreaFix records, *)
                    GDCnt : byte;             (* # of group default records *)
                    rescan_def : _rescan_def;
                    duperecords : longint;
                    arcext : _arcext;
                    AFixRcptLen,
                    AKAcnt,
                    MaxPKT : Word;
                    Sharing,
                    Sorting : Byte;
                    Sysop: Array[1..11] of SysopRecord;
                    AreaFixLog : PathStr;
                    TempInbound : PathStr;
                    maxPKTmsgs : Word;
                    RouteCnt : Word;
                    Resv2:Array[1..822] of Char;
                    MaxAreas,
                    MaxNodes : word;
                    NodeRecSize : word;
                    Offset:Longint;
                  end; {Config}

(* To directly access the 'Nodes' and/or 'Areas' while bypassing the *)
(* Extensions, perform an absolute (from beginning of file) seek to  *)
(*                   sizeof(CONFIG) + CONFIG.offset                  *)

     NodeRecord=Record
            Addr,
            ArcDest : Address;
            Aka : byte;
            AutoPassive : byte;
            NewGroup : char;
            advFlags : byte;
            Flags : Word;
            Sec_Level : Word;
            Password : Str9;
            Arcmailpw : Str9;
            Groups : Longint; (* Bit-field, Bit 0 = 'A', 1 = 'B' etc. *)
            resv : Longint;
            Areas : Array[1..MAX_AREAS div 8] of Byte;
                    (* Bit-field with MAX_AREAS bits, Byte 0/Bit 7 *)
                    (* is conference 0, etc.                       *)
          end;

     AreaRecord=Record
                Name : Str41;
                AreaType : byte;
                Board,
                Messages : Integer;
                Flags : Word;
                        { 0.. 2=Origin
                          3.. 7=Group
                          8..10=Type
                             11=Umlaut
                         12..15=Aka}

              Days,
              Conference, (* 0 - 991, see Node.areas *)
              Read_sec,
              Write_Sec : Integer;
              AdvFlags : Word;
                        {     0=Autoadded
                              1=Tinyseen
                              2=Cpp
                              3=Passive
                              4=keepeen
                              5=mandatory
                              6=keepsysop
                              7=killread
                              8=disablepsv;
                              9-15=reserved
                        }
              SeenByes : word;
              RecvDays : integer;
              RescV1 : longint;
              path : PathStr;
              Desc : Str42;
           end;

(********************************************************)
(* Optional Extensions                                  *)
(********************************************************)

Type ExtensionHeader=record
                       Typ : word;
                       offset : longint;
                     end;

Const EH_Areafix=1;

TYpe AreaFixSendTo=(Areafix,AreaMgr,Arealink,EchoMgr);
     AreaFixAreaListFormat=(Areas_BBS,Areas_List);

     ForwardAreaFix=record
       nodenr : word;
       flags : word;
               { 0-2=sendto
                 3-7=newgroup
                   8=valid
                   9=uncond
                  10=addplus
                  11=addtear
               12-14=format
                  15=active
               }
       filen : pathstr;
       groups : longint;
       sec_level : word;
       reserved : array[1..6] of char;
     end;

Const EH_groups=2;
Type Groupnames=record
       groups : array[1..26] of str35;
     end;

Const EH_sysopnames=3;
Type  sysopnames=Str36;

Const EH_GRPDEFAULTS=6;
Type  GRPdefaults=record
        group : byte;
        area : arearecord;
        nodes : array[1..32] of byte;
      end;

Const EH_AKAS=7;
Type  SysAddress=record
        Main : address;
        domain : Str28;
        pointnet : word;
        flags : longint;
      end;

Const EH_PackRoute=9;
Type  PackRoute=record
        Dest : Address;
        routes: array [0..max_route-1] of address;
      end;

Const
  EH_RA111_MSG  =$0100;
  EH_QBBS_MSG   =$0101;
  EH_SBBS_MSG   =$0102;
  EH_PB122_MSG  =$0103;
  EH_TAG_MSG    =$0104;
  EH_RA200_MSG  =$0105;
  EH_PB130_MSG  =$0106;

