Program FE2RA(input,output);

(*
** Fe2ra main program
**
** (c) 1993,94 Hans Siemons, Prime Productions; All rights reserved;
**
** If you have fixed anything about this source, or made enhancements,
** I'd appriciate a copy (with source) for incorperating in this program.
**
** last revision (dd/mm/yy) : 26-06-94
*)

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

uses dos,
     crt,
     miscradu;                                { included with RADU v3.00/g3 }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

{$I thedate.inc}
{$I struct.200}
{$I fe_cfg.inc}

const ver='1.02';

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

Var MessageDefault,                              { read from FastEcho.CFG }
    MessageCurrent : MessageRecord;                         { work record }
    rasys,                               { Remote Access system directory }
    buffer : String;                          { temporary buffer variable }
    f : file;
    fm : file of messagerecord;
    numread : word;
    eh : ExtensionHeader;
    akalist : array[1..max_akas] of SysAddress;
    fp : longint;
    grnames : groupnames;
    config : configuration;
    configra : configrecord;

    JAMareas : array[1..4096] of longint;   { JAM areas already in config.ra }
    CurrentJAM : Longint;
    updated,
    tel,
    NrJAMareas : integer;
    Boards : array[1..200] of boolean;
    AKAmap : array[0..15] of shortint;
    a: arearecord;
    i,j:integer;

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

Procedure Fe2raStart;
begin
  textcolor(Yellow);textbackground(black);
  clrscr;
  Writeln ('FE2RA '+ver+'   FastEcho (1.41) to Remote Access (2.0x) conversion utility!');
  textcolor(green);
  Writeln ('(c) 1993,94 by Hans Siemons, Prime Productions; All rights reserved.');
  textcolor(cyan);
  writeln (compiledate);                           { included in thedate.inc }
  Writeln;
  textcolor(15);
  rasys:=forceback(getenv('ra'));
  assign(f,rasys+'config.ra');
  {$I-} reset(f,1); {$I+}
  if ioresult<>0 then
     begin
       Writeln ('Config.RA not found!');
       halt;
     end;
  blockread(f,configra,sizeof(configra),numread);
  close(f);
  if numread<>sizeof(configra) then
    begin
      Writeln ('Error reading config.ra');
      halt;
    end;
  if configra.syspath<>'' then rasys:=forceback(configra.syspath);

  buffer:=GetEnv('FE');                       { get location of FastEcho.CFG }
              { This also works if no FE env is set, because the current dir
                will be used then }
  Buffer:=FExpand(ForceBack(Buffer)+'FastEcho.CFG');         { full filename }
  Assign(f,buffer);
  {$I-} Reset(f,1); {$I+}                          { use an untyped file !!! }
  if ioresult<>0 then
    begin
      WriteLN ('  Error reading ',buffer,'.');
      Halt;
    end;
  BlockRead(f,Config,SizeOf(Configuration),Numread);   { read in main config }
  If Numread<>SizeOf(Configuration) then         { handle broken config file }
    begin
      Writeln ('Error reading FastEcho.CFG!');
      halt;
    end;
  If Config.Revision<>Revision then                        { wrong revision? }
    begin
      Writeln ('  Incompatible FastEcho.CFG, needs revision 5 (FastEcho 1.41)');
      Halt;
    end;

  Move(config.akas,akalist,sizeof(config.akas));         { for FastEcho 1.2x }

  textcolor(white+8+blink);
  Write ('Converting !!!');
  textcolor(yellow);

  { the following code reads the extra stuff from the configfile, please note
    that eh.offset is not used to determine how many bytes I should read,
    this to avoid memory corruption. (it could be the case in a future update
    that the eh.offset has more bytes then you reserved for it!)
    eh.offset is however always used to go the next header
  }

  fp:=sizeof(config);
  while fp<sizeof(config)+config.offset do
  begin
    blockread(f,eh,sizeof(eh));                                { read header }
    fp:=filepos(f);

    case eh.typ of                  { check all headers I find of importance }
      eh_groups : begin
                    blockread(f,grnames,sizeof(grnames));
                  end;
      eh_akas   : begin
                    blockread(f,akalist,config.akacnt*sizeof(SysAddress));
                  end;
      eh_ra200_msg : begin
                    blockread(f,MessageDefault,sizeof(MessageDefault));
                  end;
     end;
    Seek(f,fp+eh.offset);                                 { goto next header }
    fp:=filepos(f);
  end; { while }

  { set up aka matching table, -1=no matching aka
    This is a bit faster then testing on the fly, and easier to code
  }

  fillchar(akamap,sizeof(akamap),#255);
  for i:=1 to config.akacnt do
    with akalist[i].main do
      for j:=0 to 9 do
      begin
        if (configra.address[j].zone=zone) and
           (configra.address[j].net=net) and
           (configra.address[j].node=node) and
           (configra.address[j].point=point) then
             begin
               akamap[i-1]:=j;
             end;
      end;

  Seek(f,sizeof(config)+config.offset+config.nodecnt*sizeof(noderecord));


  fillchar(boards,sizeof(boards),#0);
  nrJAMareas:=0;
  updated:=0;
  assign(fm,rasys+'messages.ra');
  {$I-}
  reset(fm);
  {$I+}
  if ioresult<>0 then
    begin

      { If Messages.RA does not exist, create a new messages.ra, with 200
        empty records. This is because Fe2RA writes it stuff in the order
        that they are located in FastEcho.CFG. I just write them as they
        come along }

      rewrite(fm);
      fillchar(MessageCurrent,sizeof(MessageCurrent),#0);
      for i:=1 to 200 do write(fm,MessageCurrent);
    end else
    begin
      while not eof(fm) do
        begin

          { search for used areas }

          read(fm,MessageCurrent);
          if messagecurrent.name<>'' then
          begin
            if (messagecurrent.attribute and 128)=128
              then
                begin { Jam area ! }
                  Inc(nrJamAreas);
                  with messagecurrent do
                    JamAreas[NrJamAreas]:=jamcrc32(JAMbase[1],length(jambase),-1);
                end else
                  if filepos(fm)<201 then Boards[filepos(fm)]:=true;
          end;
        end;
    end;

  for i:=1 to config.areacnt do
  begin
    blockread(f,a,sizeof(a));                        { read area information }
    numread:=(a.flags shr 8) and $07;                         { type of area }
    if (numread=qbbs) or (numread=jam) then       { only QBBS and JAM for RA }
      begin
        move(MessageDefault,MessageCurrent,sizeof(MessageCurrent));
        MessageCurrent.Name:=asciiztostr(a.desc);
        if MessageCurrent.name='' then
          MessageCurrent.name:=Asciiztostr(a.name);
        with MessageCurrent,a do
          begin
            DaysKill:=days;
            Countkill:=messages;
            RecvKill:=RecvDays;
            group:=1+((A.Flags and $ff) shr 3);
            originline:=asciiztostr(config.originline[a.flags and $07]);
            typ:=localmail;
            case a.areatype of
              area_echomail : typ:=echomail;
              area_netmail : typ:=netmail
            end;
          end; { with }
       MessageCurrent.AkaAddress:=akamap[(a.flags shr 12) and $0f];
       { if no aka was found, areatype is set to $ffff to that the record will
         not be written by FE2RA }
       if akamap[(a.flags shr 12) and $0f]=-1 then numread:=$ffff;

        if numread=qbbs then
          begin
            if not boards[a.board] then
            begin
              seek(fm,a.board-1);    { go to right position for writing board }
              inc(updated);
              write(fm,MessageCurrent);
            end;
          end else
          if numread=jam then begin
            with Messagecurrent do attribute:=attribute or 128;
            MessageCurrent.jambase:=AsciiZtostr(a.path);
            with messagecurrent do
               CurrentJAM:=jamcrc32(JAMbase[1],length(jambase),-1);
            for tel:=1 to NrJamAreas do
              if jamareas[tel]=CurrentJam then break;
            if jamareas[tel]<>currentjam then
            begin
              seek(fm,filesize(fm));          { append to end of messages.ra }
              write(fm,messagecurrent);
              inc(updated);
            end;
          end; { if }
      end; { if }
  end; { for }

  close(f);
  close(fm);
  Write (#13,'Updated ',updated,' message areas!');clreol;writeln;
end;

begin
  fe2rastart;
end.
