;
; ===========================================================================
;                Patch script for timEd v1.10 (DOS Version)
;                      Version 2.10 - 23. Dec 1999
;
;    Created by Tobias Ernst, Fido 2:2476/418, e-mail tobi@bland.fido.de
; ===========================================================================
;
; NOTE: This patch script will rename timed.exe into timed.ovl if the patch
;       is successful. You will have to execute timed by using timed.com
;       which should have been supplied to you together with this patch file.
;
;       If you wish to understand this patch, you will want to see what
;       the service routines on interrupts 47..49 and 4B..4C do. Have a
;       look at timed.asm for this. It is the source for timed.com.
;
SIZE 377952                ; filesize timed.exe
;
COPY UNPATCH\TIMED.EXE     ; make a backup copy in <TimedPath>\unpatch
;
REN TIMED.OVL              ; rename pached timed.exe to timed.ovl in order
                           ; to prevent the patched executable from being
                           ; executed without installed interrupt handlers
;
; ---------------------------------------------------------------------------
; Fix three digit year in FTSC (msg, squish) and Hudson date fields.
; ("100" instead of "00"). Previously, a three digit number was pushed
; to the stack from 2000 on.
;
VER 24233 FF770A           ; push word ptr [bx+0a]
;
CHA $     CD8D+            ; int 8d          ; call service routine #1
          90               ; nop
;
VER 27E97 FF770A           ; push word ptr [bx+0a]
;
CHA $     CD8D+            ; int 8d          ; call service routine #1
          90               ; nop
;
VER 2DD66 FF770A           ; push word ptr [bx+0a]
;
CHA $     CD8D+            ; int 8d          ; call service routine #1
          90               ; nop
;
;
; --------------------------------------------------------------------------
; Fix incorrect dates in replies generated with a template containing
; the %year token.  Previously, a three digit year number was pushed to
; the stack, and the sprintf format string had a hard coded "19" in
; front of it. Now, a four digit year number is pushed to the stack by
; service routine #2, and the format string is adapted.
;
VER 4F220 313925322E326900 ; db "19%2.2i",0
;
CHA $     25342E3469000000 ; db "%4.4i",0
;
VER CDB0  FF770A           ; push word ptr [bx+0a]
;
CHA $     CD8E+            ; int 8E          ; call service routine #2
          90               ; nop
;
;
; --------------------------------------------------------------------------
; Patch the Tearline and other places to announce version "1.10.y2k"
; intead of "1.10".
;
VER 53c32 00000000         ; db 0,0,0,0
;
CHA $     2E79326B         ; db ".y2k"
;
;
; --------------------------------------------------------------------------
; Fix interpretation of a two digit year number when reading *.MSG and
; Squish messages. Previously: 19xx, Now: 19xx if xx>=80, 20xx if xx<80
;
VER 4039  2D5000           ; sub ax,0050
;
CHA $     CD8F+            ; int 8F          ; call service routine #3
          90               ; nop             ; instead
;
;
; --------------------------------------------------------------------------
; Fix handling of a UNIX time_t timestamp from  2038 on. Previously,
; it was treated as a signed long (which led to an overflow on 18/01/2038).
; Now we treat it as an unsigned long.
; Note: This did not look like a programming error. It rather looked like
; an error in the runtime library of Watcom C. BTW, the Borland C library
; also has this bug.
;
VER 3969   9AB01F980F      ; call 0F98:1FB0  ; call the watcom routine
                           ;                 ; for 32-bit signed divisions
;
CHA $      9AB81F980F      ; call 0F98:1FB8  ; call the watcom routine
                                             ; for 32-bit unsigned divisions
;
VER 397B   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 3989   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 399B   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 39A9   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 39BB   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 39CF   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
VER 39E1   9AB01F980F      ; call 0F98:1FB0
;
CHA $      9AB81F980F      ; call 0F98:1FB8
;
;
; --------------------------------------------------------------------------
; Fix date display of the message info screen
; ('110 instead of '10 and so on). Previously, a three digit year number
; was pushed to the stack from 2000 on.
;
VER 2440   FF740A          ; push word ptr [si+0a]
;
CHA $      CD8B+           ; int 8b         ; call service routine #4
           90              ; nop            ; instead
;
;
; --------------------------------------------------------------------------
; Fix incorrect interpretation of a hudson time stamp which led to
; totally wrong display of a hudson message date after 2000.
;
VER 2D6B9  8B46F2          ; mov ax, word ptr [bp-08]
;
CHA $      CD8C+           ; int 8c         ; call service routine #5
           90              ; nop            ; instead
;
; Done!
;
