// Functions for the Utility2 object, Y2K
// Created 25 May 1996
// Revised 06 January 1998

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <share.h>
#include <string.h>
#include <mem.h>
#include "extern.h"
#include "utility2.h"
#include "bbsinfo.h"
#include "config.h"
#if defined (__AMU16__) || defined(__AMU2__)
  #include <dir.h>
#endif


extern class Config Config_obj;

#if defined(__AMU16__) || defined(__AMU2__)
Utility2::Utility2(void)
{
    screen_buffer = (char *) calloc(4000, 1);
}

Utility2::~Utility2(void)
{
    free(screen_buffer);
}

void Utility2::get_screen(void)
{
    gettext(1, 1, 80, 25, screen_buffer);
}

void Utility2::put_screen(void)
{
    puttext(1, 1, 80, 25, screen_buffer);
}

void Utility2::toggle(short *i)
{
    if(*i)
    {
        *i = FALSE;
    }
    else
    {
        *i = TRUE;
    }
}

char *Utility2::YN(short i)
{
    static char tmpstr[5];

    if(i)
    {
        strcpy(tmpstr, "Yes;");
    }
    else
    {
        strcpy(tmpstr, "No ;");
    }
    return(tmpstr);
}

char *Utility2::_squeeze(char *instr)
{
    static char tmpstr[71], *ptr, *ptr2;

    /* Remove the first  you find, append one space to the end, then return the string */
    ptr = instr;
    ptr2 = tmpstr;
    while(*ptr)
    {
        if(*ptr != '')
        {
            *ptr2 = *ptr;
            ptr2++;
        }
        ptr++;
    }
    *ptr2 = NULL;
    return(tmpstr);
}

/* Return the name of the color */
char *Utility2::color_str(short color)
{
    static char tmpstr[21];

    switch(color)
    {
        case 0: strcpy(tmpstr, "Black;");
                break;
        case 1: strcpy(tmpstr, "Blue;");
                break;
        case 2: strcpy(tmpstr, "Green;");
                break;
        case 3: strcpy(tmpstr, "Cyan;");
                break;
        case 4: strcpy(tmpstr, "Red;");
                break;
        case 5: strcpy(tmpstr, "Magenta;");
                break;
        case 6: strcpy(tmpstr, "Brown;");
                break;
        case 7: strcpy(tmpstr, "Light Gray;");
                break;
        case 8: strcpy(tmpstr, "Dark Gray;");
                break;
        case 9: strcpy(tmpstr, "Light Blue;");
                break;
        case 10: strcpy(tmpstr, "Light Green;");
                 break;
        case 11: strcpy(tmpstr, "Light Cyan;");
                 break;
        case 12: strcpy(tmpstr, "Light Red;");
                 break;
        case 13: strcpy(tmpstr, "Light Magenta;");
                 break;
        case 14: strcpy(tmpstr, "Yellow;");
                 break;
        case 15: strcpy(tmpstr, "White;");
                 break;
    }
    return(tmpstr);
}

char *Utility2::listtype_str(short type)
{
    static char str[21];

    switch(type)
    {
        case RA_FDB     : strcpy(str, "RA;");
                          break;
        case CONCORD_FDB: strcpy(str, "Concord;");
                          break;
        case LORA_FDB   : strcpy(str, "LoraBBS;");
                          break;
        case EZY_FDB    : strcpy(str, "Ezycom;");
                          break;
        case TG_FDB     : strcpy(str, "TG 3.02;");
                          break;
        case TG310_FDB  : strcpy(str, "TG 3.09g;");
                          break;
        case FILESBBS   : strcpy(str, "FILES.BBS;");
                          break;
        default         : strcpy(str, "Unknown;");
                          break;
    }
    return(str);
}

char *Utility2::datetype_str(short type)
{
    static char str[11];

    switch(type)
    {
        case 0: strcpy(str, "MM-DD-YY;");
                break;
        case 1: strcpy(str, "MM-YY-DD;");
                break;
        case 2: strcpy(str, "DD-MM-YY;");
                break;
        case 3: strcpy(str, "DD-YY-MM;");
                break;
        case 4: strcpy(str, "YY-MM-DD;");
                break;
        case 5: strcpy(str, "YY-DD-MM;");
                break;
    }
    return(str);
}

char *Utility2::mailerstr(short type)
{
    static char str[25];

    switch(type)
    {
        case 0: strcpy(str, "None            ;");
                break;
        case 1: strcpy(str, "FrontDoor       ;");
                break;
        case 2: strcpy(str, "D'Bridge        ;");
                break;
        case 3: strcpy(str, "BinkleyTerm     ;");
                break;
        case 4: strcpy(str, "InterMail       ;");
                break;
        case 5: strcpy(str, "Portal of Power ;");
                break;
        case MD: strcpy(str, "MainDoor        ;");
                 break;
        case XENIA: strcpy(str, "Xenia           ;");
                    break;
        case MCMAIL: strcpy(str, "McMail          ;");
                     break;
    }
    return(str);
}

char *Utility2::sorttype_str(short type)
{
    static char str[20];

    switch(type)
    {
        case 0: strcpy(str, "A-Z");
                break;
        case 1: strcpy(str, "Z-A");
                break;
        case 2: strcpy(str, "A-Z, new");
                break;
        case 3: strcpy(str, "A-Z, old");
                break;
        case 4: strcpy(str, "Z-A, new");
                break;
        case 5: strcpy(str, "Z-A, old");
                break;
        default: strcpy(str, "Unknown");
                 break;
    }
    return(str);
}

char *Utility2::cdformat_str(short type)
{
    static char str[20];

    switch(type)
    {
        case CD_3: strcpy(str, "Type 1");
                   break;
        case CD_2: strcpy(str, "Type 2");
                   break;
        case CD_5: strcpy(str, "Type 3");
                   break;
        case CD_1: strcpy(str, "Type 4");
                   break;
        case CD_4: strcpy(str, "Type 5");
                   break;
        default  : strcpy(str, "Unknown");
                   break;
    }
    return(str);
}

/* Return 'Yes' or 'No' without the ';' */
char *Utility2::_YN(short i)
{
    static char tmpstr[5];

    if(i)
    {
        strcpy(tmpstr, "Yes");
    }
    else
    {
        strcpy(tmpstr, "No");
    }
    return(tmpstr);
}

char *Utility2::arctype_str(short intype)
{
    switch(intype)
    {
        case ARC: return("ARC");
        case ARJ: return("ARJ");
        case HAP: return("HAP");
        case LZH: return("LZH");
        case PAK: return("PAK");
        case SQZ: return("SQZ");
        case ZIP: return("ZIP");
        case ZOO: return("ZOO");
        case UC2: return("UC2");
        case RAR: return("RAR");
    }
    return("???");
}

/* Get a Lora user level */
char *Utility2::get_userlevel(short level)
{
    switch(level)
    {
        case L_TWIT: return("Twit");
        case L_DISGRACE: return("Disgrace");
        case L_LIMITED: return("Limited");
        case L_NORMAL: return("Normal");
        case L_WORTHY: return("Worthy");
        case L_PRIVIL: return("Priviledged");
        case L_FAVORED: return("Favored");
        case L_EXTRA: return("Extra");
        case L_CLERK: return("Clerk");
        case L_ASSTSYSOP: return("Assistant Sysop");
        case L_SYSOP: return("Sysop");
        case L_HIDDEN: return("Hidden");
    }
    return("Invalid value");
}

/* Get a Maximus user level */
char *Utility2::get_maximus_userlevel(short level)
{
    switch(level)
    {
        case M_TWIT: return("Twit");
        case M_DISGRACE: return("Disgrace");
        case M_LIMITED: return("Limited");
        case M_NORMAL: return("Normal");
        case M_WORTHY: return("Worthy");
        case M_PRIVIL: return("Priviledged");
        case M_FAVORED: return("Favored");
        case M_EXTRA: return("Extra");
        case M_CLERK: return("Clerk");
        case M_ASSTSYSOP: return("Assistant Sysop");
        case M_SYSOP: return("Sysop");
        case M_HIDDEN: return("Hidden");
    }
    return("Invalid value");
}

void Utility2::mkdir_nested(char *inpath)
{
    char *ptr, *ptr2, tmpstr[129];

    ptr = inpath;
    ptr2 = tmpstr;
    while(*ptr)
    {
        while(*ptr != '\\'  &&  *ptr)
        {
            *ptr2 = *ptr;
            ptr++;
            ptr2++;
        }
        *ptr2 = NULL;
        mkdir(tmpstr);
        *ptr2 = '\\';
        if(*ptr)
        {
            ptr++;
            ptr2++;
        }
    }
}


#pragma argsused
void Utility2::read_help(char *instring)
{
/*
    class Menus Menus_obj;
    char *dispstr, *tmpbuf;
    struct coordinates cvar;
    FILE *docfile, *idxfile;
    struct
    {
        unsigned long s22,
                      s23,
                      s24,
                      s25,
                      s26,
                      s27,
                      s28;
    }indexvar;

    cvar.uses_blanks = FALSE;
    tmpbuf = (char *) malloc(4000);
    dispstr = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    docfile = _fsopen("AMU.DOC", "rt", SH_DENYWR);
    idxfile = _fsopen("AMUCFG.IDX", "rb", SH_DENYWR);
    fseek(idxfile, filelength(fileno(idxfile)) - sizeof(indexvar), SEEK_SET);
    fread(&indexvar, sizeof(indexvar), 1, idxfile);
    fseek(


    sprintf(dispstr, "             %s;  ;   Copyright 1994 by David Hickey;  ;          All rights reserved;", Sysinfo_obj.get_version());
                strcat(dispstr, "  ;       Original visual interface;designed by Joaquim H. Homrighausen;  ;         Used with permission;  ;");
                cvar.options = dispstr;
                cvar.left = 23;
                cvar.width = 38;
                cvar.items = 11;
                cvar.top = 6;
                cvar.high_num = 0;
                cvar.title = NULL;
                Menus_obj.dialog(&cvar, ' ');
                break;
    puttext(1, 1, 80, 25, tmpbuf);
*/
}
#endif

char *Utility2::BBSstr(short type)
{
    static char str[30];

    switch(type)
    {
        case RA2      : strcpy(str, "RemoteAccess 2.02      ;");
                        break;
        case SBBS     : strcpy(str, "SuperBBS 1.17          ;");
                        break;
        case QBBS     : strcpy(str, "QuickBBS 2.76          ;");
                        break;
        case RA250    : strcpy(str, "RemoteAccess 2.52      ;");
                        break;
        case RA1      : strcpy(str, "RemoteAccess 1.11      ;");
                        break;
        case QBBSC    : strcpy(str, "QuickBBS 2.85/Classic  ;");
                        break;
        case QBBSG    : strcpy(str, "QuickBBS 2.85/GoldBase ;");
                        break;
        case CONCORD  : strcpy(str, "Concord 0.01           ;");
                        break;
        case PB2      : strcpy(str, "ProBoard 2.16          ;");
                        break;
        case LORA     : strcpy(str, "LoraBBS 2.40           ;");
                        break;
        case MAXIMUS2 : strcpy(str, "Maximus 2.02           ;");
                        break;
        case MAXIMUS3 : strcpy(str, "Maximus 3.01           ;");
                        break;
        case LORA3    : strcpy(str, "LoraBBS 2.99           ;");
                        break;
        case EZ       : strcpy(str, "EzyCom 1.20/1.48g      ;");
                        break;
        case TG3      : strcpy(str, "Telegard 3.02          ;");
                        break;
        case TG310    : strcpy(str, "Telegard 3.09g         ;");
                        break;
        default       : strcpy(str, "Unknown                ;");
                        break;
    }
    return(str);
}

void Utility2::calc_original_crc(void)
{
    original_crc = Crc_obj.struct_crc((char *) &Config_obj.amu_cfgvar, CFG_SIZE);
}

/***********************************************************************/
// EOF - UTILITY2.CPP
