// Header file for the Utility object
// Created 09 September 1995
// Revised 21 May 1998

#if !defined(__UTILITY__)

 #define __UTILITY__
#include "crc.h"
#include "dates.h"
#include "amustr.h"

#define ERRORS_AMU    "ERRORS.AMU"     /* File containing the run's errors */
#define TRACKING_AMU  "TRACKING.AMU"   /* Tracking file              */
#define ADD_FILES    0		       /* Add files read 	     */
#define REMOVE_FILES 1		       /* Delete files read	     */
#define DEFAULT_PARAM -1

struct tracking_record
{
    unsigned long filecrc,
		  recnum;
    struct
    {
	short scanned   : 1,
	      imported  : 1,
	      exported  : 1,
	      commented : 1,
	      rearced   : 1,
	      unused    : 11;
    }status;
};

class Utility
{
    /* Private data */
    private:
    class Crc Crc_obj;
    class Amustr Amustr_obj;
    char LOGSTR[101];
    int AMU_ERRORS;

    public:
    Utility(void) { AMU_ERRORS = 0; }
    int check_param(int argc, char *argv[], char *param, int num);
    void togglebit(unsigned *i, unsigned bit);
    int bitset(unsigned i, unsigned bit);
    void setbit(unsigned *i, unsigned bit);
    void clearbit(unsigned *i, unsigned bit);
    int get_arctype(char *inname);
    int is_secure(char *inname);
    int is_sfx(char *inname);
    int disk_ok(long amount, char *directory);
    void logentry(char *str, int level);
    void change_dir(char *path);
    void cleardir(void);
    void get_newarc_ext(char *fn, int arctype);
    struct tracking_record *read_tracking(char *filename);
    void update_tracking(struct tracking_record *trackvar);
    int copyfile(char *source, char *target);
    void toggle(int *i);
    int get_errors(void) { return(AMU_ERRORS); }
    void cleanup(void);
    char *arcext(char *instring, int arctype);
    void check_files(char *fn, int mode);
    void remove_all(char *source);
    int system_filename(char *inname);
    int check_zipav(char *fn);
    int is_multivolume(char *fn);
/*
    void check_exe_integrity(char *exename);
*/
};
#endif

// EOF UTILITY.H
