// Header file for the Users class
// Created 29 March 1996
// Revised 07 January 1998

#if !defined(__USERS_H__)
#define __USERS_H__

#include <stdio.h>
#include "bbsinfo.h"
#include "msgs.h"
#include "crc.h"
#include "amustr.h"
#include "utility.h"

#define TMPUSERS_AMU "TMPUSERS.AMU"
#define BDAY_TRACK   "BIRTHDAY.AMU"
#define SUBEXP_TRACK "SUBEXP.AMU"
#define CREDIT_TRACK "CREDIT.AMU"

#define READ_MODE  0
#define WRITE_MODE 1

class Users
{
   /* Private data */
    private:
    class Msgs Msgs_obj;
    class Crc Crc_obj;
    class Amustr Amustr_obj;
    class Utility Utility_obj;

    FILE *trackfile;
    struct track trackvar;
    char trackfn[MAX_FILESPEC];
    char LOGSTR[101];
    FILE  *userfile,      /* User file */
	  *xifile;        /* Index file (if used) */
    struct user_array *toprec, *currec, *tmprec;
    short user_recsize,
	  xi_recsize;
    struct q276_users q276uservar;
    struct q280_users q280uservar;
    struct aliasrecord aliasvar;
    struct ra20_users ra20uservar;
    struct ra10_users ra10uservar;
    struct ra10_users_xi ra10userxivar;
    struct lora_users lorauservar;
    struct l300_users l300uservar;
    struct e120_users e120uservar;
    struct e120_users_xi e120userxivar;
    struct conc_usershdr concuserhdrvar;
    struct conc_users concuservar;
    struct max2_users max2uservar;
    struct max3_users max3uservar;
    struct s117_users s117uservar;
    struct s117_users_xi s117userxivar;
    struct t302_users t302uservar;

    public:
    Users(void);
    void process_users(int argc, char *argv[]);

    private:
    int open_users(int mode);
    int read_users(void);
    void write_users(void);
    void deallocate_users(void);
    void close_users(void);
    void clean_users(void);
    void adjust_subdate(struct user_array *userptr);
    void user_msgs(int argc, char *argv[]);
    void enforce(void);
    void open_track(int type);
    int entry_exists(struct track *x);
    void close_track(int type);
};
#endif
/***********************************************************************/
/* EOF - USERS.H */
