/* Functions for the Usermsgs object */

#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>
#include "config.h"
#include "usermsgs.h"
#include "utility.h"
#include "logs.h"
#include "screen.h"
#include "users.h"
#include "msgs.h"
#include "datetime.h"
#include "crc.h"

/* External objects */
extern Utility Utility_obj;
extern Screen Screen_obj;
extern Sysinfo Sysinfo_obj;
extern DateTime DateTime_obj;
extern Crc Crc_obj;
extern Users Users_obj;

/* Posts messages for newuser, uploads, and lost carriers */
void Usermsgs::user_msgsl(int mode)
{
    char user_name[41], user_nametmp[41], txtfn[81], subject[41], *ptr;
    int i, index, found;
    class Logs *Logs_obj;
    class Msgs *Msgs_obj;
    struct screeninfo *s;

    user_name[0] = user_nametmp[0] = NULL;

    s = (struct screeninfo *) calloc(1, sizeof(struct screeninfo));

    switch(mode)
    {
	case CARRIER_MSG: strcpy(s->internal, "Posting messages to users who drop carrier ");
			  sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, CARRIER_TXT);
			  strcpy(subject, "Lost carrier");
			  break;
	case UPLOAD_MSG: strcpy(s->internal, "Posting messages to users who upload ");
			 sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, UPLOAD_TXT);
			 strcpy(subject, "Uploads");
			 break;
	case NEWUSER_MSG: strcpy(s->internal, "Posting messages to new users ");
			  sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, NEW_USER_TXT);
			  strcpy(subject, "New user");
			  break;
    }
    strcpy(Utility_obj.LOGSTR, s->internal);
    Utility_obj.logentry();
    Screen_obj.display(s);

    /* Attempt to allocate space for the Logs &&  Msgs object */
    Logs_obj = new(Logs);
    Msgs_obj = new(Msgs);
    if(!Logs_obj  ||  !Msgs_obj)
    {
	sprintf(Utility_obj.LOGSTR, "! (Line %d, file %s) Unable to allocate object - (%s)",
		__LINE__, __FILE__, _strerror(""));
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	if(Logs_obj)
	{
	    delete(Logs_obj);
	}
	if(Msgs_obj)
	{
	    delete(Msgs_obj);
	}
	free(s);
	return;
    }

    /* Attempt to open the user files */
    if(!Users_obj.open_u())
    {
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	delete(Logs_obj);
	delete(Msgs_obj);
	free(s);
	return;
    }

    /* Try to read the appropriate message record */
    if(!Sysinfo_obj.read_msgs(amu_cfgvar.userpostarea-1))
    {
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	delete(Logs_obj);
	delete(Msgs_obj);
	free(s);
	return;
    }

    s->num_areas = amu_hdrvar.num_logs;
    for(index = 1; index <= amu_hdrvar.num_logs; index++)
    {
	if(!Sysinfo_obj.read_logs_record(index))
	{
	    continue;
	}

	/* If this is not a BBS logfile, or if it's not enabled, skip it */
	if(Logs_obj->get_logtype(Sysinfo_obj.logsvar.type) != BBS_LOG  ||
	   !Sysinfo_obj.logsvar.enabled)
	{
	    continue;
	}


	s->cur_area = index;
	/* Open and process the logfile if it is found */
	if(Logs_obj->open_l(Sysinfo_obj.logsvar.name))
	{
	    strcpy(s->external, "Scanning ");
	    strncat(s->external, Sysinfo_obj.logsvar.name, LEN - 1 - strlen(s->external));
	    Screen_obj.display(s);

	    /* Figure out which CRC-32/Offset should be used */
	    switch(mode)
	    {
		case CARRIER_MSG: Logs_obj->set_position(&Sysinfo_obj.logsvar.carrier_crc,
							 &Sysinfo_obj.logsvar.carrier_offset);
				  break;
		case UPLOAD_MSG: Logs_obj->set_position(&Sysinfo_obj.logsvar.upload_crc,
							 &Sysinfo_obj.logsvar.upload_offset);
				 break;
		case NEWUSER_MSG: Logs_obj->set_position(&Sysinfo_obj.logsvar.newuser_crc,
							 &Sysinfo_obj.logsvar.newuser_offset);
				  break;
	    }
	    Sysinfo_obj.update_logs_record(index);

	    /* Process the logfile */
	    user_name[0] = NULL;
	    s->length = Logs_obj->get_length();
	    i = Logs_obj->read_l(Sysinfo_obj.logsvar.type);
	    while(!Logs_obj->_EOF)
	    {
		s->cur_offset = Logs_obj->get_curpos();
		Screen_obj.display(s);
		if(i == USER_NAME)
		{
		    ptr = Logs_obj->get_uname();
		    if(ptr)
		    {
			strncpy(user_name, ptr, sizeof(user_name) - 1);
			strncpy(user_nametmp, user_name, sizeof(user_name) - 1);
		    }
		    else
		    {
			user_name[0] = user_nametmp[0] = NULL;
		    }
		}
		else
		{
		    /* See if the mode we're in matches one of the return types */
		    if(((mode == CARRIER_MSG  &&  i == LOST_CARRIER)  ||
		       (mode == UPLOAD_MSG && i == UPLOAD) ||
		       (mode == NEWUSER_MSG && i== NEW_USER))  &&  user_name[0])
		    {
			found = FALSE;
			Users_obj.rewind_u();
			Users_obj.read_u();
			/* Search for this user's record so we have their information */
			while(!Users_obj._EOF  &&  !found)
			{
			    if(stricmp(user_name, Users_obj.get_name()) == 0)
			    {
				found = TRUE;
			    }
			    else
			    {
				Users_obj.read_u();
			    }
			}
			if(user_name[0]  &&  found &&  Msgs_obj->post_msg(user_name, amu_cfgvar.sysop, subject, txtfn,
								amu_cfgvar.userpostarea))
			{
			    sprintf(Utility_obj.LOGSTR, " Message posted to %s", user_name);
			}
			user_name[0] = user_nametmp[0] = NULL;
			Utility_obj.logentry();
			Screen_obj.display(s);
		    }
		}
		i = Logs_obj->read_l(Sysinfo_obj.logsvar.type);
	    }
	    Logs_obj->close_l();
	}
    }
    Users_obj.close_u();
    delete(Logs_obj);
    delete(Msgs_obj);
    Screen_obj.display_shutdown();
    free(s);
}


void Usermsgs::user_msgsu(int mode)
{
    char tmpstr[61], date[9], today_date[9], newbday[10],
	 txtfn[81], trackfn[81], subject[41];
    int user_num, ok;
    class Msgs *Msgs_obj;
    struct screeninfo *s;

    s = (struct screeninfo *) calloc(1, sizeof(struct screeninfo));
    /* Get the date in the default date format of MM-DD-YY */
    strcpy(date, DateTime_obj.curdate(-1));
    strcpy(today_date, date);
    switch(mode)
    {
	case BDAY_MSG: strcpy(s->internal, "Posting messages to users on their birthday ");
		       sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, BDAY_TXT);
		       strcpy(subject, "Happy Birthday!");
		       sprintf(trackfn, "%s%s", amu_cfgvar.AMUpath, BDAY_TRACK);
		       date[5] = NULL;  // We only need MM-DD for this one
		       break;
	case SUB_MSG: strcpy(s->internal, "Posting messages to users regarding expired subscriptions ");
		      sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, SUBEXP_TXT);
		      strcpy(subject, "Subscription expiration");
		      sprintf(trackfn, "%s%s", amu_cfgvar.AMUpath, SUBEXP_TRACK);
		      if(amu_cfgvar.BBStype == QBBS)
		      {
			  sprintf(Utility_obj.LOGSTR, "? QuickBBS 2.76 does not support user subscriptions, aborting");
			  Utility_obj.logentry();
			  Screen_obj.display(s);
			  free(s);
			  Screen_obj.display_shutdown();
			  return;
		      }
		      break;
	case CREDIT_MSG: strcpy(s->internal, "Posting messages to users regarding low credit ");
			 sprintf(txtfn, "%s%s", amu_cfgvar.AMUpath, CREDIT_TXT);
			 sprintf(trackfn, "%s%s", amu_cfgvar.AMUpath, CREDIT_TRACK);
			 strcpy(subject, "Low netmail credit");
			 break;
    }
    strcpy(Utility_obj.LOGSTR, s->internal);
    Utility_obj.logentry();
    Screen_obj.display(s);

    /* Attempt to allocate space for the Msgs object */
    Msgs_obj = new(Msgs);
    if(!Msgs_obj)
    {
	sprintf(Utility_obj.LOGSTR, "! (Line %d, file %s) Unable to allocate object - (%s)",
		__LINE__, __FILE__, _strerror(""));
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	delete(Msgs_obj);
	free(s);
	return;
    }

    /* Attempt to open the user files */
    if(!Users_obj.open_u())
    {
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	delete(Msgs_obj);
	free(s);
	return;
    }

    /* Try to read the appropriate message record and the tracking file */
    if(!Sysinfo_obj.read_msgs(amu_cfgvar.userpostarea-1)  ||
       !Utility_obj.open_trackfile(trackfn))
    {
	Utility_obj.logentry();
	Screen_obj.display(s);
	Screen_obj.display_shutdown();
	delete(Msgs_obj);
	free(s);
	return;
    }

    user_num = 0;
    Users_obj.read_u();
    s->num_areas = s->length = Users_obj.FILE_SIZE;
    while(!Users_obj._EOF)
    {
	ok = FALSE;
	user_num++;
	strcpy(s->name, Users_obj.name);
	s->cur_area = s->cur_offset = user_num;
	Screen_obj.display(s);

	switch(mode)
	{
	    case BDAY_MSG: if(!Users_obj.bday[0])
			   {
			       Users_obj.read_u();
			       continue;
			   }
			   strcpy(newbday, Users_obj.bday);
			   newbday[5] = NULL;  // We're just comparing the MM-DD portion
			   if(strstr(date, newbday))
			   {
			       ok = TRUE;
			   }
			   /* The string the BDAY uses is the user + today_date */
			   sprintf(tmpstr, "%s %s", Users_obj.get_name(), today_date);
			   break;
	    case SUB_MSG: if(!Users_obj.subexp[0])
			   {
			       Users_obj.read_u();
			       continue;
			   }
			   if(Utility_obj.age() <= amu_cfgvar.sub_exp)
			   {
			       ok = TRUE;
			       sprintf(LOGSTR, "[DEBUG] Age = %d
			   }
			   /* The string for SUB_EXP is the user + expiration date */
			   sprintf(tmpstr, "%s %s", Users_obj.get_name(), Users_obj.get_subexp());
			   break;
	    case CREDIT_MSG: if(Users_obj.get_credit() <= amu_cfgvar.num_credit)
			     {
				 ok = TRUE;
			     }
			     if(amu_cfgvar.nonzero && Users_obj.get_credit() == 0)
			     {
				 ok = FALSE;
			     }
			     /* CREDIT uses the user name + minimum credit */
			     sprintf(tmpstr, "%s %d", Users_obj.get_name(), amu_cfgvar.num_credit);
			     break;
	}

	/* If things are ok, proceed */
	if(ok)
	{
	    if(!Utility_obj.entry_exists(tmpstr))
	    {
		if(Msgs_obj->post_msg(Users_obj.name, amu_cfgvar.sysop, subject, txtfn, amu_cfgvar.userpostarea))
		{
		    sprintf(Utility_obj.LOGSTR, " Message posted to %s", Users_obj.name);
		}
		Utility_obj.logentry();
		Screen_obj.display(s);
	    }
	}
	Users_obj.read_u();
    }
    Users_obj.close_u();
    Utility_obj.close_trackfile();
    Screen_obj.display_shutdown();
    free(s);
    delete(Msgs_obj);
}

/* EOF - USERMSGS.CPP */


