/* Header file for the UserMenu class */
/* Created 25 February 1996           */
/* Revised 26 September 1997          */

#if !defined(__USERMENU_H__)
#define __USERMENU_H__

class UserMenu_msgs
{
    /* Private data */
    private:
    char optionsstr[1000];
    struct coordinates cvar;

    /* Private functions */
    private:
    void action(int position);
    char *options(void);

    /* Public functions */
    public:
    int menu(void);
};


struct max3levels
{
    unsigned short level;
    char name[59];
    struct max3levels *nextrec;
};

class UserMenu_enforce
{
    /* Private data */
    private:
    char optionsstr[1000], *max3str;
    struct coordinates cvar;
    struct max3levels *toprec, *currec, *prevrec;
    int num_levels;


    /* Private functions */
    private:
    void action(int position);
    int read_max3levels(void);
    void destroy_max3levels(void);
    int index2level(int index);
    char *level2alias(int value);
    char *options(void);

    /* Public functions */
    public:
    int menu(void);
};

class UserMenu
{
    private:
    class UserMenu_enforce Enforce_obj;
    class UserMenu_msgs Msgs_obj;

    /* Private functions */
    protected:
    void action(int position);
    char *options(void);

    /* Public functions */
    public:
    int menu(void);
};
#endif
/************************************************************************/
/* EOF - UserMenu.H */
