/* Functions for the User menu   */
/* Created 25 February 1996      */
/* Revised 27 September 1997     */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <share.h>
#include <dir.h>
#include <mem.h>
#include "execute.h"
#include "menus.h"
#include "usermenu.h"
#include "utility2.h"
#include "amustr.h"
#include "crc.h"
#include "listbox.h"
#include "config.h"
#include "amuidx.h"

/* external objects */
extern class Utility2 Utility2_obj;
extern class Amustr Amustr_obj;
extern class Crc Crc_obj;
extern class ListBox ListBox_obj;
extern class Config Config_obj;
extern class Menus Menus_obj;

/* external variables */
extern listbox *msglistbox;

int UserMenu::menu(void)
{
    int i;
    struct coordinates cvar;
    class Menus Menu_obj;

    cvar.uses_blanks = TRUE;
    cvar.items = 4;
    cvar.width = 18;
    cvar.left = 38;
    cvar.top = 9;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = "User Manager";
    cvar.options = options();
    do
    {
	Menu_obj.set_help(MAIN_USER_HELP);
	Menu_obj.help("User/Msg Maintenance configuration");
	i = Menu_obj.display_menu(&cvar, 1);
	switch(i)
	{
	    case ENTER: action(cvar.position);
			break;
	    case F1   : Menus_obj.online_help(cvar.position - 2 + _ENFORCE);
			break;
	}
    }while(i != ESC);
    return(i);
}

char *UserMenu::options(void)
{
    static char str[31];

    strcpy(str, " ;Enforce;Messages; ;");
    return(str);
}

void UserMenu::action(int position)
{
    char *tmpbuf;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
	case 2: Enforce_obj.menu();
		break;
	case 3: Msgs_obj.menu();
		break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/**************************************************************************/

/* Deallocate the list that contains the Maximus 3 levels */
void UserMenu_enforce::destroy_max3levels(void)
{
    struct max3levels *tmprec;

    currec = toprec;
    while(currec)
    {
	tmprec = currec -> nextrec;
	free(currec);
	currec = tmprec;
    }
}


/* Return the security level of record #<index> */
int UserMenu_enforce::index2level(int index)
{
    int current;

    currec = toprec;
    current = 1;
    while(currec)
    {
	if(current == index)
	{
	    break;
	}
	else
	{
	    currec = currec -> nextrec;
	}
	current++;
    }
    if(currec)
    {
	return(currec -> level);
    }
    return(-1);
}

/* Return the name of the level corresponding to 'value' */
char *UserMenu_enforce::level2alias(int value)
{
    currec = toprec;
    while(currec)
    {
	if(currec -> level == value)
	{
	    return(currec -> name);
	}
	currec = currec -> nextrec;
    }
    return("Invalid Value");
}

/* Read ACCESS.CTL and create a list of Maximus security levels and names */
int UserMenu_enforce::read_max3levels(void)
{
    FILE *infile;
    char fn[MAX_FILESPEC], *ptr, str[256], alias[59];
    int level_found, alias_found, level;

    sprintf(fn, "%sACCESS.CTL", Config_obj.amu_cfgvar.BBSsyspath);
    infile = _fsopen(fn, "rt", SH_DENYNO);
    if(!infile)
    {
	return(FALSE);
    }

    toprec = currec = prevrec = NULL;
    alias_found = FALSE;
    level_found = FALSE;
    num_levels = 0;
    while(fgets(str, sizeof(str)-2, infile))
    {
	Amustr_obj.strip_n(str);
	Amustr_obj.trimlead(str);
	Amustr_obj.trimend(str);
	if(str[0] != '%')
	{
	    ptr = strchr(str, ' ');
	    if(ptr)
	    {
		*ptr = NULL;
		strupr(str);
		*ptr = ' ';
	    }
	    else
	    {
		strupr(str);
	    }

	    if(strstr(str, "LEVEL"))
	    {
		ptr = strstr(str, "LEVEL");
		ptr = strchr(ptr, ' ');
		if(ptr)
		{
		    Amustr_obj.trimlead(ptr);
		    sscanf(ptr, "%d", &level);
		    level_found = TRUE;
		}
	    }

	    if(strstr(str, "DESC"))
	    {
		ptr = strstr(str, "DESC");
		ptr = strchr(ptr, ' ');
		if(ptr)
		{
		    Amustr_obj.trimlead(ptr);
		    strcpy(alias, ptr);
		    alias_found = TRUE;
		}
	    }

	    if(level_found && alias_found)
	    {
		currec = (struct max3levels *)malloc(sizeof(struct max3levels));
		if(toprec == NULL)
		{
		    toprec = currec;
		}
		if(prevrec)
		{
		    prevrec -> nextrec = currec;
		}
		currec -> level = level;
		strcpy(currec -> name, alias);
		currec -> nextrec = NULL;
		prevrec = currec;
		level_found = alias_found = FALSE;
		num_levels++;
	    }
	}
    }
    fclose(infile);

    max3str = (char *)calloc(sizeof(struct max3levels) * num_levels, 1);
    currec = toprec;
    while(currec)
    {
	strcat(max3str, currec -> name);
	strcat(max3str, ";");
	currec = currec -> nextrec;
    }
    return(TRUE);
}


int UserMenu_enforce::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];


    if(Config_obj.amu_cfgvar.BBStype == MAXIMUS3)
    {
	i = read_max3levels();
	if(i == FALSE)
	{
	    return(FALSE);
	}
    }

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 13;
    cvar.width = 50;
    cvar.left = 14;
    cvar.top = 6;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(ENFORCE_RECORD);
    do
    {
	Menu_obj.help("Ratio/subscription enforcement; F3 - Copy");
        Menu_obj.set_help(ENFORCE_HELP);
	if(index > Config_obj.num_enforce)
        {
            index = 1;
        }
        if(index < 1)
        {
            index = Config_obj.num_enforce;
        }
	Config_obj.read_record(ENFORCE_RECORD, index);
	sprintf(str, "Enforce - Record %d/%d", index, Config_obj.num_enforce);
        if(Config_obj.enforcevar.deleted)
        {
	    strcat(str, " [Deleted]");
	}
	cvar.title = str;
	cvar.options = options();
        i = Menu_obj.dialog(&cvar, ENTER, 1);
	switch(i)
        {
            case LEFT: index--;
		       break;
	    case RIGHT: index++;
			break;
	    case ENTER: cvar.position = 2;
			break;
	    case HOME: index = 1;
		       break;
	    case END: index = Config_obj.num_enforce;
		      break;
	    case DEL: Utility2_obj.toggle(&Config_obj.enforcevar.deleted);
		      Config_obj.update_record(ENFORCE_RECORD, index);
		      break;
	    case INS: Config_obj.add_record(ENFORCE_RECORD, ADD_NEW_RECORD);
		      index = Config_obj.num_enforce;
		      break;
	    case F1   : Menus_obj.online_help(_ENFORCE);
			break;
	    case F3: Config_obj.add_record(ENFORCE_RECORD, COPY_CUR_RECORD);
		     index = Config_obj.num_enforce;
		     break;
	    case ESC: Config_obj.close_config(ENFORCE_RECORD);
		      return(i);
	}
        if(i == ENTER)
        {
            crc = Crc_obj.struct_crc((char *) &Config_obj.enforcevar, sizeof(Config_obj.enforcevar));
            strcpy(str, "Enforcement options");
            cvar.title = str;
            do
            {
                cvar.options = options();
                i = Menu_obj.display_menu(&cvar, 1);
		Menu_obj.set_help(ENFORCE_HELP);
		switch(i)
                {
		    case ENTER: action(cvar.position);
				break;
		    case F1   : Menus_obj.online_help(_ENFORCE);
			        break;
		}
            }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.enforcevar, sizeof(Config_obj.enforcevar))  &&  Menu_obj.prompt(0))
	    {
		Config_obj.update_record(ENFORCE_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(ENFORCE_RECORD);

    if(Config_obj.amu_cfgvar.BBStype == MAXIMUS3)
    {
	destroy_max3levels();
    }

    return(i);
}

char *UserMenu_enforce::options(void)
{
    char tmpstr[25], *ptr;

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Type            : ");
    switch(Config_obj.enforcevar.type)
    {
	case ULS         : strcat(optionsstr, "Uploads;");
                           strcat(optionsstr, "How many        : ");
                           break;
	case DLS         : strcat(optionsstr, "Downloads;");
                           strcat(optionsstr, "How many        : ");
                           break;
	case POSTS       : strcat(optionsstr, "Posts;");
			   strcat(optionsstr, "How many        : ");
			   break;
        case CALLS       : strcat(optionsstr, "Calls;");
                           strcat(optionsstr, "How many        : ");
                           break;
        case ULDL        : strcat(optionsstr, "Upload:Download ratio (Files);");
                           strcat(optionsstr, "Ratio           : ");
                           break;
        case ULDLKB      : strcat(optionsstr, "Upload:Download ratio (KB);");
			   strcat(optionsstr, "Ratio           : ");
                           break;
	case POSTCALL    : strcat(optionsstr, "Post:Call;");
                           strcat(optionsstr, "Ratio           : ");
                           break;
        case SUBSCRIPTION: strcat(optionsstr, "Subscription;");
			   strcat(optionsstr, "Criteria        : ");
                           break;
    }

    switch(Config_obj.enforcevar.type)
    {
	case ULS         : sprintf(tmpstr, "%ld;", Config_obj.enforcevar.num);
			   break;
	case DLS         : sprintf(tmpstr, "%ld;", Config_obj.enforcevar.num);
                           break;
        case CALLS       : sprintf(tmpstr, "%ld;", Config_obj.enforcevar.num);
                           break;
        case POSTS       : sprintf(tmpstr, "%ld;", Config_obj.enforcevar.num);
                           break;
        case ULDL        : sprintf(tmpstr, "%03ld:%03ld;", Config_obj.enforcevar.num, Config_obj.enforcevar.num2);
                           break;
	case ULDLKB      : sprintf(tmpstr, "%03ld:%03ld;", Config_obj.enforcevar.num, Config_obj.enforcevar.num2);
			   break;
        case POSTCALL    : sprintf(tmpstr, "%03ld:%03ld;", Config_obj.enforcevar.num, Config_obj.enforcevar.num2);
                           break;
        case SUBSCRIPTION: strcpy(tmpstr, "n/a;");
                           break;
    }

    ptr = tmpstr;
    if(*ptr  &&  strchr(tmpstr, ':'))
    {
        while(*ptr == '0')
	{
	    *ptr = ' ';
	    ptr++;
        }
        while(*ptr != ':')
        {
            ptr++;
        }
        ptr++;
        while(*ptr == '0')
	{
            *ptr = '';
            ptr++;
        }
        strcpy(tmpstr, Utility2_obj._squeeze(tmpstr));
    }
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Comparison type : ");
    if(Config_obj.enforcevar.type == SUBSCRIPTION)
    {
        strcat(optionsstr, "n/a;");
    }
    else
    {
        switch(Config_obj.enforcevar.comparison)
        {
            case GREATER: strcat(optionsstr, "Greater than;");
                          break;
            case LESS   : strcat(optionsstr, "Less than;");
                          break;
	    default     : Config_obj.enforcevar.comparison = GREATER;
			  strcat(optionsstr, "Greater than;");
                          break;
        }
    }

    strcat(optionsstr, "Days forward    : ");
    if(Config_obj.enforcevar.type == SUBSCRIPTION)
    {
        sprintf(tmpstr, "%d;", Config_obj.enforcevar.days_forward);
	strcat(optionsstr, tmpstr);
    }
    else
    {
	strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Current level   : ");
    switch(Config_obj.amu_cfgvar.BBStype)
    {
	case LORA      : strcat(optionsstr, Utility2_obj.get_userlevel(Config_obj.enforcevar.cur_level));
			 break;
	case MAXIMUS2  : strcat(optionsstr, Utility2_obj.get_maximus_userlevel(Config_obj.enforcevar.cur_level));
			 break;
	case MAXIMUS3  : strcat(optionsstr, level2alias(Config_obj.enforcevar.cur_level));
			 break;
	default        : sprintf(tmpstr, "%d", Config_obj.enforcevar.cur_level);
			 strcat(optionsstr, tmpstr);
			 break;
    }
    strcat(optionsstr, ";");

    strcat(optionsstr, "Next level      : ");
    switch(Config_obj.amu_cfgvar.BBStype)
    {
	case LORA      : strcat(optionsstr, Utility2_obj.get_userlevel(Config_obj.enforcevar.next_level));
			 break;
	case MAXIMUS2  : strcat(optionsstr, Utility2_obj.get_maximus_userlevel(Config_obj.enforcevar.next_level));
			 break;
	case MAXIMUS3  : strcat(optionsstr, level2alias(Config_obj.enforcevar.next_level));
			 break;
	default        : sprintf(tmpstr, "%d", Config_obj.enforcevar.next_level);
			 strcat(optionsstr, tmpstr);
			 break;
    }
    strcat(optionsstr, ";");

    strcat(optionsstr, "User msg area   : ");
    sprintf(tmpstr, "%d;", Config_obj.enforcevar.user_area);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "User msg name   : ");
    strcat(optionsstr, Config_obj.enforcevar.user_fn);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Sysop msg area  : ");
    sprintf(tmpstr, "%d;", Config_obj.enforcevar.sysop_area);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Sysop msg name  : ");
    strcat(optionsstr, Config_obj.enforcevar.sysop_fn);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Enabled         : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.enforcevar.enabled));

    strcat(optionsstr, "   ;");
    return(optionsstr);
}

void UserMenu_enforce::action(int position)
{
    char *tmpbuf, tmpstr[11];
    int offset, x, max3index;
    class Menus Menus_obj;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
        case 2: Menus_obj.get_enforcetype();
		break;
	case 3: Menus_obj.set_validtype(RANGE_3);
		if(Config_obj.enforcevar.type != SUBSCRIPTION)
		{
		    ltoa(Config_obj.enforcevar.num, tmpstr, 10);
		    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + 3, 5));
                    Config_obj.enforcevar.num = atol(tmpstr);
                    if(Config_obj.enforcevar.type == ULDL  ||  Config_obj.enforcevar.type == ULDLKB  ||  Config_obj.enforcevar.type == POSTCALL)
		    {
                        ltoa(Config_obj.enforcevar.num2, tmpstr, 10);
                        strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset + 4, cvar.top + 3, 3));
                        Config_obj.enforcevar.num2 = atol(tmpstr);
                    }
                }
                break;
        case 4: if(Config_obj.enforcevar.type != SUBSCRIPTION)
                {
		    Utility2_obj.toggle(&Config_obj.enforcevar.comparison);
                }
		break;
	case 5: Menus_obj.set_validtype(RANGE_7);
                sprintf(tmpstr, "%d", Config_obj.enforcevar.days_forward);
                strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + 5, 5));
                Config_obj.enforcevar.days_forward = atoi(tmpstr);
                break;
	case 6: Menus_obj.set_validtype(RANGE_2);
		switch(Config_obj.amu_cfgvar.BBStype)
		{
		    case LORA     : Menus_obj.get_userlevel(&Config_obj.enforcevar.cur_level);
				    break;
		    case MAXIMUS2 : Menus_obj.get_maximus2_userlevel(&Config_obj.enforcevar.cur_level);
				    break;
		    case MAXIMUS3 : Menus_obj.get_maximus3_userlevel(&max3index, max3str, num_levels);
				    Config_obj.enforcevar.cur_level = index2level(max3index);
				    break;
		    default       : sprintf(tmpstr, "%d", Config_obj.enforcevar.cur_level);
				    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 5));
				    Config_obj.enforcevar.cur_level = (unsigned) atol(tmpstr);
				    break;
		}
		break;
	case 7: Menus_obj.set_validtype(RANGE_2);
		switch(Config_obj.amu_cfgvar.BBStype)
		{
		    case LORA     : Menus_obj.get_userlevel(&Config_obj.enforcevar.next_level);
				    break;
		    case MAXIMUS2 : Menus_obj.get_maximus2_userlevel(&Config_obj.enforcevar.next_level);
				    break;
		    case MAXIMUS3 : Menus_obj.get_maximus3_userlevel(&max3index, max3str, num_levels);
				    Config_obj.enforcevar.next_level = index2level(max3index);
				    break;
		    default       : sprintf(tmpstr, "%d", Config_obj.enforcevar.next_level);
				    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 5));
				    Config_obj.enforcevar.next_level = (unsigned) atol(tmpstr);
				    break;
		}
		break;
	case 8: x = ListBox_obj.display_listbox(msglistbox, "Message areas", 50);
		if(x != -1)
		{
		    Config_obj.enforcevar.user_area = x;
		}
		break;
	case 9: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.enforcevar.user_fn,
		       Menus_obj.getfield(Config_obj.enforcevar.user_fn,
		       cvar.left + offset, cvar.top + position, 30));
		break;
	case 10: x = ListBox_obj.display_listbox(msglistbox, "Message areas", 50);
		 if(x != -1)
		 {
		     Config_obj.enforcevar.sysop_area = x;
		 }
		 break;	case 11: Menus_obj.set_validtype(FILENM);
		 strcpy(Config_obj.enforcevar.sysop_fn,
		       Menus_obj.getfield(Config_obj.enforcevar.sysop_fn,
		       cvar.left + offset, cvar.top + position, 30));
		 break;
	case 12: Utility2_obj.toggle(&Config_obj.enforcevar.enabled);
		 break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}


/**************************************************************************/


int UserMenu_msgs::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 11;
    cvar.width = 50;
    cvar.left = 14;
    cvar.top = 7;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(USERMSGS_RECORD);
    do
    {
	Menu_obj.help("User messages; F3 - Copy");
	Menu_obj.set_help(MSG_HELP);
	if(index > Config_obj.num_usermsgs)
	{
	    index = 1;
	}
	if(index <1)
	{
	    index = Config_obj.num_usermsgs;
	}
	Config_obj.read_record(USERMSGS_RECORD, index);
	sprintf(str, "User Msgs - Record %d/%d", index, Config_obj.num_usermsgs);
	if(Config_obj.usermsgsvar.deleted)
	{
	    strcat(str, " [Deleted]");
	}
	cvar.title = str;
	cvar.options = options();
	i = Menu_obj.dialog(&cvar, ENTER, 1);
	switch(i)
	{
	    case LEFT: index--;
		       break;
	    case RIGHT: index++;
			break;
	    case ENTER: cvar.position = 2;
			break;
	    case HOME: index = 1;
		       break;
	    case END: index = Config_obj.num_usermsgs;
		      break;
	    case DEL: Utility2_obj.toggle(&Config_obj.usermsgsvar.deleted);
		      Config_obj.update_record(USERMSGS_RECORD, index);
		      break;
	    case INS: Config_obj.add_record(USERMSGS_RECORD, ADD_NEW_RECORD);
		      index = Config_obj.num_usermsgs;
		      break;
	    case F1   : Menus_obj.online_help(_USERS);
			break;
	    case F3: Config_obj.add_record(USERMSGS_RECORD, COPY_CUR_RECORD);
		     index = Config_obj.num_usermsgs;
		     break;
	    case ESC: Config_obj.close_config(USERMSGS_RECORD);
		      return(i);
	}
	if(i == ENTER)
	{
	    crc = Crc_obj.struct_crc((char *) &Config_obj.usermsgsvar, USERMSGS_SIZE);
	    strcpy(str, "User Messages");
	    cvar.title = str;
	    do
	    {
		Menu_obj.set_help(MSG_HELP);
		cvar.options = options();
		i = Menu_obj.display_menu(&cvar, 1);
		switch(i)
		{
		    case ENTER: action(cvar.position);
				break;
		    case F1   : Menus_obj.online_help(_USERS);
				break;
		}
	    }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.usermsgsvar, USERMSGS_SIZE)  &&  Menu_obj.prompt(0))
	    {
		Config_obj.update_record(USERMSGS_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(USERMSGS_RECORD);
    return(i);
}

char *UserMenu_msgs::options(void)
{
    char tmpstr[31];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Type            : ");
    switch(Config_obj.usermsgsvar.type)
    {
	case MSG_NEWUSER  : strcat(optionsstr, "Newuser;");
			    break;
	case MSG_UPLOADS  : strcat(optionsstr, "Uploads;");
			    break;
	case MSG_CARRIER  : strcat(optionsstr, "Lost carrier;");
			    break;
	case MSG_BIRTHDAY : strcat(optionsstr, "Birthday;");
			    break;
	case MSG_SUBEXP   : strcat(optionsstr, "Subscription Exp.;");
			    break;
	case MSG_CREDIT   : strcat(optionsstr, "Low credit;");
			    break;
	default           : strcat(optionsstr, "Unknown type;");
			    break;
    }

    strcat(optionsstr, "Minimum credits : ");
    if(Config_obj.usermsgsvar.type == MSG_CREDIT)
    {
        sprintf(tmpstr, "%d;", Config_obj.usermsgsvar.num_credit);
        strcat(optionsstr, tmpstr);
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Post for zero?  : ");
    if(Config_obj.usermsgsvar.type == MSG_CREDIT)
    {
        strcat(optionsstr, Utility2_obj.YN(Config_obj.usermsgsvar.post_zero));
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Days before exp : ");
    if(Config_obj.usermsgsvar.type == MSG_SUBEXP)
    {
        sprintf(tmpstr, "%d;", Config_obj.usermsgsvar.num_days);
        strcat(optionsstr, tmpstr);
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "User msg area   : ");
    sprintf(tmpstr, "%d;", Config_obj.usermsgsvar.user_area);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "User msg name   : ");
    strcat(optionsstr, Config_obj.usermsgsvar.user_fn);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Sysop msg area  : ");
    sprintf(tmpstr, "%d;", Config_obj.usermsgsvar.sysop_area);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Sysop msg name  : ");
    strcat(optionsstr, Config_obj.usermsgsvar.sysop_fn);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Enabled         : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.usermsgsvar.enabled));

    strcat(optionsstr, "   ;");
    return(optionsstr);
}

void UserMenu_msgs::action(int position)
{
    char *tmpbuf, tmpstr[11];
    int offset, x;
    class Menus Menus_obj;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
	case 2: Menus_obj.get_messagestype();
		break;
	case 3: if(Config_obj.usermsgsvar.type == MSG_CREDIT)
		{
		    Menus_obj.set_validtype(RANGE_3);
		    sprintf(tmpstr, "%d", Config_obj.usermsgsvar.num_credit);
		    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
			   cvar.top + position, 5));
		    Config_obj.usermsgsvar.num_credit = atoi(tmpstr);
		}
		break;
	case 4: if(Config_obj.usermsgsvar.type == MSG_CREDIT)
		{
		    Utility2_obj.toggle(&Config_obj.usermsgsvar.post_zero);
		}
		break;
	case 5: if(Config_obj.usermsgsvar.type == MSG_SUBEXP)
		{
		    Menus_obj.set_validtype(RANGE_3);
		    sprintf(tmpstr, "%d", Config_obj.usermsgsvar.num_days);
		    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
			   cvar.top + position, 5));
		    Config_obj.usermsgsvar.num_days = atoi(tmpstr);
		}
		break;
	case 6: x = ListBox_obj.display_listbox(msglistbox, "Message areas", 50);
		if(x != -1)
		{
		    Config_obj.usermsgsvar.user_area = x;
		}
		break;
	case 7: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.usermsgsvar.user_fn,
		       Menus_obj.getfield(Config_obj.usermsgsvar.user_fn,
		       cvar.left + offset, cvar.top + position, 30));
		break;
	case 8: x = ListBox_obj.display_listbox(msglistbox, "Message areas", 50);
		if(x != -1)
		{
		    Config_obj.usermsgsvar.sysop_area = x;
		}
		break;	case 9: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.usermsgsvar.sysop_fn,
		       Menus_obj.getfield(Config_obj.usermsgsvar.sysop_fn,
		       cvar.left + offset, cvar.top + position, 30));
		break;
	case 10: Utility2_obj.toggle(&Config_obj.usermsgsvar.enabled);
		 break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}


/**************************************************************************/


/* EOF - UserMenu.CPP */
