/* Menu to allow editing of the TRACKING.AMU */
/* Created 19 April 1996                     */
/* Last updated 21 July 1996                 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include "trckmenu.h"
#include "config.h"
#include "menus.h"
#include "listbox.h"
#include "crc.h"
#include "utility.h"
#include "utility2.h"
#include "amuidx.h"

extern char curdir[256];
extern class Crc Crc_obj;
extern class Utility Utility_obj;
extern class Utility2 Utility2_obj;
extern class AreasBox AreasBox_obj;
extern class Menus Menus_obj;
extern class Config Config_obj;

/************************************************************************/
void EditTrackMenu::menu(int mode)
{
    int x, i;
    struct coordinates cvar;

    editlistbox = AreasBox_obj.create_listbox();
    listboxitem.itemnum = 0;
    Config_obj.open_config(FILEAREA_RECORD);
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
	Config_obj.read_record(FILEAREA_RECORD, x);
	strcpy(listboxitem.itemname, Config_obj.fileareavar.areaname);
	listboxitem.itemnum++;
	AreasBox_obj.additem(&listboxitem, &editlistbox);
    }
    Config_obj.close_config(FILEAREA_RECORD);

    cvar.uses_blanks = TRUE;
    cvar.items = 7;
    cvar.width = 20;
    cvar.left = 28;
    cvar.top = 9;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = "Tracking";

    change_comment = change_scan = change_rearc = change_import =
    change_export = FALSE;
    do
    {
        cvar.options = options();
        Menus_obj.set_help(NO_HELP);
	i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
	    case ENTER: action(cvar.position);
			break;
	    case F1   : Menus_obj.online_help(_MARK + mode);
			break;
	}
    }while(i != ESC);

    if(change_comment != 0 || change_scan != 0 || change_import != 0
       || change_export != 0 || change_rearc != 0)
    {
        memset(&Config_obj.areasvar, 0, AREAS_SIZE);
	AreasBox_obj.display_listbox(editlistbox, "Areas to change", 50);
        change_tracking(mode);
    }
    AreasBox_obj.destroy_listbox(&editlistbox);
}

void EditTrackMenu::action(int position)
{
    switch(position)
    {
        case 2: Utility2_obj.toggle(&change_comment);
                break;
        case 3: Utility2_obj.toggle(&change_scan);
                break;
        case 4: Utility2_obj.toggle(&change_import);
                break;
        case 5: Utility2_obj.toggle(&change_export);
                break;
        case 6: Utility2_obj.toggle(&change_rearc);
                break;
    }
}

char *EditTrackMenu::options(void)
{
    strcpy(optionsstr, " ;");

    strcat(optionsstr, "Comments    : ");
    strcat(optionsstr, Utility2_obj.YN(change_comment));

    strcat(optionsstr, "Virus Scan  : ");
    strcat(optionsstr, Utility2_obj.YN(change_scan));

    strcat(optionsstr, "Import DIZ  : ");
    strcat(optionsstr, Utility2_obj.YN(change_import));

    strcat(optionsstr, "Export DIZ  : ");
    strcat(optionsstr, Utility2_obj.YN(change_export));

    strcat(optionsstr, "Rearchive   : ");
    strcat(optionsstr, Utility2_obj.YN(change_rearc));

    strcat(optionsstr, " ;");
    return(optionsstr);
}

void EditTrackMenu::change_tracking(int mode)
{
    short newvalue, done, x, y, found;
    struct find_t fileinfo;
    struct tracking_record *trackptr, *trackarray;
    unsigned long num_recs, crc;
    FILE *trackfile;
    char fn[MAX_FILESPEC], str[71];

    trackarray = NULL;
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRACKING_AMU);
    trackfile = fopen(fn, "r+b");
    if(!trackfile)
    {
	trackfile = fopen(fn, "w+b");
	if(!trackfile)
	{
	    Menus_obj.help("!! Unable to create tracking file !!");
	    sleep(2);
	    return;
	}
    }
    num_recs = filelength(fileno(trackfile)) / sizeof(struct tracking_record);
    trackarray = (struct tracking_record *) calloc(num_recs, sizeof(struct tracking_record));
    if(!trackarray && num_recs > 0)
    {
//	Menus_obj.help("!! Out of memory !!");
//	sleep(2);
	fclose(trackfile);
//	return;
    }

    if(trackarray && num_recs > 0)
    {
	fread(trackarray, filelength(fileno(trackfile)), 1, trackfile);
    }

    switch(mode)
    {
	case AREAS_ON : newvalue = 1;
			break;
	case AREAS_OFF: newvalue = 0;
			break;
    }

    Config_obj.open_config(FILEAREA_RECORD);
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
       if(Config_obj.active(x))
       {
	   sprintf(str, "Making changes, please wait (Area #%d)...", x);
	   Menus_obj.help(str);
	   Config_obj.read_record(FILEAREA_RECORD, x);
	   sprintf(fn, "%s*.*", Config_obj.fileareavar.filepath);
	   done = _dos_findfirst(fn, _A_ARCH, &fileinfo);
	   while(!done)
	   {
	       sprintf(fn, "%s%s", Config_obj.fileareavar.filepath, fileinfo.name);
	       crc = Crc_obj.crc32(fn);

	       if(trackarray)
	       {
		   trackptr = trackarray;
		   found = FALSE;
		   for(y = 0; y < num_recs; y++)
		   {
		       if(trackptr -> filecrc == crc)
		       {
			   found = TRUE;
			   break;
		       }
		       trackptr++;
		   }
		   if(!found)
		   {
		       num_recs++;
		       trackarray = (struct tracking_record *) realloc(trackarray, num_recs * sizeof(struct tracking_record));
		       trackptr = trackarray;
		       trackptr += (num_recs - 1);
		       memset(trackptr, NULL, sizeof(struct tracking_record));
		       trackptr -> filecrc = crc;
		       trackptr -> recnum = num_recs;
		   }
	       }
	       else
	       {
		   trackptr = Utility_obj.read_tracking(fn);
	       }

	       if(change_comment)
	       {
		   trackptr -> status.commented = newvalue;
	       }
	       if(change_scan)
	       {
		   trackptr -> status.scanned = newvalue;
	       }
	       if(change_rearc)
	       {
		   trackptr -> status.rearced = newvalue;
	       }
	       if(change_import)
	       {
		   trackptr -> status.imported = newvalue;
	       }
	       if(change_export)
	       {
		   trackptr -> status.exported = newvalue;
	       }

	       if(!trackarray)
	       {
		   Utility_obj.update_tracking(trackptr);
	       }

	       done = _dos_findnext(&fileinfo);
	   }
       }
    }
    Config_obj.close_config(FILEAREA_RECORD);

    if(trackarray)
    {
	fseek(trackfile, 0, SEEK_SET);
	fwrite(trackarray, sizeof(struct tracking_record) * num_recs, 1, trackfile);
	fclose(trackfile);
	free(trackarray);
    }
}

/***********************************************************************/
/* EOF - TRCKMENU.CPP */
