// Convert a description into Telegard 3.02's format, Y2K
// Created 11 October 1997
// Revised 06 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <string.h>
#include <ctype.h>
#include "tgfdb.h"

// Constructor - takes 'desc' and converts it into a TG format
Tgfdb::Tgfdb(char *desc)
{
    int index, length;
    char *dptr, *tmpptr;

    num_blocks = 0;
    memset(blocks, NULL, sizeof(blocks));
    if(!desc || *desc == NULL)
    {
	return;
    }

    // Loop through 'desc' and break it into 45 character blocks
    for(index = 0; index < MAX_TG_BLOCKS; index++)
    {
	// If it's at the end, get out of this loop
	if(*desc == NULL)
	{
	    break;
	}

	dptr = blocks[index];
	length = 0;
	num_blocks++;

	// Run through 'desc' until we hit the max length, \n, or null
	while(*desc && length <= TG_DESC_LEN && (*desc != '\n' && *desc != '\r'))
	{
	    *dptr = *desc;
	    dptr++;
	    desc++;
	    length++;
	}

	// If it broke out because it hit a NULL, we're done
	if(*desc == NULL)
	{
	    break;
	}

	// If it broke out because it hit a \n, we're done with this line
	if(*desc == '\n' || *desc == '\r')
	{
	    blocks[index][45] = NULL;
	    desc++;
	    continue;
	}

	// Otherwise it broke out because the line was too long...
	if(length >= TG_DESC_LEN)
	{
	    // save the current position, just in case
	    tmpptr = desc;

	    desc--;
	    while(!isspace(*desc) && length > 0)
	    {
		desc--;
		dptr--;
		length--;
	    }

	    // If it decrements too far, restore the saved pointer and
	    // just go with the full 45 characters, something is strange,
	    // there's no way to figure out what it is short of AI
	    if(length <= 0)
	    {
		desc = tmpptr;
	    }
	    else
	    {
		*dptr = NULL;
	    }
	}
    }

/*
    for(index = 0; index < MAX_TG_BLOCKS; index++)
    {
	Amustr_obj.trimlead(blocks[index]);
	Amustr_obj.trimend(blocks[index]);
    }
*/
}

// Return the number of 45 character blocks in this description
int Tgfdb::get_num_blocks(void)
{
    return(num_blocks);
}

// Return a pointer to the block indicated by 'block_num'
char *Tgfdb::get_tg_block(int block_num)
{
    if(block_num > num_blocks || block_num < 1)
    {
	return(NULL);
    }

    return(blocks[block_num-1]);
}

// EOF - TGFDB.CPP
