/* Functions for the System menu */
/* Created 10 September 1995     */
/* Revised 23 July 1997          */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include "execute.h"
#include "menus.h"
#include "listbox.h"
#include "sysmenu.h"
#include "utility2.h"
#include "amustr.h"
#include "crc.h"
#include "config.h"
#include "logsmenu.h"
#include "utility.h"
#include "amuidx.h"

class LogsMenu LogsMenu_obj;

/* external objects */
extern class Utility Utility_obj;
extern class Config Config_obj;
extern class Amustr Amustr_obj;
extern class ListBox ListBox_obj;
extern class Utility2 Utility2_obj;
extern class Menus Menus_obj;
extern class Crc Crc_obj;

extern struct amucfg amu_cfgvar;
extern listbox *msglistbox, *filelistbox;
extern int check_bbsfiles(int force_import);
extern int check_bbsmsgs(int force_import);

/*********************************************************************/

void SysMenu::menu(void)
{
    int i;
    struct coordinates cvar;
    char *tmpbuf;

    tmpbuf = (char *)malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    cvar.uses_blanks = TRUE;
    cvar.items = 6;
    cvar.width = 19;
    cvar.left = 37;
    cvar.top = 9;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = "System data";
    cvar.options = options();
    do
    {
        Menus_obj.set_help(MAIN_SYSTEM_HELP);
        i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(cvar.position - 2 + _SYSTEM);
                        break;
        }
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

char *SysMenu::options(void)
{
    static char str[81];

    strcpy(str, " ;System;Pathnames;Filenames;Logfiles; ;");
    return(str);
}

void SysMenu::action(int position)
{
    char *tmpbuf;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
        case 2: System_obj.menu();
                break;
        case 3: Pathnames_obj.menu();
                break;
        case 4: Filenames_obj.menu();
                break;
        case 5: LogsMenu_obj.menu();
		break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/**************************************************************************/

int SysMenu_system::menu(void)
{
    int i;
    char *tmpbuf, str[21];

    cvar.uses_blanks = TRUE;
    cvar.items = 19;
    cvar.width = 51;
    cvar.left = 15;
    cvar.top = 4;
    cvar.position = 2;
    cvar.high_num = 13;
    strcpy(str, "System information");
    cvar.title = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        Menus_obj.set_help(SYSTEM_HELP);
        cvar.options = options();
        i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(_SYSTEM);
                        break;
	}
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(i);
}

char *SysMenu_system::options(void)
{
    char tmpstr[11], *ptr;

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Sysop name  : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.sysop);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Sysop alias : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.sysopalias);
    strcat(optionsstr, ";");

    strcat(optionsstr, "BBS name    : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.bbsname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Date format : ");
    strcat(optionsstr, Utility2_obj.datetype_str(Config_obj.amu_cfgvar.date_format));

/*
        #define MODE_1 (SWAP_ANY)
        #define MODE_2 (SWAP_EMS | SWAP_XMS)
        #define MODE_3 (SWAP_DISK)
*/

    strcat(optionsstr, "Swapping    : ");
    #if defined (__DOS__)
    switch(Config_obj.amu_cfgvar.swaptype)
    {
        case MODE_1: strcat(optionsstr, "XMS/EMS/DISK;");
                     break;
        case MODE_2: strcat(optionsstr, "XMS/EMS;");
                     break;
        case MODE_3: strcat(optionsstr, "DISK;");
                     break;
        default: strcat(optionsstr, "XMS/EMS/DISK;");
		 Config_obj.amu_cfgvar.swaptype = MODE_1;
                 break;
    }
    #else
    strcat(optionsstr, "N/A for OS/2;");
    #endif

    strcat(optionsstr, "BBS type    : ");
    strcat(optionsstr, Utility2_obj.BBSstr(Config_obj.amu_cfgvar.BBStype));
    ptr = NULL;
    switch(Config_obj.amu_cfgvar.BBStype)
    {
	case RA2     :
	case RA1     :
	case RA250   : ptr = getenv("RA");
		       break;
	case QBBS    :
	case QBBSG   :
	case QBBSC   : ptr = getenv("QUICK");
		       break;
	case CONCORD : ptr = getenv("CONCORD");
		       break;
	case LORA3   :
	case LORA    : ptr = getenv("LORA");
		       break;
	case MAXIMUS2:
	case MAXIMUS3: ptr = getenv("MAX");
		       if(!ptr)
		       {
			   ptr = getenv("MAXIMUS");
		       }
		       break;
	case PB2     : ptr = getenv("PROBOARD");
		       break;
        case EZ      : ptr = getenv("EZY");
                       break;
 
    }
    if(ptr)
    {
	strcpy(Config_obj.amu_cfgvar.BBSsyspath, ptr);
	strupr(Config_obj.amu_cfgvar.BBSsyspath);
	if(Config_obj.amu_cfgvar.BBStype == MAXIMUS2 ||
	   Config_obj.amu_cfgvar.BBStype == MAXIMUS3)
	{
	    ptr = strstr(Config_obj.amu_cfgvar.BBSsyspath, "MAX.");
	    if(ptr)
	    {
		*ptr = NULL;
            }
        }
        Amustr_obj.slash(Config_obj.amu_cfgvar.BBSsyspath);
    }

    strcat(optionsstr, "Mailer type : ");
    strcat(optionsstr, Utility2_obj.mailerstr(Config_obj.amu_cfgvar.mailertype));

    strcat(optionsstr, "Alias system: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.alias_system));

    strcat(optionsstr, "Post logfile: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.postlog));

    strcat(optionsstr, "Post errors : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.posterrors));

    strcat(optionsstr, "Post area   : ");
    sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.amu_area);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Switch      : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar._switch));

    strcat(optionsstr, "Clean users : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.clean));

    strcat(optionsstr, "Log level   : ");
    switch(Config_obj.amu_cfgvar.logging_level)
    {
        case LOG_MINIMAL  : strcat(optionsstr, "Minimal;");
                            break;
        case LOG_NORMAL   : strcat(optionsstr, "Normal;");
			    break;
        case LOG_EXTENSIVE: strcat(optionsstr, "Extensive;");
			    break;
    }

    strcat(optionsstr, "Old config  : ");
    switch(Config_obj.amu_cfgvar.old_config)
    {
	case CFG_ABORT   : strcat(optionsstr, "Abort;");
			   break;
	case CFG_IGNORE  : strcat(optionsstr, "Use old data;");
			   break;
	case CFG_IMPORT  : strcat(optionsstr, "Import new data;");
			   break;
    }

    strcat(optionsstr, "Password    : ;");

    strcat(optionsstr, "Date Sep.   : ");
    sprintf(tmpstr, "%c;", Config_obj.amu_cfgvar.date_separator);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void SysMenu_system::action(int position)
{
    char *tmpbuf, password[21], tmpstr[5];
    int offset = 16;
    short x;

    tmpbuf = (char *)malloc(4000);
    Menus_obj.set_validtype(SPACES_OK);
    switch(position)
    {
	case 2: strcpy(Config_obj.amu_cfgvar.sysop, Menus_obj.getfield(Config_obj.amu_cfgvar.sysop, cvar.left + offset, cvar.top + 2, 35));
		break;
	case 3: strcpy(Config_obj.amu_cfgvar.sysopalias, Menus_obj.getfield(Config_obj.amu_cfgvar.sysopalias, cvar.left + offset, cvar.top + 3, 35));
                break;
        case 4: strcpy(Config_obj.amu_cfgvar.bbsname, Menus_obj.getfield(Config_obj.amu_cfgvar.bbsname, cvar.left + offset, cvar.top + 4, 35));
                break;
        case 5: Menus_obj.get_datetype(&Config_obj.amu_cfgvar.date_format);
                break;
        case 6: Menus_obj.get_swaptype(&Config_obj.amu_cfgvar.swaptype);
                break;
	case 7: Menus_obj.get_bbstype(&Config_obj.amu_cfgvar.BBStype);
		check_bbsfiles(FALSE);
		check_bbsmsgs(FALSE);
                break;
	case 8: Menus_obj.get_mailertype(&Config_obj.amu_cfgvar.mailertype);
		break;
        case 9: Utility2_obj.toggle(&Config_obj.amu_cfgvar.alias_system);
                break;
	case 10: Utility2_obj.toggle(&Config_obj.amu_cfgvar.postlog);
                 break;
        case 11: Utility2_obj.toggle(&Config_obj.amu_cfgvar.posterrors);
                 break;
        case 12: check_bbsmsgs(FALSE);
                 gettext(1, 1, 80, 25, tmpbuf);
		 x = ListBox_obj.display_listbox(msglistbox, "Available message areas", 50);
                 if(x != -1)
                 {
                     Config_obj.amu_cfgvar.amu_area = x;
                 }
		 puttext(1, 1, 80, 25, tmpbuf);
                 break;
	case 13: Utility2_obj.toggle(&Config_obj.amu_cfgvar._switch);
                 break;
        case 14: Utility2_obj.toggle(&Config_obj.amu_cfgvar.clean);
                 break;
        case 15: Menus_obj.get_loglevel(&Config_obj.amu_cfgvar.logging_level);
		 break;
	case 16: Menus_obj.get_oldconfig(&Config_obj.amu_cfgvar.old_config);
		 break;
	case 17: password[0] = NULL;
		 strcpy(password, Menus_obj.getfield(password, cvar.left + offset, cvar.top + 17, 15));
		 if(password[0] == NULL)
		 {
		     Config_obj.amu_cfgvar.passwordcrc = 0;
		 }
		 else
		 {
		     Config_obj.amu_cfgvar.passwordcrc = Crc_obj.crc32(password);
		 }
		 break;
	case 18: Menus_obj.set_validtype(FILENM);
		 sprintf(tmpstr, "%c", Config_obj.amu_cfgvar.date_separator);
		 strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 1));
		 Config_obj.amu_cfgvar.date_separator = tmpstr[0];
		 Menus_obj.set_validtype(SPACES_OK);
		 break;
    }
    free(tmpbuf);
}

/************************************************************************/

int SysMenu_pathnames::menu(void)
{
    int i;
    char *tmpbuf, str[21];

    cvar.uses_blanks = TRUE;
    cvar.items = 9;
    cvar.width = 55;
    cvar.left = 12;
    cvar.top = 7;
    cvar.position = 2;
    cvar.high_num = 11;

    strcpy(str, "System directories");
    cvar.title = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        Menus_obj.set_help(PATHNAMES_HELP);
        cvar.options = options();
        i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(_PATHNAMES);
                        break;
        }
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(i);
}

char *SysMenu_pathnames::options(void)
{
    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "AMU Path  : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.AMUpath);
    strcat(optionsstr, ";");

    strcat(optionsstr, "BBS Path  : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.BBSsyspath);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Work Path : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.workpath);
    strcat(optionsstr, ";");

    strcat(optionsstr, "User Path : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.userpath);
    strcat(optionsstr, ";");

    switch(Config_obj.amu_cfgvar.BBStype)
    {
	case QBBSG:  strcat(optionsstr, "GoldBase  : ");
		     break;
	case EZ   :  strcat(optionsstr, "EzyCom    : ");
		     break;
	default   :  strcat(optionsstr, "HMB Path  : ");
		     break;

    }
    strcat(optionsstr, Config_obj.amu_cfgvar.hmbpath);
    strcat(optionsstr, ";");

    strcat(optionsstr, "FDB Path  : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.FDBpath);
    strcat(optionsstr, ";");

    strcat(optionsstr, "CDROM list: ");
    if(Config_obj.amu_cfgvar.BBStype == RA1)
    {
        strcat(optionsstr, Config_obj.amu_cfgvar.cdlistpath);
    }
    else
    {
        strcat(optionsstr, "Not applicable for your BBS software");
    }
    strcat(optionsstr, ";");

         strcat(optionsstr, "  ;");
	 return(optionsstr);
}

void SysMenu_pathnames::action(int position)
{
    int offset = 14;

    Menus_obj.set_validtype(PATH);
    switch(position)
    {
        case 2: strcpy(Config_obj.amu_cfgvar.AMUpath, Menus_obj.getfield(Config_obj.amu_cfgvar.AMUpath, cvar.left + offset, cvar.top + 2, 40));
                break;
        case 3: strcpy(Config_obj.amu_cfgvar.BBSsyspath, Menus_obj.getfield(Config_obj.amu_cfgvar.BBSsyspath, cvar.left + offset, cvar.top + 3, 40));
		check_bbsfiles(FALSE);
		check_bbsmsgs(FALSE);
                break;
        case 4: strcpy(Config_obj.amu_cfgvar.workpath, Menus_obj.getfield(Config_obj.amu_cfgvar.workpath, cvar.left + offset, cvar.top + 4, 40));
                break;
        case 5: strcpy(Config_obj.amu_cfgvar.userpath, Menus_obj.getfield(Config_obj.amu_cfgvar.userpath, cvar.left + offset, cvar.top + 5, 40));
                break;
	case 6: strcpy(Config_obj.amu_cfgvar.hmbpath, Menus_obj.getfield(Config_obj.amu_cfgvar.hmbpath, cvar.left + offset, cvar.top + 6, 40));
                break;
	case 7: strcpy(Config_obj.amu_cfgvar.FDBpath, Menus_obj.getfield(Config_obj.amu_cfgvar.FDBpath, cvar.left + offset, cvar.top + 7, 40));
                break;
        case 8: if(Config_obj.amu_cfgvar.BBStype == RA1)
		{
                    strcpy(Config_obj.amu_cfgvar.cdlistpath, Menus_obj.getfield(Config_obj.amu_cfgvar.cdlistpath, cvar.left + offset, cvar.top + 8, 40));
		}
		break;
    }
}


/************************************************************************/

int SysMenu_filenames::menu(void)
{
	 int i;
	 char *tmpbuf, str[21];

    cvar.uses_blanks = TRUE;
    cvar.items = 6;
    cvar.width = 55;
    cvar.left = 12;
    cvar.top = 10;
    cvar.position = 2;
    cvar.high_num = 11;

    strcpy(str, "System filenames");
    cvar.title = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        Menus_obj.set_help(FILENAMES_HELP);
        cvar.options = options();
	i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(_FILENAMES);
                        break;
        }
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(i);
}

char *SysMenu_filenames::options(void)
{
    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "AMU log   : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.AMUlogfile);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Freq dirs : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.freqdirs);
    strcat(optionsstr, ";");

    strcat(optionsstr, "DOS Editor: ");
    strcat(optionsstr, Config_obj.amu_cfgvar.doseditor);
    strcat(optionsstr, ";");

    strcat(optionsstr, "OS2 Editor: ");
    strcat(optionsstr, Config_obj.amu_cfgvar.os2editor);
    strcat(optionsstr, ";");

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void SysMenu_filenames::action(int position)
{
    int offset = 14;

    Menus_obj.set_validtype(FILENM);
    switch(position)
    {
        case 2: strcpy(Config_obj.amu_cfgvar.AMUlogfile, Menus_obj.getfield(Config_obj.amu_cfgvar.AMUlogfile, cvar.left + offset, cvar.top + 2, 40));
                break;
        case 3: strcpy(Config_obj.amu_cfgvar.freqdirs, Menus_obj.getfield(Config_obj.amu_cfgvar.freqdirs, cvar.left + offset, cvar.top + 3, 40));
                break;
        case 4: strcpy(Config_obj.amu_cfgvar.doseditor, Menus_obj.getfield(Config_obj.amu_cfgvar.doseditor, cvar.left + offset, cvar.top + 4, 40));
                break;
        case 5: strcpy(Config_obj.amu_cfgvar.os2editor, Menus_obj.getfield(Config_obj.amu_cfgvar.os2editor, cvar.left + offset, cvar.top + 5, 40));
                break;
    }
}

/* EOF - SYSMENU.CPP */


