// Functions to switch menus/textfiles, Y2K
// Created 21 March 1996
// Revised 06 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include "screen.h"
#include "switch.h"
#include "config.h"
#include "extern.h"

// external objects
extern class Config Config_obj;
extern class Screen Screen_obj;

/***************************************************************************/

Switch::Switch(void)
{
  // Empty constructor
}

void Switch::switch_(void)
{
    FILE *switchfile;
    char newdest[81], tempname[81], target[81], fn[81];
    int i, j;
    struct screeninfo s;
    time_t t;

    srand((unsigned) time(&t));
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, SWITCH);
    switchfile = fopen(fn, "rt");
    if(!switchfile)
    {
	sprintf(LOGSTR, "! [SWITCH] Could not open '%s'", fn);
	Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	return;
    }

    for(i = 0; i < MAX_STR; i++)
    {
	switcharray[i] = (struct switch_struct *) calloc(1, sizeof(switchvar));
    }

    strcpy(s.curoption, "Picking random menus/textfiles");
    Utility_obj.logentry(s.curoption, LOG_MINIMAL);
    i = 0;
    fgets(tempname, 79, switchfile);
    strncpy(newdest, tempname, sizeof(newdest) - 1);
    do
    {
	strcpy(s.curarea, newdest);
	Screen_obj.display(&s);

	/* If this is a target name... */
	if(tempname[0] == '-')
	{
	    i = 0;
	    Amustr_obj.trimend(tempname);
	    Amustr_obj.trimlead(tempname);
	    Amustr_obj.strip_n(tempname);

	    /* Get rid of the '-' at the beginning */
	    strrev(tempname);
	    tempname[strlen(tempname)-1] = NULL;
	    strrev(tempname);

	    strncpy(target, tempname, sizeof(target) - 1);

	    do
	    {
		fgets(tempname, 79, switchfile);
		Amustr_obj.trimlead(tempname);
		Amustr_obj.trimend(tempname);
		Amustr_obj.strip_n(tempname);

		if(tempname[0] != '-')
		{
		    strncpy(switcharray[i]->s, tempname, sizeof(switcharray[i]->s) - 1);
		    i++;
		}
	    }while(tempname[0] != '-'  &&  i < 50  &&  !feof(switchfile));

	    if(tempname[0] == '-')
	    {
		strncpy(newdest, tempname, sizeof(newdest) - 1);
	    }

	    j = rand() % i;

	    sprintf(LOGSTR, "[SWITCH] Copying %s  --->  '%s'", switcharray[j]->s, target);
	    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
	    Utility_obj.copyfile(switcharray[j]->s, target);
	}

	/* if this is the final '-' delimater indicating an EOF... get outta here */
	if(newdest[0] == '-'  &&  newdest[1] == NULL)
	{
	    break;
	}
    }while(!feof(switchfile));
    fclose(switchfile);

    for(i = 0; i < MAX_STR; i++)
    {
	free(switcharray[i]);
    }
}

// EOF SWITCH.CPP
