/* Structures for the Squish message base */
/* Based on the Squish version 2.0 developers kit information */
#if !defined(__SQUISH_H__)

#define __SQUISH_H__)
#define word unsigned short
#define sword short
#define dword unsigned long
#define byte unsigned char
#define FOFS unsigned long

struct NETADDR
{
    unsigned short zone,
		   net,
		   node,
		   point;
};

struct __stamp   /* DOS-style datestamp */
{
  struct
  {
    unsigned short da : 5;
    unsigned short mo : 4;
    unsigned short yr : 7;
  } date;

  struct
  {
    unsigned short ss : 5;
    unsigned short mm : 6;
    unsigned short hh : 5;
  } time;
};

/* Format of the Data File - *.SQD */
/* Static header at the beginning of each .SQD file */
struct _squishhdr
{
  word len;               /* LENGTH OF THIS STRUCTURE! */           /*   0 */
  word rsvd1;             /* reserved */                            /*   2 */

  dword num_msg;          /* Number of messages in area */          /*   4 */
  dword high_msg;         /* Highest msg in area. Same as num_msg*/ /*   8 */
  dword skip_msg;         /* Skip killing first x msgs in area */   /*  12 */
  dword high_water;       /* Msg# (not umsgid) of HWM */            /*  16 */

  dword uid;              /* Number of the next UMSGID to use */    /*  20 */

  byte base[80];          /* Base name of SquishFile */             /*  24 */

  FOFS begin_frame;       /* Offset of first frame in file */       /* 104 */
  FOFS last_frame;        /* Offset to last frame in file */        /* 108 */
  FOFS free_frame;        /* Offset of first FREE frame in file */  /* 112 */
  FOFS last_free_frame;   /* Offset of last free frame in file */   /* 116 */
  FOFS end_frame;         /* Pointer to end of file */              /* 120 */

  dword max_msg;          /* Max # of msgs to keep in area */       /* 124 */
  word keep_days;         /* Max age of msgs in area (SQPack) */    /* 128 */
  word sz_sqhdr;          /* sizeof(SQHDR) */                       /* 130 */
  byte rsvd2[124];        /* Reserved by Squish for future use*/    /* 132 */

							     /* total: 256 */
};

/* Header for each message frame */
struct _sqmsghdr
{
  #define SQHDRID       0xafae4453L

  dword id;             /* sqhdr.id must always equal SQHDRID */

  FOFS next_frame;
  FOFS prev_frame;

  dword frame_length;
  dword msg_length;
  dword clen;

  word frame_type;
  word rsvd;
};


/* XMSG structure */
typedef struct
{
  dword attr;

  /* Bitmasks for 'attr' */

  #define MSGPRIVATE 0x0001
  #define MSGCRASH   0x0002
  #define MSGREAD    0x0004
  #define MSGSENT    0x0008
  #define MSGFILE    0x0010
  #define MSGFWD     0x0020
  #define MSGORPHAN  0x0040
  #define MSGKILL    0x0080
  #define MSGLOCAL   0x0100
  #define MSGHOLD    0x0200
  #define MSGXX2     0x0400
  #define MSGFRQ     0x0800
  #define MSGRRQ     0x1000
  #define MSGCPT     0x2000
  #define MSGARQ     0x4000
  #define MSGURQ     0x8000
  #define MSGSCANNED 0x00010000L
  #define MSGUID     0x00020000

  #define XMSG_FROM_SIZE  36
  #define XMSG_TO_SIZE    36
  #define XMSG_SUBJ_SIZE  72

  char from[XMSG_FROM_SIZE];
  char to[XMSG_TO_SIZE];
  char subj[XMSG_SUBJ_SIZE];

  struct NETADDR orig;        /* Origination and destination addresses             */
  struct NETADDR dest;

  struct __stamp date_written;  /* When user wrote the msg (UTC)            */
  struct __stamp date_arrived;  /* When msg arrived on-line (UTC)           */
  sword utc_ofs;                /* Offset from UTC of message writer, in    *
				 * minutes.                                 */

  #define MAX_REPLY 9          /* Max number of stored replies to one msg  */

  dword replyto;
  dword replies[MAX_REPLY];
  dword umsgid;

  char  ftsc_date[20];  /* Obsolete date information.  If it weren't for the *
			* fact that FTSC standards say that one cannot      *
			* modify an in-transit message, I'd be VERY         *
			* tempted to axe this field entirely, and recreate  *
			* an FTSC-compatible date field using               *
			* the information in 'date_written' upon            *
			* export.  Nobody should use this field, except     *
			* possibly for tossers and scanners.  All others    *
			* should use one of the two binary datestamps,      *
			* above.                                            */
}XMSG;


/* Squish index structure - *.SQI */
struct _sqidx
{
  FOFS ofs;
  dword umsgid;
  dword hash;
};

#undef byte
#undef word
#undef dword
#undef sword
#undef FOFS
#endif
/*********************************************************************/
/* EOF - SQUISH.H */
