// Implementation of an Insertion Sort, Y2K
// Created 31 March 1996
// Revised 06 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "extern.h"
#include "sort.h"

/* Constructor */
InsertSort::InsertSort(void)
{
    s = NULL;
    progress = 0;
}

/* Destructor */
InsertSort::~InsertSort(void)
{
    if(s != NULL)
    {
	freearray();
    }
}

/***************Initialize the sorting array*****************/
sortptr InsertSort::sortinit(void)
{
    short x;

    progress = 0;
    s = (sortptr) calloc(MAX_SORT, sizeof(struct sort_array));
    if(s)
    {
	for(x = 0; x < MAX_SORT; x++)
	{
	    s[x].sortfield = -1;
	}
    }
    return(s);
}

/****Takes the input and adds it to the sorting array if applicable*****/
void InsertSort::addtoarray(sortptr newentry)
{
    short low_index, j;

    j = low_index = 0;
    if(progress < MAX_SORT)
    {
	memcpy(&s[progress], newentry, sizeof(struct sort_array));
    }
    else
    {
	for(j = 0; j < MAX_SORT; j++)
	{
	    if(s[j].sortfield < s[low_index].sortfield)
	    {
		low_index = j;
	    }
	}
	memcpy(&s[low_index], newentry, sizeof(struct sort_array));
    }
    progress++;
}

/********Sort the array**********/
void InsertSort::sortarray(void)
{
    short k, j;
    struct sort_array tmpsort;

    /* Perform a bubblesort on the file */
    for(k = 0; k < (MAX_SORT - 1); k++)
    {
	for(j = k+1; j < MAX_SORT; j++)
	{
		    /* If the second record should come before the first, swap 'em */
	    if(s[j].sortfield > s[k].sortfield)
	    {
		/* Make a copy of 'k' */
		memcpy(&tmpsort, &s[k], sizeof(struct sort_array));

		/* Dump 'j' into 'k's slot */
		memcpy(&s[k], &s[j], sizeof(struct sort_array));

		/* Dump the copy of 'k' into j's slot */
		memcpy(&s[j], &tmpsort, sizeof(struct sort_array));
	    }
	}
    } /* End sort */
}

/* Free the sorting array */
void InsertSort::freearray(void)
{
    if(s != NULL)
    {
	free(s);
	s = NULL;
    }
}

// EOF - SORT.CPP
