// Class declaration for the Screen object, Y2K
// Created 05 May 1996
// Revised 06 January 1998

#if !defined(__SCREEN_LOADED__)
#define __SCREEN_LOADED__

#include "extern.h"
#include "utility.h"
#include "utility2.h"
#include "amustr.h"

#if defined(__AMU95__)
  #include <windows.h>
#endif

struct screeninfo
{
    char curoption[151],    	/* Description of current option 	*/
	 curarea[151];		/* Current file/msg area, or Blank	*/
    float progress;             /* Percent completed                    */
};

class Screen
{
    private:
    class Utility Utility_obj;
    class Utility2 Utility2_obj;
    class Amustr Amustr_obj;
    short Swapping_Ok;
    char Color;
    unsigned int SCREEN_AREA, SCREEN_LIN_ADDR, SCREEN_SIZE;
#if defined(__AMU95__)
    CONSOLE_CURSOR_INFO Cinfo;
    HANDLE hStdin, hStdout;
    DWORD result;
    COORD coord;
#endif


    public:
    Screen(void);
    void set_swapping(int x) { Swapping_Ok = x; }
    void writestr(int x, int y, char color, char *str);
    void screen_init(void);
    void display(struct screeninfo *s);
    void shutdown(void);
    void putscreen(char *buf);
    void getscreen(char *buf);
    void clearscreen(void);
    void hide_cursor(void);
};
#endif

/************************************************************************/
// EOF - SCREEN.H
