// Screen I/O routines, Y2K
// Created 28 February 1996
// Revised 06 January 1998

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <mem.h>
#include "extern.h"
#include "screen.h"
#include "config.h"

// External objects
extern class Config Config_obj;
extern int use_mono;

#if defined(__AMU32__) || defined(__AMU95__)

    #if defined(__AMU32__)
      #include <graph.h>
    #endif

#define BLACK        0
#define BLUE         1
#define GREEN        2
#define CYAN         3
#define RED          4
#define MAGENTA      5
#define BROWN        6
#define LIGHTGRAY    7
#define DARKGRAY     8
#define LIGHTBLUE    9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15
#define BLINK        128
#endif

#if defined(__AMU2__) || defined(__AMU16__)
  #include <conio.h>
#endif

#if defined(__AMU95__)
  #include <windows.h>
#endif

Screen::Screen(void)
{
    Swapping_Ok = TRUE;
#if defined(__AMU95__)
    char str[81];

    sprintf(str, "AMU %s", VERSION);
    AllocConsole();
    SetConsoleTitle(str);
    hStdin = GetStdHandle(STD_INPUT_HANDLE);
    hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
#endif
}

/*****************************************************************/
/* Display a window with the information from the 's' structure */
void Screen::display(struct screeninfo *s)
{
    char str[11];

    s -> curarea[40] = NULL;
    s -> curoption[40] = NULL;
    Amustr_obj.strip_n(s -> curarea);
    Amustr_obj.strip_n(s -> curoption);
    Color = CYAN | BLACK * 16;
    Amustr_obj.pad(s -> curarea, 40);
    Amustr_obj.pad(s -> curoption, 40);
    writestr(29, 13, Color, s->curarea);
    writestr(29, 14, Color, s->curoption);
    sprintf(str, "%d", Utility_obj.get_errors());
    writestr(29, 15, Color, str);
}


/********************************************************************/
/* Initialize the screen */
void Screen::screen_init(void)
{
    short i;
    char str[151], tmpstr[151], *ptr;

#if defined(__AMU32__)
    if(use_mono)
    {
        SCREEN_AREA = 0xb000;
    }
    else
    {
        SCREEN_AREA = 0xb800;
    }
    SCREEN_LIN_ADDR = ((SCREEN_AREA) << 4);
    SCREEN_SIZE = 80 * 25;
#endif

#if defined(__AMU2__) || defined(__AMU16__)
    _setcursortype(_NOCURSOR);
#endif

#if defined(__AMU32__)
    _settextcursor(0x2000);
#endif

#if defined(__AMU95__)
    GetConsoleCursorInfo(hStdout, &Cinfo);
    Cinfo.bVisible = FALSE;
    SetConsoleCursorInfo(hStdout, &Cinfo);
#endif


    /* Fill the screen initially */
    memset(str, '', 80);
    str[80] = NULL;
    Color = BLACK * 16 | LIGHTGRAY;
    for(i = 0; i < 24; i++)
    {
        writestr(1, i+1, Color, str);
    }

    Color = LIGHTGRAY * 16 | BLUE;

    /* Line 1 of the header */
    memset(str, '', 80);
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    writestr(1, 1, Color, str);

    /* Line 2 of the header */
    memset(str, ' ', 80);
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    writestr(1, 2, Color, str);


    sprintf(str, "AMU %s - (%s)  %s", VERSION, PLATFORM, __DATE__);
    writestr(3, 2, Color, str);

    /* Line 3 of the header */
    memset(str, ' ', 80);
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    writestr(1, 3, Color, str);
    writestr(3, 3, Color, "Copyright (C) 1994-1999 David L. Hickey.  All rights reserved.");


    /* Line 4 of the header */
    memset(str, '', 80);
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    writestr(1, 4, Color, str);

      /* Bottom line */
    Color = BLACK * 16 | BLUE;
    memset(str, '', 80);
    str[80] = NULL;
    writestr(1, 24, Color, str);
    Color = BLACK * 16 | BLACK;
    memset(str, ' ', 80);
    str[80] = NULL;

    Color = BLACK * 16 | LIGHTGRAY;
   /* Open the box in the middle of the screen */
    memset(tmpstr, '', 58);
    tmpstr[58] = NULL;
    sprintf(str, "%s", tmpstr);
    writestr(10, 9, Color, str);

    memset(str, ' ', 60);
    str[60] = NULL;
    str[0] = str[59] = '';
    for(i = 10; i <= 16; i++)
    {
        writestr(10, i, Color, str);
    }

    memset(tmpstr, '', 58);
    tmpstr[58] = NULL;
    sprintf(str, "%s", tmpstr);
    writestr(10, 17, Color, str);

    /* Add the bottom shadow */
    memset(str, '', 80);
    str[60] = NULL;
    Color = BLACK * 16 | DARKGRAY;
    writestr(12, 18, Color, str);

    /* Add the shadows for the sides */
    memset(str, '', 80);
    str[2] = NULL;
    for(i = 10; i <= 17; i++)
    {
        writestr(70, i, Color, str);
    }


    Color = BLACK * 16 | CYAN;
    strcpy(tmpstr, Config_obj.get_bbstype());
    ptr = strchr(tmpstr, ';');
    if(ptr)
    {
        *ptr = NULL;
    }
    sprintf(str, "BBS Type       : %s", tmpstr);
    writestr(12, 12, Color, str);

    sprintf(str, "Current Area   : ");
    writestr(12, 13, Color, str);

    sprintf(str, "Current Option : ");
    writestr(12, 14, Color, str);

    sprintf(str, "Errors         : %d", Utility_obj.get_errors());
    writestr(12, 15, Color, str);
}

/************************************************************************/

/* Shut down at the end of AMU's run */
void Screen::shutdown(void)
{
#if defined (__AMU16__) || defined(__AMU2__)
    gotoxy(1, 25);
    _setcursortype(_NORMALCURSOR);
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
#endif

#if defined(__AMU32__)
    _settextcursor(0x0607);
    writestr(10, 1, LIGHTGRAY, " ");
#endif

#if defined(__AMU95__)
    Cinfo.bVisible = TRUE;
    SetConsoleCursorInfo(hStdout, &Cinfo);
    FreeConsole();
#endif
}


/************************************************************************/
/* Write to the screen, directly */
void Screen::writestr(int x, int y, char color, char *str)
{

    if(use_mono)
    {
        color = BLACK | LIGHTGRAY * 16;
    }

#if defined(__AMU95__)
    coord.X = x-1;
    coord.Y = y-1;
    SetConsoleTextAttribute(hStdout, color);
    SetConsoleCursorPosition(hStdout, coord);
    WriteConsole(hStdout, str, strlen(str), &result, NULL);
#endif

#if defined(__AMU32__)
    char *screenptr, *strptr;

    screenptr = (char *)SCREEN_LIN_ADDR;
    screenptr += ((80 * (y-1) * 2) + (2 * (x-1)));
    strptr = str;
    while(*strptr)
    {
        *screenptr = *strptr;
        screenptr++;
        *screenptr = color;
        screenptr++;
        strptr++;
    }
#endif

#if defined(__AMU2__) || defined(__AMU16__)
    gotoxy(x, y);
    textattr(color);
    cprintf(str);
#endif
}

/**********************************************************/
/* Get an image of the screen and put into 'buf' */
void Screen::getscreen(char *buf)
{
    if(Swapping_Ok == FALSE)
    {
         return;
    }

#if defined(__AMU32__)
    char *screenptr, *ptr;
    int x;

    screenptr = (char *)SCREEN_LIN_ADDR;
    ptr = buf;
    for(x = 0; x < SCREEN_SIZE * 2; x++)
    {
        *ptr = *screenptr;
        ptr++;
        screenptr++;
    }
#endif

#if defined(__AMU2__) || defined(__AMU16__)
    gettext(1, 1, 80, 25, buf);
#endif
}


/**********************************************************/
/* Put the image from 'buf' onto the screen */
void Screen::putscreen(char *buf)
{
    if(Swapping_Ok == FALSE)
    {
         return;
    }

#if defined(__AMU95__)
    screen_init();
#endif

#if defined(__AMU32__)
    char *screenptr, *ptr;
    int x;

    screenptr = (char *)SCREEN_LIN_ADDR;
    ptr = buf;
    for(x = 0; x < SCREEN_SIZE * 2; x++)
    {
        *screenptr = *ptr;
        ptr++;
        screenptr++;
    }
#endif

#if defined(__AMU16__) || defined(__AMU2__)
    puttext(1, 1, 80, 25, buf);
#endif
}


/**********************************************************/
/* Clear the screen */
void Screen::clearscreen(void)
{

#if defined(__AMU95__)
    char str[105];
    int y;

    memset(str, ' ', sizeof(str));
    str[100] = NULL;
    coord.X = 0;
    SetConsoleTextAttribute(hStdout, 0);
    for(y = 0; y < 25; y++)
    {
        coord.Y = y;
        SetConsoleCursorPosition(hStdout, coord);
        WriteConsole(hStdout, str, strlen(str), &result, NULL);
    }
#endif

#if defined(__AMU32__)
    if(use_mono)
    {
        SCREEN_AREA = 0xb000;
    }
    else
    {
        SCREEN_AREA = 0xb800;
    }
    SCREEN_LIN_ADDR = ((SCREEN_AREA) << 4);
    SCREEN_SIZE = 80 * 25;

/*
    ptr = (char *)SCREEN_LIN_ADDR;
    memset(ptr, 0, SCREEN_SIZE * 2);
    printf("\n");
*/
    system("cls");
#endif


#if defined(__AMU2__) || defined(__AMU16__)
    clrscr();
#endif
}

void Screen::hide_cursor(void)
{
#if defined(__AMU2__) || defined(__AMU16__)
    _setcursortype(_NOCURSOR);
#endif

#if defined(__AMU32__)
    _settextcursor(0x2000);
#endif

#if defined(__AMU95__)
    GetConsoleCursorInfo(hStdout, &Cinfo);
    Cinfo.bVisible = FALSE;
    SetConsoleCursorInfo(hStdout, &Cinfo);
#endif
}

/**********************************************************************/
// EOF - SCREEN.CPP
