  /* SuperBBS 1.17 structures needed for AMU */

  /* FLSEARCH.BBS */

  struct sbbs_files
  {
      unsigned char ln1;
      char name[60];
      unsigned char ln2;
      char directory[79];
      short security;
      unsigned char flags[4];
      short pfilessec;
      unsigned char pflags[4],
		    attrib,
		    age,
		    ln3;
      char listname[67];
      unsigned short requiredbpsrate;
      unsigned char extraspace[28];
  };
/*  Attrib:

      Bit 0  : Exclude from template
      Bit 1  : No downloads  { Used in template system only }
      Bit 2  : No uploads    { Used in template system only }
      Bit 3  : No virus check
      Bit 4  : No dupe scan
      Bit 5  : No new files check
      Bit 6-7: Unused

*/

  /* USERS.BBS */
  struct sbbs_users
  {
      unsigned char ln1;
      char name[35];
      unsigned char ln2;
      char location[25];
      unsigned char ln3;
      char password[15];
      unsigned char ln4;
      char dataphone[12];
      unsigned char ln5;
      char homephone[12];
      unsigned char ln6;
      char time[5];
      unsigned char ln7;
      char date[8];
      unsigned char attrib,
		    flags[4];
      short credit,
	  pending;
      unsigned short msgsposted,
		   highmsgread,
		   seclvl,
		   times,
		   ups,
		   downs,
		   upk,
		   downk;
      short todayk,
	  elapsed,
	  len;
      unsigned char extraspace[2],
		    age;
      short extrauserrecptr;
      unsigned char extraspace2[3];
  };

/*  Attrib:

      bit 0: Deleted user
      bit 1: Screen clear codes
      bit 2: More prompt
      bit 3: ANSI graphics
      bit 4: No-Kill
      bit 5: Ignore Download Hours
      bit 6: ANSI editor
      bit 7: Do not disturb mode ON

*/

  /* SUSERS.BBS */
  struct extrauser
  {
      unsigned char l1;
      char name[35];
      unsigned char l2;
      char birthday[8];
      unsigned short attrib;
      unsigned char flags[4];
      unsigned char l3;
      char firsttime[5];
      unsigned char l4;
      char firstdate[8];
      unsigned char combined[25];
      unsigned char l5;
      char sysopcomment[79];
      char defaultproto;
      short userrecptr;
      unsigned char colors[10],
		    filelisttype,
		    l6;
      char alias[35];
      long minutesused;
      unsigned char l7;
      char viewfilename[12];
      unsigned char l8;
      char menutorun[8];
      unsigned short timeinbank;
      unsigned char todaycalls,
		    l9;
      char languagefilen[8];
      unsigned char l10;
      char expirationdate[8];
      unsigned char currentfarea,
		    currentmarea,
		    currentdoor,
		    defaultpacker,
		    l11;
      char lastnewfilescheck[8];
      unsigned char callssincebverify,
		    extraspace[402];
  };
/*  Attrib:

1     Bit  0: MailCheck at logon
2     Bit  1: Newfiles Check at logon
4     Bit  2: No downloadratio
8     Bit  3: Female
16    Bit  4: Delete file after viewing
32    Bit  5: Display file only once
64    Bit  6: File viewed
128   Bit  7: Fullscreen viewer
256   Bit  8: Combined mail check
512   Bit  9: No hotkeys
      Bit 10:
      Bit 11:
      Bit 12:
      Bit 13:
      Bit 14:
      Bit 15:
*/

 /* BOARDS.BBS */
 struct sbbs_msgs
 {
     unsigned char ln1;
     char name[30];
     unsigned char ln2;
     char qwkname[12];
     unsigned char typ,  /* 0=standard, 1=net, 2=echo */
		   kinds, /* 0 = private & public, 1 = private, 2 = public, 3 = readonly */
		   aliases; /* 0 = no aliases, 1 = yes, 2 = ask alias, 3 = alias/name */
     short readseclvl;
     unsigned char readflags[4];
     short writeseclvl;
     unsigned char writeflags[4];
     short sysopseclvl;
     unsigned char sysopflags[4];
     char group;
     unsigned char replystatus,
		   age,
		   attrib,
		   useaka;
 };

	       /*
		  Attributes :

		  bit 0 : Combined
		  bit 1 : Default combined
		  bit 2 : Allow message deleting
		  bit 3 : Allow taglines
		  bit 4 : Use in template system
		  bit 5 : Convert 8bit -> 7bit
		  bit 6 : forced ON in the mail check
	       */


/* EOF - SBBS117.H */