/* Contains structures of files that changed from Revision 8 which was
   3.01 - 3.10/Beta 2 */


struct rev8_msgarea
{
    char areaname[41],          /* Name of the message area */
	 basepath[81];          /* Path of the message base */
    short security,             /* Read security for area   */
	  areatype,             /* Type of message base     */
	  areanum,
	  deleted;
    char freespace[50];
};

struct rev8_bulletin
{
    short type,                 /* Type of bulletin           */
	  unused1,
	  num_listed,           /* Number of items to list    */
	  unused2[9];
    char fname[41];             /* Bulletin filename          */
    struct
    {
	short include_sysop: 1, /* Include the sysop?         */
	      create_ascii : 1, /* Create a .ASC bulletin?    */
	      create_ansi  : 1, /* Create a .ANS bulletin?    */
	      create_avatar: 1, /* Create a .AVT bulletin?    */
	      freespace    : 12;
    }attrib;
    short enabled,
	  deleted;
    char datafname[9],         /* Tracking file for Doors, Msgovr */
	 templatefn[41];       /* Template file for the bulletin  */
};

struct rev8_filearea
{

/* The first group of variables are taken from the BBS configuration    */
/* and may not be edited by the user in AMUCFG                          */

    char  areaname[41],         /* Name of this area                    */
	  filepath[41],         /* Path to the files                    */
	  listpath[41];         /* Name of alternate FILES.BBS type     */
    long  security;             /* List security                        */
    short listtype;             /* Type of file listing:                */
				/*    0 - RA 2.0x FDB                   */
				/*    1 - Concord O.O1 FDB              */
				/*    2 - FILES.BBS                     */


/* Settings that may be editted by the user in AMUSETUP */

    short days_old,             /* Days old for the Old option          */
	  move_area,            /* Area to Move old files to            */
	  rearc_type,           /* Rearchive format                     */
	  sort_type,            /* Sorting format for 'Sort' option     */
	  cdformat;             /* Format of CD-ROM areas               */


    struct
    {
	short cdrom       : 1,  /* Is this area on CD-ROM?              */
	      password    : 1,  /* Is this area password protected?     */
	      move_old    : 1,  /* 0 = Kill, 1 = Move                   */
	      unused      : 13;
    }attrib;

    short force_rearc,              /* Force rearchiving */
	  honor_av,                 /* Honor -AV validation */
	  deleted;
    unsigned short areanum;
    short sort,
	  headers,
	  adopt,
	  orphan,
	  old,
	  backup,
	  pack,
	  rearchive,
	  comment,
	  virus,
	  importdiz,
	  exportdiz,
	  importbbs,
	  exportbbs,
	  bbsdls,
	  mailerdls,
	  import_gif,       /* Import GIF information               */
	  filter_graph,     /* Filter graphics from DIZ files?      */
	  move_nodesc,      /* Move files with missing desc         */
	  nodesc_area,      /* Area to move files with no desc      */
	  compress_txt,     /* Compress text files as encountered?  */
	  compresstxt_type, /* Format for compression               */
	  useuldate;        /* For RA, use Upload or File date for moving files? */
    char freespace[2];
};

struct rev8_allnew
{
    short type;               /* 0 = Allfiles, 1 = Newfiles */
    char txtname[41],
	 arcname[41],
	 main_hdr[41],
	 main_ftr[41],
	 area_hdr[41],
	 area_ftr[41],
	 list_format[41];
    short compress,
	  arctype,
	  erase,
	  age,                  /* For newfiles listing only */
	  enabled,
	  deleted,
	  ulordos,             /* 1 = Use upload date, 0 = use DOS date */
	  add_comments;        /* Send comment lines to the list or not */
    double totalfiles,
	   totalbytes,
	   totaldls;
    char freespace[24];
};
