/* File structures for the Revision 2 configuration - AMU 1.10 - 2.01 */
/* 14 May 1996 */

/*
Format of AMU configuration file:

   Block 1   -   Header
   Block 2   -   Main configuration record
   Block 3   -   File area definitions (1 for each option)
   Block 4   -   Allfiles/Newfiles definitions (plus area on/off)
   Block 5   -   Archive definitions
   Block 6   -   Enforcement definitions
   Block 7   -   Logfile definitions
*/

  /* Block 1 - Header record */

  struct amuhdr2
  {
    short sys_rev;           // Revision level of config files
    long Config_CRC;         // CRC of everything beyond this point
    long Config_Offset,      // Offset of main Config record
	 Area_Offset,        // Offset where first Area On/Off starts
	 Allnew_Offset,      // Offset where the Allfiles/Newfiles begin
	 Archive_Offset,     // Offset where the Archives begin
	 Enforce_Offset,     // Offset where the Enforcment begin
	 Logs_Offset;        // Offset where the Logfiles begin
    unsigned short num_files,      // Number of file area options
		   num_allnew,     // Number of Allfiles/Newfiles records
		   num_archives,   // Number of Archives records
		   num_enforce,    // Number of Enforcement records
		   num_logs;       // Number of Logfile records
    unsigned long begin_date;   // Day AMU usage was begun
    char freespace[196];     // Future expansion
  };

  /* Block 2 - AMU configuration file record structure */
typedef char arctype[13];
typedef char paramtype[41];
typedef char pathtype[61];
    struct amucfg2
    {
	char sysop[41],
	     bbsname[41];

	arctype arc,
		unarc,
		arj,
		unarj,
		hap,
		unhap,
                lzh,
                unlzh,
                pak,
		unpak,
                sqz,
                unsqz,
                zip,
                unzip,
                zoo,
                unzoo,
                virusscan;

        char sysop_alias[41];  // Sysop's alias

	short clear_screen, // If the CLS code should be placed in ANSI bulletins
	    nextline, // If FILE_ID.DIZ should start on the 2nd line instead of the first line
            importall,
            postcredit,  // If a message should be posted when users' credit is lowe
            num_credit,  // How much credit is left before AMU posts a message
            nonzero;     //  TRUE - Only users with a nonzero credit will be processed
        long files_crc;  // CRC of the FILES.RA type file
        long msgs_crc;   // CRC of the MESSAGES.RA type file
        short exportall,
              dizlength;   // Number of characters per line for DIZ file import
        arctype uc2;
        paramtype uc2param;

	paramtype doorsbull,
                  ulbull,
                  dlbull;
        short weeklyday,
              monthlyday,
              before_arc,
	      posterrors;
        pathtype utilitypath;           // Where (de)compression utilities are located
        short num_files,
              use_low_ascii;  // Yes - Do not use high-ascii borders in AMU
        char scanpath[42];              // Where the virus scanner is located

	short daysdelete,
              bull_num,
              hi_ascii,
              lower_case,  // If the filename in FILES.BBS should be in lower case instead
              rearctype;

            /* Number of the archive type:
               0 - ARC
               1 - ARJ
               2 - HAP
               3 - LZH
               4 - PAK
	       5 - SQZ
               6 - ZIP
               7 - ZOO
            */

        long BEGIN_USAGE;    // Date on which the user began using AMU
        char left_bracket,   // Left bracket for dl counter
             right_bracket;  // Right bracket for dl counter
        short num_places;      // Number of 0's for dl counter (0 = disable)

        short postlogfile;
        unsigned short sysoppostarea;
	short num_users;

        unsigned short userpostarea;

        pathtype AMUpath,
                 AMUlogfile,
                 uldlratio,
                 postcallratio,
                 userpath,
                 workpath,
                 storagepath,
                 BBSsyspath,
		 FDBLIST_path,


                 topul,
                 topcall,
                 toppost,
                 topdl,
                 topfile,
                 uldlratiokb,
                 msgact,
                 filovr;


        short BBStype;
            /*
                0 - RemoteAccess 2.00
                1 - SuperBBS 1.17
                2 - QuickBBS 2.76
                3 - ProBoard 1.31
                4 - RemoteAccess 1.11
            */


        short mailertype;
	    /*
                0 - None
                1 - FrontDoor
                2 - D'Bridge
                3 - Binkley
                4 - InterMail
            */

        short date_format;
      /*
         0  - mmddyy
         1  - mmyydd
	 2  - ddmmyy
         3  - ddyymm
         4  - yymmdd
         5  - yyddmm
      */

        short swaptype,
            abc,
            pack,
            dlcount,
	    freqcount,
            addhdr,
	    killorp,
            addmsng,
            bak,
            rearc,
            comment,
            killold,
            scan,
            daily,
            weekly,
            monthly,
            movefiles,
            import_desc,

            newusers,
            uploaders,
            carriers,
            subdate,
            birthday;

        char missing_desc[41];

        short use_handle, /* Use handles instead of real names in bulletins? */
            exclude_sysop,  /* Exclude sysop from bulletins */

	    border_fore,  /* Foreground border */
            border_back,  /* Background border */
             text_fore,    /* Main text foreground */
            text_back,    /* Main text background */
            hdr_fore,     /* Header text foreground */
            hdr_back,     /* Header text background */
            ftr_fore,     /* Footer text foreground */
            ftr_back,     /* Footer text background */

            border_style; /* Character set for the border */

        paramtype arcparam,
		  unarcparam,
                  arjparam,
                  unarjparam,
                  happaram,
                  unhapparam,
                  lzhparam,
		  unlzhparam,
                  pakparam,
                  unpakparam,
                  sqzparam,
                  unsqzparam,
                  zipparam,
		  unzipparam,
                  zooparam,
                  unzooparam,
                  virusparam;

        short sub_exp, // How many days before a subscription expires
              display_type,  // How AMU should display it's information
              checksnow, // Check for snow on CGA systems?
              addftr,
              _switch,
              clean;
        char ext_desc_char;
	short ext_offset;
        short import_gif;
        arctype unuc2;
        paramtype unuc2param;
	char cdlist_path[41];
        paramtype rarparam,
		unrarparam;
	arctype rar,
		unrar;
	char oklistpath[41];
	char hmbpath[41];
	short sort_type;
	char doskey[21],
	     os2key[21];
	short use_exes,         // If EXEs should be checked for SFX
              honor_av,         // 0 - ignore, 1 - do not convert
              cdformat,         // Format of CD listings
              unused,
              maxlines,         // Max DIZ lines to import
              gif_first,        // If the GIF resolution should be first
              filter_ctl,       // If AMU should filter all control characters from files.bbs
              add_prompt;       // Add a 'Press Enter' prompt?
        char future_expansion[921];
    };


struct areas2
{
    unsigned short status[4000 / 16];
};

/* Structure for the Allfiles/Newfiles records */
struct allnew2
{
    short type;  // 0 = Allfiles, 1 = Newfiles
    char txtname[41];
    char arcname[41];
    char hdr[41];
    char ftr[41];
    short compress,
	  arctype,
	  erase,
	  age, /* For newfiles listing only */
	  enabled,
	  deleted,
	  ulordos, /* 1 = Use upload date, 0 = use DOS date */
	  add_dltime,  /* Add a line about DL time to the file lists  */
	  add_dlcount; /* Add download counter? */
    char freespace[44];
};

struct archives2
{
    char name[41];
    char path[41];
    char ltrs[3];
    short arctype,
	  date_format,
    /*
       0  - mmddyy
       1  - mmyydd
       2  - ddmmyy
       3  - ddyymm
       4  - yymmdd
       5  - yyddmm
    */
	erase,
	monthly_arc,
	erase_daily,
	enabled,
	deleted,
	type,            // Type of archive this is: 0 = Normal, 1 = Julian (Rename), 2 = Julian (Compress)
	day;             // Day this is executed on
    char freespace[46];
};


struct logs2
{
    char name[41];
    short enabled;

    /* Record the offsets/CRC-32's for this logfile for the various
       options which might access the logfile
    */
    long carrier_crc,
	 carrier_offset,
	 upload_crc,
	 upload_offset,
	 newuser_crc,
	 newuser_offset,
	 dl_crc,
	 dl_offset,
	 freq_crc,
         freq_offset,
         msgact_crc,
         msgact_offset;
    short type;  // Type of logfile
    short deleted;
    long doors_crc,
	 doors_offset;
    char freespace[42];
};

/* Structure to enforcement file */
struct enforce2
{
unsigned short cur_level,      // Level a user must have to activate this
	       next_level;     // Level to change user to
long num;                // # days in advance to notify a user of subscription expiration, #dls, etc.
char filename[81];       // Text file to post to user if level is changed
short type;                // Which type of record is this?
long num2;
short comparison;        // 0 = greater than, 1 = less than
short days_forward;        // Number of days to move a subscription date forward
char freespace[72];      // Future expansion
short enabled;             // Enabled?
short deleted;
};

/* EOF EXTERN.H */
