const
  ver = '4-05 Exp';
  MAXPROTOCOLS = 120;
  MAXEVENTS = 10;
  MAXARCS = 8;
  MAXBATCHFILES = 50;
  MAXMENUCMDS = 100;
  MAXRESULTCODES = 20;
  MAXEXTDESC = 9;

TYPE
  astr=string[160];
  str8=string[8];

  ACString=string[20];            { Access Condition String }
  acrq='@'..'Z';                  { Access Restriction flags }

  uflags =
   (rlogon,                       { L - Limited to one call a day }
    rchat,                        { C - No SysOp paging }
    rvalidate,                    { V - Posts are unvalidated }
    ruserlist,                    { U - Can't list users }
    ramsg,                        { A - Can't post an auto message }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post }
    remail,                       { E - Can't send email }
    rvoting,                      { K - Can't use voting booth }
    rmsg,                         { M - Force email deletion }
    vt100,                        { Supports VT100 }
    hotkey,                       { hotkey input mode }
    avatar,                       { Supports Avatar }
    pause,                        { screen pausing }
    novice,                       { user requires novice help }
    ansi,                         { Supports ANSI }
    color,                        { Supports color }
    alert,                        { Alert SysOp upon login }
    smw,                          { Short message(s) waiting }
    nomail,                       { Mailbox is closed }
    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnocredits,                   { 3 - No credits checking }
    fnodeletion);                 { 4 - Protected from deletion }

  suflags =
    (lockedout,                   { if locked out }
    deleted,                      { if deleted }
    trapactivity,                 { if trapping users activity }
    trapseparate,                 { if trap to seperate TRAP file }
    chatauto,                     { if auto chat trapping }
    chatseparate,                 { if separate chat file to trap to }
    slogseparate,                 { if separate SysOp log }
    clsmsg,                       { if clear-screens }
    RIP,                          { if RIP graphics can be used }
    fseditor,                     { if Full Screen Editor }
    AutoDetect                    { Use auto-detected emulation }
  );

  anontyp =
   (atno,                         { Anonymous posts not allowed }
    atyes,                        { Anonymous posts are allowed }
    atforced,                     { Force anonymous }
    atdearabby,                   { "Dear Abby" base }
    atanyname);                   { Post under any name }

  netattr=
    (Private,
     Crash,
     Recd,
     NSent,
     FileAttach,
     Intransit,
     Orphan,
     KillSent,
     Local,
     Hold,
     Unused,
     FileRequest,
     ReturnReceiptRequest,
     IsReturnReceipt,
     AuditRequest,
     FileUpdateRequest);

  NetAttribs = set of netattr;

  colors   = array[FALSE..TRUE,0..9] of byte; { Color tables }
  secrange = array[0..255] of integer;        { Access tables }

  mzscanr  = set of 1..250;              { Which message bases to scan }
  fzscanr  = set of 1..250;             { Which file bases to scan }
  mhireadr = array[1..250] of longint;   { Lastread pointers }

/***********************************************************************/
/* User file - USERS.DAT */
  userrec=                            { USERS.DAT : User records }
    record
      name:string[36];                  { system name        }
      realname:string[36];              { real name          }
      street:string[30];                { street address     }
      citystate:string[30];             { city, state        }
      callerid:string[20];              { caller ID string   }
      zipcode:string[10];               { zipcode            }
      ph:string[12];                    { phone #            }
      pw:longint;                       { password           }
      usrdefstr:array[1..3] of
          string[35];                   { definable strings  }
      Birthdate,                        { Birth date         }
      FirstOn,                          { First On Date      }
      LastOn:longint;                   { Last On Date       }
      note:string[35];                  { SysOp note         }
      userstartmenu:string[8];          { menu to start at   }
      lockedfile:string[8];             { print lockout msg  }
      flags:set of uflags;              { flags              }
      sflags:set of suflags;            { status flags       }
      ar:set of acrq;                   { AR flags           }
      vote:array[1..25] of byte;        { voting data        }

      sex:char;                         { gender             }
      ttimeon,                          { total time on      }
      uk,                               { UL k               }
      dk,                               { DL k               }
      lastqwk,                          { last qwk packet    }
      credit,                           { Amount of credit   }
      debit,                            { Amount of debit    }
      expiration,                       { Expiration date    }
      passwordchanged:longint;          { date pw changed    }

      tltoday,                          { # min left today   }
      forusr:integer;                   { forward mail to    }

      uploads,                          { # of DLs           }
      downloads,                        { # of DLs           }
      loggedon,                         { # times on         }
      msgpost,                          { # message posts    }
      emailsent,                        { # email sent       }
      feedback,                         { # feedback sent    }
      timebank,                         { # mins in bank     }
      timebankadd,                      { # added today      }
      dlktoday,                         { # kbytes dl today  }
      dltoday,                          { # files dl today   }
      timebankwith,                     { Time withdrawn     }
      lastmbase,                        { # last msg base    }
      lastfbase:word;                   { # last file base   }

      waiting,                          { mail waiting       }
      linelen,                          { line length        }
      pagelen,                          { page length        }
      ontoday,                          { # times on today   }
      illegal,                          { # illegal logons   }
      defarctype,                       { QWK archive type   }
      ColorScheme,                      { Color scheme #     }
      sl,dsl:byte;                      { SL / DSL           }

      Subscription,                     { their subscription }
      expireto,                         { level to expire to }
      lastconf:char;                    { last conference in }

      TeleConfEcho,                     { Teleconf echo?     }
      TeleConfInt,                      { Teleconf interrupt }
      getownqwk,                        { Get own messages   }
      scanfilesqwk,                     { new files in qwk   }
      privateqwk:boolean;               { private mail qwk   }
      reserved:array[474..512] of byte;
    end;

  msgstatusr=
    (mdeleted,
     sent,
     unvalidated,
     permanent,
     allowmci,
     netmail,
     prvt,
     junked);

  mhireadrec=
  record
    NewScan:boolean;           { New scan this base? }
    LastRead:longint;          { Last message date read }
  end;

  fromtoinfo=                  { from/to information for mheaderrec }
  record
    anon:byte;
    usernum:word;              { user number   }
    as:string[36];             { posted as     }
    real:string[36];           { real name     }
    name:string[36];           { system name   }
    zone,
    net,
    node,
    point:word;
  end;

  mheaderrec=
  record
     from,mto:fromtoinfo;            { message from/to info    }
     pointer:longint;                { starting record of text }
     textsize:word;                  { size of text            }
     replyto:word;                   { ORIGINAL + REPLYTO = CURRENT }
     date:longint;                   { date/time packed string }
     dayofweek:byte;                 { message day of week     }
     status:set of msgstatusr;       { message status flags    }
     replies:word;                   { times replied to        }
     subject:string[40];             { subject of message      }
     origindate:string[19];          { date of echo/group msgs }
     fileattached:byte;              { 0=No, 1=Yes&Del, 2=Yes&Save }
     netattribute:NetAttribs;        { Netmail attributes }
     res:array[1..2] of byte;        { reserved }
  end;

  mbflags=
   (mbunhidden,                   { whether *VISIBLE* to users w/o access }
    mbrealname,                   { whether real names are forced }
    mbcrap,                       { }
    mbinternet,                   { if internet message base }
    mbfilter,                     { whether to filter ANSI/8-bit ASCII }
    mbskludge,                    { strip IFNA kludge lines }
    mbsseenby,                    { strip SEEN-BY lines }
    mbsorigin,                    { strip origin lines }
    mbprivate,                    { allow private messages }
    mbforceread,                  { force the reading of this base }
    mbScanOut,                    { Needs to be scanned out by renemail }
    mbaddtear,                    { add tear/origin lines }
    mbtopstar);                   { whether Top Star for GroupMail base }


/* Message area configuration - MBASES.DAT */
  boardrec=                       { MBASES.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { HDR/DAT data filename }
    msgpath:string[40];           { messages pathname   }
    ACS,                          { access requirement }
    postACS,                      { post access requirement }
    mciACS,                       { MCI usage requirement }
    sysopACS:ACString;            { Message base sysop requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    password:string[20];          { base password }
    mbstat:set of mbflags;        { message base status vars }
    mbtype:integer;               { base type (0=Local,1=Echo,2=Group) }
    origin:string[50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color:byte;            { color of origin line }
    aka:byte;                     { alternate address }
    QWKIndex:word;                { QWK indexing number }
    res:array[1..11] of byte;      { RESERVED }
  end;

/* File area configuration - FBASES.DAT */
  fbflags=
   (fbnoratio,                    { if <No Ratio> active }
    fbunhidden,                   { whether *VISIBLE* to users w/o access }
    fbdirdlpath,                  { if *.DIR file stored in DLPATH }
    fbshowname,                   { show uploaders in listings }
    fbusegifspecs,                { whether to use GifSpecs }
    fbcdrom,                      { base is read only, no sorting or ul scanning }
    fbshowdate,                   { show date uploaded in listings }
    fbnodupecheck);               { No dupe check on this area }

  ulrec=                          { FBASES.DAT  : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:word;                { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    res1:integer;                 { not used }
    fbstat:set of fbflags;        { file base status vars }
    ACS,                          { access requirements }
    ulACS,                        { upload requirements }
    dlACS:ACString;               { download requirements }
    res:array[1..10] of byte;     { RESERVED }
  end;

  filstat=
   (notval,                       { if file is NOT validated }
    isrequest,                    { if file is REQUEST }
    resumelater,                  { if file is RESUME-LATER }
    hatched);                     { has file been hatched? }

  ulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    credits:integer;              { File points }
    downloaded:word;              { Number DLs }
    sizemod:byte;                 { # chars over last 128 byte block }
    blocks:word;                  { # 128 byte blks }
    owner:word;                   { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:word;                   { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;

  verbrec=                        { EXTENDED.DAT: Extendeddescriptions }
  record
    descr:array[1..9] of string[50];
  end;

/* EOF - RENEGADE.H */
