/* Include file for RemoteAccess BBS software */
/* Last updated 29 December 1995              */

/*************************************************************************/

/**********************************************************************/
/*                    RemoteAccess v2.02			      */
/**********************************************************************/

typedef unsigned char FlagType[4];

struct tstruct
{
    unsigned short time,
		   date;
};

union timedate
{
    struct tstruct t1;
    long t2;
};

typedef struct {
        byte    l1;
	char    Time[5];
	}TIME;

typedef struct {
        byte    l1;
	char    Date[8];
	}DATE;

typedef struct {                        /*  MSGINFO.BBS  */
	word   lowmsg;
	word   highmsg;
	word   totalmsgs;
	word   totalonboard[200];
	}MSGINFO;

typedef struct {                         /*  MSGIDX.BBS  */
	short     msgnum;
	byte    board;
	}MSGIDX;

typedef struct {
	byte    l1;
	char    string[35];
	}MSGTOIDX;

typedef struct {                       /*  MSGHDR.BBS  */
	short     msgnum;
	word    prevreply;
	word    nextreply;
	word    timesread;
	word    startblock;
	word    numblocks;
	word    destnet;
	word    destnode;
	word    orignet;
	word    orignode;
	byte    destzone;
	byte    origzone;
	word    cost;
	byte    msgattr;
	byte    netattr;
	byte    board;
	TIME    posttime;
	DATE    postdate;
	MSGTOIDX         whoto;
	MSGTOIDX         whofrom;
	byte    l1;
	char    subject[72];
	}MSGHDR;

typedef struct {
	byte    l1;
	char    text[255];
	}MSGTXT;

struct FILESHDR{
	byte            l1;
	char            name[12];
	long            size;
	long            CRC32;
	byte            l2;
	char            uploader[35];
	union timedate uploadtimedate,
		       timedate,
		       lastdl;
	word            timesdl;
	byte            attrib;
	byte            l3;
	char            password[15];
	struct {
		byte l1;
		char desc[15];
		}keyword[5];
	word            cost;
	long            longdescptr;
	byte            freespace[20];
	};

#define RA_DELETED      1
#define RA_UNLISTED 	2
#define RA_FREE		4
#define RA_NOTAVAIL     8
#define RA_LOCKED       16
#define RA_MISSING      32
#define RA_NORESTRICT   64
/*
Attrib - Bit 0 : Deleted
	     1 : Unlisted
	     2 : Free (don't adjust ratio) - Does NOT affect "Cost"
	     3 : Not available (don't allow downloads)
	     4 : Locked (no kill)
	     5 : Missing/offline
	     6 : No time restrictions - always allow DL
*/

struct FILESIDX{
	byte l1;
	     char name[12];
	     union timedate uploadtimedate;
	     long keywordcrc[5];
	     long longdescptr;
	     };


typedef word COMBINED[200];

struct ra202_users{
	MSGTOIDX        name;
	byte            l1;
        char            location[25];
	byte            l2;
        char            organization[50];
        byte            l3;
        char            address1[50];
        byte            l4;
        char            address2[50];
	byte            l5;
        char            address3[50];
	byte            l6;
        char            handle[35];
	byte            l7;
	char            comment[80];
	long            passwordcrc;
	byte            l8;
	char            dataphone[15];
	byte            l9;
	char            voicephone[15];
	TIME            lasttime;
	DATE            lastdate;
	byte            attribute;
/*
			 { Bit 0 : Deleted
			    1 : Clear screen
			    2 : More prompt
			    3 : ANSI
			    4 : No-kill
			    5 : Xfer priority
			    6 : Full screen msg editor
			    7 : Quiet mode }
*/
	byte            Attribute2;
/*
		      { Bit 0 : Hot-keys
			    1 : AVT/0
			    2 : Full screen message viewer
			    3 : Hidden from userlist
			    4 : Page priority
			    5 : No echomail in mailbox scan
			    6 : Guest account
			    7 : Post bill enabled }
*/
	FlagType        flags;
	long int        credit;
	long int        pending;
	word            msgsposted;
	word            security;
	long int        lastread;
	long int        nocalls;
	long int        uploads;
	long int        downloads;
	long int        uploadsk;
	long int        downloadsk;
	long int        todayk;
	short           elapsed;
	word            screenlength;
	byte            lastpwdchange;
	word            group;
	COMBINED        combinedinfo;
	DATE            firstdate;
	unsigned char ln1;
	char birthdate[8];
	unsigned char ln2;
	char subdate[8];
	byte            screenwidth;
	byte            language;
	byte            dateformat;
	byte            l10;
	char            forwardto[35];
	word            msgarea;
	word            filearea;
	char            defualtprot;
	word            filegroup;
	byte            lastdobcheck;
	byte            sex;
	long            XIrecord;
	word            msggroup;
	byte            freespace[48];
	};

struct ra202_msgs{
	byte            unused[4];
	byte            l1;
	char            name[40];
	short           typ;
	short           msgkinds;                 // Attributes
	byte            attribute;
	//   Bit 0 : Enable EchoInfo
	//   1 : Combined access
	//   2 : File attaches
	//   3 : Allow aliases
	//   4 : Use SoftCRs as characters
	//   5 : Force handle
	//   6 : Allow deletes
	//   7 : Is a JAM area
	byte            recvkill; // { Kill older thax 'X' days }
	byte            dayskill; // { Kill recv msgs for more than 'x' days }
	word            countkill;
	word            readsecurity;
	FlagType        readflags;
	FlagType        readnotflags;
	word            writesec;
	FlagType        writeflags;
	FlagType        writenotflags;
	word            sysopsec;
	FlagType        sysopflags;
	FlagType        sysopnotflags;
	byte            l2;
	char            originline[60];
	byte            akaaddress;
	byte            age;
	byte            l3;
	char            jambase[60];
	word            group;
	word            altgroup[3];
	byte            attribute2;  // BIT 0 : Include all groups
	byte            freespace2[9];
	};

struct ra202_files {
	byte            unused[4];
	byte            l1;
	char            name[40];
	byte            attrib;

/*                          0 : Include in new files scan
			    1 : Include in upload dupe scan
			    2 : Permit long descriptions
			    3 : Area is on CD-ROM
			    4 : All files are FREE
			    5 : Allow DLs not in FDB
			    6 : Allow users to password uploads
			    7 : Scan uploads }
*/
	byte            l2;
	char            filepath[40];
	word            killsdaysdl;
	word            killdaysfd;
	byte            l3;
	char            password[15];
	word            movearea;
	byte            age;
	byte            convertExt;
	word            group;
	byte            attrib2;    // BIT 0 : Include in all groups
	word            defcost;
	word            uploadarea;
	word            uploadsec;
	FlagType        uploadflags;
	FlagType        uploadnotflags;
	word            security;
	FlagType        flags;
	FlagType        noflags;
	word            listsecurity;
	FlagType        listflags;
	FlagType        listnotflags;
	word            altgroup[3];
	byte            device;
	byte            freespace[13];
	};

/**********************************************************************/
/*                    RemoteAccess v1.11			      */
/**********************************************************************/

struct ra111_users {
	   unsigned char  l1;
	   char           name[35];
	   unsigned char  l2;
	   char           location[25];
	   unsigned char  l3;
	   char           pwd[15];
	   unsigned char  l4;
	   char           dataphone[12];
	   unsigned char  l5;
	   char           homephone[12];
	   unsigned char  l6;
	   unsigned char  time[5];
	   unsigned char  l7;
	   unsigned char  date[8];
	   unsigned char  attrib;
	   unsigned char  flags[4];
	   unsigned short   credit;
	   unsigned short   pending;
	   unsigned short   timesposted;
	   unsigned short   highmsgread;
	   unsigned short   seclvl;
	   unsigned short   times;
	   unsigned short   ups;
	   unsigned short   downs;
	   unsigned short   upk;
	   unsigned short   downk;
	   short            todayk;
	   short            elapsed;
	   unsigned short   len;
	   unsigned char  lastpwdchange;
	   unsigned char  attribute2;
	   /* Bit 3 - Hidden */

	   unsigned char  group;
	   unsigned short   XIrecord;
	   unsigned char  extraspace[3];
	   };

struct ra111_usersxi {
	unsigned char   l1;
	char            handle[35];
	unsigned char   l2;
	char            comment[80];
	   unsigned char   l3;
	   char            firstdate[8];
	   unsigned char   combined[25];
	   unsigned char   l4;
	   char            birthdate[8];
	   unsigned char   l5;
	   char            subdate[8];
	   unsigned char   screenwidth;
	   unsigned char   msgarea;
	   unsigned char   filearea;
	   unsigned char   language;
	   unsigned char   dateformat;
	   unsigned char   l6;
	   char            forwardto[35];
	   unsigned char   extraspace[43];
	   };


struct ra111_msgs {            /* ------------ MESSAGES.RA */
	unsigned char   l1;
	   char            name[40];
	   char            type;
	   char            kinds;
	   unsigned char   attribute;
	   unsigned char   dayskill;
	   unsigned char   recvkill;
	   unsigned short    countkill;
	   unsigned short    readseclvl;
	   unsigned char   readflags[4];
	   unsigned short    writeseclvl;
	   unsigned char   writeflags[4];
	   unsigned short    sysopseclvl;
	   unsigned char   sysopflags[4];
	   unsigned char   l2;
	   char            origin_line[60];
	   unsigned char   akaaddress;
	   };

/* FILES.RA */
struct ra111_files{
	   unsigned char   l1;
	   char            name[30];
	   unsigned char   attrib;
	   unsigned char   l2;
	   char            filepath[40];
	   unsigned char   freespace[35];
	   unsigned short    uploadsecurity;
	   FlagType        uploadflags;
	   unsigned short    security;
	   FlagType        flags;
	   unsigned short    privatesecurity;
	   FlagType        privateflags;
	};

/*--------------------------------------------------------  File Attributes --

Bit 0 : Include in new files scan
Bit 1 : Include in upload dupe scan
Bit 2 : Permit long descriptions

*/

/***********************************************************************/
/* EOF - RA.H */
