/*
	     Structures document for QuickBBS version 2.80 Gamma-3
	     This information may be freely copied and used at no charge
	     by any party to write utilities and other software which
	     enhances the use of the QuickBBS software.
	     Use of this information in any other BBS program is
	     strictly prohibited. Copyright 1991,92,93  Pegasus Software
	     All Rights Reserved. Translation by Ed Grinnell               */



/*
enum            TypeMsgs {Standard, Netmail, FMail, EchoMail};
enum            KindMsgs {Both, Private, Public, ROnly};
enum            AskType {No, Maybe, Yes};
*/
typedef         unsigned short    Word;
typedef         char            Byte;
typedef         short           Integer;
typedef         long            LongInt;
typedef         char            Char;
typedef         char            String;

typedef char Boolean;
typedef char TypeMsgs;
typedef char KindMsgs;

/* USERS.BBS or USERS.DAT */

struct  qbbs_280_users
        {
        Byte            ln1;
        String          name[35];
        Byte            ln2;
        String          location[25];
        Byte            ReservedZero; /* Reserved, should always be 0 */
        Byte            Language;
        LongInt         PwdCrc;
        Word            PwdChangeDate;
        Word            expiredate;  /* Number of days since 1/1/1900 */
        LongInt         HighMsgRead; /* UnusedSpace for Classic version */
        Byte            ExtraSpace[2];
        Byte            DataPhoneLen;
        String          DataPhone[12];
        Byte            HomePhoneLen;
	String          HomePhone[12];
        Byte            l3;
        String          time[5];
	Byte            l4;
        String          date[8];
        Byte            Attrib;
        Byte            Flags[4];
        Word            Credit;
        Word            Pending;
        Word            timesposted;
        Word            ObsoleteField; /* HighMsgRead for Classic */
        Word            seclvl;
        Word            times;
        Word            ups;
        Word            downs;
        Word            upk;
        Word            downk;
        Integer         todayk;
        Integer         Elapsed;
        Integer         Len;
	Word            CombinedPtr; /* Record number in COMBINED.BBS */
        Word            aliasptr; /* Record number in ALIAS.BBS */
	long            bdate;  /* Number of days since 1/1/1600 */
        };



/*      Attrib:

        Bit 0: Deleted
        Bit 1: Screen Clear Codes
        Bit 2: More Prompt
        Bit 3: ANSI
        Bit 4: No-Kill
        Bit 5: Ignore Download Hours
        Bit 6: ANSI Full Screen Editor
        Bit 7: Sex (0=male, 1=female)
*/



/* MSGTOIDX.BBS or MSGTOIDX.DAT*/

struct  GoldMsgToIdxRecord
        {
        Byte            l1;
	String          string[35];
        };



/* MSGTXT.BBS or MSGTXT.DAT */

struct  GoldMsgTxtRecord
        {
        Byte            MsgTxtRecordLen;
        String          MsgTxtRecord[255];
        };


/* MSGINFO.BBS or MSGINFO.DAT */

struct  GoldMsgInfoRecord
        {
        LongInt         lowmsg;            /* Lowest message in file.   */
        LongInt         highmsg;           /* Highest message in file.  */
	LongInt         totalmsgs;         /* Total active messages.    */
        Word            totalonboard[500];
        };



/* MSGIDX.BBS or MSGIDX.DAT */

struct  GoldMsgIdxRecord
        {
        LongInt         msgnum;
        Word            board;
        };



/* MSGHDR.BBS or MSGHDR.DAT */

struct  GoldMsgHdrRecord
        {
	LongInt         msgnum;
	LongInt         prevreply;
	LongInt         nextreply;
	Integer         timesread;
	LongInt         startblock;
	Integer         numblocks;
	Integer         destnet;
	Integer         destnode;
	Integer         orignet;
	Integer         orignode;
	Byte            destzone;
	Byte            origzone;
	Integer         cost;
/**/    Word            msgattr;
/**/    Word            netattr;
	Word            board;
	Byte            l1;
	String          posttime[5];
	Byte            l2;
	String          postdate[8];
	Byte            l3;
	String          whoto[35];
	Byte            l4;
	String          whofrom[35];
	Byte            l5;
	String          subj[72];
	};

/* Msg Attributes:

      Bit 0: Deleted
      Bit 1: Unmoved Outgoing Net Message
      Bit 2: Is a Net Mail Message
      Bit 3: Private
      Bit 4: Received
      Bit 5: Unmoved Outgoing Echo Message
      Bit 6: Local Bit
      Bit 7: Group Message

   Net Attributes:

      Bit 0: Kill Message after it's been sent
      Bit 1: Sent OK
      Bit 2: File(s) Attached
      Bit 3: Crash Priority
      Bit 4: Request Receipt
      Bit 5: Audit Request
      Bit 6: Is a Return Receipt
      Bit 7: Freq

*/

/*  Configuration Information  */


typedef struct
        {
        Word            security;
        Byte            Flags[4];
        }SecurityRecord;



/* FILECFG.DAT */

struct  qbbs_280_files
        {
        Byte            ln1;
        String          areaname[66];
        Byte            ln2;
        String          filepath[66];
        Byte            ln3;
        String          listpath[66];
        Boolean         AllowUploads;
	Boolean         IgnoreKlimit;
        Boolean         IgnoreRatio;
        SecurityRecord  dlsec;
        SecurityRecord  searchsec;
        SecurityRecord  templatesec;
        Boolean         CheckDupes;
        Byte            Group;
        Byte            Spare[10];
        };


/* MSGCFG.DAT */

struct  qbbs_280_msgs
	{
	Byte            ln1;
        String          name[40];
        TypeMsgs        Typ;
        KindMsgs        Kinds;
        Boolean         Combined;
	char            Aliases;
	Byte            Aka;
	Byte            ln2;
	String          OriginLine[58];
	Boolean         AllowDelete;
	Word            KeepCnt;   /* Max # of Msgs to keep */
	Word            KillRcvd;  /* Kill received msgs after this many days */
	Word            KillOld;   /* Kill msgs after this many days */
	SecurityRecord  readsec;
	SecurityRecord  writesec;
	SecurityRecord  templatesec;
	SecurityRecord  sysopSec;
	Integer         FileArea; /* for Fmail */
	Byte            Group;
	Byte            Spare[9];
	};



/* EOF QBBS280.H */
