/* QuickBBS 2.76 structures (C version) for files AMU needs  */
/*

  /* USERS.BBS */
  struct qbbs_users
  {
      unsigned char ln1;
      char name[35];
      unsigned char ln2;
      char location[25];
      unsigned char ln3;
      char pwd[15];
      unsigned char ln4;
      char dataphone[12];
      unsigned char ln5;
      char homephone[12];
      unsigned char ln6;
      char time[5];
      unsigned char ln7;
      char date[8];
      unsigned char attrib;

/*  Attrib:

      Bit 0: Deleted
      Bit 1: Screen Clear Codes
      Bit 2: More Prompt
      Bit 3: ANSI
      Bit 4: No-Kill
      Bit 5: Ignore Download Hours
      Bit 6: ANSI Full Screen Editor
      Bit 7: Sex (0=male, 1=female)

*/

      unsigned char flags[4];
      unsigned short credit,
		   pending,
		   timesposted,
		   highmsgread,
		   seclvl,
		   times,
		   ups,
		   downs,
		   upk,
		   downk;
      short todayk,
	  elapsed,
	  len;
      unsigned short combinedptr,
		   aliasptr;
      long bdate;
  };


  /* Structure of ALIAS.BBS */
  struct aliasrecord
  {
      unsigned char l1;
      char alias[35];
  };

  /* Security record - needed in FILECFG.DAT */
  struct securityrecord
  {
      unsigned short security;
      unsigned char flags[4];
  };

  /* FILECFG.DAT */
  struct qbbs_files
  {
      unsigned char ln1;
      char areaname[66];
      unsigned char ln2;
      char filepath[66];
      unsigned char ln3;
      char listpath[66];
      char allowuploads,
	   ignoreklimit,
	   ignoreratio;
      struct securityrecord dlsec,
			    searchsec,
			    templatesec;
      unsigned char checkdupes,
		    group,
		    spare[10];
  };

  /* MSGCFG.DAT */
  struct qbbs_msgs
  {
      unsigned char ln1;
      char name[40];
      unsigned char typ,
		    kinds,
		    combined,
		    aliases,
		    aka,
		    ln2;
      char originline[58];
      unsigned char allowdelete;
      unsigned short keepcnt,
		   killrcvd,
		   killold;
      struct securityrecord readsec,
			    writesec,
			    templatesec,
			    sysopsec;
      short filearea;
      unsigned char group,
		    spare[9];
  };

/* EOF - QBBS276.H */