/*
                       --->  VALID FOR BETA/12 <---

                     Ŀ
                      ProBoard v2.02 File Structures 
                     


This document describes the file structures used by ProBoard version 2.02.
For information on the structures of the RemoteAccess compatible files, refer
to the RemoteAccess structures document. It can be obtained from any of the
ProBoard distribution sites.

-------------------------------------------------------------------------------

The data-structures are C-structures, this means:

- Strings are stored as an array of characters, terminated by a 0.
- A date is stored as 3 bytes (day,month,year)
- A time is stored as 3 bytes (hour,min,sec)

The 'accessflags' are stored in a long integer, with bit 31 being flag 'A',
bit 30 flag 'B' , ... Bit 5 is flag '1', bit 4 is flag '2', etc...
I know this doesn't sound logical, but we had some good reasons for doing
this <grin>.

The combined boards are stored in 25 bytes (200 bits). One bit per message
area.
*/

typedef unsigned uint;
typedef unsigned long ulong;
typedef unsigned char byte;
typedef unsigned long accessflags;
typedef unsigned char combinedboards[125];
typedef unsigned char bool;
typedef unsigned char Time[3];
typedef unsigned char Date[3];
typedef unsigned char TimeFrame[7][6];

/*

 USERSPB.BBS


This file is tied to the files USERS.BBS and USERSXI.BBS. The records are
stored in the same order as the records in USERS.BBS. The name of the user
is duplicated in this file, so it is possible to fix the userfile after using
a third-party userfile packer/sorter, which does not know about USERSPB.BBS.

*/

struct UsersPbBBS
  {
   char         name[36];
   char         country[26];
   char         state[26];
   char         faxPhone[16];
   char         passWord[16];
   char         language[9];
   Date         lastPwdChange;
   Date         lastNewFilesCheck;
   int          logLevel;
   int          tbTimeBalance;
   int          tbKbBalance;
   int          tbTimeWithdrawn;
   int          tbKbWithdrawn;
   uint         tbTimeDeposited;
   uint         tbKbDeposited;
   uint         tbTimeLoaned;
   uint         tbKbLoaned;
   Date         tbTimePayback;
   Date         tbKbPayback;
   Date         tbLastUsed;

   uint         expLevel;
   accessflags  expFlagsOn;
   accessflags  expFlagsOff;
   ulong        uFlags;
   combinedboards mailCheckBoards;
   ulong        totalTimeUsed;
   uint         qwkMaxMsgsPerArea;
   uint         qwkMaxMsgs;
   byte         qwkArchiver;
   byte         ripFont;
   byte         checkMail;
   byte         checkNewFiles;

   byte         extra[398];
  };

/* These are the extra user-flags for 'uFlags': */

#define RA_UFLAG_NOIBM        1
#define RA_UFLAG_NOTOPS       2
#define RA_UFLAG_AVTPLUS      4
#define RA_UFLAG_ATTEN        8
#define RA_UFLAG_NORIP       16
#define RA_UFLAG_MULTILOGIN  32
#define RA_UFLAG_FREECHAT    64
#define RA_UFLAG_LOCALONLY  128

/*

 CONFIG.PRO

*/

struct CONFIG_PRO
 {
  char shellmsg[81];         /* Message to show when shelling                */
  char sysopname[36];        /* Name of sysop                                */
  char txtpath[61];          /* Path for textfiles                           */
  char mnupath[61];          /* Path for menu-files                          */
  char msgpath[61];          /* Path for message base                        */
  char uploadpath[61];       /* Uploadpath                                   */
  char editorname[61];       /* Name of external editor                      */
  uint newuserlevel;         /* Level for new user                           */
  int newuserloglevel;       /* Loglevel for new user                        */
  accessflags newuserflags;  /* New user flags                               */
  int max_passinput;         /* Maximum attempts for password entry          */
  int min_passlength;        /* Minimum password length                      */
  int inactivity_time;       /* Inactivity time-out limit                    */
  int max_sysop_pages;       /* Maximum times sysop can be paged             */
  int pagebell_length;       /* Length of page-bell (secs)                   */
  int mailcheck;             /* Check for mail at logon?                     */
  int europe;                /* European date format?                        */
  int numnodes;              /* # nodes                                      */
  bool allowansi;            /* Allow ANSI?                                  */
  bool allowavatar;          /* Allow AVATAR?                                */
  int discrete;              /* Hide sysop activity?                         */
  int askphone;              /* Ask for phone number?                        */
  int allowoneword;          /* Allow one-word names                         */
  unsigned crashlevel;       /* Level needed for crashmail                   */
  accessflags crashflags;    /* Flags needed for crashmail                   */
  uint attachlevel;          /* Level needed for file attach                 */
  accessflags attachflags;   /* Flags needed for file attach                 */
  int allowmsgupload;        /* Allow message uploads                        */
  int allowstacking;         /* Allow command stacking                       */
  Time page_start;           /* Paging hours start                           */
  Time page_end;             /* Paging hours end                             */
  int handshaking;           /* I/O Handshaking                              */
  int allowalias;            /* Allow alias for login                        */
  int loglocal;              /* Log local calls                              */
  int doswap;                /* Allow swapping                               */
  char originline[61];       /* Origin line                                  */
  char nodelistdir[61];      /* Nodelist directory                           */
  char sysopkeys[10][60];    /* Sysop hotkeys                                */
  Time dl_start;             /* Download hours start                         */
  Time dl_end;               /* Download hours end                           */
  int uploadspace;           /* Space needed for uploads                     */
  char pvtuploadpath[61];    /* Directory for files uploads                  */
  char quotestring[6];       /* String used for quoting                      */
  bool fastmode;             /* Use fast mode                                */
  bool extra_bool_1;
  bool killsent;             /* Kill netmail after sent                      */
  bool multiline;            /* Use message base sharing?                    */
  bool egamode;              /* Use 43/50 line mode                          */
  bool showuserinfo;         /* Show user info while in EGA mode?            */
  char pexpath[61];          /* Directory for PEX files                      */
  bool allowquicklogin;      /* Allow quick sysop login?                     */
  bool suspendmsgtime;       /* Suspend time when writing msgs               */
  int securityboard;         /* MsgBoard for security messages               */
  bool pwdmessages;          /* Write security-messages?                     */
  bool extra_bool_2;
  char bbsname[36];          /* Name of the BBS                              */
  char pwdchar;              /* Password character                           */
  int  tb_maxtimedeposit;    /* Max time deposit per day (TimeBank)          */
  int  tb_maxkbdeposit;      /* Max Kbytes deposit per day (TimeBank)        */
  int  tb_maxtimewithdrawal; /* Max time withdrawal per day (TimeBank)       */
  int  tb_maxkbwithdrawal;   /* Max Kbytes withdrawal per day (TimeBank)     */
  int  usage_days;           /* Days to keep usage graphs                    */
  char systempwd[16];        /* System password                              */
  bool usesystempwd;         /* Use system password?                         */
  bool askbirthdate;         /* Ask Birth Date?                              */
  int  binlogdays;           /* # days to log in BINLOG.PB                   */
  bool binloglocal;          /* Log local calls to BINLOG.PB yes/no          */
  int  pageArea;             /* Area number for page messages                */
  bool indexfiles;           /* Use file indexing                            */
  bool checkdupes;           /* Check for dupes                              */
  bool killdupes;            /* Kill duplocate files                         */
  bool ignore_ext;           /* Ignore file extensions for dupe checking     */

  char RIPpath[61];          /* Path for RIP scripts                         */
  char iconspath[61];        /* Path for RIP icons                           */
  char location[36];         /* BBS Location (city)                          */
  char phone[26];            /* BBS Phone #                                  */
  char QWKid[9];             /* BBS QWK id                                   */
  uint IObuffersize;         /* I/O buffer size in bytes                     */
  TimeFrame pagingHours;     /* Paging hours                                 */
  char defaultLanguage[9];   /* Default language                             */
  bool addUploaderName;      /* Add uploader's name to FILES.BBS             */
  TimeFrame downloadHours;   /* Download hours                               */
  bool askdataphone;         /* Ask data phone #                             */
  bool askfaxphone;          /* Ask fax phone #                              */
  bool askaddress;           /* Ask mailing address                          */
  bool asksex;               /* Ask sex                                      */
  bool askdateformat;        /* Ask date format                              */
  bool askstate;             /* Ask state                                    */
  bool askcountry;           /* Ask country                                  */
  int fuzzyRate;             /* Fuzzy search percentage for user editor      */
  bool hidePassword;         /* Hide password in user editor                 */
  bool valConfirm;           /* Confirm user validation                      */

  char extra[272];
 };


/*

 TIMELOG.PRO

*/

struct TIMELOG_PRO
  {
   int numdays;           /* Number of days active                         */
   Date lastdate;         /* Last update                                   */
   long hours[24];        /* # minutes per hour usage (obsolete)           */
   long days[7];          /* # minutes per day usage  (obsolete)           */
   long weeks[53];        /* # minutes per week usage (obsolete)           */
   long totalcalls;       /* Total calls to system                         */
  };


/*

 FILECFG.PRO

*/

struct FILECFG_PRO
  {
   char name[80];       /* Name of file area                                */
   char listpath[80];   /* Path for file-list                               */
   char filepath[80];   /* Path for files                                   */
   uint level;          /* Level needed for access                          */
   long flags;          /* Flags needed for access                          */
   char type;           /* 1 = CDROM File listing type                      */
   int  maxfiles;       /* Max files per day in this area downloadable      */
   int  maxkb;          /* Max Kbytes per day in this area                  */
   bool notops;         /* Set to 1 -> should not be listed in TOPFILES.A?? */
   bool free;           /* Set to 1 -> free area                            */
   byte groups[4];      /* Groups belonging to                              */
   bool allGroups;      /* Belongs to all groups                            */
   byte minAge;         /* Minimum age                                      */
   long flagsNot;       /* Access flags not allowed                         */
   byte dateFormat;     /* Date format (same as in user file)               */

   byte extra[2];
  };


/*

 MESSAGES.PB

*/

struct MESSAGES_PB
  {
   uint areaNum;              /* # of message area (1-10000)                    */
   uint hudsonBase;           /* Number of Hudson message base                  */
   char name[81];             /* Name of message area                           */
   byte msgType;              /* Kind of message area (Net/Echo/Local)          */
   byte msgKind;              /* Type of message (Private only/Public only/...) */
   byte msgBaseType;          /* Type of message base                           */
   char path[81];             /* Path to Squish or *.MSG                        */
   byte flags;                /* Alias allowed/forced/prohibited                */
   uint readLevel;            /* Minimum level needed to read msgs              */
   accessflags readFlags;     /* flags needed to read msgs                      */
   accessflags readFlagsNot;  /* flags non-grata to read msgs                   */
   uint writeLevel;           /* Minimum level needed to write msgs             */
   accessflags writeFlags;    /* flags needed to write msgs                     */
   accessflags writeFlagsNot; /* flags non-grata to read msgs                   */
   uint sysopLevel;           /* Minimum level needed to change msgs            */
   accessflags sysopFlags;    /* flags needed to change msgs                    */
   accessflags sysopFlagsNot; /* flags non-grata to read msgs                   */

   char origin[62];           /* Origin line                                    */
   int aka;                   /* AKA                                            */

   uint rcvKillDays;          /* Kill received after xx days                    */
   uint msgKillDays;          /* Kill after xx days                             */
   uint maxMsgs;              /* Max # msgs                                     */

   char sysop[36];            /* Area Sysop                                     */
   int  replyBoard;           /* Area number where replies should go            */

   char echoTag[61];          /* Echomail Tag Name                              */
   char qwkTag[13];           /* QWK Area Name                                  */

   byte groups[4];            /* Groups belonging to                            */
   bool allGroups;            /* Belongs to all groups                          */
   byte minAge;               /* Minimum age for this area                      */

   byte extra[112];
  };


#define MSGTYPE_BOTH     0 /* Private/Public */
#define MSGTYPE_PVT      1 /* Private Only   */
#define MSGTYPE_PUBLIC   2 /* Public Only    */
#define MSGTYPE_TOALL    3 /* To All         */

#define MSGKIND_LOCAL    0 /* Local          */
#define MSGKIND_NET      1 /* NetMail        */
#define MSGKIND_ECHO     2 /* EchoMail       */
#define MSGKIND_PVTECHO  3 /* Pvt EchoMail   */

#define MSGBASE_HUDSON   0
#define MSGBASE_SQUISH   1
#define MSGBASE_SDM      2
#define MSGBASE_JAM      3

/*

 ONLINE.PRO

*/

struct ONLINE_PRO
  {
   char name[36];     /* Name of user online                                 */
   char city[16];     /* City of user online                                 */
   int baud;          /* Baud rate of user                                   */
   int status;        /* 0 -> online , <0 -> not online or unavailable       */
   char extra[8];
  };



/*

 TOPS.PB

*/

struct TOPS_PB
  {
   char name[36];     /* Name of user online                                 */
   ulong n;           /* Data (# kb/minutes/files/etc...)                    */
  };



/*

 PROTOCOL.PRO

*/

struct PROTOCOL_PRO
  {
   char name[50];       /* Name of protocol                                  */
   char key;            /* Hotkey for Protocol                               */
   char flags;          /* Protocol behavior                                 */
   char logfile[60];    /* Logfile from protocol                             */
   char ctlfile[60];    /* Control file (redirection file)                   */
   char dlcom[128];     /* Download command line                             */
   char ulcom[128];     /* Upload command line                               */
   char dlstring[80];   /* String to place in download control file          */
   char ulstring[80];   /* String to place in upload control file            */
   char dlkeyword[40];  /* Download keyword to search for in logfile         */
   char ulkeyword[40];  /* Upload keyword to search for in logfile           */
   int wordnr;          /* File name word nr after keyword (1-..)            */
  };


/* Flags: */

#define PROT_BATCH   1    /* Batch protocol        */
#define PROT_ENABLED 2    /* Enabled               */
#define PROT_BOTH    4    /* Full-duplex protocol  */
#define PROT_BIM     8    /* Bimodem-type ctl-file */
#define PROT_LOCAL  16    /* Local only            */


/*

 LIMITS.PRO

*/

struct LIMITS_PRO
  {
   uint level;            /* Level                                           */
   int timelimit;         /* # minutes per day                               */
   int daily_klimit;      /* Kbytes per day allowed                          */
   int pre_download;      /* # minutes online before download                */
   char id[6];            /* Usergroup ID                                    */
   uint free;             /* Free upload in Kb.                              */
   byte factor;           /* Percentage upload required                      */
   uint max_download;     /* Max download for this level                     */
   int fallto;            /* Fall to level x when max. reached               */
   int msgfactor;         /* # Kbytes granted per message written            */
   char extra[5];
  };

/*

 MODEM.PRO

*/

struct MODEM_PB
   {
      long  maxBps;             /* Maximum Baud Rate                         */
      long  lockedBps;          /* Locked Baud Rate  (not used)              */
      ulong flags;              /* Attributes (see below)                    */
      int   port;               /* COM port (1-8)                            */
      int   commandDelay;       /* Delay in 1/10s between characters sent    */
      int   answerDelay;        /* Delay in 1/10s before answer string sent  */
      int   blankTime;          /* Time in seconds for screen blanker        */

      char  msgCon300     [80]; /* Connect 300 string                        */
      char  msgCon1200    [80]; /* Connect 1200 string                       */
      char  msgCon1275    [80]; /* Connect 1275 string                       */
      char  msgCon2400    [80]; /* Connect 2400 string                       */
      char  msgCon4800    [80]; /* Connect 4800 string                       */
      char  msgCon7200    [80]; /* Connect 7200 string                       */
      char  msgCon9600    [80]; /* Connect 9600 string                       */
      char  msgCon12000   [80]; /* Connect 12000 string                      */
      char  msgCon14400   [80]; /* Connect 14400 string                      */
      char  msgCon16800   [80]; /* Connect 16800 string                      */
      char  msgCon19200   [80]; /* Connect 19200 string                      */
      char  msgCon21600   [80]; /* Connect 21600 string                      */
      char  msgCon24000   [80]; /* Connect 24000 string                      */
      char  msgCon26400   [80]; /* Connect 26400 string                      */
      char  msgCon28800   [80]; /* Connect 28800 string                      */
      char  msgCon38400   [80]; /* Connect 38400 string                      */
      char  msgCon57600   [80]; /* Connect 57600 string                      */
      char  msgCon64000   [80]; /* Connect 64000 string                      */
      char  msgCon115200  [80]; /* Connect 115200 string                     */

      char  msgConExternal[80]; /* External/Fax connect string               */

      char  msgRing       [80]; /* Ring string                               */
      char  msgOk         [80]; /* "OK" string                               */

      char  cmdInit1      [80]; /* Init command string 1                     */
      char  cmdInit2      [80]; /* Init command string 2                     */
      char  cmdInit3      [80]; /* Init command string 3                     */
      char  cmdAnswer     [80]; /* Answer commnad string                     */
      char  cmdOffHook    [80]; /* Off Hook command string                   */
      char  cmdDown       [80]; /* BBS Down command string                   */
      char  cmdAttention  [80]; /* Attention command string (usually "AT|")  */

      int   externalErrorLevel; /* Errorlevel for external/fax connect       */

      byte  extra[1664];
   };

const ulong MODEM_LOCKED        = 0x00000001L;
const ulong MODEM_MANUAL_ANSWER = 0x00000002L;


/*

 BINLOG.PB

*/

struct BINLOG_PB
  {
    Date     date;
    Time     timeIn;
    Time     timeOut;
    char     name[36];
    char     city[26];
    char     country[26];
    long     baud;
    uint     node;
    long     kbDown;
    long     kbUp;
    uint     yells;
    uint     level;
    ulong    uflags;
    char     alias[36];
    char     extra[45];
  };


/*

 FILESIDX.PB

*/

struct FILESIDX_PB
  {
    char filename[13];        /* Name of the file, with extension       */
    uint area;                /* File area number where file is located */
  };



/*

 FGROUPS.PB / MGROUPS.PB

*/

struct GROUPS_PB
  {
   char name[80];
   uint level;
   long flags;
   long flagsNot;
   byte extra[10];
  };
