typedef unsigned short uint;
typedef long ulong;
typedef char bbye;
typedef long accessflags;
typedef char combinedboards[125];
typedef char bool;
typedef char Time[3];
typedef char Date[3];
typedef char TimeFrame[7][6];

/*

 FILECFG.PRO

*/

struct pb2_files
  {
   char name[80];       /* Name of file area                                */
   char listpath[80];   /* Path for file-list                               */
   char filepath[80];   /* Path for files                                   */
   uint level;          /* Level needed for access                          */
   long flags;          /* Flags needed for access                          */
   char type;           /* 1 = CDROM File listing type                      */
   short  maxfiles;       /* Max files per day in this area downloadable      */
   short  maxkb;          /* Max Kbbyes per day in this area                  */
   bool notops;         /* Set to 1 -> should not be listed in TOPFILES.A?? */
   bool free;           /* Set to 1 -> free area                            */
   char extra[13];      /* Reserved                                         */
  };


/*

 MSGAREAS.PB

*/

struct pb2_msgs
  {
   short  areaNum;
   char name[31];             /* Name of message areas                          */
   byte msgType;              /* Kind of message area (Net/Echo/Local)          */
   byte msgKind;              /* Type of message (Private only/Public only/...) */
   byte msgbasetype;          /* Type of message base                           */
   char path[80];             /* Path to Squish or *.MSG                        */
   byte flags;                /* Alias allowed/forced/prohibited                */
   unsigned short readlevel;            /* Minimum level needed to read msgs              */
   long readFlags;            /* flags needed to read msgs                      */
   unsigned short writelevel;           /* Minimum level needed to write msgs             */
   long writeFlags;           /* flags needed to write msgs                     */
   unsigned short sysoplevel;           /* Minimum level needed to change msgs            */
   long sysopFlags;           /* flags needed to change msgs                    */

   char origin[62];           /* Origin line                                    */
   short aka;                   /* AKA                                            */

   short rcvKillDays;
   short msgKillDays;
   short maxMsgs;

   char sysop[36];            /* Area Sysop                                     */
   short  replyBoard;           /* Area number where replies should go            */

   char echoTag[21];          /* Echomail Tag Name                              */
   char qwkTag[13];           /* QWK Area Name                                  */

   byte extra[23];
};

/*

 MESSAGES.PB

*/
struct pb202_msgs
  {
   uint areaNum;              /* # of message area (1-10000)                    */
   uint hudsonBase;           /* Number of Hudson message base                  */
   char name[81];             /* Name of message area                           */
   byte msgType;              /* Kind of message area (Net/Echo/Local)          */
   byte msgKind;              /* Type of message (Private only/Public only/...) */
   byte msgbasetype;          /* Type of message base                           */
   char path[81];             /* Path to Squish or *.MSG                        */
   byte flags;                /* Alias allowed/forced/prohibited                */
   uint readlevel;            /* Minimum level needed to read msgs              */
   accessflags readFlags;     /* flags needed to read msgs                      */
   accessflags readFlagsNot;  /* flags non-grata to read msgs                   */
   uint writeLevel;           /* Minimum level needed to write msgs             */
   accessflags writeFlags;    /* flags needed to write msgs                     */
   accessflags writeFlagsNot; /* flags non-grata to read msgs                   */
   uint sysopLevel;           /* Minimum level needed to change msgs            */
   accessflags sysopFlags;    /* flags needed to change msgs                    */
   accessflags sysopFlagsNot; /* flags non-grata to read msgs                   */

   char origin[62];           /* Origin line                                    */
   short aka;                   /* AKA                                            */

   uint rcvKillDays;          /* Kill received after xx days                    */
   uint msgKillDays;          /* Kill after xx days                             */
   uint maxMsgs;              /* Max # msgs                                     */

   char sysop[36];            /* Area Sysop                                     */
   short  replyBoard;           /* Area number where replies should go            */

   char echoTag[61];          /* Echomail Tag Name                              */
   char qwkTag[13];           /* QWK Area Name                                  */

   byte groups[4];            /* Groups belonging to                            */
   bool allGroups;            /* Belongs to all groups                          */
   byte minAge;               /* Minimum age for this area                      */

   byte extra[112];
  };

/* EOF PB200.H */