/*****************************************************************************
			 Maximus Structure Definitions
 *****************************************************************************

 Copyright 1989-1991 by Scott J. Dudley.  All rights reserved.
 Portions copyright 1990 by Bit Bucket Software, Inc.  Used with permission.

 This file contains the C structures used by Maximus 2.0.  Most of the
 structures were designed to be compatible with future versions, so
 PLEASE write your programs to permit variable-length structures. When
 we finally changed the user file size in Max 2.0, we found that a
 number of poorly-written third-party programs would not work under
 the new version.  (This is talking collectively, as Max SysOps.)

 However, programs which were properly written to spec worked as
 advertised, with no problems encountered.  The user file, the area
 file, and a few others are all VARIABLE LENGTH.  This may make things
 difficult if you're coding in Pascal or BASIC, but it's a cinch under
 C, and it makes things much more expandable.

 Just to make sure that everyone follows this, I may make the next
 version Maximus generate a random user record size.  }:->

 This file isn't as clean as I'd like it to be; it was thrown together
 in about an hour or so, scraping together the various tidbits from
 all over the Max source.  I had planned to clean it up and publish
 some sort of developer's kit, but I don't have time.

 The format for the Squish message base will be published in a
 separate file, with a full source release of the Maximus level 0
 MsgAPI layer.  I indend to make this available in a short period of
 time, but no guarantees.

 Scott J. Dudley
 November 11th, 1991
 FidoNet 1:249/106
 Internet f106.n249.z1.fidonet.org

 *****************************************************************************/


#define MAXCLASS          12       /* number of possible priv levels       */
#define MAX_OVR            16   /* Maximum # of override privs per area     */
#define MAX_ALEN           10   /* Max length of usr.msg[] and usr.files[]  */

typedef char   sbyte;
typedef signed short   sword;
typedef long    sdword;
typedef unsigned short ushort;
typedef   signed short sshort;
typedef   signed long  slong;

/* DOS-style bitmapped datestamp */

struct __stamp__
{
  struct
  {
    ushort da : 5;
    ushort mo : 4;
    ushort yr : 7;
  } date;

  struct
  {
    ushort ss : 5;
    ushort mm : 6;
    ushort hh : 5;
  } time;
};


struct _dos_st
{
  word date;
  word time;
};

/* Union so we can access stamp as "int" or by individual components */

union stamp_combo
{
  dword ldate;
  struct __stamp__ msg_t;
  struct _dos_st dos_st;
};

typedef union stamp_combo SCOMBO;

/* Access levels, as used in user file, PRM file, and others. */

#define MSGTYPE_SDM     0x01
#define MSGTYPE_SQUISH  0x02

#define  _TWIT        -2 /* 0xFFFE */
#define  _DISGRACE    0x0000
#define  _LIMITED     0x0001  /**/
#define  _NORMAL      0x0002
#define  _WORTHY      0x0003  /**/
#define  _PRIVIL      0x0004
#define  _FAVORED     0x0005  /**/
#define  _EXTRA       0x0006
#define  _CLERK       0x0007  /**/
#define  _ASSTSYSOP   0x0008
#define  _SYSOP       0x000A
#define  _HIDDEN      0x000b

#ifndef _ADDRESS_DEFINED
#define _ADDRESS_DEFINED
typedef struct _ADDRESS
{
  word Zone;
  word Net;
  word Node;
  word Point;
} ADDR;
#endif

/* Structure for AREA.DAT */

struct _override
{
  sword priv;   /* Override priv level */
  dword lock;   /* Override lock setting */

  byte ch;      /* First letter of menu option to apply override to */
  byte fill;    /* Reserved by Maximus */
};

struct maximus_areas
{
  long id;              /* Unique identifier for AREA.DAT structure.       *
                         * Should be AREA_id, above.                       */

  word struct_len;      /* Length of _area structure -- this needs only    *
			 * to be read from the first record in an area     *
			 * data file, since it can be assumed to remain    *
                         * the same throughout the entire file.  This is   *
                         * GUARANTEED to be at offset four for this and    *
                         * all future versions of this structure.          */

  word areano;          /* OBSOLETE.  Two-byte integer representation of   *
                         * this area's name.  Use area.name instead.       */

  byte name[40];        /* String format of area's name.  USE THIS!        */

  /*************************************************************************/
  /**                        Message Area Information                     **/
  /*************************************************************************/

  word type;            /* Message base type.  MSGTYPE_SDM = *.MSG.        *
			 * MSGTYPE_SQUISH = SquishMail.  (Constants are    *
			 * in MSGAPI.H)                                    */

  byte msgpath[80];     /* Path to messages                                */
  byte msgname[40];     /* The 'tag' of the area, for use in ECHOTOSS.LOG  */
  byte msginfo[80];     /* The DIR.BBS-like description for msg section    */
  byte msgbar[80];      /* Barricade file for message area                 */
  byte origin[62];      /* The ORIGIN line for this area                   */

  sword msgpriv;        /* This is the priv required to access the msg     *
			 * section of this area.                           */
  byte fill0;           /* The lock for the message area (obsolete)        */

  byte fill1;

  sword origin_aka;     /* This is the AKA number to use on the origin     *
			 * line.  See the normal SysOp documentation on    *
			 * the "Origin" statement, for info on how this    *
			 * number is used.                                 */

  /*************************************************************************/
  /**                        File Area Information                        **/
  /*************************************************************************/


  byte filepath[80];    /* Path for downloads                              */
  byte uppath[80];      /* Path for uploads                                */
  byte filebar[80];     /* Barricade file for file areas                   */
  byte filesbbs[80];    /* Path to FILES.BBS-like catalog for this area    */
  byte fileinfo[80];    /* The DIR.BBS-like description for file section   */

  sword filepriv;       /* This is the priv required to access the file    *
			 * section of this area.                           */
  byte fill15;          /* The locks for the file area (obsolete)          */
  byte fill2;

  /*************************************************************************/
  /**                      Miscellaneous Information                      **/
  /*************************************************************************/


  byte msgmenuname[13]; /* Alternate *.MNU name to use for this msg.area   */
  byte filemenuname[13];/* Alternate *.MNU name to use for this file area  */

  word attrib[MAXCLASS];/* This is an array of attributes for the          *
                         * msg/file areas.  These are dependant on PRIV    *
                         * level.  Once you have the CLASS number for a    *
                         * particular user (via Find_Class_Number()), you  *
                         * can find the attributes for that particular     *
                         * priv level like this: "area.attrib[class]"      *
                         * ...which will get you the attribute for that    *
                         * priv level.                                     */

  /*************************************************************************/
  /**                      Stuff hacked on later                          **/
  /*************************************************************************/

  struct _override movr[MAX_OVR]; /* Override privs for msg/file areas */
  struct _override fovr[MAX_OVR];
  
  dword msglock;        /* 32-bit locks for message areas                  */
  dword filelock;       /* 32-bit locks for file areas                     */

  word killbyage;       /* MAXREN: max # of days to keep msgs in this area */
			/*         (use 0 for no deletion by age)          */
  word killbynum;       /* MAXREN: max # of msgs to keep in area (use 0    */
                        /*         for no deletion by #msgs.)              */

};

/* Structure for USER.BBS and LASTUSER.BBS */

/* NOTE:  This structure is semi-stable.  Although it is still compatible  *
 * with the old Opus 1.03 structure, don't expect it to stay that way      *
 * for long.  In a future version, Maximus will be using a dymaic-sized    *
 * user record, making it possible to make additions without breaking      *
 * preexisting software.  You can start to code for this now in your       *
 * software, as the usr.struct_len variable indicates the length of the    *
 * current user structure, divided by twenty.  This allows us to build up  *
 * a base of utilities, and be able to switch to a new format (while still *
 * not breaking anything) in the future.  Also, if usr.sruct_len==0, then  *
 * you MUST assume that the length of the structure is actually 180 bytes  *
 * long, as Opus (and Maximus v1.00 only) did not use this field.  In      *
 * other words:                                                            *
 *                                                                         *
 * len_of_struct=(usr.struct_len ? (usr.struct_len*20) : 180)              *
 *                                                                         *
 * In addition, you can assume that all user records in the user file are  *
 * the SAME size...  ie. You can just read the first user record out of    *
 * the file, and you are assured that the rest of the records in the file  *
 * area also the same size.                                                *
 *                                                                         *
 *                                                                         *
 * Example for reading in the dynamic-sized user structure:                *
 *                                                                         *
 *    {                                                                    *
 *      struct _usr users[MAX_USERS];                                      *
 *                                                                         *
 *      int x,                                                             *
 *          userfile,                                                      *
 *          s_len;                                                         *
 *                                                                         *
 *      if ((userfile=open(ufile_name,O_RDONLY | O_BINARY))==-1)           *
 *        Error();                                                         *
 *                                                                         *
 *      read(userfile,&users[0],sizeof(struct _usr));                      *
 *                                                                         *
 *      s_len=users[0].struct_len ? users[0].struct_len*20 : 180;          *
 *                                                                         *
 *      for (x=0;x < MAX_USERS;x++)                                        *
 *      {                                                                  *
 *        lseek(userfile,(long)x*(long)s_len,SEEK_SET);                    *
 *        read(userfile,&users[x],sizeof(struct _usr));                    *
 *      }                                                                  *
 *                                                                         *
 *      close(userfile);                                                   *
 *    }                                                                    *
 *                                                                         *
 * If anything is added to the user structure, it will be appended to the  *
 * END of the structure, so you can be assured that the offsets of each    *
 * individual variable will NOT change.                                    *
 *                                                                         *
 * Also, when ADDING or DELETING users, certain special operations have    *
 * to be performed, mainly those related to the lastread pointers.  When   *
 * adding a user, the procedure is fairly simple; just make sure that      *
 * usr.lastread_ptr is a unique number, different from all others in       *
 * USER.BBS.  Although Max uses a somewhat complicated algorithm to        *
 * fill gaps in the user file, most utility programs can just read through *
 * USER.BBS, and keep a running tally of the HIGHEST usr.struct_len        *
 * variable.  Once you have that, increment it by one, and stuff it into   *
 * the usr.struct_len of the user to be added.                             *
 *                                                                         *
 * When DELETING users, you must go through the process of "cleansing"     *
 * the lastread pointers for the user you deleted.  The procedure for this *
 * is simple:  For every area listed in AREAS.CTL, open the LASTREAD.BBS   *
 * file for that area, and seek to the offset...                           *
 *                                                                         *
 *    usr.lastread_ptr*(long)sizeof(int)                                   *
 *                                                                         *
 * ...and write *two* NUL bytes (ASCII 00).                                *
 *                                                                         *
 * Please note that you do NOT need to do anything special to sort the     *
 * user file...  Since the lastread offset is stored in usr.lastread_ptr,  *
 * you can sort the user file with impunity, and even use old Opus 1.03    *
 * sort utilities.                                                         */

struct maximus_user
   {
      byte name[36];        /* Caller's name                                */
      byte city[36];        /* Caller's location                            */

      byte alias[21];       /* MAX: user's alias (handle)                   */
      byte phone[15];       /* MAX: user's phone number                     */

      word lastread_ptr;    /* MAX: a num which points to offset in LASTREAD*/
                            /* file -- Offset of lastread pointer will be   */
                            /* lastread_ptr*sizeof(int).                    */

      word timeremaining;   /* MAX: time left for current call (xtern prog) */

      byte pwd[16];         /* Password                                     */
      word times;           /* Number of previous calls to this system      */
      byte help;            /* Help level                                   */
/**/  byte rsvd1[2];        /* Reserved by Maximus for future use           */
      byte video;           /* user's video mode (see GRAPH_XXXX)           */
      byte nulls;           /* Number of Nulls (delays) after <cr>          */

      byte bits;            /* Bit flags for user (number 1)                */

/**/  word rsvd2;           /* Reserved by Maximus for future use           */

      word bits2;           /* Bit flags for user (number 2)                */

      sword priv;           /* Access level                                 */
/**/  byte rsvd3[19];       /* Reserved by Maximus for future use           */
      byte struct_len;      /* len of struct, divided by 20. SEE ABOVE!     */
      word time;            /* Time on-line so far today                    */

      word delflag;         /* Used to hold baud rate for O)utside command  */
                            /* In USER.BBS, usr.flag uses the constants     */
                            /* UFLAG_xxx, defined earlier in this file.     */
      
/**/  byte rsvd4[8];        /* Reserved by Maximus for future use           */

      byte width;           /* Width of the caller's screen                 */
      byte len;             /* Height of the caller's screen                */
      word credit;          /* Matrix credit, in cents                      */
      word debit;           /* Current matrix debit, in cents               */

      word  xp_priv;        /* Priv to demote to, when time or minutes run  */
                            /* out.                                         */

      union stamp_combo xpdate;  /* Bit-mapped date of when user expires.  */
                                  /* If zero, then no expiry date.          */
 
      dword xp_mins;        /* How many minutes the user has left before    *
                             * expiring.                                    */

      byte  xp_flag;        /* Flags for expiry.  See above XFLAG_XXX defs. */
      byte  xp_rsvd;

      union stamp_combo ludate;   /* Bit-mapped date of user's last call    */

      dword xkeys;          /* User's keys (all 32 of 'em)                  */
      byte  lang;           /* The user's current language #                */
      sbyte def_proto;      /* Default file-transfer protocol               */

      dword up;             /* K-bytes uploaded, all calls                  */
      dword down;           /* K-bytes downloaded, all calls                */
      dword downtoday;      /* K-bytes downloaded, today                    */

      byte msg[MAX_ALEN];   /* User's last msg area (string)                */
      byte files[MAX_ALEN]; /* User's last file area (string)               */

      byte compress;        /* Default compression program to use           */

/**/  byte rsvd5;
      dword extra;
   };


