// Header file for the Msgs class
// Created 28 February 1996
// Revised 21 May 1998

#if !defined(__MSGS_H__)
#define __MSGS_H__

#include "extern.h"
#include "dates.h"
#include "crc.h"
#include "utility.h"
#include "amustr.h"
#include "config.h"
#include "macros.h"

#define NO_POST "NOPOST.CTL"

/* Structure used to pass msg posting info into the Msgs object */
struct msgpostinfo
{
    struct msgarea *area;
    char to[36],
	 from[36],
	 subject[36],
	 fn[MAX_FILESPEC];
};

class Msgs
{
    private:
    char LOGSTR[151],
	 Header[201];
    int share_installed;
    class AMU_Msgs MsgMacro_obj;
    class Dates Today;
    class Utility Utility_obj;
    class Crc Crc_obj;
    class Amustr Amustr_obj;

    /* Public functions */
    public:
    Msgs(void);
    int post_msg(struct msgpostinfo *msgpostvar, struct user_array *userptr);
    long area_info(struct msgarea *area);

    /* Private functions */
    private:
    int write_to_JAM(struct msgpostinfo *msgpostvar);
    int write_to_Hudson(struct msgpostinfo *msgpostvar);
    int write_to_Gold(struct msgpostinfo *msgpostvar);
    int write_to_Squish(struct msgpostinfo *msgpostvar);
    int write_to_MSG(struct msgpostinfo *msgpostvar);
    int write_to_EZY(struct msgpostinfo *msgpostvar);
    long JAM_info(struct msgarea *area);
    long EZY_info(struct msgarea *area);
    long Hudson_info(struct msgarea *area);
    long Gold_info(struct msgarea *area);
    long Squish_info(struct msgarea *area);
    long MSG_info(struct msgarea *area);
    long get_squish_hash(char *f);
    unsigned long JAMtime(void);
};
#endif
/***********************************************************************/
/* EOF - MSGS.H */

