/* Menus class                   */
/* Created      01 November 1996 */
/* Revised 26 September 1997     */

#if !defined(__MENUS__)
  #define __MENUS__

#include "crc.h"
#include "utility.h"
#include "amustr.h"
#include "extern.h"

#define NO_HELP           -1
#define MAIN_HELP         100
#define MAIN_SYSTEM_HELP  150
#define SYSTEM_HELP       200
#define PATHNAMES_HELP    250
#define FILENAMES_HELP    300
#define LOGFILE_HELP      350
#define ARCHIVES_HELP     400
#define MAINT_HELP        450
#define MAIN_FILES_HELP   500
#define GLOBAL_HELP       550
#define AREAS_HELP        600
#define MAIN_USER_HELP    650
#define ENFORCE_HELP      700
#define MSG_HELP          750
#define BULLETIN_HELP     800
#define ALLNEW_HELP       850
#define LANGUAGE_HELP     900
#define ARCHIVER_HELP     950
#define SCANNER_HELP      1000

#define SAVE_PROMPT           0
#define DELETE_PROMPT         1
#define CFGNOTFOUND_PROMPT    2
#define CREATEPATH_PROMPT     3
#define FILECFGCHANGED_PROMPT 4
#define MSGCFGCHANGED_PROMPT 5

#define FALSE  0
#define TRUE   1

#define BACK 8
#define ESC 27
#define ENTER 13
#define SPACE 32
#define UP 72
#define DOWN 80
#define LEFT 75
#define RIGHT 77
#define HOME 71
#define END 79
#define DEL 83
#define INS 82
#define PGDN 81
#define PGUP 73
#define F1 59
#define F2 60
#define F3 61
#define F4 62
#define F5 63
#define F6 64
#define F7 65
#define HATCH ""

/* Possible values for VALID_TYPE */
#define PATH      0    // Directory - checked for validity
#define FILENM    1    // Uppercase only, no spaces
#define SPACES_OK 2    // Allow spaces and lowercase
#define NO_EXT    3    // No extension
#define RANGE_1   4    // 1 - 200
#define RANGE_2   5    // 1 - 65535
#define RANGE_3   6    // 1 - 32766
#define RANGE_4   7    // 0 - 10
#define RANGE_5   8    // 0 - 99
#define RANGE_6   9    // 1 - 31
#define RANGE_7  10    // 0 - 32766

extern int use_mono;

struct coordinates
{
    int top,
        left,
        width,
	items,
        high_num,
        uses_blanks,
        position;       // Used to return the position to the calling fn
    char *title,
         *options;
};

class Menus
{
    public:
    struct coordinates cvar;

    private:
    class Amustr Amustr_obj;
    class Utility Utility_obj;
    class Crc Crc_obj;

    protected:
    short VALID_TYPE;
    char *optionsstr;
    long BASE_HELP;

    public:
    int dialog(struct coordinates *cvar, char default_char, int columns);
    void color(int back, int fore);

    void set_help(long i) { BASE_HELP = i;}
    void set_validtype(short i) { VALID_TYPE = i;}
    char *getfield(char *infield, int left, int top, int length);
    void help(char *str);
    int display_menu(struct coordinates *cvar, int columns);
    unsigned get_point(int type, int range);
    int prompt(int mode);
    int areasmenu(int option);
    void arctype_toggle(short *intype);
    void get_enforcetype(void);
    void get_mainttype(void);
    void get_bulletintype(void);
    void get_messagestype(void);
    void get_color(int mode, short *incolor);
    void get_border(short *intype);
    void get_sorttype(short *intype);
    void get_cdformat(short *intype);
    void get_swaptype(short *intype);
    void get_bbstype(short *intype);
    void get_datetype(short *intype);
    void get_loglevel(short *intype);
    void get_oldconfig(short *intype);
    void get_listtype(short *intype);
    void get_mailertype(short *intype);
    void get_archivestype(short *intype);
    void get_weekday(short *intype);
    void get_archivesweekday(short *intype);
    void get_logtype(short *intype);
    void get_userlevel(unsigned short *intype);
    void get_maximus2_userlevel(unsigned short *intype);
    void get_maximus3_userlevel(int *max3index, char *max3str, int num_levels);
    int get_yesno(void);
    void online_help(int topic);

    void writemenu(char *options, char *title, int left, int top, int width,
		   int columns, int items, int highlight, int num_high);
    int valid(char *inpath);
    int _strlength(char *str);
    char *squeeze(char *instr);
    char *makestr(int begin, int end, int option);

//    void position_help(int i);
//    void update_bar(char *options, int left, int top, int oldpos, int newpos, int high_num);
};
#endif

/* EOF - MENUS.H */
