// Functions dealing with menus
// Created 03 June 1994
// Revised 12 November 1997   

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include "utility2.h"
#include "extern.h"
#include "bbsinfo.h"
#include "listbox.h"
#include "config.h"
#include "menus.h"
#include "amuidx.h"

class OnlineBox OnlineBox_obj;

/* external objects */
extern int use_mono;
extern class Utility2 Utility2_obj;
extern class Config Config_obj;
extern void position_help(int i, int BASE_HELP);

/***********************************************************************/

/* Put a menu onto the screen
   options   - String with a list of each option to appear on the menu, each
               item is separated by a ';'
   title     - Title of the menu
   left      - left corner of the menu
   top       - top corner of the menu
   width     - how wide the menu is allowed to be
   columns   - how many columns the menu should be divided into
   items     - number of items to place on the menu
   highlight - number of the item to be highlighted, 0 = don't highlight
   num_high  - number of columns to highlight
*/
void Menus::writemenu(char *options, char *title, int left, int top, int width,
                      int columns, int items, int highlight, int num_high)
{
    int i, j, current_column, top_offset, per_column, in_column;
    char *ptr, *ptr2, str[100], tmpstr[200];

    /* First, we need to make sure the number of items is evenly divisible
       by the number of columns passed in */
    while(items % columns != 0)
    {
        items++;
        strcat(options, " ;");
    }
    per_column = items / columns;

    width += (width + 2 + columns - 1) % columns;

   /* Create the top line with the title */
    gotoxy(left, top);
    color(BLACK, LIGHTGRAY);
    cprintf("");
    if(title && *title)
    {
        color(LIGHTBLUE, YELLOW);
        cprintf("%s", title);
        color(BLACK, LIGHTGRAY);
        i = width - strlen(title) + 1;
    }
    else
    {
        i = width + 1;
    }
    memset(tmpstr, '', i);
    tmpstr[i] = NULL;
    cprintf("%s", tmpstr);


   /* Now write the items to the screen */
    in_column = 0;
    current_column = 1;
    ptr = options;
    top_offset = top;
    for(i = 1; i <= items; i++)
    {
        color(BLACK, LIGHTGRAY);

        /* See if we need to move to the next column or not */
        if(in_column == per_column)
        {
            current_column++;
            top_offset = top;
            in_column = 0;
        }
        top_offset++;
        in_column++;

        j = (current_column - 1) * (width / columns);
        if(current_column > 1)
        {
            j++;
        }

        gotoxy(left + j, top_offset);

      /* Extract the next item and put it into 'str' */
        ptr2 = str;
        while(*ptr != ';'  &&  *ptr)
        {
            *ptr2 = *ptr;
            ptr++;
            ptr2++;
        }
        *ptr2 = NULL;
        if(*ptr == ';')
        {
            ptr++;
        }

        Amustr_obj.pad(str, width / columns);

        if(current_column == 1)
        {
            cprintf(" ");
        }
        else
        {
            cprintf("  ");
        }


     /* See if we're at the item that needs to be highlighted */
        if(i == highlight)
        {
            if(!use_mono)
            {
                color(LIGHTGRAY, BLUE);
            }
            else
            {
                textcolor(LIGHTGRAY);
                textbackground(BLACK);
            }

            /* Some spots need to have only part of the line highlighted,
               and num_high will be non-zero if this is the case
            */
            ptr2 = str;
            if(num_high > 0)
            {
                for(j = 0; j < num_high; j++)
                {
                    tmpstr[j] = *ptr2;
                    ptr2++;
                }
                tmpstr[j] = NULL;
                cprintf("%s", tmpstr);
                color(BLACK, CYAN);
            }
            cprintf("%s", ptr2);
        }
        else
        {
            color(BLACK, CYAN);
            cprintf("%s", str);
        }

        if(current_column == columns)
        {
            color(BLACK, LIGHTGRAY);
            cprintf(" ");

            /* Add the shadow */
            color(BLACK, DARKGRAY);
            gettext(wherex(), wherey(), wherex() + 1, wherey(), tmpstr);
            cprintf("%c%c", tmpstr[0], tmpstr[2]);
        }
    }


    /* Put the bottom border on the menu */
    color(BLACK, LIGHTGRAY);
    gotoxy(left, (items / columns) + top + 1);
    memset(tmpstr, '', width+2);
    tmpstr[width+2] = NULL;
    cprintf("%s", tmpstr);

    /* Add the shadow */
    color(BLACK, DARKGRAY);
    gettext(wherex(), wherey(), wherex() + 1, wherey(), tmpstr);
    cprintf("%c%c", tmpstr[0], tmpstr[2]);


    /* Add the shadow */
    color(BLACK, DARKGRAY);
    gotoxy(left+1, wherey() + 1);
    gettext(left+1, wherey(), left+5+width, wherey(), tmpstr);
    ptr = tmpstr;
    for(i = 0; i < (width + 5); i++)
    {
        cprintf("%c", *ptr);
        ptr += 2;
    }
    color(BLACK, LIGHTGRAY);
}

char *Menus::getfield(char *infield, int left, int top, int length)
{
    static char field[101], infieldtmp[101];
    static int insert = TRUE;
    unsigned i, k, index, ok;


     /* The input INFIELD parameter must NOT be modified, doing so may result
        in other data being overwritten in memory */


    /* If this looks like it may be a path, reduce the length by one so there
       is enough room for a backslash
    */
    if(length > 25)
    {
        length--;
    }
    ok = FALSE;
    strcpy(infieldtmp, infield);
    gotoxy(left, top);
    color(LIGHTGREEN, BLUE);
    if(insert)
    {
        _setcursortype(_NORMALCURSOR);
    }
    else
    {
        _setcursortype(_SOLIDCURSOR);
    }

    while(strlen(infieldtmp) < length)
    {
        strcat(infieldtmp, HATCH);
    }
    cprintf("%s", infieldtmp);


    /* Make a copy of the original string, which we'll use to work on.
       If the user chooses to abort, the original INFIELD will remain intact
       to be restored
    */
    strcpy(field, infieldtmp);

    do
    {
        if(length == 1)
        {
            insert = FALSE;
        }
    /* Index is used as an index into the actual string */
        index = 0;
        gotoxy(left, top);
        color(LIGHTGREEN, BLUE);
        i = getch();
    while(i != ESC && i != ENTER)
    {

        /* Do not allow users to use a ';' */
         if(i == ';')
         {
             i = getch();
             continue;
         }

                        /* An arrow key or something was pressed, handle it */
         if(i == 0)
         {
             i = getch();
             switch(i)
             {
                 /* Decrement the index and cursor, IF it's not at position 0 */
                 case LEFT: if(index > 0)
                            {
                                gotoxy(wherex() - 1, wherey());
                                index--;
                            }
                            break;

                 /* Increment the index and cursor, IF it's not at the end */
                 case RIGHT: if(index < (length - 1))
                             {
                                 gotoxy(wherex() + 1, wherey());
                                 index++;
                             }
                             break;

                 /* Go to the end of the line */
                 case END: index = strcspn(field, HATCH);
                           if(index == length)
                           {
                               index--;
                           }
                           gotoxy(left + index, wherey());
                           break;

                 /* Go to the beginning of the line */
                 case HOME: index = 0;
                            gotoxy(left, wherey());
                            break;

                 /* If DEL is hit, we need to "squeeze" the string and redisplay it */
                 case DEL: if(length > 1)
                           {
                               field[index] = '';
                               strcpy(field, squeeze(field));
                               gotoxy(left, wherey());
                               cprintf("%s", field);
                               gotoxy(index + left, wherey());
                           }
                           break;
                 case INS: Utility_obj.toggle(&insert);
                           if(insert)
                           {
                               _setcursortype(_NORMALCURSOR);
                           }
                           else
                           {
                               _setcursortype(_SOLIDCURSOR);
                           }
                           break;
             }
         }
         else
         {
             if(index <= (length)  &&  isprint(i))
             {

                 if(index == length)
                 {
                     index--;
                 }

                 /* Allow capitalized input with NO spaces */
                 if(!isspace(i)  &&  VALID_TYPE != SPACES_OK)
                 {
                     i = toupper(i);
                     if(insert)
                     {
                         if(_strlength(field) < length)
                         {
                             field[strcspn(field, HATCH)] = NULL;
                             for(k = strlen(field); k > index; k--)
                             {
                                 field[k] = field[k-1];
                             }
                             field[index] = i;
                             gotoxy(left, wherey());
                             cprintf("%s", field);
                             gotoxy(left+index+1, wherey());
                             index++;
                         }
                     }
                     else
                     {
                         cprintf("%c", i);
                         field[index] = i;
                         index++;
                     }
                 }

                 /* Allow case sensitive input, spaces ok */
                 if(VALID_TYPE == SPACES_OK)
                 {
                     if(insert)
                     {
                         if(_strlength(field) < length)
                         {
                             field[strcspn(field, HATCH)] = NULL;
                             for(k = strlen(field); k > index; k--)
                             {
                                 field[k] = field[k-1];
                             }
                             field[index] = i;
                             gotoxy(left, wherey());
                             cprintf("%s", field);
                             gotoxy(left+index+1, wherey());
                             index++;
                         }
                     }
                     else
                     {
                         cprintf("%c", i);
                         field[index] = i;
                         index++;
                     }
                 }

                 if(index == length)
                 {
                     gotoxy(wherex() - 1, wherey());
                 }

             }
             if(i == BACK && index > 0)
             {
                 index--;
                 field[index] = '';
                 strcpy(field, squeeze(field));
                 gotoxy(left, wherey());
                 cprintf("%s", field);
                 gotoxy(index + left, wherey());
             }
         }
         i = getch();
    }

    field[strcspn(field, HATCH)] = NULL;

    _setcursortype(_NOCURSOR);
    ok = valid(field);
    if(!ok  &&  VALID_TYPE == PATH)
    {
        /* If this is a path, prompt the user to create it */
        if(prompt(CREATEPATH_PROMPT))
        {
            Amustr_obj.noslash(field);
            Utility2_obj.mkdir_nested(field);
            Amustr_obj.slash(field);
        }
        ok = TRUE;
    }
    _setcursortype(_NORMALCURSOR);


    }while(!ok);

    _setcursortype(_NOCURSOR);

    if(i == ESC)
    {
        strcpy(field, infield);
    }
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
    return(field);
}

char *Menus::squeeze(char *instr)
{
    static char tmpstr[71];
    int i = 0;

    /* Remove the first  you find, append one space to the end, then return the string */
    while(instr[i] != '')
    {
        tmpstr[i] = instr[i];
        i++;
    }
    i++;

    while(instr[i])
    {
         tmpstr[i-1] = instr[i];
         i++;
    }
    tmpstr[i-1] = '';
    tmpstr[i] = NULL;
    return(tmpstr);
}


/* Determine if the input string is valid */
int Menus::valid(char *inpath)
{
    int value;
    long i;
    char *ptr;

    switch(VALID_TYPE)
    {
        case PATH: Amustr_obj.noslash(inpath);
                   if(!*inpath)
                   {
                       return(TRUE);
                   }
                   if(access(inpath, 0) == 0)
                   {
                       value = TRUE;
                   }
                   else
                   {
                       help("Must be a valid pathname");
                       value = FALSE;
                   }
                   Amustr_obj.slash(inpath);
                   break;

        case FILENM: Amustr_obj.noslash(inpath);
                     value = TRUE;
                     break;

        case SPACES_OK: value = TRUE;
                        break;

        case NO_EXT: ptr = (char *) strchr(inpath, '.');
                     if(ptr)
                     {
                         *ptr = NULL;
                     }
                     value = TRUE;
                     break;
        case RANGE_1: i = atol(inpath);
                      if(i >= 1  &&  i <= 200)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 1 and 200");
                      }
                      break;
        case RANGE_2: i = atol(inpath);
                      if(i >= 1  &&  i <= 65534)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 1 and 65534");
                      }
                      break;
        case RANGE_3: i = atol(inpath);
                      if(i >= 1  &&  i <= 32765)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 1 and 32765");
                      }
                      break;
        case RANGE_4: i = atol(inpath);
                      if(i >= 0  &&  i <= 10)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 0 and 10");
                      }
                      break;
        case RANGE_5: i = atol(inpath);
                      if(i >= 0  &&  i <= 99)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 1 and 99");
                      }
                      break;
        case RANGE_6: i = atol(inpath);
                      if(i > 0  &&  i <= 31)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 1 and 31");
                      }
                      break;
        case RANGE_7: i = atol(inpath);
                      if(i >= 0  &&  i <= 32765)
                      {
                          value = TRUE;
                      }
                      else
                      {
                          value = FALSE;
                          help("Must be between 0 and 32765");
                      }
                      break;
    }
    return(value);
}

void Menus::color(int back, int fore)
{
    if(use_mono)
    {
        back = LIGHTGRAY;
        fore = BLACK;
    }
    textcolor(fore);
    textbackground(back);
}

void Menus::help(char *str)
{
    color(BLACK, LIGHTGRAY);
    gotoxy(1, 25);
         delline();
    cprintf(str);
}

int Menus::_strlength(char *str)
{
    int i = 0;
    char *ptr;

    ptr = str;
    while(*ptr)
    {
        if(*ptr != '')
        {
            i++;
        }
        ptr++;
    }
    return(i);
}

unsigned Menus::get_point(int type, int range)
{
    int width, max_options, left, top, position, point, offset;
    char str[41], title[20], *tmpbuf, tmpstr[6];

    max_options = 1;
    width = 25;
    left = 30;
    top = 10;
    position = 2;
    point = -1;
    tmpstr[0] = NULL;
    offset = 20;

    /*
        type

        0  - Start position
        1  - End position
        2  - Jump to area
        3  - Get a number with 'range' bounds
    */

    switch(type)
    {
        case 0: strcpy(str, "Area to start at: ;");
                break;
        case 1: strcpy(str, "Area to end at  : ;");
                break;
        case 2: strcpy(str, "Area to jump to : ;");
                break;
        case 3: strcpy(str, "Enter new value : ;");
                break;
    }

    title[0] = NULL;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);

    writemenu(str, title, left, top, width, 1, max_options, position, 0);

    VALID_TYPE = RANGE_2;
    if(type == 3)
    {
        VALID_TYPE = range;
    }
    strcpy(tmpstr, getfield(tmpstr, left + offset, top + 1, 5));
    if(tmpstr[0] == NULL)
    {
        point = 0;
    }
    else
    {
        point = atoi(tmpstr);
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(point);
}

int Menus::prompt(int mode)
{
    int answer, _char;
    char str[91], *tmpbuf, default_char;
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    cvar.items = 3;
    cvar.top = 10;
    cvar.high_num = 0;
    cvar.title = NULL;
    switch(mode)
    {
        case SAVE_PROMPT: strcpy(str, "  ;Save (Y/n)?  ;  ;");
                          help("Save changes?");
                          cvar.left = 32;
                          cvar.width = 15;
                          default_char = 'Y';
                          break;
        case DELETE_PROMPT: strcpy(str, "  ;Delete (y/N)?  ;  ;");
                            help("Confirm deletion");
                            cvar.left = 32;
                            cvar.width = 17;
                            default_char = 'N';
                            break;
        case CFGNOTFOUND_PROMPT: sprintf(str, "  ;%s not found;Create (Y/n)?  ;  ;", CONFIG_AMU);
                                 cvar.width = 22;
                                 cvar.left = 27;
                                 cvar.items = 4;
                                 default_char = 'Y';
                                 break;

        case CREATEPATH_PROMPT: sprintf(str, "  ;Path not found;Create (Y/n)?  ;  ;");
                                cvar.width = 22;
                                cvar.left = 27;
                                cvar.items = 4;
                                cvar.top = 11;
                                default_char = 'Y';
                                break;
        case FILECFGCHANGED_PROMPT: sprintf(str, "  ;BBS file areas have changed;Import new data? (Y/n)  ;  ;");
                                    cvar.width = 30;
                                    cvar.left = 25;
                                    cvar.items = 4;
                                    default_char = 'Y';
                                    break;
        case MSGCFGCHANGED_PROMPT: sprintf(str, "  ;BBS message areas have changed;Import new data? (Y/n)  ;  ;");
                                   cvar.width = 33;
                                   cvar.left = 22;
                                   cvar.items = 4;
                                   default_char = 'Y';
                                   break;
    }

    cvar.options = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    _char = dialog(&cvar, default_char, 1);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    if(toupper(_char) == 'Y')
    {
        answer = TRUE;
    }
    else
    {
        answer = FALSE;
    }
    if(_char == ESC)
    {
        answer = ESC;
    }
    return(answer);
}

/*
  Handles moving the highlight bar up and down, when a key other than UP or
  DOWN is pressed, return the key to the calling funtion.  This calls
  writemenu() to display the actual menu.
  cvar    - pointer to a 'coordinates' struct with the size information
  columns - how many columns the options should be spread across
*/
int Menus::display_menu(struct coordinates *cvar, int columns)
{
    int position, i, amax_options;

    position = cvar->position;
    amax_options = cvar->items;
    if(amax_options % columns)
    {
        amax_options++;
    }

    writemenu(cvar->options, cvar->title, cvar->left, cvar->top, cvar->width, columns,
              cvar->items, position, cvar->high_num);
    do
    {
        position_help(position, BASE_HELP);
        i = getch();
        if(i == 0)
        {
            i = getch();
            switch(i)
            {
                case UP: if(cvar->uses_blanks)
                         {
                             if(position == 2)
                             {
                                 position = cvar->items - 1;
                             }
                             else
                             {
                                 position--;
                             }
                         }
                         else
                         {
                             if(position == 1)
                             {
                                 position = cvar->items;
                             }
                             else
                             {
                                 position--;
                             }
                         }
                         break;

                case DOWN: if(cvar->uses_blanks)
                           {
                               if(position == cvar->items - 1)
                               {
                                   position = 2;
                               }
                               else
                               {
                                   position++;
                               }
                           }
                           else
                           {
                               if(position == cvar->items)
                               {
                                   position = 1;
                               }
                               else
                               {
                                   position++;
                               }
                           }
                           break;

                case RIGHT: if(position + (amax_options / columns) <= amax_options)
                            {
                                position += amax_options / columns;
                            }
                            else
                            {
                                position = position % (amax_options / columns);
                            }
                            break;

                case LEFT: if(position - (amax_options / columns) < 1)
                           {
                               position = position + ((columns - 1) * amax_options / columns);
                           }
                           else
                           {
                               position -= amax_options / columns;
                           }
                           break;
                case F1: cvar->position = position;
                         return(i);
            }
            writemenu(cvar->options, cvar->title, cvar->left, cvar->top, cvar->width,
                      columns, cvar->items, position, cvar->high_num);
            position_help(position, BASE_HELP);
        }
        else
        {
            if(i == ENTER)
            {
                cvar->position = position;
                return(i);
            }
        }
    } while(i != ESC);
    return(i);
}

/* Displays 'str' and waits for a key to be pressed.  If ENTER is pressed,
   return 'default_char', otherwise return the key pressed.  Uses makemenu().
*/
int Menus::dialog(struct coordinates *cvar, char default_char, int columns)
{
    int i;

    writemenu(cvar->options, cvar->title, cvar->left, cvar->top, cvar->width, columns, cvar->items, 0, 0);
    /* If the default character is DEL, don't wait for user input */
    if(default_char == DEL)
    {
        return(DEL);
    }

    i = getch();
    if(i == 0)
    {
        i = getch();
    }
    if(i == ENTER)
    {
        i = default_char;
    }
    return(toupper(i));
}

void Menus::arctype_toggle(short *intype)
{
    int i;
    char *tmpbuf, optionsstr[51];
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    cvar.items = 10;
    cvar.width = 5;
    cvar.left = 3;
    cvar.top = 7;
    cvar.position = 1;
    cvar.high_num = 0;

    strcpy(optionsstr, "ARC;ARJ;HAP;LZH;PAK;SQZ;ZIP;ZOO;UC2;RAR;");
    cvar.options = optionsstr;
    cvar.title = NULL;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    }while(i != ENTER  &&  i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/* Get the Border style type */
void Menus::get_border(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(150);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 5;
    cvar.width = 25;
    cvar.left = 24;
    cvar.top = 10;
    cvar.position = 1;
    cvar.title = NULL;

    set_help(NO_HELP);
    strcpy(optionsstr, "           ;           ;           ;           ;+ | -;");
    cvar.options = optionsstr;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    }while(i != ENTER  &&  i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_color(int mode, short *incolor)
{
    int i;
    char *tmpbuf, title[7], *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(200);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;

    /* Mode
       0 - Background color (0-7)
       1 - Foreground color (0-15)
    */

    if(mode == 0)
    {
        cvar.items = 8;
        cvar.width = 15;
    }
    else
    {
        cvar.items = 16;
        cvar.width = 30;
    }
    cvar.left = 30;
    cvar.top = 11;
    cvar.position = 1;

    strcpy(optionsstr, "Black;Blue;Green;Cyan;Red;Magenta;Brown;Light Gray;Dark Gray;Light Blue;");
    strcat(optionsstr, "Light Green;Light Cyan;Light Red;Light Magenta;Yellow;White;");
    strcpy(title, "Colors");
    cvar.title = title;
    cvar.options = optionsstr;
    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        if(mode == 0)
        {
            i = display_menu(&cvar, 1);
        }
        else
        {
            i = display_menu(&cvar, 2);
        }
        switch(i)
        {
            case ENTER: *incolor = cvar.position - 1;
                        break;
        }
    }while(i != ENTER  &&  i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

/* Get the swap type */
#pragma argsused
void Menus::get_swaptype(short *intype)
{
#ifdef __OS2__
    return;
#else

    int i;
    char *tmpbuf, optionsstr[31];
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 3;
    cvar.width = 15;
    cvar.left = 32;
    cvar.top = 9;
    cvar.position = 1;
    strcpy(optionsstr, "XMS/EMS/DISK;XMS/EMS;DISK;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: switch(cvar.position-1)
            {
                case 0: *intype = MODE_1;
                        break;
                case 1: *intype = MODE_2;
                        break;
                case 2: *intype = MODE_3;
                         break;
                default: *intype = MODE_3;
                         break;
            }
            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
#endif
}

void Menus::get_bbstype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(400);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = NUM_BBS;
    cvar.width = 50;
    cvar.left = 15;
    cvar.top = 7;
    cvar.position = 1;

    strcpy(optionsstr, "Concord 0.01;EzyCom 1.20/1.48g;LoraBBS 2.40;LoraBBS 2.99;Maximus 2.02;Maximus 3.01;Proboard 2.16;");
    strcat(optionsstr, "QuickBBS 2.76;QuickBBS 2.85/Classic;QuickBBS 2.85/GoldBase;");
    strcat(optionsstr, "RemoteAccess 1.11;RemoteAccess 2.02;RemoteAccess 2.52;SuperBBS 1.17;Telegard 3.02;Telegard 3.09g");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 2);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = CONCORD;
                                        break;
                                case 1: *intype = EZ;
                                        break;
                                case 2: *intype = LORA;
                                        break;
                                case 3: *intype = LORA3;
                                        break;
                                case 4: *intype = MAXIMUS2;
                                        break;
                                case 5: *intype = MAXIMUS3;
                                        break;
                                case 6: *intype = PB2;
                                        break;
                                case 7: *intype = QBBS;
                                        break;
                                case 8: *intype = QBBSC;
                                        break;
                                case 9: *intype = QBBSG;
                                        break;
                                case 10: *intype = RA1;
                                         break;
                                case 11: *intype = RA2;
                                         break;
                                case 12: *intype = RA250;
                                         break;
                                case 13: *intype = SBBS;
                                         break;
                                case 14: *intype = TG3;
                                         break;
                                case 15: *intype = TG310;
                                         break;
                                default: *intype = CONCORD;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_mailertype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = NUM_MAIL;
    cvar.width = 19;
    cvar.left = 35;
    cvar.top = 8;
    cvar.position = 1;

    strcpy(optionsstr, "None;BinkleyTerm;D'Bridge;FrontDoor;InterMail;Portal of Power;MainDoor;");
    strcat(optionsstr, "Xenia;McMail;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = NOMAIL;
                                        break;
                                case 1: *intype = BT;
                                        break;
                                case 2: *intype = DB;
                                        break;
                                case 3: *intype = FD;
                                        break;
                                case 4: *intype = IM;
                                        break;
                                case 5: *intype = POP;
                                        break;
                                case 6: *intype = MD;
                                        break;
                                case 7: *intype = XENIA;
                                        break;
                                case 8: *intype = MCMAIL;
                                        break;
                                default: *intype = NOMAIL;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_logtype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(250);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = NUM_LOG;
    cvar.width = 36;
    cvar.left = 20;
    cvar.top = 8;
    cvar.position = 1;

    strcpy(optionsstr, "RemoteAccess;QuickBBS;SuperBBS;ProBoard;Concord;Maximus;EzyCom;LoraBBS;Telegard;BinkleyTerm;D'Bridge;FrontDoor;");
    strcat(optionsstr, "InterMail;Portal of Power;Silver Xpress;BlueWave;JC-QWK;MainDoor;");
    strcat(optionsstr, "Xenia;McMail;O.L.M.S.");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 2);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = RA_L;
                                        break;
                                case 1: *intype = QBBS_L;
                                        break;
                                case 2: *intype = SBBS_L;
                                        break;
                                case 3: *intype = PB_L;
                                        break;
                                case 4: *intype = CONCORD_L;
                                        break;
                                case 5: *intype = MAX_L;
                                        break;
                                case 6: *intype = EZ_L;
                                        break;
                                case 7: *intype = LORA_L;
                                        break;
                                case 8: *intype = TG_L;
                                        break;
                                case 9: *intype = BT_L;
                                        break;
                                case 10: *intype = DB_L;
                                         break;
                                case 11: *intype = FD_L;
                                         break;
                                case 12: *intype = IM_L;
                                         break;
                                case 13: *intype = POP_L;
                                         break;
                                case 14: *intype = SX_L;
                                         break;
                                case 15: *intype = BW_L;
                                         break;
                                case 16: *intype = JC_L;
                                         break;
                                case 17: *intype = MD_L;
                                         break;
                                case 18: *intype = XENIA_L;
                                         break;
                                case 19: *intype = MCMAIL_L;
                                         break;
                                case 20: *intype = OLMS_L;
                                         break;
                                default: *intype = RA_L;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_archivestype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 4;
    cvar.width = 25;
    cvar.left = 25;
    cvar.top = 10;
    cvar.position = 1;

    strcpy(optionsstr, "Normal;Julian - Rename;Julian - Compress;Size;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_sorttype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(150);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 6;
    cvar.width = 21;
    cvar.left = 29;
    cvar.top = 10;
    cvar.position = 1;

    strcpy(optionsstr, "A-Z;Z-A;");
    strcat(optionsstr, "A-Z, new first;A-Z, old first;Z-A, new first;Z-A, old first;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_cdformat(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(300);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 5;
    cvar.width = 41;
    cvar.left = 24;
    cvar.top = 8;
    cvar.position = 1;

    strcpy(optionsstr, "<filename> <description>;<filename> <size> <description>;");
    strcat(optionsstr, "<filename> <date> <description>;");
    strcat(optionsstr, "<filename> <size> <date> <description>;<filename> <date> <size> <description>;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: switch(cvar.position - 1)
                        {
                            case 0: *intype = CD_3;
                                    break;
                            case 1: *intype = CD_2;
                                    break;
                            case 2: *intype = CD_5;
                                    break;
                            case 3: *intype = CD_1;
                                    break;
                            case 4: *intype = CD_4;
                                    break;
                            default: *intype = CD_1;
                                     break;
                        }
                        break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(optionsstr);
    free(tmpbuf);
}

void Menus::get_archivesweekday(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 8;
    cvar.width = 25;
    cvar.left = 25;
    cvar.top = 8;
    cvar.position = 1;

    strcpy(optionsstr, "Sunday;Monday;Tuesday;Wednesday;Thursday;Friday;Saturday;Everyday;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(optionsstr);
    free(tmpbuf);
}

void Menus::get_weekday(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 7;
    cvar.width = 25;
    cvar.left = 45;
    cvar.top = 8;
    cvar.position = 1;

    set_help(NO_HELP);
    strcpy(optionsstr, "Sunday;Monday;Tuesday;Wednesday;Thursday;Friday;Saturday;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: *intype = cvar.position - 1;
                        break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(optionsstr);
    free(tmpbuf);
}

void Menus::get_datetype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(85);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 6;
    cvar.width = 10;
    cvar.left = 34;
    cvar.top = 8;
    cvar.position = 1;
    strcpy(optionsstr, "MM-DD-YY;MM-YY-DD;DD-MM-YY;DD-YY-MM;YY-MM-DD;YY-DD-MM;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = 0;
                                        break;
                                case 1: *intype = 1;
                                        break;
                                case 2: *intype = 2;
                                        break;
                                case 3: *intype = 3;
                                        break;
                                case 4: *intype = 4;
                                        break;
                                case 5: *intype = 5;
                                        break;
                                default: *intype = 0;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

/* Get the logging level */
void Menus::get_loglevel(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(85);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 3;
    cvar.width = 12;
    cvar.left = 34;
    cvar.top = 10;
    cvar.position = 1;
    strcpy(optionsstr, "Minimal;Normal;Extensive;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = LOG_MINIMAL;
                                        break;
                                case 1: *intype = LOG_NORMAL;
                                        break;
                                case 2: *intype = LOG_EXTENSIVE;
                                        break;
                                default: *intype = LOG_NORMAL;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

/* See how to handle old configurations */
void Menus::get_oldconfig(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(85);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 3;
    cvar.width = 20;
    cvar.left = 30;
    cvar.top = 10;
    cvar.position = 1;
    strcpy(optionsstr, "Abort;Use old data;Import new data;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = CFG_ABORT;
                                        break;
                                case 1: *intype = CFG_IGNORE;
                                        break;
                                case 2: *intype = CFG_IMPORT;
                                        break;
                                default: *intype = CFG_ABORT;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

/* Get the file storage type for this area */
void Menus::get_listtype(short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(125);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 7;
    cvar.width = 20;
    cvar.left = 34;
    cvar.top = 8;
    cvar.position = 1;
    strcpy(optionsstr, "RemoteAccess FDB;Concord FDB;LoraBBS FDB;Ezycom FDB;Telegard 3.02 FDB;Telegard 3.09 FDB;FILES.BBS;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = RA_FDB;
                                        break;
                                case 1: *intype = CONCORD_FDB;
                                        break;
                                case 2: *intype = LORA_FDB;
                                        break;
                                case 3: *intype = EZY_FDB;
                                        break;
                                case 4: *intype = TG_FDB;
                                        break;
                                case 5: *intype = TG310_FDB;
                                        break;
                                case 6: *intype = FILESBBS;
                                        break;
                                default: *intype = RA_FDB;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

/* Get Lora user levels */
void Menus::get_userlevel(unsigned short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(145);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 12;
    cvar.width = 18;
    cvar.left = 30;
    cvar.top = 6;
    cvar.position = 1;
    strcpy(optionsstr, "Twit;Disgrace;Limited;Normal;Worthy;Priviledged;Favored;");
    strcat(optionsstr, "Extra;Clerk;Assistant Sysop;Sysop;Hidden;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = L_TWIT;
                                        break;
                                case 1: *intype = L_DISGRACE;
                                        break;
                                case 2: *intype = L_LIMITED;
                                        break;
                                case 3: *intype = L_NORMAL;
                                        break;
                                case 4: *intype = L_WORTHY;
                                        break;
                                case 5: *intype = L_PRIVIL;
                                        break;
                                case 6: *intype = L_FAVORED;
                                        break;
                                case 7: *intype = L_EXTRA;
                                        break;
                                case 8: *intype = L_CLERK;
                                        break;
                                case 9: *intype = L_ASSTSYSOP;
                                        break;
                                case 10: *intype = L_SYSOP;
                                         break;
                                case 11: *intype = L_HIDDEN;
                                         break;
                                default: *intype = L_TWIT;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}

void Menus::get_maximus3_userlevel(int *max3index, char *max3str, int num_levels)
{
    int i;
    char *tmpbuf;
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = num_levels;
    cvar.width = 18;
    cvar.left = 30;
    cvar.top = 6;
    cvar.position = 1;
    cvar.title = NULL;
    cvar.options = max3str;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
    } while(i != ESC && i != ENTER);
    *max3index = cvar.position;
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

void Menus::get_maximus2_userlevel(unsigned short *intype)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *)malloc(145);
    cvar.uses_blanks = FALSE;
    cvar.high_num = 0;
    cvar.items = 12;
    cvar.width = 18;
    cvar.left = 30;
    cvar.top = 6;
    cvar.position = 1;
    strcpy(optionsstr, "Twit;Disgrace;Limited;Normal;Worthy;Priviledged;Favored;");
    strcat(optionsstr, "Extra;Clerk;Assistant Sysop;Sysop;Hidden;");
    cvar.title = NULL;
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
                case ENTER: switch(cvar.position-1)
                            {
                                case 0: *intype = M_TWIT;
                                        break;
                                case 1: *intype = M_DISGRACE;
                                        break;
                                case 2: *intype = M_LIMITED;
                                        break;
                                case 3: *intype = M_NORMAL;
                                        break;
                                case 4: *intype = M_WORTHY;
                                        break;
                                case 5: *intype = M_PRIVIL;
                                        break;
                                case 6: *intype = M_FAVORED;
                                        break;
                                case 7: *intype = M_EXTRA;
                                        break;
                                case 8: *intype = M_CLERK;
                                        break;
                                case 9: *intype = M_ASSTSYSOP;
                                        break;
                                case 10: *intype = M_SYSOP;
                                         break;
                                case 11: *intype = M_HIDDEN;
                                         break;
                                default: *intype = M_TWIT;
                                         break;
                            }
                            break;
        }
    } while(i != ESC && i != ENTER);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    free(optionsstr);
}


/* Get the 'Enforce' type */
void Menus::get_enforcetype(void)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.items = 8;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.width = 15;
    cvar.left = 30;
    cvar.top = 9;
    cvar.title = NULL;
    strcpy(optionsstr, "Uploads;Downloads;Posts;Calls;Ul:Dl (Files);Ul:Dl (KB);Post:Call;Subscription;");
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    help("Type of enforcement");
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: switch(cvar.position-1)
                        {
                            case 0: Config_obj.enforcevar.type = ULS;
                                    break;
                            case 1: Config_obj.enforcevar.type = DLS;
                                    break;
                            case 2: Config_obj.enforcevar.type = POSTS;
                                    break;
                            case 3: Config_obj.enforcevar.type = CALLS;
                                    break;
                            case 4: Config_obj.enforcevar.type= ULDL;
                                    break;
                            case 5: Config_obj.enforcevar.type = ULDLKB;
                                    break;
                            case 6: Config_obj.enforcevar.type = POSTCALL;
                                    break;
                            case 7: Config_obj.enforcevar.type = SUBSCRIPTION;
                                    break;
                            default: Config_obj.enforcevar.type = ULS;
                                     break;
                        }
                        break;
        }
    }while(i != ESC  &&  i != ENTER);
    free(optionsstr);
}


/* Get the 'Messages' type */
void Menus::get_messagestype(void)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.items = 6;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.width = 15;
    cvar.left = 30;
    cvar.top = 11;
    cvar.title = NULL;
    strcpy(optionsstr, "Newuser;Uploads;Carrier;Birthday;Sub. Exp.;Credit;");
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    help("Type of messages");
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: Config_obj.usermsgsvar.type = cvar.position - 1;
        }
    }while(i != ESC  &&  i != ENTER);
    free(optionsstr);
}

/* Get the 'Maintenance' type */
void Menus::get_mainttype(void)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(100);
    cvar.uses_blanks = FALSE;
    cvar.items = 4;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.width = 15;
    cvar.left = 30;
    cvar.top = 11;
    cvar.title = NULL;
    strcpy(optionsstr, "Daily;Weekly;Monthly;Interval;");
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    help("Type of maintenance");
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: Config_obj.maintvar.type = cvar.position - 1;
        }
    }while(i != ESC  &&  i != ENTER);
    free(optionsstr);
}

/* Get a Yes or No for the global changes */
int Menus::get_yesno(void)
{
    int i, type;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(20);
    cvar.uses_blanks = FALSE;
    cvar.items = 2;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.width = 5;
    cvar.left = 36;
    cvar.top = 11;
    cvar.title = NULL;
    strcpy(optionsstr, "On;Off;");
    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    help("Turn option On or Off");
    do
    {
        i = display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: switch(cvar.position - 1)
                        {
                            case 0: type = TRUE;
                                    break;
                            case 1: type = FALSE;
                                    break;
                        }
        }
    }while(i != ESC  &&  i != ENTER);
    free(optionsstr);
    return(type);
}

/* Get the 'Bulletin' type */
void Menus::get_bulletintype(void)
{
    int i;
    char *tmpbuf, *optionsstr;
    struct coordinates cvar;

    optionsstr = (char *) malloc(500);
    cvar.uses_blanks = FALSE;
    cvar.items = 19;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.width = 50;
    cvar.left = 14;
    cvar.top = 8;
    cvar.title = NULL;
    strcpy(optionsstr, "Top Uploaders (Files);Top Uploaders (KB);Top Downloaders (Files);");
    strcat(optionsstr, "Top Downloaders (KB);Top Ul:Dl Ratio (Files);Top Ul:Dl Ratio (KB);");
    strcat(optionsstr, "Top Message Posters;Top Callers;Top Post:Call Ratio;");
    strcat(optionsstr, "Most Downloaded Files;File Area Overview;Message Base Overview;");
    strcat(optionsstr, "Most Popular Doors;Daily Downloads;Daily Uploads;");
    strcat(optionsstr, "User List;Today's Calls;Today's Birthdays;Today's Sub Exp;");

    cvar.options = optionsstr;

    set_help(NO_HELP);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    help("Bulletin type");
    do
    {
        i = display_menu(&cvar, 2);
        switch(i)
        {
            case ENTER: switch(cvar.position)
                        {
                            case 1: Config_obj.bulletinvar.type = BULL_TOPUL;
                                    break;
                            case 2: Config_obj.bulletinvar.type = BULL_TOPULK;
                                    break;
                            case 3: Config_obj.bulletinvar.type = BULL_TOPDL;
                                    break;
                            case 4: Config_obj.bulletinvar.type = BULL_TOPDLK;
                                    break;
                            case 5: Config_obj.bulletinvar.type = BULL_ULDL;
                                    break;
                            case 6: Config_obj.bulletinvar.type = BULL_ULDLK;
                                    break;
                            case 7: Config_obj.bulletinvar.type = BULL_TOPPOST;
                                    break;
                            case 8: Config_obj.bulletinvar.type = BULL_TOPCALL;
                                    break;
                            case 9: Config_obj.bulletinvar.type = BULL_POSTCALL;
                                    break;
                            case 10: Config_obj.bulletinvar.type = BULL_TOPFILE;
                                     break;
                            case 11: Config_obj.bulletinvar.type = BULL_FILEOVR;
                                     break;
                            case 12: Config_obj.bulletinvar.type = BULL_MSGOVR;
                                     break;
                            case 13: Config_obj.bulletinvar.type = BULL_DOORS;
                                     break;
                            case 14: Config_obj.bulletinvar.type = BULL_DAILYDL;
                                     break;
                            case 15: Config_obj.bulletinvar.type = BULL_DAILYUL;
                                     break;
                            case 16: Config_obj.bulletinvar.type = BULL_USERLIST;
                                     break;
                            case 17: Config_obj.bulletinvar.type = BULL_TODAYCALL;
                                     break;
                            case 18: Config_obj.bulletinvar.type = BULL_BIRTHDAY;
                                     break;
                            case 19: Config_obj.bulletinvar.type = BULL_SUBEXP;
                                     break;
                        }
                        break;
        }
    }while(i != ESC  &&  i != ENTER);
    free(optionsstr);
}

/********************************************************************/
/* Bring up the online help */
void Menus::online_help(int topic)
{
    int width;
    long *offset1, *offset2;
    FILE *idxfile, *docfile;
    struct amuidx indexvar;
    char fn[MAX_FILESPEC], str[101], *tmpbuf;
    listbox *doclistbox, listboxitem;

    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, IDXNAME);
    idxfile = fopen(fn, "rb");
    if(!idxfile)
    {
        return;
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, DOCNAME);
    docfile = fopen(fn, "rt");
    if(!docfile)
    {
        fclose(idxfile);
        return;
    }
    fread(&indexvar, sizeof(indexvar), 1, idxfile);
    fclose(idxfile);

    switch(topic)
    {
        case SYSTEM_DATA: offset1 = &indexvar.s22;
                          break;
        case FILE_MANAGER: offset1 = &indexvar.s23;
                          break;
        case USERMSG_MANAGER: offset1 = &indexvar.s24;
                          break;
        case BULLETIN_MANAGER: offset1 = &indexvar.s25;
                          break;
        case FILELIST_MANAGER: offset1 = &indexvar.s26;
                          break;
        case EXTERNAL_UTILITY: offset1 = &indexvar.s27;
                          break;
        case ARCHIVES: offset1 = &indexvar.s28;
                          break;
        case MAINTENANCE: offset1 = &indexvar.s29;
                          break;
        case EDIT_FILES: offset1 = &indexvar.s210;
                          break;
        case _SYSTEM: offset1 = &indexvar.s221;
                      break;
        case _PATHNAMES: offset1 = &indexvar.s222;
                         break;
        case _FILENAMES: offset1 = &indexvar.s223;
                         break;
        case _LOGFILES: offset1 = &indexvar.s224;
                        break;
        case _GLOBAL: offset1 = &indexvar.s231;
                      break;
        case _AREA_MANAGER: offset1 = &indexvar.s232;
                            break;
        case _MARK: offset1 = &indexvar.s233;
                    break;
        case _UNMARK: offset1 = &indexvar.s234;
                      break;
        case _ENFORCE: offset1 = &indexvar.s241;
                       break;
        case _USERS: offset1 = &indexvar.s242;
                     break;
        case NO_ONLINE_HELP: break;
        default: fclose(docfile);
                 return;
    }
    offset2 = offset1;
    offset2++;

    doclistbox = OnlineBox_obj.create_listbox();
    listboxitem.itemnum = 0;

    if(topic == NO_ONLINE_HELP)
    {
        listboxitem.itemnum++;
        strcpy(listboxitem.itemname, "No help available for this topic");
        OnlineBox_obj.additem(&listboxitem, &doclistbox);
        width = 45;
    }
    else
    {
        width = 71;
        fseek(docfile, *offset1, SEEK_SET);
        while(fgets(str, sizeof(str)-2, docfile) && ftell(docfile) < *offset2)
        {
            if(!strstr(str, "Page ") && !strchr(str, ''))
            {
                Amustr_obj.strip_n(str);
                str[72] = NULL;
                strcpy(listboxitem.itemname, str);
                listboxitem.itemnum++;
                OnlineBox_obj.additem(&listboxitem, &doclistbox);
            }
            else
            {
                fgets(str, sizeof(str)-2, docfile);
            }
        }
    }
    listboxitem.itemnum++;
    strcpy(listboxitem.itemname, "");
    OnlineBox_obj.additem(&listboxitem, &doclistbox);
    listboxitem.itemnum++;
    strcpy(listboxitem.itemname, "                            [END OF SECTION]");
    OnlineBox_obj.additem(&listboxitem, &doclistbox);

    fclose(docfile);
    tmpbuf = (char *)malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    OnlineBox_obj.display_listbox(doclistbox, "AMU On-Line Help", width);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    OnlineBox_obj.destroy_listbox(&doclistbox);
}

/********************************************************************/
/* EOF - MENUS.CPP */
