/* Functions for the Maintenance menu */
/* Created 28 January 1996            */
/* Last updated 17 April 1996         */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include <conio.h>
#include "menus.h"
#include "mantmenu.h"
#include "config.h"
#include "utility2.h"
#include "crc.h"
#include "amuidx.h"

/* external objects */
extern Utility2 Utility2_obj;
extern Config Config_obj;
extern Crc Crc_obj;

/**************************************************************************/
int MaintMenu::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 8;
    cvar.width = 60;
    cvar.left = 10;
    cvar.top = 9;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(MAINT_RECORD);
    do
    {
	Menu_obj.set_help(MAINT_HELP);
	Menu_obj.help("Maintenance configuration; F3 Copy");
	if(index > Config_obj.num_maint)
	{
	    index = 1;
	}
	if(index < 1)
	{
	    index = Config_obj.num_maint;
        }
	Config_obj.read_record(MAINT_RECORD, index);
        sprintf(str, "Maintenance - Record %d/%d", index, Config_obj.num_maint);
        if(Config_obj.maintvar.deleted)
        {
            strcat(str, " [Deleted]");
        }
        cvar.title = str;
        cvar.options = options();
	i = Menu_obj.dialog(&cvar, ENTER, 1);
        switch(i)
	{
            case LEFT: index--;
                       break;
            case RIGHT: index++;
                        break;
            case ENTER: cvar.position = 2;
                        break;
            case HOME: index = 1;
                       break;
            case END: index = Config_obj.num_maint;
		      break;
            case DEL: Utility2_obj.toggle(&Config_obj.maintvar.deleted);
		      Config_obj.update_record(MAINT_RECORD, index);
                      break;
            case INS: setmem(&Config_obj.maintvar, MAINT_SIZE, NULL);
		      Config_obj.add_record(MAINT_RECORD, ADD_NEW_RECORD);
		      index = Config_obj.num_maint;
		      break;
	    case F1   : Menu_obj.online_help(MAINTENANCE);
			break;
	    case F3: Config_obj.maintvar.last_date = 0;
		     Config_obj.add_record(MAINT_RECORD, COPY_CUR_RECORD);		     index = Config_obj.num_maint;
		     break;
	    case ESC: Config_obj.close_config(MAINT_RECORD);
		      return(i);
	}
        if(i == ENTER)
        {
            crc = Crc_obj.struct_crc((char *) &Config_obj.maintvar, sizeof(Config_obj.maintvar));
            strcpy(str, "Maintenance configuration");
            cvar.title = str;
	    do
	    {
		Menu_obj.set_help(MAINT_HELP);
		cvar.options = options();
		i = Menu_obj.display_menu(&cvar, 1);
		switch(i)
                {
		    case ENTER: action(cvar.position);
				break;
		    case F1   : Menu_obj.online_help(MAINTENANCE);
				break;
		}
	    }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.maintvar, MAINT_SIZE)  &&  Menu_obj.prompt(0))
	    {
		Config_obj.update_record(MAINT_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(MAINT_RECORD);
    return(i);
}

char *MaintMenu::options(void)
{
    char tmpstr[11];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Type            : ");
    switch(Config_obj.maintvar.type)
    {
        case MAINT_DAILY   : strcat(optionsstr, "Daily;");
                             break;
        case MAINT_WEEKLY  : strcat(optionsstr, "Weekly;");
                             break;
        case MAINT_MONTHLY : strcat(optionsstr, "Monthly;");
                             break;
        case MAINT_INTERVAL: strcat(optionsstr, "Interval;");
                             break;
    }

    strcat(optionsstr, "Interval (days) : ");
    if(Config_obj.maintvar.type == MAINT_INTERVAL)
    {
        sprintf(tmpstr, "%d;", Config_obj.maintvar.days);
        strcat(optionsstr, tmpstr);
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Day of week     : ");
    if(Config_obj.maintvar.type == MAINT_WEEKLY)
    {
        switch(Config_obj.maintvar.weekly_day)
        {
            case 0: strcat(optionsstr, "Sunday;");
                    break;
            case 1: strcat(optionsstr, "Monday;");
                    break;
            case 2: strcat(optionsstr, "Tuesday;");
                    break;
            case 3: strcat(optionsstr, "Wednesday;");
                    break;
            case 4: strcat(optionsstr, "Thursday;");
                    break;
            case 5: strcat(optionsstr, "Friday;");
                    break;
            case 6: strcat(optionsstr, "Saturday;");
                    break;
            default: Config_obj.maintvar.weekly_day = 0;
                     strcat(optionsstr, "Sunday;");
                     break;
        }
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Day of month    : ");
    if(Config_obj.maintvar.type == MAINT_MONTHLY)
    {
        sprintf(tmpstr, "%d;", Config_obj.maintvar.monthly_day);
        strcat(optionsstr, tmpstr);
    }
    else
    {
        strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Maint. filename : ");
    strcat(optionsstr, Config_obj.maintvar.fname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Enabled         : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.maintvar.enabled));

    strcat(optionsstr, "   ;");
    return(optionsstr);
}

void MaintMenu::action(int position)
{
    char *tmpbuf, tmpstr[11];
    int offset;
    class Menus Menus_obj;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
        case 2: Menus_obj.get_mainttype();
                break;
        case 3: if(Config_obj.maintvar.type == MAINT_INTERVAL)
                {
                    Menus_obj.set_validtype(RANGE_3);
                    sprintf(tmpstr, "%d", Config_obj.maintvar.days);
                    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
                           cvar.top + position, 5));
                    Config_obj.maintvar.days = atoi(tmpstr);
                }
                break;
        case 4: if(Config_obj.maintvar.type == MAINT_WEEKLY)
                {
                    Menus_obj.get_weekday(&Config_obj.maintvar.weekly_day);
                }
                break;
        case 5: if(Config_obj.maintvar.type == MAINT_MONTHLY)
                {
                    Menus_obj.set_validtype(RANGE_3);
                    sprintf(tmpstr, "%d", Config_obj.maintvar.monthly_day);
                    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
                           cvar.top + position, 5));
                    Config_obj.maintvar.monthly_day = atoi(tmpstr);
                }
                break;
        case 6: Menus_obj.set_validtype(FILENM);
                strcpy(Config_obj.maintvar.fname, Menus_obj.getfield(Config_obj.maintvar.fname,
                       cvar.left + offset, cvar.top + position, 40));
                break;
	case 7: Utility2_obj.toggle(&Config_obj.maintvar.enabled);
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/************************************************************************/
/* EOF - MANTMENU.CPP */
