#include <stdio.h>
#include <io.h>
#include <string.h>
#include <conio.h>
#include <dir.h>
#include <share.h>
#include "install.h"

void makeexe(char *exename, char *txtname);

void main(int argc, char *argv[])
{
	textbackground(BLACK);
	textcolor(YELLOW);
	cprintf("Automated Maintenance Utility - Installation file creator\n\r");
	textcolor(CYAN);
	cprintf("Copyright (C) 1994 David Hickey. All rights reserved\r\n\r\n");
	textcolor(LIGHTGRAY);
	if(argc < 3)
	{
	    printf("Usage: MAKEEXE <exename> <txtname>\n");
	    return;
	}

	/* 0 contains the exe name, 1 contains the txt name */
	makeexe(argv[1], argv[2]);
}

void makeexe(char *exename, char *txtname)
{
    FILE *exefile, *txtfile, *infile;
    char str[81];
    char drive[MAXDRIVE], dir[MAXDIR], fname[MAXFILE], ext[MAXEXT];
    short index;
    long progress;

    txtfile = fopen(txtname, "rt");
    if(!txtfile)
    {
	printf("Unable to open %s\n", txtname);
	return;
    }

    exefile = _fsopen(exename, "r+b", SH_DENYWR);
    if(!exefile)
    {
        fclose(txtfile);
        printf("Unable to open %s\n", exename);
        return;
    }

    fseek(exefile, 0, SEEK_END);
    index = 0;
    fgets(str, sizeof(str)-2, txtfile);
    while(!feof(txtfile)  && index < MAX_FILES)
    {
	str[strlen(str)-1] = NULL;
	fnsplit(strupr(str), drive, dir, fname, ext);
	infile = _fsopen(str, "rb", SH_DENYWR);
	if(infile)
	{
	    printf("Adding %s\n", str);
	    datavar[index].filesize = filelength(fileno(infile));
	    datavar[index].exefilesize = filelength(fileno(exefile));
	    sprintf(datavar[index].filename, "%s%s", fname, ext);
	    progress = _read(fileno(infile), buffer, sizeof(buffer));
            while(progress > 0)
            {
                _write(fileno(exefile), buffer, progress);
		progress = _read(fileno(infile), buffer, sizeof(buffer));
	    }
	    fclose(infile);
	    index++;
	}
	else
	{
	    printf("Unable to open %s\n", str);
	}
	fgets(str, sizeof(str)-2, txtfile);
    }
    fclose(txtfile);
    fwrite(&datavar[0], sizeof(struct data_rec) * MAX_FILES, 1, exefile);
    fclose(exefile);
}

