// Functions to perform external maintenance, Y2K
// Created 29 March 1996
// Revised 21 May 1998

#include <stdio.h>
#include <dos.h>
#include <direct.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <share.h>
#include <conio.h>
#include <ctype.h>
#include "maint.h"
#include "config.h"
#include "screen.h"

/* External objects */
extern class Config Config_obj;
extern class Screen Screen_obj;

/**************************************************************************/

// Constructor for this class
Maint::Maint(void)
{
}

// Destructor for this class
Maint::~Maint(void)
{
}

void Maint::maintenance(int argc, char *argv[])
{
    FILE *maintfile;
    char path[MAX_FILESPEC], prog[MAX_FILESPEC], params[151], str[301], *ptr;
    char *ptr2, tmpparam[41];
    short index, x;
    struct screeninfo s;

    strcpy(s.curoption, "Processing 'Maintenance' records");
    Config_obj.open_config(MAINT_RECORD);
    for(index = 1; index <= Config_obj.num_maint; index++)
    {
	if(!Config_obj.read_record(MAINT_RECORD, index))
	{
	    sprintf(LOGSTR, "! [MAINT] Unable to read record #%d", index);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	    continue;
	}

	if(!Config_obj.maintvar.enabled)
	{
	    continue;
	}

	switch(Config_obj.maintvar.type)
	{
	    case MAINT_DAILY   : strcpy(tmpparam, "DAILY_MAINT");
				 break;
	    case MAINT_WEEKLY  : strcpy(tmpparam, "WEEKLY_MAINT");
				 break;
	    case MAINT_MONTHLY : strcpy(tmpparam, "MONTHLY_MAINT");
				 break;
	    case MAINT_INTERVAL: strcpy(tmpparam, "INTERVAL_MAINT");
				 break;
	    default: tmpparam[0] = NULL;
		     break;
	}
	if(argc > 1 && !Utility_obj.check_param(argc, argv, tmpparam, 0))
	{
	    continue;
	}

	switch(Config_obj.maintvar.type)
	{
	    case MAINT_WEEKLY: if(Config_obj.maintvar.weekly_day != Today.getDayOfWeek() - 1)
			       {
				   continue;
			       }
			       break;
	    case MAINT_MONTHLY: if(Config_obj.maintvar.monthly_day != Today.getDay())
				{
				    continue;
				}
				break;
	    case MAINT_INTERVAL: x = Today.getDaysSince(1970) - Config_obj.maintvar.last_date;
				 if(x < Config_obj.maintvar.days)
				 {
				     continue;
				 }
				 else
				 {
				     Config_obj.maintvar.last_date = Today.getDaysSince(1970);
				     Config_obj.update_record(MAINT_RECORD, index);
				 }
				 break;
	}

	sprintf(s.curarea, "Processing record #%d", index, Config_obj.maintvar.fname);
	Screen_obj.display(&s);
	sprintf(LOGSTR, "[MAINT] Processing record #%d - '%s'", index, Config_obj.maintvar.fname);
	Utility_obj.logentry(LOGSTR, LOG_NORMAL);
	maintfile = _fsopen(Config_obj.maintvar.fname, "rt", SH_DENYWR);
	if(!maintfile)
	{
	    sprintf(LOGSTR, "! [MAINT] Unable to open '%s'", Config_obj.maintvar.fname);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	}
	else
	{
	    while(fgets(str, sizeof(str)-2, maintfile))
	    {
		Amustr_obj.strip_n(str);
		Amustr_obj.trimend(str);
		Amustr_obj.trimlead(str);
		if(str[0] && str[0] != ';')
		{
		    ptr = str;
		    ptr2 = path;
		    while(*ptr && *ptr != ' ' && *ptr != '\t')
		    {
			*ptr2 = *ptr;
			ptr++;
			ptr2++;
		    }
		    *ptr2 = NULL;
		    Amustr_obj.trimlead(ptr);

		    ptr2 = prog;
		    while(*ptr && *ptr != ' ' && *ptr != '\t')
		    {
			*ptr2 = *ptr;
			ptr++;
			ptr2++;
		    }
		    *ptr2 = NULL;
		    Amustr_obj.trimlead(ptr);
		    strcpy(params, ptr);

		    sprintf(str, "%s\\%s", path, prog);
		    sprintf(LOGSTR, "[MAINT] Executing '%s %s'", str, params);
		    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
		    Utility_obj.change_dir(path);
		    Execute_obj.general_exec(str, params);
		}
	    }
	    fclose(maintfile);
	    Utility_obj.change_dir(Config_obj.amu_cfgvar.AMUpath);
	}
    }
    Config_obj.close_config(MAINT_RECORD);
}

/************************************************************************/
/* EOF MAINT.CPP */
