/* Functions for the Main menu   */
/* Created 16 November 1995      */
/* Last updated 23 July 1996     */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include "extern.h"
#include "utility.h"
#include "utility2.h"
#include "mainmenu.h"
#include "config.h"
#include "menus.h"
#include "crc.h"
#include "extern.h"
#include "sysmenu.h"
#include "fileman.h"
#include "usermenu.h"
#include "execute.h"
#include "bullmenu.h"
#include "listmenu.h"
#include "mantmenu.h"
#include "listbox.h"
#include "arcmenu.h"
#include "extmenu.h"
#include "editmenu.h"
#include "amuidx.h"

class SysMenu SysMenu_obj;
class FileMan FileMan_obj;
class UserMenu UserMenu_obj;
class BullMenu BullMenu_obj;
class ListMenu ListMenu_obj;
class MaintMenu MaintMenu_obj;
class ArcMenu ArcMenu_obj;
class ExtMenu ExtMenu_obj;
class EditMenu EditMenu_obj;

/* external variables */
extern listbox *filelistbox, *msglistbox;

extern char curdir[256];
extern class Crc Crc_obj;
extern class ListBox ListBox_obj;
extern class Utility2 Utility2_obj;
extern class Execute Execute_obj;
extern class Utility Utility_obj;
extern class Config Config_obj;
extern class Menus Menus_obj;
extern void startup(void);
extern int read_msgarray(int begin);
extern int read_filearray(int begin);

/***********************************************************************/

void MainMenu::menu(void)
{
    int i;
    struct coordinates cvar;

    cvar.uses_blanks = TRUE;
    cvar.items = 13;
    cvar.width = 24;
    cvar.left = 27;
    cvar.top = 7;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = "Main";
    cvar.options = options();
    Utility2_obj.put_screen();
    do
    {
	Menus_obj.set_help(MAIN_HELP);
	i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
	    case ENTER: action(cvar.position);
                        break;
	    case F1   : Menus_obj.online_help(cvar.position + NO_ONLINE_HELP - 1);
                        break;
	}
    }while(i != ESC);
    action(cvar.items - 1);
}

char *MainMenu::options(void)
{
    strcpy(optionsstr, " ;System Data;File Manager;User/Msg Manager;Bulletin Manager;");
    strcat(optionsstr, "File List Manager;External Utilities;");
    strcat(optionsstr, "Archives;Maintenance;Edit Files;Shell;Exit; ;");
    return(optionsstr);
}

void MainMenu::action(int position)
{
    static char *tmpbuf;
    unsigned long crc;
    int answer, save_type;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);

    save_type = SAVE_EXTERNAL;
    switch(position)
    {
	case 2: SysMenu_obj.menu();
		break;
	case 3: FileMan_obj.menu();
		break;
	case 4: UserMenu_obj.menu();
		break;
	case 5: BullMenu_obj.menu();
		break;
	case 6: ListMenu_obj.menu();
		break;
	case 7: ExtMenu_obj.menu();
		break;
	case 8: ArcMenu_obj.menu();
		break;
	case 9: MaintMenu_obj.menu();
		break;
	case 10: EditMenu_obj.menu();
		 break;
	case 11: _setcursortype(_NORMALCURSOR);
		 clrscr();
		 Execute_obj.general_exec(Config_obj.get_comspec(), "");
		 Utility_obj.change_dir(curdir);
		 _setcursortype(_NOCURSOR);
		 break;
	case 12: crc = Crc_obj.struct_crc((char *)&Config_obj.amu_hdrvar, HDR_SIZE)
		       + Crc_obj.struct_crc((char *)&Config_obj.amu_cfgvar, CFG_SIZE);
                 if(crc != Config_obj.crc)
                 {
                     answer = Menus_obj.prompt(SAVE_PROMPT);
		     switch(answer)
                     {
                         case TRUE : save_type = SAVE_ALL;
                         case FALSE: free(tmpbuf);
                                     Config_obj.save_cfg(save_type);
                                     Config_obj.close_config(CFG_RECORD);
				     if(filelistbox)
				     {
					 ListBox_obj.destroy_listbox(&filelistbox);
				     }
				     if(msglistbox)
				     {
					 ListBox_obj.destroy_listbox(&msglistbox);
				     }

				     clrscr();
                                     _setcursortype(_NORMALCURSOR);
                                     exit(NO_ERRORS);
                                     break;
                         case ESC  : startup();
                                     break;
                     }
                 }
                 else
                 {
                     free(tmpbuf);
                     Config_obj.save_cfg(save_type);
		     Config_obj.close_config(CFG_RECORD);
		     if(filelistbox)
		     {
			 ListBox_obj.destroy_listbox(&filelistbox);
		     }
		     if(msglistbox)
		     {
			 ListBox_obj.destroy_listbox(&msglistbox);
		     }
		     clrscr();
                     _setcursortype(_NORMALCURSOR);
                     exit(NO_ERRORS);
                 }
                 break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/************************************************************************/
/* EOF - MAINMENU.CPP */
