// Header file for the Macro class
// Created 17 November 1996
// Revised 21 May 1998

#if !defined(__MACROS_H__)
#define __MACROS_H__

#include "extern.h"
#include "dates.h"
#include "utility.h"
#include "amustr.h"
#include "config.h"

#define MACRO_NOT_FOUND "[UNDEFINED]"

struct AllfilesMacros
{
    char filename[MAX_FILENAME],
	 date[9];
    double dls,
	   size;
};

struct BullMacros
{
    /* Following are data members which may have their values used in
       macro expansions */
    int Rank;                    // Item's rank
    long AreaNum,                // File/Message area number
	 LowestBpsRate,          // Lowest BPS rate
	 HighestBpsRate,         // Highest BPS rate
	 BpsRate;                // BPS Connect rate
    char UserName[41],           // User's name
	 UserAlias[41],          // User's alias
	 FileName[MAX_FILENAME], // Filename
	 DoorName[81],           // Description of the door
	 AreaName[81],           // Name of the file area
	 Location[41],           // User's city/state
	 UsageGraph[41];         // Relative Usage Graph
    class Dates Birthdate,       // Birthdate
		Subdate;         // Subscription expiration
    double FileSize,             // Size of the file
	   FileSizek,            // Size of the file (kbs)
	   FileDls,              // Number of downloads
	   TotalFiles,           // Total number of files
	   TotalSize,            // Total size of the files listed
	   TotalSizek,           // Total size of the files listed (kbs)
	   TotalFileDls,         // Total number of downloads
	   AverageFileDls,       // Average number of downloads
	   AreaFiles,            // Total number of files
	   AreaSize,             // Total size of the files listed
	   AreaSizek,            // Total size of the files listed (kbs)
	   AreaFileDls,          // Total number of downloads
	   AreaPosts,            // Number of posts for this area
	   AreaReads,            // Number of reads for this area
	   AreaMsgs,             // Number of messages in this area
	   TotalMsgPosts,        // Total posts
	   TotalMsgReads,        // Total reads
	   TotalMsgs,            // Total messages
	   DoorAccess,           // Door accesses
	   TotalDoorAccess,      // Total door accesses
	   AverageDoorAccess,    // Average door accesses
	   UserUls,              // User uploads (files)
	   UserUlsk,             // User uploads (kb)
	   UserDls,              // User downloads (files)
	   UserDlsk,             // User downloads (kb)
	   UserPosts,            // User posts
	   UserCalls,            // User calls
	   UserUlDlRatio,        // User UL:DL ratio (files)
	   UserUlDlRatiok,       // User UL:DL ratio (kb)
	   UserPostCallRatio,    // User Post:Call ratio
	   TotalUls,             // Total user uploads (files)
	   TotalUlsk,            // Total user uploads (kb)
	   TotalDls,             // Total downloads (files)
	   TotalDlsk,            // Total downloads (kb)
	   TotalPosts,           // Total posts
	   TotalCalls,           // Total calls
	   TotalUlDlRatio,       // Total UL:DL ratio (files)
	   TotalUlDlRatiok,      // Total UL:DL ratio (kb)
	   TotalPostCallRatio,   // Total Post:Call ratio
	   AverageUls,           // User uploads (files)
	   AverageUlsk,          // User uploads (kb)
	   AverageDls,           // User downloads (files)
	   AverageDlsk,          // User downloads (kb)
	   AveragePosts,         // User posts
	   AverageCalls,         // User calls
	   AverageUlDlRatio,     // User UL:DL ratio (files)
	   AverageUlDlRatiok,    // User UL:DL ratio (kb)
	   AveragePostCallRatio, // User Post:Call ratio
	   NumXfer;              // Number of files uploaded/downloaded today
};

/* Base class to process macros from text files */
class Macros
{
    public:
    void get_expansion(char *s, char *e); // Returns an expansion of 's' in 'e'

    protected:
    class Utility Utility_obj;
    class Amustr Amustr_obj;
    class Dates Date_Now;
    int Desc_Offset;
    virtual void match_macro(char *macro, char *Expansion); // Function 'get_expansion()' calls
					    // to match macros valid for this
					    // derivation of the Macros class
};

/* Descendant of Macros class, used to process lines from AMU.HDR */
class AMU_Headers : public Macros
{
    public:
    AMU_Headers(void);
    AMU_Headers(struct filearea *f, struct fbaseinfo *i);

    private:
    struct fbaseinfo infovar;
    struct filearea fileareavar;               // File area information

    protected:
    virtual void match_macro(char *macro, char *Expansion);
};


/* Descendant of Macros class, used to process lines from bulletin
   template files */
#define MAX_FORMATS    4
#define ASCII          0
#define ANSI           1
#define AVATAR         2
#define HTML           3
#define PROCESS_HEADER 0
#define PROCESS_TEXT   1
#define PROCESS_FOOTER 2
#define HEADER_START   "<HEADER_BEGIN>"
#define HEADER_END     "<HEADER_END>"
#define TEXT_START     "<TEXT_BEGIN>"
#define TEXT_END       "<TEXT_END>"
#define FOOTER_START   "<FOOTER_BEGIN>"
#define FOOTER_END     "<FOOTER_END>"

class AMU_Bulletins : AMU_Headers
{
    public:
    AMU_Bulletins(void);
    void set_bulletin(struct bulletin *b);
    void create_bulletins(void);
    void close_bulletins(void);
    void process_template(int mode);
    void clear_macro_record(void);

    protected:
    virtual void match_macro(char *macro, char *Expansion);

    private:
    char *ansiback(char x);
    char *ansifore(char x);
    char *avtcode(char *x);

    private:
    FILE *bull_fp[MAX_FORMATS],
	 *tplfile;
    int color_code;
    struct fbaseinfo infovar;
    struct filearea fileareavar;               // File area information
    struct bulletin bulletinvar;

    public:
    struct BullMacros macrosvar;
};

/* Descendant of Macros class, used to process lines to post messages */
class AMU_Msgs : public Macros
{
    public:
    AMU_Msgs(void);
    void set_userrecord(struct user_array *userptr);

    private:
    struct user_array uservar;

    protected:
    virtual void match_macro(char *macro, char *Expansion);
};


/* Descendant of Macros class, used to process lines for Allfiles */
class AMU_Allfiles : public Macros
{
    public:
    AMU_Allfiles(void);
    void set_values(struct filearray *currec);

    private:
    struct AllfilesMacros macrosvar;
    struct filearray filerec;
    void create_desc(char *Expansion, int add_dl);

    protected:
    virtual void match_macro(char *macro, char *Expansion);
};

#endif
// EOF - MACROS.H
