// Code to handle the parsing of macros - Y2K
// Created 17 November 1996
// Revised 06 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include <share.h>
#include "macros.h"
#include "fileopts.h"
#include "config.h"

#if defined(__AMU32__) || defined(__AMU95__)

#define BLACK        0
#define BLUE         1
#define GREEN        2
#define CYAN         3
#define RED          4
#define MAGENTA      5
#define BROWN        6
#define LIGHTGRAY    7
#define DARKGRAY     8
#define LIGHTBLUE    9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15
#define BLINK        128
#endif

extern class Config Config_obj;

/************************************************************************/
/* Process the raw header line 's' and put the result in 'e'            */
/* A macro is of the form: @macro@ and is followed by one of three      */
/* characters to denote how it should be handled and how many spaces    */
/* it occupies. | = center, < = Left justify, > = Right justify         */
/* i.g.:  @SYSOP<<<<<<<@ means left justify the sysop name to 12 spaces */
void Macros::get_expansion(char *s, char *e)
{
    char *Sptr, *Eptr, *Mptr, macro[101], *new_macro, *savedptr,
	 *ptr, *tmpstr;
    int macro_len;

    tmpstr = new_macro = NULL;

    /* If s or e are NULL, get out of here */
    if(!s || !e)
    {
	return;
    }

    Eptr = e;
    *Eptr = NULL;

    /* If there is no '@' in the string, there are no macros so we can just
       copy it into the 'e' as is and get out of here
    */
    if(!strchr(s, '@'))
    {
	strcpy(e, s);
	return;
    }

    new_macro = (char *)calloc(1, 5000);
    tmpstr = (char *)calloc(1, 5000);
    if(!tmpstr || !new_macro)
    {
	strcpy(e, s);
	if(new_macro)
	{
	    free(new_macro);
	}
	if(tmpstr)
	{
	    free(tmpstr);
	}
	return;
    }

    Sptr = s;
    while(*Sptr)
    {
	/* If this is not the beginning of a macro, copy to Eptr */
	if(*Sptr != '@')
	{
	    *Eptr = *Sptr;
	    Eptr++;
	    Sptr++;
	    *Eptr = NULL;
	}
	else
	{
	    /* Extract the macro */
	    savedptr = Sptr;
	    Mptr = macro;
	    Sptr++;
	    while(*Sptr &&  *Sptr != '@' && *Sptr != ' ')
	    {
		*Mptr = *Sptr;
		Sptr++;
		Mptr++;
	    }
	    *Mptr = NULL;

	  /* If it broke out of the loop because it encountered a valid
	     'end of macro' delimiting '@', process the macro.  Otherwise,
	     go back to 'savedptr' and continue on */
	    if(*Sptr == '@')
	    {
		Sptr++;
//		endptr = Sptr;
		macro_len = strlen(macro);

		/* Make a copy of the macro into new_macro and get rid of
		   the formatting information so the object just gets the
		   actual macro to expand */
		strcpy(new_macro, macro);
		strupr(new_macro);
		ptr = strchr(new_macro, '|');
		if(ptr)
		{
		    *ptr = NULL;
		}
		ptr = strchr(new_macro, '<');
		if(ptr)
		{
		    *ptr = NULL;
		}
		ptr = strchr(new_macro, '>');
		if(ptr)
		{
		    *ptr = NULL;
		}
		match_macro(new_macro, tmpstr);
		strcpy(new_macro, tmpstr);

		/* Now decide how to center or justify the macro */
		if(macro[macro_len-1] == '|')
		{
		    Amustr_obj.center_str(new_macro, macro_len+2);
		    new_macro[macro_len] = NULL;
		}
		if(macro[macro_len-1] == '<')
		{
		    Amustr_obj.pad(new_macro, macro_len);
		    new_macro[macro_len] = NULL;
		}
		if(macro[macro_len-1] == '>')
		{
		    Amustr_obj.lpad(new_macro, macro_len);
		    new_macro[macro_len] = NULL;
		}

	    /*
		while(savedptr < endptr)
		{
		    *savedptr = ' ';
		    savedptr++;
		}
	     */
/*
		if(macro_padded)
		{
		    strcat(Eptr, " ");
		    strcat(Eptr, new_macro);
		    strcat(Eptr, " ");
		    Eptr += strlen(new_macro) + 2;
		}
		else
		{

*/		    strcat(Eptr, new_macro);
		    Eptr += strlen(new_macro);
//		}
		*Eptr = NULL;
//		Desc_Offset = strlen(e) + 1;
	    }
	    else
	    {
		Sptr = savedptr;
		*Eptr = *Sptr;
		Eptr++;
		Sptr++;
	    }
	    *Eptr = NULL;
	}
	Desc_Offset = strlen(e);
    }
    free(new_macro);
    free(tmpstr);
}

/* Return a string which replaces the macro indicated by 'macro' */
void Macros::match_macro(char *macro, char *Expansion)
{
    strcpy(Expansion, MACRO_NOT_FOUND);
    if(strcmp(macro, "SYSOP") == 0)
    {
	strcpy(Expansion, Config_obj.amu_cfgvar.sysop);
	return;
    }
    if(strcmp(macro, "ALIAS") == 0)
    {
	strcpy(Expansion, Config_obj.amu_cfgvar.sysopalias);
    }
    if(strcmp(macro, "BBSNAME") == 0)
    {
	strcpy(Expansion, Config_obj.amu_cfgvar.bbsname);
	return;
    }
    if(strcmp(macro, "PRODUCT_ID") == 0)
    {
	sprintf(Expansion, "AMU %s", VERSION);
	return;
    }
    if(strcmp(macro, "DATE") == 0)
    {
	strcpy(Expansion, Date_Now.getDateStr(Config_obj.amu_cfgvar.date_format));
	return;
    }
    if(strcmp(macro, "TIME") == 0)
    {
	strcpy(Expansion, Date_Now.getTimeStr(DATES_HHMMSS24));
	return;
    }
    if(strcmp(macro, "DAYNUM") == 0)
    {
	sprintf(Expansion, "%d", Date_Now.getDay());
	return;
    }
    if(strcmp(macro, "DAYNAME") == 0)
    {
	strcpy(Expansion, Date_Now.getDayOfWeekStr());
	return;
    }
    if(strcmp(macro, "MONTHNUM") == 0)
    {
	sprintf(Expansion, "%d", Date_Now.getMonth());
	return;
    }
    if(strcmp(macro, "MONTHNAME") == 0)
    {
	sprintf(Expansion, "%d", Date_Now.getMonthStr());
	return;
    }
    if(strcmp(macro, "YEAR") == 0)
    {
	sprintf(Expansion, "%d", Date_Now.getYear());
	return;
    }
    return;
}


/************************************************************************/
/* Following are methods for the AMU_Headers class, derived from Macros */
/************************************************************************/

/* Default constructor for the AMU_Headers class */
AMU_Headers::AMU_Headers(void)
{
}

/* Constructor for the AMU_Headers class */
AMU_Headers::AMU_Headers(struct filearea *f, struct fbaseinfo *i)
{
    if(f)
    {
	memcpy(&fileareavar, f, sizeof(struct filearea));
    }
    if(i)
    {
	memcpy(&infovar, i, sizeof(struct fbaseinfo));
    }
}

/* Return a string which replaces the macro indicated by 'macro' */
void AMU_Headers::match_macro(char *macro, char *Expansion)
{
    Macros::match_macro(macro, Expansion);
    if(strcmp(Expansion, MACRO_NOT_FOUND) != 0)
    {
	return;
    }

    if(strcmp(macro, "AREANAME") == 0)
    {
	strcpy(Expansion, fileareavar.areaname);
	return;
    }
    if(strcmp(macro, "AREANUM") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.area));
	return;
    }
    if(strcmp(macro, "TOTALFILES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.totalfiles));
	return;
    }
    if(strcmp(macro, "TOTALBYTESK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.totalbytes / 1024.0));
	return;
    }
    if(strcmp(macro, "TOTALBYTES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.totalbytes));
	return;
    }
    if(strcmp(macro, "TOTALDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.totaldls));
	return;
    }
    if(strcmp(macro, "FILES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.areafiles));
	return;
    }
    if(strcmp(macro, "BYTESK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.areabytes / 1024.0));
	return;
    }
    if(strcmp(macro, "BYTES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.areabytes));
	return;
    }
    if(strcmp(macro, "DLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.areadls));
	return;
    }
    if(strcmp(macro, "TOPFILE") == 0)
    {
	strcpy(Expansion, infovar.topfile);
	return;
    }
    if(strcmp(macro, "TOPDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.topfile_dls));
	return;
    }
    if(strcmp(macro, "TOPSIZE") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.topfile_size));
	return;
    }
    if(strcmp(macro, "TOPSIZEK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value(infovar.topfile_size / 1024.0));
	return;
    }
    return;
}

/**************************************************************************/
/* Following are methods for the AMU_Bulletins class, derived from Macros */
/**************************************************************************/

/* Constructor for the AMU_Bulletins class */
AMU_Bulletins::AMU_Bulletins(void)
{
    color_code = ASCII;
}

/* Sets the bulletin record to 'b' */
void AMU_Bulletins::set_bulletin(struct bulletin *b)
{
    color_code = ASCII;
    if(b)
    {
	memcpy(&bulletinvar, b, sizeof(struct bulletin));
    }
}

/* Return a string which replaces the macro indicated by 'macro' */
void AMU_Bulletins::match_macro(char *macro, char *Expansion)
{
    strcpy(Expansion, MACRO_NOT_FOUND);

    /* See if it's a CLS code */
    if(stricmp(macro, "CLS") == 0)
    {
	switch(color_code)
	{
	    case ANSI  : strcpy(Expansion, ansifore(-1));
			 break;
	    case AVATAR: sprintf(Expansion, "%c", 12);
			 break;
	    default    : Expansion[0] = NULL;
			 break;
	}
	return;
    }

    /* if the macro is only two characters long, it's a color code */
    if(strlen(macro) == 2)
    {
	switch(color_code)
	{
	    case ANSI   : strcpy(Expansion, ansifore(macro[1]));
			  strcat(Expansion, ansiback(macro[0]));
			  break;
	    case AVATAR : strcpy(Expansion, avtcode(macro));
			  break;
	    default     : strcpy(Expansion, "");
			  break;
	}
	return;
    }

    if(strcmp(macro, "USER_BDATE") == 0)
    {
	strcpy(Expansion, macrosvar.Birthdate.getDateStr(DATES_MMDDYYYY));
	return;
    }
    if(strcmp(macro, "USER_SUBDATE") == 0)
    {
	strcpy(Expansion, macrosvar.Subdate.getDateStr(DATES_MMDDYYYY));
	return;
    }
    if(strcmp(macro, "USER_CITY") == 0)
    {
	strcpy(Expansion, macrosvar.Location);
	return;
    }
    if(strcmp(macro, "RANK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.Rank));
	return;
    }
    if(strcmp(macro, "AREANUM") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaNum));
	return;
    }
    if(strcmp(macro, "BPS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.BpsRate));
	return;
    }
    if(strcmp(macro, "LOWBPS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.LowestBpsRate));
	return;
    }
    if(strcmp(macro, "HIGHBPS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.HighestBpsRate));
	return;
    }
    if(strcmp(macro, "USERNAME") == 0)
    {
	strcpy(Expansion, macrosvar.UserName);
	return;
    }
    if(strcmp(macro, "USERALIAS") == 0)
    {
	strcpy(Expansion, macrosvar.UserAlias);
	return;
    }
    if(strcmp(macro, "FILENAME") == 0)
    {
	strcpy(Expansion, macrosvar.FileName);
	return;
    }
    if(strcmp(macro, "DOORNAME") == 0)
    {
	strcpy(Expansion, macrosvar.DoorName);
	return;
    }
    if(strcmp(macro, "AREANAME") == 0)
    {
	strcpy(Expansion, macrosvar.AreaName);
	return;
    }
    if(strcmp(macro, "GRAPH") == 0)
    {
	strcpy(Expansion, macrosvar.UsageGraph);
	return;
    }
    if(strcmp(macro, "FILESIZE") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.FileSize));
	return;
    }
    if(strcmp(macro, "FILESIZEK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.FileSizek));
	return;
    }
    if(strcmp(macro, "FDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.FileDls));
	return;
    }
    if(strcmp(macro, "TOTALFILES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalFiles));
	return;
    }
    if(strcmp(macro, "TOTALFSIZE") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalSize));
	return;
    }
    if(strcmp(macro, "TOTALFSIZEK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalSizek));
	return;
    }
    if(strcmp(macro, "TOTALFDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalFileDls));
	return;
    }
    if(strcmp(macro, "AVGFDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageFileDls));
	return;
    }
    if(strcmp(macro, "AREAFILES") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaFiles));
	return;
    }
    if(strcmp(macro, "AREASIZE") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaSize));
	return;
    }
    if(strcmp(macro, "AREASIZEK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaSizek));
	return;
    }
    if(strcmp(macro, "AREADLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaFileDls));
	return;
    }
    if(strcmp(macro, "POSTS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaPosts));
	return;
    }
    if(strcmp(macro, "READS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaReads));
	return;
    }
    if(strcmp(macro, "MSGS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AreaMsgs));
	return;
    }
    if(strcmp(macro, "TOTALPOSTS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalMsgPosts));
	return;
    }
    if(strcmp(macro, "TOTALREADS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalMsgReads));
	return;
    }
    if(strcmp(macro, "TOTALMSGS") == 0 && bulletinvar.type == BULL_MSGOVR)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalMsgs));
	return;
    }
    if(strcmp(macro, "ACCESS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.DoorAccess));
	return;
    }
    if(strcmp(macro, "TOTALACCESS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalDoorAccess));
	return;
    }
    if(strcmp(macro, "AVGACCESS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageDoorAccess));
	return;
    }
    if(strcmp(macro, "ULS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserUls));
	return;
    }
    if(strcmp(macro, "ULSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserUlsk));
	return;
    }
    if(strcmp(macro, "DLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserDls));
	return;
    }
    if(strcmp(macro, "DLSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserDlsk));
	return;
    }
    if(strcmp(macro, "POSTS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserPosts));
	return;
    }
    if(strcmp(macro, "CALLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.UserCalls));
	return;
    }
    if(strcmp(macro, "ULDL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.UserUlDlRatio);
	return;
    }
    if(strcmp(macro, "ULDLK") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.UserUlDlRatiok);
	return;
    }
    if(strcmp(macro, "POSTCALL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.UserPostCallRatio);
	return;
    }
    if(strcmp(macro, "TOTALULS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalUls));
	return;
    }
    if(strcmp(macro, "TOTALULSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalUlsk));
	return;
    }
    if(strcmp(macro, "TOTALDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalDls));
	return;
    }
    if(strcmp(macro, "TOTALDLSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalDlsk));
	return;
    }
    if(strcmp(macro, "TOTALPOSTS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalPosts));
	return;
    }
    if(strcmp(macro, "TOTALCALLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.TotalCalls));
	return;
    }
    if(strcmp(macro, "TOTALULDL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.TotalUlDlRatio);
	return;
    }
    if(strcmp(macro, "TOTALULDLK") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.TotalUlDlRatiok);
	return;
    }
    if(strcmp(macro, "TOTALPOSTCALL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.TotalPostCallRatio);
	return;
    }
    if(strcmp(macro, "AVGULS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageUls));
	return;
    }
    if(strcmp(macro, "AVGULSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageUlsk));
	return;
    }
    if(strcmp(macro, "AVGDLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageDls));
	return;
    }
    if(strcmp(macro, "AVGDLSK") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageDlsk));
	return;
    }
    if(strcmp(macro, "AVGPOSTS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AveragePosts));
	return;
    }
    if(strcmp(macro, "AVGCALLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.AverageCalls));
	return;
    }
    if(strcmp(macro, "AVGULDL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.AverageUlDlRatio);
	return;
    }
    if(strcmp(macro, "AVGULDLK") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.AverageUlDlRatiok);
	return;
    }
    if(strcmp(macro, "AVGPOSTCALL") == 0)
    {
	sprintf(Expansion, "%.05f", (float) macrosvar.AveragePostCallRatio);
	return;
    }
    if(strcmp(macro, "NUMXFER") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) macrosvar.NumXfer));
	return;
    }


    /* If the macro has been found, get out of here */
    if(strcmp(Expansion, MACRO_NOT_FOUND) != 0)
    {
	return;
    }

   /* Else check for base class macros */
    Macros::match_macro(macro, Expansion);
    if(strcmp(Expansion, MACRO_NOT_FOUND) != 0)
    {
	return;
    }

   /* Else check for ones from the Headers descendant */
    AMU_Headers::match_macro(macro, Expansion);
    if(strcmp(Expansion, MACRO_NOT_FOUND) != 0)
    {
	return;
    }
    return;
}

/* Take an ascii number x and return the ANSI color code */
char *AMU_Bulletins::ansiback(char x)
{
    static char st[11];
    int i;

    sprintf(st, "%c", x);
    sscanf(st, "%x", &i);

    /* Set up the ANSI init and cls codes */
    st[0] = NULL;
    switch(i)
    {
	case BLACK    : strcat(st, "40m");
			break;
	case BLUE     : strcat(st, "44m");
			break;
	case GREEN    : strcat(st, "42m");
			break;
	case CYAN     : strcat(st, "46m");
			break;
	case RED      : strcat(st, "41m");
			break;
	case MAGENTA  : strcat(st, "45m");
			break;
	case BROWN    : strcat(st, "43m");
			break;
	case LIGHTGRAY: strcat(st, "47m");
			break;
    }
    return(st);
}

/* Take an ascii number x and return the ANSI color code */
char *AMU_Bulletins::ansifore(char x)
{
    static char st[11];
    int i;

    sprintf(st, "%c", x);
    sscanf(st, "%x", &i);

    /* Set up the ANSI init and cls codes */
    sprintf(st, "%c[", 0x001B);
    if((int) x == 0xFF)
    {
	i = -1;
    }
    switch(i)
    {
	case -1          : /* See if the user wants the CLS code sent on ANSI bulletins */
			   strcat(st, "2J");  /* If -1, do clear screen */
			   break;
	case BLACK       : strcat(st, "30;");
			   break;
	case BLUE        : strcat(st, "34;");
			   break;
	case GREEN       : strcat(st, "32;");
			   break;
	case CYAN        : strcat(st, "36;");
			   break;
	case RED         : strcat(st, "31;");
			   break;
	case MAGENTA     : strcat(st, "35;");
			   break;
	case BROWN       : strcat(st, "33;");
			   break;
	case LIGHTGRAY   : strcat(st, "0;");
			   break;
	case DARKGRAY    : strcat(st, "1;30;");
			   break;
	case LIGHTBLUE   : strcat(st, "1;34;");
			   break;
	case LIGHTGREEN  : strcat(st, "1;32;");
			   break;
	case LIGHTCYAN   : strcat(st, "1;36;");
			   break;
	case LIGHTRED    : strcat(st, "1;31;");
			   break;
	case LIGHTMAGENTA: strcat(st, "1;35;");
			   break;
	case YELLOW      : strcat(st, "1;33;");
			   break;
	case WHITE       : strcat(st, "1;37;");
			   break;
    }
    return(st);
}

/* Take an ascii number x and return the AVATAR color code */
char *AMU_Bulletins::avtcode(char *x)
{
    static char st[11];
    int fore, back, color;

    sprintf(st, "%c", x[0]);
    sscanf(st, "%x", &back);
    sprintf(st, "%c", x[1]);
    sscanf(st, "%x", &fore);

    color = back;
    color *= 16;
    color |= fore;

    /* Set up the AVATAR init codes */
    sprintf(st, "%c%c%c", 22, 1, color);
    return(st);
}

/* Clear the structure used to store macro data */
void AMU_Bulletins::clear_macro_record(void)
{
    memset(&macrosvar, NULL, sizeof(macrosvar));
}


/* Method to create the actual bulletins */
void AMU_Bulletins::create_bulletins(void)
{
    char fn[MAX_FILESPEC];
    int x;

    /* Reset all of the bulletin file pointers to NULL */
    for(x = 0; x < MAX_FORMATS; x++)
    {
	bull_fp[x] = NULL;
    }

    if(bulletinvar.attrib.create_ascii)
    {
	sprintf(fn, "%s.ASC", bulletinvar.fname);
	bull_fp[ASCII] = _fsopen(fn, "w+t", SH_DENYRW);
    }
    if(bulletinvar.attrib.create_ansi)
    {
	sprintf(fn, "%s.ANS", bulletinvar.fname);
	bull_fp[ANSI] = _fsopen(fn, "w+t", SH_DENYRW);
    }
    if(bulletinvar.attrib.create_avatar)
    {
	sprintf(fn, "%s.AVT", bulletinvar.fname);
	bull_fp[AVATAR] = _fsopen(fn, "w+t", SH_DENYRW);
    }
    if(bulletinvar.attrib.create_html)
    {
	sprintf(fn, "%s.HTM", bulletinvar.fname);
	bull_fp[HTML] = _fsopen(fn, "w+t", SH_DENYRW);
    }
}

/* Close the bulletins, reset the pointers */
void AMU_Bulletins::close_bulletins(void)
{
    int x;

    for(x = 0; x < MAX_FORMATS; x++)
    {
	if(bull_fp[x] != NULL)
	{
	    fclose(bull_fp[x]);
	}
	bull_fp[x] = NULL;
    }
}

/* Process the portion of the template specified in 'mode' */
void AMU_Bulletins::process_template(int mode)
{
    char instr[251], Expansion[251], begin_str[20], end_str[20];
    int done, x;

    /* See which search strings we'll be looking for */
    switch(mode)
    {
	case PROCESS_HEADER: strcpy(begin_str, HEADER_START);
			     strcpy(end_str, HEADER_END);
			     break;
	case PROCESS_TEXT  : strcpy(begin_str, TEXT_START);
			     strcpy(end_str, TEXT_END);
			     break;
	case PROCESS_FOOTER: strcpy(begin_str, FOOTER_START);
			     strcpy(end_str, FOOTER_END);
			     break;
	default: strcpy(instr, "! [MACROS_OBJ] Invalid mode to process_template() method");
		 Utility_obj.logentry(instr, LOG_MINIMAL);
		 return;
    }

   /* Try to open the template file */
    tplfile = _fsopen(bulletinvar.templatefn, "rt", SH_DENYWR);
    if(tplfile == NULL)
    {
	sprintf(instr, "! [MACRO_OBJ] Unable to open '%s' - (%s)",
		bulletinvar.templatefn, strerror(errno));
	Utility_obj.logentry(instr, LOG_MINIMAL);
	return;
    }

    /* Read until we reach the beginning of the header */
    done = FALSE;
    while(!done && fgets(instr, sizeof(instr)-2, tplfile))
    {
	Amustr_obj.strip_n(instr);
	if(stricmp(instr, begin_str) == 0)
	{
	    done = TRUE;
	}
    }

    /* If done is TRUE, then we found the header marker and we can now
       process the header portion of the bulletin */
    if(done == TRUE)
    {
	while(fgets(instr, sizeof(instr)-2, tplfile))
	{
	    Amustr_obj.strip_n(instr);

	    /* If we found the end of the header, break out of here */
	    if(stricmp(instr, end_str) == 0)
	    {
		break;
	    }
	    else
	    {
		/* Get the expanded macro for each bulletin type except the HTML one */
		for(x = 0; x < MAX_FORMATS; x++)
		{
		  if(x != HTML)
		  {
		    color_code = x;
		    get_expansion(instr, Expansion);
		    if(bull_fp[x] != NULL)
		    {
			fprintf(bull_fp[x], "%s\n", Expansion);
		    }
		  }
		}
	    }
	}
    }
    fclose(tplfile);

//**************************************************************


   // Try to open the HTML template file

  if(bull_fp[HTML] != NULL)
  {
    tplfile = _fsopen(bulletinvar.html_template, "rt", SH_DENYWR);
    if(tplfile == NULL)
    {
	sprintf(instr, "! [MACRO_OBJ] Unable to open '%s' - (%s)",
		bulletinvar.html_template, strerror(errno));
	Utility_obj.logentry(instr, LOG_MINIMAL);
	return;
    }

    /* Read until we reach the beginning of the header */
    done = FALSE;
    while(!done && fgets(instr, sizeof(instr)-2, tplfile))
    {
	Amustr_obj.strip_n(instr);
	if(stricmp(instr, begin_str) == 0)
	{
	    done = TRUE;
	}
    }

    /* If done is TRUE, then we found the header marker and we can now
       process the header portion of the bulletin */
    if(done == TRUE)
    {
	while(fgets(instr, sizeof(instr)-2, tplfile))
	{
	    Amustr_obj.strip_n(instr);

	    /* If we found the end of the header, break out of here */
	    if(stricmp(instr, end_str) == 0)
	    {
		break;
	    }
	    else
	    {
		// Get the expanded macro
		color_code = HTML;
		get_expansion(instr, Expansion);
		fprintf(bull_fp[HTML], "%s\n", Expansion);
	    }
	}
    }
    fclose(tplfile);
  }
}

/************************************************************************/
/*         Macro descendant for messages posted to uses                 */
/************************************************************************/

AMU_Msgs::AMU_Msgs(void)
{
// Empty constructor
}

/* Copy 'userptr' into the internal user record variable */
void AMU_Msgs::set_userrecord(struct user_array *userptr)
{
    if(userptr != NULL)
    {
	memcpy(&uservar, userptr, sizeof(struct user_array));
    }
}


/* Return a string which replaces the macro indicated by 'macro' */
void AMU_Msgs::match_macro(char *macro, char *Expansion)
{
    char tmpstr[45], *tmpptr;

    Macros::match_macro(macro, Expansion);
    if(strcmp(Expansion, MACRO_NOT_FOUND) != 0)
    {
	return;
    }

    if(strcmp(macro, "USER_NAME") == 0)
    {
	strcpy(Expansion, uservar.name);
	return;
    }
    if(strcmp(macro, "USER_FIRST") == 0)
    {
	strcpy(tmpstr, uservar.name);
	tmpptr = strchr(tmpstr, ' ');
	if(tmpptr)
	{
	    *tmpptr = NULL;
	}
	strcpy(Expansion, tmpstr);
	return;
    }
    if(strcmp(macro, "USER_LAST") == 0)
    {
	strcpy(tmpstr, uservar.name);
	strrev(tmpstr);
	tmpptr = strchr(tmpstr, ' ');
	if(tmpptr)
	{
	    *tmpptr = NULL;
	}
	strrev(tmpstr);
	strcpy(Expansion, tmpstr);
	return;
    }
    if(strcmp(macro, "USER_ALIAS") == 0)
    {
	strcpy(Expansion, uservar.alias);
	return;
    }
    if(strcmp(macro, "USER_BDATE") == 0)
    {
	strcpy(Expansion, uservar.BirthDate.getDateStr(DATES_MMDDYYYY));
	return;
    }
    if(strcmp(macro, "USER_SUBDATE") == 0)
    {
	strcpy(Expansion, uservar.SubDate.getDateStr(DATES_MMDDYYYY));
	return;
    }
    if(strcmp(macro, "USER_CITY") == 0)
    {
	strcpy(Expansion, uservar.city);
	return;
    }
    if(strcmp(macro, "USER_DLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.dls));
	return;
    }
    if(strcmp(macro, "USER_ULS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.uls));
	return;
    }
    if(strcmp(macro, "USER_DLKB") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.dlkb));
	return;
    }
    if(strcmp(macro, "USER_ULKB") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.ulkb));
	return;
    }
    if(strcmp(macro, "USER_CALLS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.calls));
	return;
    }
    if(strcmp(macro, "USER_POSTS") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.posts));
	return;
    }
    if(strcmp(macro, "USER_SECURITY") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.security));
	return;
    }
    if(strcmp(macro, "USER_CREDIT") == 0)
    {
	strcpy(Expansion, Amustr_obj.format_value( (double) uservar.credit));
	return;
    }
    return;
}


/************************************************************************/
/*         Macro descendant for the allfiles/newfiles list              */
/************************************************************************/

AMU_Allfiles::AMU_Allfiles(void)
{
    memset(&filerec, NULL, sizeof(filerec));
    Desc_Offset = 0;
}

void AMU_Allfiles::set_values(struct filearray *currec)
{
    memcpy(&filerec, currec, sizeof(filerec));
    Desc_Offset = 0;
}


/* Return a string which replaces the macro indicated by 'macro' */
void AMU_Allfiles::match_macro(char *macro, char *Expansion)
{
    char str[11];
    int i, j;

    strcpy(Expansion, MACRO_NOT_FOUND);

    if(strcmp(macro, "FILENAME") == 0)
    {
	sprintf(Expansion, "%s", filerec.filename);
	return;
    }

    if(strcmp(macro, "DATE") == 0)
    {
	sprintf(Expansion, "%s", filerec.timedate.getDateStr(Config_obj.amu_cfgvar.date_format));
	return;
    }

    if(strcmp(macro, "DLS") == 0 && Config_obj.amu_cfgvar.counter_width)
    {
	sprintf(str, "%d", filerec.timesdl);
	if(strlen(str) < Config_obj.amu_cfgvar.counter_width)
	{
	    j = strlen(str);
	    strrev(str);
	    for(i = 0; i < (Config_obj.amu_cfgvar.counter_width - j); i++)
	    {
		strcat(str, "0");
	    }
	    strrev(str);
	}
	sprintf(Expansion, "%c%s%c", Config_obj.amu_cfgvar.left_bracket,
			     str, Config_obj.amu_cfgvar.right_bracket);
	return;
    }

    if(strcmp(macro, "SIZE") == 0)
    {
	sprintf(Expansion, "%s", Amustr_obj.format_value(filerec.size));
	return;
    }

    if(strcmp(macro, "SIZEK") == 0)
    {
	sprintf(Expansion, "%sk", Amustr_obj.format_value(filerec.size / 1024));
	return;
    }

    if(strcmp(macro, "DESC") == 0)
    {
	Expansion[0] = NULL;
	create_desc(Expansion, FALSE);
	return;
    }

    if(strcmp(macro, "DESCDL") == 0)
    {
	Expansion[0] = NULL;
	create_desc(Expansion, TRUE);
	return;
    }
    return;
}

/************************************************************************/
/* Concatenate a formated description to 'str' beginning at desc_offset + 1*/
void AMU_Allfiles::create_desc(char *Expansion, int add_dl)
{
   char tmpstr[81], *ptr, *ptr2;
   char dltime[101], dl2400[11], dl144[11], dl288[11], dl640[11];
   int x, y, max_width, dont_format, treat_as_lf;

   /* See if this contains high-ascii characters */
   dont_format = FALSE;

   /* See if there are any lines which have no spaces in them.  Y tracks
      the number of characters in each line, X counts non-space characters.
      At the end of a line, if x == y, the line had no spaces in it */
   ptr = filerec.description;
   x = y = 0;
   while(*ptr)
   {
       y++;
       if(!isspace(*ptr))
       {
           x++;
       }
       if(*ptr == '\r' || *ptr == '\n')
       {
	   x++;
	   if(y == x && y > 20)
	   {
               dont_format = TRUE;
               break;
	   }
           x = y = 0;
       }
       ptr++;
   }

   ptr = filerec.description;
   while(dont_format == FALSE && *ptr != NULL)
   {
       if(*ptr > 175 && *ptr < 224)
       {
	   dont_format = TRUE;
       }
       ptr++;
   }

   if(Desc_Offset > 70)
   {
       Desc_Offset = 40;
   }
   max_width = 79 - Desc_Offset;

   /* See if any single line exceeds 'max_width' characters.  If it does, then this
      needs to be wrapped.  If all are 'max_width' or less, assume it is a FILE_ID
      and do NOT wrap. x is a counter, y has the maximum length. */

   if(dont_format == FALSE)
   {
       ptr = filerec.description;

       x = y = 0;
       while(*ptr && dont_format == FALSE)
       {
	   if((*ptr == '\n' || *ptr == '\r'))
	   {
	       if(*ptr == '\n' && (*(ptr + 1) == '\n' || *(ptr + 1) == '\r'))
	       {
		   dont_format = TRUE;
	       }

	       if(x > y)
	       {
		   y = x;
	       }
	       x = 0;
	   }
	   else
	   {
	       x++;
	   }
	   ptr++;
       }
       if(y == 0)
       {
	   y = x;
       }
       if(y <= max_width)
       {
	   dont_format = TRUE;
       }
    }

   if(add_dl)
   {
       y = filerec.size * 8 / 2400;  // Number of bits in the file
       sprintf(dl2400, "%02d:%02d:%02d", y / 3600, y / 60, y % 60);
       y = filerec.size * 8 / 14400;  // Number of bits in the file
       sprintf(dl144, "%02d:%02d:%02d", y / 3600, y / 60, y % 60);
       y = filerec.size * 8 / 28800;  // Number of bits in the file
       sprintf(dl288, "%02d:%02d:%02d", y / 3600, y / 60, y % 60);
       y = filerec.size * 8 / 64000;  // Number of bits in the file
       sprintf(dl640, "%02d:%02d:%02d", y / 3600, y / 60, y % 60);

       sprintf(dltime, " --- D/L time:  @2400: %s    @14.4k: %s    @28.8k: %s    @64k: %s",
		       dl2400, dl144, dl288, dl640);
   }

   /* If it has high ascii, set 'max_width' so it won't wrap */
   if(dont_format)
   {
       max_width = 80;
   }

   ptr = filerec.description;

   /* Filter the /tb from Maximus files.bbs */
   if(strstr(filerec.description, "/tb") == ptr)
   {
       ptr += 3;
   }

   while(*ptr)
   {
       x = 0;
       ptr2 = tmpstr;
       while(*ptr && x < max_width)
       {
	   treat_as_lf = FALSE;

	   if(*ptr == '\r' && *(ptr + 1) != '\n')
	   {
	       treat_as_lf = TRUE;
	   }
	   else
	   {
	       if(*ptr == '\r')
	       {
		   ptr++;
	       }
	   }

	   if(*ptr == '\n' || treat_as_lf == TRUE)
	   {
	       *ptr2 = ' ';
	   }
	   else
	   {
	       *ptr2 = *ptr;
	   }

	   if((*ptr == '\n' || treat_as_lf == TRUE) && dont_format)
	   {
	       ptr++;
	       break;
	   }

	   x++;
	   ptr2++;
	   ptr++;
       }
       if(*ptr != NULL &&  *ptr != ' ' && !dont_format)
       {

       /* We're at the end and the last character is not a space, so we
	  need to back up until we find a space to wrap this at.  But if
	  there isn't a space within 20 characters, hyphenate it instead */

	   y = 0;
	   do
	   {
	       x--;
	       ptr--;
	       ptr2--;
	       y++;
	   }while(*ptr != ' ' && x > 1 && y < 20);

	   if( y == 20)
	   {
	       ptr += 20;
	       ptr2 += 20;
	       *ptr2 = '-';
	       ptr2++;
	   }
	   ptr2++;
       }
       *ptr2 = NULL;
       if(!dont_format)
       {
	   Amustr_obj.trimlead(tmpstr);
	   Amustr_obj.trimend(tmpstr);
       }
       strcat(tmpstr, "\n");
       strcat(Expansion, tmpstr);
       if(*ptr)
       {
	   memset(tmpstr, NULL, sizeof(tmpstr)-1);
	   memset(tmpstr, ' ', Desc_Offset);
	   strcat(Expansion, tmpstr);
       }

       /* If we're at the end and dl time needs to be added, reset 'ptr' */
       if(!*ptr && add_dl)
       {
	   add_dl = FALSE;
	   ptr = dltime;
	   memset(tmpstr, NULL, sizeof(tmpstr)-1);
	   memset(tmpstr, ' ', Desc_Offset);
	   strcat(Expansion, tmpstr);
       }
   }
}

// EOF - MACROS.CPP
