/* Functions for the Logfile menu */
/* Created 12 December 1995       */
/* Revised 12 May 1997            */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include <conio.h>
#include "menus.h"
#include "logsmenu.h"
#include "config.h"
#include "utility2.h"
#include "crc.h"
#include "amuidx.h"

/* external objects */
extern class Utility2 Utility2_obj;
extern class Config Config_obj;
extern class Crc Crc_obj;

/**************************************************************************/
int LogsMenu::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 5;
    cvar.width = 60;
    cvar.left = 10;
    cvar.top = 9;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(LOGFILE_RECORD);
    do
    {
	Menu_obj.help("Logfile configuration; F3 - Copy");
	if(index > Config_obj.num_logs)
	{
	    index = 1;
	}
	if(index < 1)
	{
	    index = Config_obj.num_logs;
	}
	Config_obj.read_record(LOGFILE_RECORD, index);
	sprintf(str, "Logfiles - Record %d/%d", index, Config_obj.num_logs);
	if(Config_obj.logsvar.deleted)
	{
	    strcat(str, " [Deleted]");
	}
	cvar.title = str;
	cvar.options = options();
	i = Menu_obj.dialog(&cvar, ENTER, 1);
	switch(i)
	{
	    case LEFT: index--;
		       break;
	    case RIGHT: index++;
			break;
	    case ENTER: cvar.position = 2;
			break;
	    case HOME: index = 1;
		       break;
	    case END: index = Config_obj.num_logs;
		      break;
	    case DEL: Utility2_obj.toggle(&Config_obj.logsvar.deleted);
		      Config_obj.update_record(LOGFILE_RECORD, index);
		      break;
	    case INS: Config_obj.add_record(LOGFILE_RECORD, ADD_NEW_RECORD);
		      index = Config_obj.num_logs;
		      break;
	    case F1:  Menu_obj.online_help(_LOGFILES);
	              break;
	    case F3:  Config_obj.add_record(LOGFILE_RECORD, COPY_CUR_RECORD);
		      index = Config_obj.num_logs;
		      break;
	    case ESC: Config_obj.close_config(LOGFILE_RECORD);
		      return(i);
	}
	if(i == ENTER)
	{
	    crc = Crc_obj.struct_crc((char *) &Config_obj.logsvar, sizeof(Config_obj.logsvar));
	    strcpy(str, "Logfiles configuration");
	    cvar.title = str;
	    Menu_obj.set_help(LOGFILE_HELP);
	    do
	    {
		cvar.options = options();
		i = Menu_obj.display_menu(&cvar, 1);
		switch(i)
		{
		    case ENTER: action(cvar.position);
				break;
		    case F1: Menu_obj.online_help(_LOGFILES);
			     break;
		}
	    }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.logsvar, sizeof(Config_obj.logsvar))  &&  Menu_obj.prompt(0))
	    {
		Config_obj.update_record(LOGFILE_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(LOGFILE_RECORD);
    return(i);
}

char *LogsMenu::options(void)
{
    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Filename        : ");
    strcat(optionsstr, Config_obj.logsvar.name);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Type of logfile : ");
    switch(Config_obj.logsvar.type)
    {
	case RA_L:      strcat(optionsstr, "RemoteAccess;");
			break;
	case EZ_L:      strcat(optionsstr, "EzyCom;");
			break;
	case QBBS_L:    strcat(optionsstr, "QuickBBS;");
			break;
	case SBBS_L:    strcat(optionsstr, "SuperBBS;");
			break;
	case PB_L:      strcat(optionsstr, "ProBoard;");
			break;
	case IM_L:      strcat(optionsstr, "InterMail;");
			break;
	case FD_L:      strcat(optionsstr, "FrontDoor;");
			break;
	case DB_L:      strcat(optionsstr, "D'Bridge;");
			break;
	case BT_L:      strcat(optionsstr, "BinkleyTerm;");
			break;
	case POP_L:     strcat(optionsstr, "Portal of Power;");
			break;
	case SX_L:      strcat(optionsstr, "Silver Xpress;");
			break;
	case BW_L:      strcat(optionsstr, "BlueWave;");
			break;
	case JC_L:      strcat(optionsstr, "JC-QWK;");
			break;
	case CONCORD_L: strcat(optionsstr, "Concord;");
			break;
	case TG_L     : strcat(optionsstr, "Telegard;");
			break;
	case MAX_L:     strcat(optionsstr, "Maximus;");
			break;
	case LORA_L:    strcat(optionsstr, "Lora;");
			break;
	case MD_L:      strcat(optionsstr, "MainDoor;");
			break;
	case XENIA_L:   strcat(optionsstr, "Xenia;");
			break;
	case MCMAIL_L:  strcat(optionsstr, "McMail;");
			break;
	case OLMS_L:    strcat(optionsstr, "O.L.M.S.;");
			break;
	default:        strcat(optionsstr, "RemoteAccess;");
			Config_obj.logsvar.type = RA_L;
			break;
    }
    strcat(optionsstr, "Enabled         : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.logsvar.enabled));

    strcat(optionsstr, "   ;");
    return(optionsstr);
}

void LogsMenu::action(int position)
{
    char *tmpbuf;
    int offset;
    class Menus Menus_obj;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
	case 2: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.logsvar.name, Menus_obj.getfield(Config_obj.logsvar.name, cvar.left + offset, cvar.top + 2, 40));
		break;
	case 3: Menus_obj.get_logtype(&Config_obj.logsvar.type);
		break;
	case 4: Utility2_obj.toggle(&Config_obj.logsvar.enabled);
		break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/*******************************************************************/
/* EOF - LOGSMENU.CPP */

