// Header file for the Logs class
// Created 08 October 1995
// Revised 09 January 1998

#if !defined(__LOGS_H__)

#define __LOGS_H__

#include "extern.h"
#include "utility.h"
#include "crc.h"
#include "amustr.h"

#define BBS_LOG    0
#define MAILER_LOG 1
#define QWK_LOG    2

#define OLD_LOG 0
#define NEW_LOG 1

#define NOTHING      0		/* Nothing of interest   */
#define LOST_CARRIER 1		/* User dropped carrier  */
#define UPLOAD       2		/* Upload entry		 */
#define DOWNLOAD     3		/* Download entry	 */
#define MSG_READING  4		/* User reading an area  */
#define MSG_WRITE    5		/* User posting a message*/
#define NEW_USER     6		/* New user logging in   */
#define USER_NAME    7		/* User name		 */
#define DOORS        8          /* Door entry            */
#define END_OF_ENTRY 100        /* End of user session   */

/* file that contains a list of strings that indicate a logoff was ok */
#define CARRIER_CTL "CARRIER.CTL"

#define DOORINFO    "DOORINFO.AMU"    /* Contains door data    */
/* structure is a text file with each door name on each line */

#define USERINFO   "USERINFO.AMU"    /* Contains user data    */
struct userdata
{
    char username[36];		/* User name		 */
    short newuser,		/* Is a new user	 */
	  uploads,		/* Uploaded a file(s)	 */
	  carrier;		/* Dropped carrier	 */
};

#define TODAYCALLINFO "CALLINFO.AMU"
struct calldata
{
    char username[36];
    unsigned short bps;
};

#define TRANSFER_BULL "XBULINFO.AMU" /* Transfers for bulletins         */
#define TRANSFER_UPD  "XUPDINFO.AMU" /* Transfers for updating counters */
struct transferdata
{
    char username[36],		/* User name blank = mailer */
	 fname[MAX_FILENAME];	/* Filename		    */
    short type,			/* UPLOAD or DOWNLOAD	    */
	  logtype;		/* Logfile type             */
    unsigned short bps;	        /* bps rate		    */
};

#define MSGBASE  "MSGBINFO.AMU"  /* Contains msgbase      */
struct msgbase
{
    short type;   		/* MSG_READING or MSG_WRITE */
    unsigned short areanum; 	/* Area number		    */
};

class Logs
{
    /* Private variables */
    private:
    class Crc Crc_obj;
    class Utility Utility_obj;
    class Amustr Amustr_obj;
    int check_newuser_now;
    FILE *logfile, *usersfile, *transferfile, *msgfile, *doorfile, *callfile,
	 *transferbullfile;
    long length,
	 cur_pos;
    int _eof;
    char LOGSTR[151],
	 rawlogstr[151],
	 prevlogstr[151],
	 filename[MAX_FILENAME],
	 username[51];
    long bpsrate,
	 areanum;
    struct userdata uservar;
    struct calldata calldatavar;
    struct transferdata xfervar;
    struct msgbase msgvar;

    /* Public functions */
    public:
    void analyze_logs(void);
    int get_logtype(void);

    /* Private functions */
    private:
    int dropped_carrier(char *s);
    int set_position(long *last_crc, long *last_offset);
    int filename_ok(void);
    int username_ok(void);
    int open_log(void);
    int read_log(void);
    void close_log(void) { fclose(logfile); }
};
#endif

/************************************************************************/
/* EOF - LOGS.H */
