// Functions to analyze the system logs, Y2K
// Created 01 February 1996
// Revised 06 June 1998

#include <stdio.h>
#include <string.h>
#include <share.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <io.h>
#include "extern.h"
#include "config.h"
#include "screen.h"
#include "logs.h"

/* External objects */
extern class Screen Screen_obj;
extern class Config Config_obj;

/************************************************************************/
/* Calls all other functions to process the logfiles */
void Logs::analyze_logs(void)
{
    int x, type, logtype, num_valid_logs, reset;
    char fn[MAX_FILESPEC];
    struct screeninfo s;

    bpsrate = areanum = 0;
    strcpy(s.curoption, "Reading logfiles");

    num_valid_logs = 0;
    Config_obj.open_config(LOGFILE_RECORD);

    /* First run through the log records and see if any of them are
       new.  If any are new, reset the appropriate datafiles. */
    reset = FALSE;
    for(x = 1; x <= Config_obj.num_logs; x++)
    {
        Config_obj.read_record(LOGFILE_RECORD, x);
        if(Config_obj.logsvar.enabled && get_logtype() == BBS_LOG)
        {
            if(open_log())
            {
                if(set_position(&Config_obj.logsvar.crc, &Config_obj.logsvar.offset) == NEW_LOG)
                {
                    reset = TRUE;
                }
                close_log();
            }
        }
    }

   /* If one or more logfiles have been reset, the tracking data in some
      files needs to be reset as well */
    if(reset == TRUE)
    {
        sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRANSFER_BULL);
        remove(fn);
        sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TODAYCALLINFO);
        remove(fn);
    }


    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, DOORINFO);
    doorfile = _fsopen(fn, "r+t", SH_DENYWR);
    if(!doorfile)
    {
        doorfile = _fsopen(fn, "w+t", SH_DENYWR);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, MSGBASE);
    msgfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!msgfile)
    {
        msgfile = _fsopen(fn, "w+b", SH_DENYWR);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, USERINFO);
    usersfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!usersfile)
    {
        usersfile = _fsopen(fn, "w+b", SH_DENYWR);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRANSFER_UPD);
    transferfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!transferfile)
    {
        transferfile = _fsopen(fn, "w+b", SH_DENYWR);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRANSFER_BULL);
    transferbullfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!transferbullfile)
    {
        transferbullfile = _fsopen(fn, "w+b", SH_DENYWR);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TODAYCALLINFO);
    callfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!callfile)
    {
        callfile = _fsopen(fn, "w+b", SH_DENYWR);
    }

    /* Seek to the end of each file so it's ready to be appended to */
    if(doorfile != NULL)
    {
        fseek(doorfile, 0, SEEK_END);
    }
    if(usersfile != NULL)
    {
        fseek(usersfile, 0, SEEK_END);
    }
    if(msgfile != NULL)
    {
        fseek(msgfile, 0, SEEK_END);
    }
    if(transferfile != NULL)
    {
        fseek(transferfile, 0, SEEK_END);
    }
    if(transferbullfile != NULL)
    {
        fseek(transferbullfile, 0, SEEK_END);
    }
    if(callfile != NULL)
    {
        fseek(callfile, 0, SEEK_END);
    }


    for(x = 1; x <= Config_obj.num_logs; x++)
    {
        Config_obj.read_record(LOGFILE_RECORD, x);
        if(Config_obj.logsvar.enabled)
        {
            num_valid_logs++;
        }
        else
        {
            continue;
        }

        if(open_log())
        {
            strcpy(s.curarea, Config_obj.logsvar.name);
            Screen_obj.display(&s);
            set_position(&Config_obj.logsvar.crc, &Config_obj.logsvar.offset);
            Config_obj.update_record(LOGFILE_RECORD, x);
            logtype = get_logtype();
            switch(logtype)
            {
                case QWK_LOG: type = read_log();
                              while(!_eof)
                              {
                                  if(type == MSG_READING || MSG_WRITE)
                                  {
                                      msgvar.type = type;
                                      msgvar.areanum = areanum;
                                      fwrite(&msgvar, sizeof(msgvar), 1, msgfile);
                                  }
                                  type = read_log();
                              }
                              break;
                case MAILER_LOG: type = read_log();
                                 while(!_eof)
                                 {
                                     if(type == DOWNLOAD)
                                     {
                                         xfervar.username[0] = NULL;
                                         strcpy(xfervar.fname, filename);
                                         xfervar.type = DOWNLOAD;
                                         xfervar.logtype = MAILER_LOG;
                                         xfervar.bps = 0;
                                         fwrite(&xfervar, sizeof(xfervar), 1, transferfile);
                                     }
                                     type = read_log();
                                 }
                                 break;

                case BBS_LOG: type = read_log();
                              memset(&uservar, NULL, sizeof(uservar));
                              while(!_eof)
                              {
                                  if(type == USER_NAME && username_ok())
                                  {
                                      prevlogstr[0] = NULL;
                                      while(type != END_OF_ENTRY && !_eof)
                                      {
                                          switch(type)
                                          {
                                              case USER_NAME: Amustr_obj.trimlead(username);
                                                              Amustr_obj.trimend(username);
                                                              strcpy(uservar.username, username);
                                                              strcpy(calldatavar.username, username);
                                                              break;
                                              case UPLOAD: uservar.uploads = TRUE;
                                              case DOWNLOAD: strcpy(xfervar.username, username);
                                                             strcpy(xfervar.fname, filename);
                                                             xfervar.type = type;
                                                             xfervar.logtype = BBS_LOG;
                                                             xfervar.bps = bpsrate;
                                                             fwrite(&xfervar, sizeof(xfervar), 1, transferfile);
                                                             fwrite(&xfervar, sizeof(xfervar), 1, transferbullfile);
                                                             break;
                                              case MSG_WRITE:
                                              case MSG_READING: msgvar.type = type;
                                                                msgvar.areanum = areanum;
                                                                fwrite(&msgvar, sizeof(msgvar), 1, msgfile);
                                                                break;
                                              case LOST_CARRIER: if(dropped_carrier(prevlogstr))
                                                                 {
                                                                     uservar.carrier = TRUE;
                                                                 }
                                                                 break;
                                              case NEW_USER: uservar.newuser = TRUE;
                                                             check_newuser_now = FALSE;
                                                             break;
                                              case DOORS: fprintf(doorfile, "%s\n", rawlogstr);
                                                          break;
                                          }
                                          strcpy(prevlogstr, rawlogstr);
                                          type = read_log();
                                      }
                                      fwrite(&uservar, sizeof(uservar), 1, usersfile);
                                      memset(&uservar, NULL, sizeof(uservar));
                                      calldatavar.bps = bpsrate;
                                      fwrite(&calldatavar, sizeof(calldatavar), 1, callfile);
                                  }
                                  else
                                  {
                                      type = read_log();
                                      if(Config_obj.logsvar.type == EZ_L && type == USER_NAME)
                                      {
                                          if(strstr(rawlogstr, "NewUser:"))
                                          {
                                              check_newuser_now = TRUE;
                                              fseek(logfile, ftell(logfile) - strlen(rawlogstr), SEEK_SET);
                                          }
                                      }
                                  }
                              }
                              break;
            }
            close_log();
        }
        else
        {
            sprintf(LOGSTR, "? [READ_LOGS] Unable to open '%s' - (%s)", Config_obj.logsvar.name, strerror(errno));
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        }
    }
    Config_obj.close_config(LOGFILE_RECORD);

    if(num_valid_logs == 0)
    {
	sprintf(LOGSTR, "[WARNING] No logfiles enabled, some options may not run properly");
	Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	sprintf(LOGSTR, "[WARNING] Run AMUCFG to configure logs on System -> Logfiles menu");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
    }

/*
    rewind(doorfile);
    rewind(usersfile);
    rewind(msgfile);
    rewind(transferfile);

    printf("Dump of USERS.$$$\n\n");
    fread(&uservar, sizeof(uservar), 1, usersfile);
    while(!feof(usersfile))
    {
        printf("Name   : %s\n", uservar.username);
        printf("Upload : %d\n", uservar.uploads);
        printf("Newuser: %d\n", uservar.newuser);
        printf("Carrier: %d\n\n", uservar.carrier);
        fread(&uservar, sizeof(uservar), 1, usersfile);
    }
    printf("Press enter");
    x = getch();

    printf("Dump of TRANSFER.$$$\n\n");
    fread(&xfervar, sizeof(xfervar), 1, transferfile);
    while(!feof(transferfile))
    {
        printf("Name   : %s\n", xfervar.username);
        printf("Fname  : %s\n", xfervar.fname);
        printf("Type   : %d\n", xfervar.type);
        printf("BPS    : %d\n\n", xfervar.bps);
        fread(&xfervar, sizeof(xfervar), 1, transferfile);
    }
    printf("Press enter");
    x = getch();

    printf("Dump of MSGBASE.$$$\n\n");
    fread(&msgvar, sizeof(msgvar), 1, msgfile);
    while(!feof(msgfile))
    {
        printf("Type   : %d\n", msgvar.type);
        printf("Area   : %d\n\n", msgvar.areanum);
        fread(&msgvar, sizeof(msgvar), 1, msgfile);
    }

*/
    fclose(doorfile);
    fclose(transferfile);
    fclose(transferbullfile);
    fclose(usersfile);
    fclose(msgfile);
    fclose(callfile);
}

/**************************************************************************/
/* Open the specified logfile */
int Logs::open_log(void)
{
    int status;

    cur_pos = 0;
    check_newuser_now = FALSE;  // Set for EzyCom systems
    logfile = _fsopen(Config_obj.logsvar.name, "rt", SH_DENYNO);
    if(!logfile)
    {
        sprintf(LOGSTR, "? [LOGS] Unable to open '%s' - (%s)", Config_obj.logsvar.name, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        status = FALSE;
    }
    else
    {
        _eof = FALSE;
        length = filelength(fileno(logfile));
        status = TRUE;
    }
    return(status);
}

/* Read a line from the logfile and return what type of entry was found */
int Logs::read_log(void)
{
    char str[101], tmpstr[101], *ptr, *ptr2;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    long file_pos;
    int i, num;

    /* If EOF is set, return until open_log() clears it */
    if(_eof == TRUE)
    {
        return(NOTHING);
    }

    if(cur_pos >= length)
    {
        _eof = TRUE;
        return(NOTHING);
    }

    if(!fgets(str, sizeof(str)-2, logfile)  ||  feof(logfile))
    {
        _eof = TRUE;
        return(NOTHING);
    }
    cur_pos += strlen(str);
    Amustr_obj.strip_n(str);
    Amustr_obj.trimlead(str);
    Amustr_obj.trimend(str);

/*
----------  Sat 22 Apr 95, RA 2.02+ line #1
> 19:00:10  Logging Pat Mcgary back on-line
> 19:00:10  Security level 42, 103 minutes remaining
> 19:00:33  Exit to DOS at errorlevel 38

----------  Sat 22 Apr 95, RA 2.02+ line #1
> 19:01:12  Logging Pat Mcgary back on-line
> 19:01:12  Security level 42, 102 minutes remaining
> 19:01:14  User off-line
*/
    /* If this is RA, check to see if they are using a Type 15 */
    if(Config_obj.logsvar.type == RA_L  &&  strstr(str, "Exit to DOS at"))
    {
        strcpy(rawlogstr, str);
        fgets(str, sizeof(str)-2, logfile);
        cur_pos += strlen(str);
        Amustr_obj.strip_n(str);
        if(str[0] == NULL)
        {
            for(i = 0; i < 4; i++)
            {
                fgets(str, sizeof(str)-2, logfile);
                cur_pos += strlen(str);
            }
            Amustr_obj.strip_n(str);
        }
        return(DOORS);
    }


    /* If this is a blank line, or a line with a lot of dashes (PB), reset the record */
    if(str[0] == NULL  ||  (strstr(str, "------") && Config_obj.logsvar.type == PB_L) ||  strstr(str,  "******"))
    {
        return(END_OF_ENTRY);
    }

     /* Skip lines that have Local Uploads due to file attaches */
    if(strstr(str, "Following message has"))
    {
        fgets(str, sizeof(str)-2, logfile);
        while(!strstr(str, "End of file attaches")  &&  !feof(logfile))
        {
            cur_pos += strlen(str);
            fgets(str, sizeof(str)-2, logfile);
        }
        cur_pos += strlen(str);
        Amustr_obj.strip_n(str);
    }
    strcpy(rawlogstr, str);

    /* A string was read, now to find out what it was... */
    switch(Config_obj.logsvar.type)
    {
	case TG_L:
		   /* Check for a door entry */
// TG 3.09G:  24 Dec 00:33:29 TG   Door "c:\tg\bats\war.bat 1"
// TG 3.02 :  >> 07/23/1997 00:28:31 - Door "C:\TG\TGN\TGNEWS READ 54 3 57600 /#:2"
		   if(strstr(str, "Door "))
                   {
                       return(DOORS);
                   }

                     /* Check uploads */
           /*   Upload FURY1H.RAR to `0ENew Uploads`07 */
                   if(strstr(str, "Upload ") && !strstr(str, "Upload error"))
                   {
                         /* Get the filename */
                       ptr = strstr(str, "Upload ");
                       if(ptr)
                       {
                           ptr = strstr(ptr, " ");
                           ptr++;
                           ptr2 = strstr(ptr, " ");
                           if(ptr2)
                           {
                               *ptr2 = NULL;
                               _splitpath(ptr, drive, dir, fname, ext);
                               sprintf(filename, "%s%s", fname, ext);
                               strupr(filename);
                               return(UPLOAD);
                           }
                           return(NOTHING);
                       }
                   }

                     /* Check downloads */
        /*   Batch download "JAMINFO1.ZIP" (40,499 bytes) */
/*   Batch download totals: 2 files, 731,806 bytes (1622 cps). */
                   if(strstr(str, "ownload ") && !strstr(str, "ownload error"))
                   {
                       if(strstr(str, "totals:"))
                       {
                           return(NOTHING);
                       }

                         /* Get the filename */
                       ptr = strstr(str, "ownload ");
                       if(ptr)
                       {
                           ptr = strstr(ptr, " ");
                           ptr += 2;
                           ptr2 = strstr(ptr, " ");
                           if(ptr2)
                           {
                               ptr2--;
                               *ptr2 = NULL;
                               _splitpath(ptr, drive, dir, fname, ext);
                               sprintf(filename, "%s%s", fname, ext);
                               strupr(filename);
                               return(DOWNLOAD);
                           }
                           return(NOTHING);
                       }
                   }


                     /* Check user logging on */
/*
+ 08 Nov 00:06:40 TG   Login 14400 bps (/V32/NONE)  -- Node 2
		     OR
`0BLogin `0E[07/23/1997 08:47:24]`09 (14400 bps) (Node 2)`07
`0B3679`09 -- `0BTeron Gorfiend`09 -- `0BToday 1`07 */
		   if(strstr(str, "Login"))
		   {
			 /* Extract the BPS rate */
		       strcpy(tmpstr, str);
		       ptr = strstr(tmpstr, " bps");
		       if(ptr)
		       {
			   *ptr = NULL;
			   ptr--;
			   while(isdigit(*ptr))
			   {
			       ptr--;
			   }
			   ptr++;
			   sscanf(ptr, "%d", &bpsrate);
		       }

                 /* now get the second line in this, but watch out
                    because the format is different for bad logons */

  /* `0C>> Illegal logon "Dan Dasilva" : Tried PW="CAPTAIN"`07 */
        /* `0B3679`09 -- `0BTeron Gorfiend`09 -- `0BToday 1`07 */
                /*   `0C *** `0BNew User`0C *** */
                       while(fgets(str, sizeof(str)-2, logfile))
                       {
                           cur_pos += strlen(str);
                           if(strstr(str, "New User"))
                           {
                               uservar.newuser = TRUE;
                           }
                           if(strstr(str, "-- "))
                           {
                               break;
                           }
                       }
                       Amustr_obj.strip_n(str);

                       ptr = strstr(str, "-- ");
                       if(ptr)
                       {
                           ptr = strstr(ptr, " ");
                           ptr++;
                           if(*ptr == '`')
                           {
                               ptr += 3;
                           }
                           ptr2 = strstr(ptr, "`");
                           if(ptr2)
                           {
                               *ptr2 = NULL;
                           }
                           else
                           {
                               ptr2 = strstr(ptr, " --");
                               if(ptr2)
                               {
                                   *ptr2 = NULL;
                               }
                           }
                           strcpy(username, ptr);
                           return(USER_NAME);
                       }
                       return(NOTHING);
                   }

                     /* Check Lost Carrier */
             /* `0C>>*>*>*> Carrier Lost <*<*<*<<`07 */
                   if(strstr(str, "Carrier Lost"))
                   {
                       return(LOST_CARRIER);
                   }


                     /* Check message read */
/*   Read messages (to user) in area `0ELocal Public Messages`07 (@) */
                   if(strstr(str, "Read messages "))
                   {
                       strupr(str);
                       Config_obj.open_config(MSGAREA_RECORD);
                       for(areanum = 1; areanum <= Config_obj.num_msgarea; areanum++)
                       {
                           Config_obj.read_record(MSGAREA_RECORD, areanum);
                           strupr(Config_obj.msgareavar.areaname);
                           if(strstr(str, Config_obj.msgareavar.areaname))
                           {
                               break;
                           }
                       }
                       Config_obj.close_config(MSGAREA_RECORD);
                       if(areanum <= Config_obj.num_msgarea)
                       {
                           return(MSG_READING);
                       }
                   }

                     /* Check message write */
/*   + "`0BBBS stuff`07" posted on `0ELocal Private Messages`07 */
                   if(strstr(str, "posted on "))
                   {
                       strupr(str);
                       Config_obj.open_config(MSGAREA_RECORD);
                       for(areanum = 1; areanum <= Config_obj.num_msgarea; areanum++)
                       {
                           Config_obj.read_record(MSGAREA_RECORD, areanum);
                           strupr(Config_obj.msgareavar.areaname);
                           if(strstr(str, Config_obj.msgareavar.areaname))
                           {
                               break;
                           }
                       }
                       Config_obj.close_config(MSGAREA_RECORD);
                       if(areanum <= Config_obj.num_msgarea)
                       {
                           return(MSG_WRITE);
                       }

                   }
                   break;


        case EZ_L:
                   /* > 09:51:42  Shell : E:\TEMP\EZ\TEST.BAT */
                   /* Check for door entry */
                   if(strstr(str, "Shell :"))
                   {
                       return(DOORS);
                   }

                     /* Check uploads */
        /* > 09:42:27  Upload (Local Protocol) E:\TEMP\EZ\FILES\FAREA1\AMU.CPP */
                   if(strstr(str, "Upload ("))
                   {
                         /* Get the filename */
                       ptr = strstr(str, "Upload (");
                       if(ptr)
                       {
                           ptr += 6;
                           ptr = strstr(ptr, ") ");
                           ptr += 2;
                           _splitpath(ptr, drive, dir, fname, ext);
                           sprintf(filename, "%s%s", fname, ext);
                           strupr(filename);
                           return(UPLOAD);
                       }
                   }

                     /* Check downloads */
   /* > 09:42:09  Download [Local Protocol] E:\TEMP\EZ\FILES\FAREA1\EZY-RIP.ARJ */
                   if(strstr(str, "Download ["))
                   {
                         /* Get the filename */
                       ptr = strstr(str, "Download [");
                       if(ptr)
                       {
                           ptr += 10;
                           ptr = strstr(ptr, "] ");
                           ptr += 2;
                           _splitpath(ptr, drive, dir, fname, ext);
                           sprintf(filename, "%s%s", fname, ext);
                           strupr(filename);
                           return(DOWNLOAD);
                       }
                   }

                     /* Check user logging on */
        /*  > 09:49:22  User: David Hickey at 0 baud with Security 5. */
                   if(strstr(str, "User: "))
                   {

       /* > 09:07:04  NewUser: David Hickey at 0 baud. */
                           /* Check new user */
                       if(check_newuser_now == TRUE && strstr(str, "NewUser:"))
                       {
                           check_newuser_now = FALSE;
                           return(NEW_USER);
                       }

                         /* Extract the BPS rate */
                       bpsrate = 0;
                       strcpy(tmpstr, str);
                       ptr = strstr(tmpstr, "User: ");
                       ptr = strstr(ptr, " at ");
                       if(ptr)
                       {
                           sscanf(ptr, " at %d baud", &bpsrate);
                       }
                       ptr = strstr(str, " at ");
                       if(ptr)
                       {
                           *ptr = NULL;
                           ptr = strstr(str, "User: ");
                           ptr = strstr(ptr, " ");
                           ptr++;
                           strcpy(username, ptr);
                           Amustr_obj.trimlead(username);
                           Amustr_obj.trimend(username);
                       }
                       return(USER_NAME);
                   }

                     /* Check Lost Carrier */
          /* > 09:42:37  Call Terminated Normally */
                   if(strstr(str, "Call") && strstr(str, "Terminated"))
                   {
                       if(!strstr(str, "Call Terminated Normally"))
                       {
                           return(LOST_CARRIER);
                       }
                   }

                     /* Check message posted */
           /* > 09:15:36  Message Posted in General Mail */
                   if(strstr(str, "Message Posted in "))
                   {
                       ptr = strstr(str, "Message Posted in");
                       ptr = strstr(ptr, "in ");
                       ptr += 3;
                       Amustr_obj.strip_n(ptr);
                       Amustr_obj.trimlead(ptr);
                       Amustr_obj.trimend(ptr);
                       Config_obj.open_config(MSGAREA_RECORD);
                       for(areanum = 1; areanum <= Config_obj.num_msgarea; areanum++)
                       {
                           Config_obj.read_record(MSGAREA_RECORD, areanum);
                           if(strcmp(Config_obj.msgareavar.areaname, ptr) == 0)
                           {
                               break;
                           }
                       }
                       Config_obj.close_config(MSGAREA_RECORD);
                       if(areanum <= Config_obj.num_msgarea)
                       {
                           return(MSG_WRITE);
                       }

                   }
                   break;


                     /* > 19:03:39  Completed new-user procedure */
        case RA_L: /* Check new user */
                   if(strstr(str, "Completed new-user procedure"))
                   {
                       return(NEW_USER);
                   }

                   /* Check for a door entry */
                   if(strstr(str, "DOS shell"))
                   {
                       return(DOORS);
                   }

                     /* Check uploads */
          /* > 00:44:58  Upload [Zmodem] C:\FILES\BBSLIST\GOVBBS.ZIP */
                   if(strstr(str, "Upload ["))
                   {
                         /* Get the filename */
                       ptr = strstr(str, "Upload [");
                       if(ptr)
                       {
                           ptr += 6;
                           ptr = strstr(ptr, "] ");
                           ptr += 2;
                           _splitpath(ptr, drive, dir, fname, ext);
                           sprintf(filename, "%s%s", fname, ext);
                           strupr(filename);
                           return(UPLOAD);
                       }
                   }

                     /* Check downloads */
          /* > 00:44:58  Download [Zmodem] C:\FILES\BBSLIST\GOVBBS.ZIP */
                   if(strstr(str, "Download ["))
                   {
                         /* Get the filename */
                       ptr = strstr(str, "Download [");
                       if(ptr)
                       {
                           ptr += 10;
                           ptr = strstr(ptr, "] ");
                           ptr += 2;
                           _splitpath(ptr, drive, dir, fname, ext);
                           sprintf(filename, "%s%s", fname, ext);
                           strupr(filename);
                           return(DOWNLOAD);
                       }
                   }

                     /* Check user logging on */
              /* > <time> <date>  David Hickey on-line at 0 bps */
                   if(strstr(str, "on-line at"))
                   {
                         /* Extract the BPS rate */
                       strcpy(tmpstr, str);
                       ptr = strstr(tmpstr, "on-line at");
                       if(ptr)
                       {
                           ptr = strstr(ptr, "at");
                           if(ptr)
                           {
                               sscanf(ptr, "at %d ", &bpsrate);
                           }
                       }

                       ptr = strstr(str, "on-line");
                       ptr--;
                       *ptr = NULL;

                         /* Extract the name by reversing the string, then
                            copying each character until a digit is found.
                            When a digit is found, that denotes part of the
                            'time' field in the logfile.
                         */
                       strrev(str);
                       ptr = str;
                       ptr2 = username;
                       while(!isdigit(*ptr))
                       {
                             *ptr2 = *ptr;
                             ptr++;
                             ptr2++;
                       }
                       *ptr2 = NULL;
                       strrev(username);
                       return(USER_NAME);
                   }

                     /* Check Lost Carrier */
                   if(strstr(str, "Lost carrier"))
                   {
                       return(LOST_CARRIER);
                   }

                     /* Check message posted */
              /* Message #4546 posted in Local area #2 : To and From Sysop */
                   if(strstr(str, "posted in "))
                   {
                         /* Extract the area number */
                       ptr = strstr(str, "posted in ");
                       if(ptr)
                       {
                           ptr = strchr(ptr, '#');
                           if(ptr)
                           {
                               ptr++;
                               sscanf(ptr, "%d", &areanum);
                               return(MSG_WRITE);
                           }
                       }
                   }

                     /* Check message read */
             /* Reading message area #60 : RemoteAccess Manager Beta */
                   if(strstr(str, "Reading message area "))
                   {
                         /* Extract the area number */
                       ptr = strstr(str, "Reading message area ");
                       if(ptr)
                       {
                           ptr = strchr(ptr, '#');
                           if(ptr)
                           {
                               ptr++;
                               sscanf(ptr, "%d", &areanum);
                               return(MSG_READING);
                           }
                       }
                   }
                   break;

                     /* > 19:03:39  David Hickey isn't in user list */
            case LORA_L: /* Check new user */
                        if(strstr(str, "isn't in user list"))
                        {
                            return(NEW_USER);
                        }

                        if(strstr(str, "External"))
                        {
                            return(DOORS);
                        }

            /* + 22:26:54  UL-Z/32 Olr\TASK01\THE_HOLE.QWK */
 /*+ 03 Jun 22:44:23 LORA UL-Z O:\bbs\newuplds\O:\BBS\NEWUPLDS\FTPFID16.ZIP */
                        if(strstr(str, "UL-") || strstr(str, "Received"))
                        {
                         /* Get the filename */

                            ptr = strstr(str, "UL-");
                            ptr = strchr(ptr, ':');
                            if(ptr)
                            {
                                ptr++;
                                ptr = strchr(ptr, ':');
                                if(ptr)
                                {
                                    ptr--;
                                    _splitpath(ptr, drive, dir, fname, ext);
                                    sprintf(filename, "%s%s", fname, ext);
                                    strupr(filename);
                                    if(filename_ok())
                                    {
                                        return(UPLOAD);
                                    }
                                }
                            }

                            ptr = strstr(str, "UL-");
                            ptr = strchr(ptr, ' ');
                            ptr++;
                            _splitpath(ptr, drive, dir, fname, ext);
                            sprintf(filename, "%s%s", fname, ext);
                            strupr(filename);
                            if(filename_ok())
                            {
                                return(UPLOAD);
                            }
                            else
                            {
                                return(NOTHING);
                            }
                        }

            /* + 22:26:54  DL-Z/32 Olr\TASK01\THE_HOLE.QWK */
                        if(strstr(str, "DL-") || strstr(str, "Sending"))
                        {
                         /* Get the filename */
                            ptr = strstr(str, "DL-");
                            ptr = strchr(ptr, ' ');
                            ptr++;
                            _splitpath(ptr, drive, dir, fname, ext);
                            sprintf(filename, "%s%s", fname, ext);
                            strupr(filename);
                            if(filename_ok())
                            {
                                return(DOWNLOAD);
                            }
                            else
                            {
                                return(NOTHING);
                            }
                        }


                     /* Check user logging on
                   <time> <date>  Connect Local
                 > <time> <date>  David Hickey calling */
                        if(strstr(str, "Connect "))
                        {
                         /* Extract the BPS rate */
                            if(strstr(str, " Local"))
                            {
                                bpsrate = 0;
                            }
                            else
                            {
                                ptr = strstr(str, "Connect ");
                                sscanf(ptr, "Connect %d", &bpsrate);
                            }

                         /* Now get the name of the user */
                            do
                            {
                                fgets(str, sizeof(str) - 2, logfile);
                            }while(!strstr(str, "calling") && !feof(logfile));

                            Amustr_obj.strip_n(str);

        /* Check to see if this is a node calling in instead of a human */
                            ptr = strstr(str, "(");
                            if(ptr)
                            {
                                if(strstr(ptr, ":")  &&  strstr(ptr, "/")  &&  strstr(ptr, ".")
                                   &&  strstr(ptr, ")"));
                                {
                                     return(NOTHING);
                                }
                            }

                            ptr = strstr(str, " is calling");
                            if(!ptr)
                            {
                                ptr = strstr(str, " calling");
                            }
                            if(ptr)
                            {
                                *ptr = NULL;
                            }
                            else
                            {
                                if(strstr(str, "Lost Carrier") || strstr(str, "Carrier lost"))
                                {
                                    return(LOST_CARRIER);
                                }
                                return(NOTHING);
                            }

                         /* If this is an expanded log format, there will be
                            a "LORA " right before the user name */
                            ptr = strstr(str, "LORA ");
                            if(ptr)
                            {
                                ptr = strchr(ptr, ' ');
                            }
                            else
                            {
                                ptr = strstr(str, " ");
                                ptr++;
                                ptr = strstr(ptr, " ");
                            }
                            Amustr_obj.trimlead(ptr);
                            strcpy(username, ptr);
                            return(USER_NAME);
                        }

                     /* Check Lost Carrier */
                        if(strstr(str, "Lost Carrier") || strstr(str, "Carrier lost"))
                        {
                            return(LOST_CARRIER);
                        }

                     /* Check message posted */
              /* Message #4546 posted in Local area #2 : To and From Sysop */
                        if(strstr(str, "posted in "))
                        {
                         /* Extract the area number */
                            ptr = strstr(str, "posted in ");
                            ptr = strchr(ptr, '#');
                            if(ptr)
                            {
                                sscanf(ptr, "#%d", &areanum);
                                return(MSG_WRITE);
                            }
                        }

                    /*  Writing Msg. in area 4 */
                        if(strstr(str, "Writing Msg"))
                        {
                         /* Extract the area number */
                            ptr = strstr(str, "Writing Msg");
                            ptr = strstr(ptr, "area ");
                            if(ptr)
                            {
                                sscanf(ptr, "area %d", &areanum);
                                return(MSG_WRITE);
                            }
                        }

                             /* Check message read */
            /*: 22:10:00  Message Area #1 Main Board (Lora 2.40) */
                        if(strstr(str, "Message Area #"))
                        {
                         /* Extract the area number */
                            ptr = strstr(str, "Message Area #");
                            ptr = strchr(ptr, '#');
                            if(ptr)
                            {
                                sscanf(ptr, "#%d", &areanum);
                                return(MSG_READING);
                            }
                        }

                 /* Message Area: 1 - Remarks to Sysop   (Local)   (Lora 3.0) */
                        if(strstr(str, "Message Area: "))
                        {
                         /* Extract the area number */
                            ptr = strstr(str, "Message Area: ");
                            ptr = strchr(ptr, ':');
                            if(ptr)
                            {
                                sscanf(ptr, ": %d", &areanum);
                                return(MSG_READING);
                            }

                        }
                        break;


                /*  : 01 May 03:16:42 MAX  Application */
            case MAX_L: /* Check new user */
                     if(strstr(str, "Application"))
                     {
                         return(NEW_USER);
                     }

                     if(strstr(str, "External program"))
                     {
                         return(DOORS);
                     }

        /*  = 01 May 17:41:54 MAX  UL-S D:\Down\Gpix\Esm209b.Zip */
                     if(strstr(str, "UL-"))
                     {
                         /* First see if there is an entry saying that a
                            message was posted after this.  If so, this is
                            a message upload, not a real file */
                         file_pos = ftell(logfile);
                         fgets(tmpstr, sizeof(tmpstr)-2, logfile);
                         fseek(logfile, file_pos, SEEK_SET);
                         if(strstr(tmpstr, "Msg to"))
                         {
                             return(NOTHING);
                         }

                         /* Get the filename */
                         ptr = strstr(str, "UL-");
                         ptr = strstr(ptr, " ");
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         if(filename_ok())
                         {
                             return(UPLOAD);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                     }

/*   = 01 May 19:51:34 MAX  DL-Z D:\Down\Xxx\Doherty2.Gif */
                     if(strstr(str, "DL-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "DL-");
                         ptr = strstr(ptr, " ");
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         if(filename_ok())
                         {
                             return(DOWNLOAD);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                     }


                     /* Check user logging on
                : 30 Apr 23:23:17 MAX  Caller at 14400 bps
                + 30 Apr 23:23:28 MAX  Ken Brassner calling (U#=7) */

                     if(strstr(str, " Caller at "))
                     {
                         /* Extract the BPS rate */
                         if(strstr(str, " Local"))
                         {
                             bpsrate = 0;
                         }
                         else
                         {
                             ptr = strstr(str, "Caller at ");
                             sscanf(ptr, "Caller at %d bps", &bpsrate);
                         }

                         /* Now get the name of the user */
                         fgets(str, sizeof(str) - 2, logfile);

                         Amustr_obj.strip_n(str);

                         ptr = strstr(str, "MAX ");
                         if(ptr)
                         {
                             ptr = strstr(ptr, " ");
                             Amustr_obj.trimlead(ptr);
                             ptr2 = strstr(ptr, " calling");
                             if(ptr2)
                             {
                                 *ptr2 = NULL;
                             }
                             else
                             {
                                 if(strstr(str, "Caller dropped carrier"))
                                 {
                                     return(LOST_CARRIER);
                                 }
                                 return(NOTHING);
                             }
                             strcpy(username, ptr);
                             return(USER_NAME);
                         }
                         return(NOTHING);
                     }

                     /* Check Lost Carrier */
        /*  : 01 May 19:59:59 MAX  Caller dropped carrier */
                     if(strstr(str, "Caller dropped carrier"))
                     {
                         return(LOST_CARRIER);
                     }

                     /* Check message posted */
        /* # 01 May 09:42:20 MAX  Msg to Brian Andrus, area 0, #31 */
        /*                    or it could be: */
        /* # 01 May 09:42:20 MAX  Msg to Brian Andrus, area Local Mail, #31 */
                     if(strstr(str, "Msg to "))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "Msg to ");
                         ptr = strstr(ptr, "area ");
                         if(ptr)
                         {
                             num = sscanf(ptr, "area %d", &areanum);
                             if(num == 1)
                             {
                                 return(MSG_WRITE);
                             }
                             else
                             {
                                 ptr = strstr(ptr, ", ");
                                 if(ptr)
                                 {
                                     *ptr = NULL;
                                     ptr = strstr(str, "Msg to ");
                                     ptr = strstr(ptr, "area ");
                                     if(ptr)
                                     {
                                         ptr = strchr(ptr, ' ');
                                         ptr++;
                                         Amustr_obj.trimlead(ptr);
                                         strupr(ptr);
                                         Amustr_obj.us_to_spaces(ptr);

                                         Config_obj.open_config(MSGAREA_RECORD);
                                         for(areanum = 1; areanum <= Config_obj.num_msgarea; areanum++)
                                         {
                                             Config_obj.read_record(MSGAREA_RECORD, areanum);
                                             strcpy(tmpstr, Config_obj.msgareavar.areaname);
                                             Amustr_obj.us_to_spaces(tmpstr);
                                             strupr(tmpstr);
                                             if(strstr(tmpstr, ptr))
                                             {
                                                 break;
                                             }
                                         }
                                         Config_obj.close_config(MSGAREA_RECORD);
                                         if(areanum <= Config_obj.num_msgarea)
                                         {
                                             return(MSG_WRITE);
                                         }
                                     }
                                 }
                             }
                         }
                     }

                     /* Check message read */
        /* : 01 May 09:17:03 MAX  Msg.area 0 Fantasia */
                     if(strstr(str, "Msg.area "))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "Msg.area ");
                         sscanf(ptr, "Msg.area %d", &areanum);
                         return(MSG_READING);
                     }

/* # 02 Oct 11:10:45 MAX  QWK msg to Clay Tinsley, area DFW_Tech #55 */
                     if(strstr(str, "QWK msg to"))
                     {
                         Amustr_obj.strip_n(str);
                         ptr = strchr(str, 0);
                         if(ptr)
                         {
                             while(*ptr != ' ' && *ptr != '#')
                             {
                                 ptr--;
                             }
                             if(*ptr == '#')
                             {
                                 ptr++;
                                 sscanf(ptr, "%d", &areanum);
                                 return(MSG_READING);
                             }
                         }
                         return(NOTHING);
                     }
                     break;


            case PB_L: /* Check new user */
                  /* 08-Aug-93 22:07:48 Creating new user. */
                     if(strstr(str, "Creating new user"))
                     {
                         return(NEW_USER);
                     }

                     /* Check for a regular DOS Shell, Type 7 */
                     if(strstr(str, "DOS SHELL"))
                     {
                         return(DOORS);
                     }

                     /* Check for a PEX entry */
                     if(strstr(str, "Entered") && strstr(str, "PEX"))
                     {
                         return(DOORS);
                     }

                     /* Check downloads */
            /* 08-Aug-93 15:22:39 Download-X J-CURTIS.GIF */

                     if(strstr(str, "Download-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Download-");
                         ptr = strchr(ptr, '-');
                         ptr = strchr(ptr, ' ');
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(DOWNLOAD);
                     }

                     /* Check uploads */
            /* 08-Aug-93 15:22:39 Upload-X J-CURTIS.GIF */

                     if(strstr(str, "Upload-") && !strstr(str, "(Personal)"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Upload-");
                         ptr = strchr(ptr, '-');
                         ptr = strchr(ptr, ' ');
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(UPLOAD);
                     }

                        /* Check the BPS rate (PB does this on a sep. line */
                /* 27-Mar-94 18:53:00 Incoming call at 14400 bps */
                     if(strstr(str, "Incoming call at"))
                     {
                         ptr = strstr(str, "Incoming call at");
                         sscanf(ptr, "Incoming call at %d", &bpsrate);
                     }

                     /* Check user logging on */
                 /* 08-Aug-93 15:06:47 User logged in: Jerry Rutherford */
                     if(strstr(str, "User logged in: "))
                     {
                         ptr = strstr(str, "User logged in: ");
                         ptr = strchr(ptr, ':');
                         ptr++;
                         strcpy(username, ptr);
                         Amustr_obj.trimlead(username);
                         Amustr_obj.trimend(username);
                         return(USER_NAME);
                     }


                     /* Check new user logging on */
                 /* 08-Aug-93 15:06:47 User not located : Jerry Rutherford */
                     if(strstr(str, "User not located : "))
                     {
                         ptr = strstr(str, "User not located : ");
                         ptr = strchr(ptr, ':');
                         ptr++;
                         strcpy(username, ptr);
                         Amustr_obj.trimlead(username);
                         Amustr_obj.trimend(username);
                         return(USER_NAME);
                     }

                     /* Check Lost Carrier */
                 /* 08-Aug-93 16:11:53 Carrier lost! */
                     if(strstr(str, "Carrier lost!")  ||  strstr(str, "hung up"))
                     {
                         return(LOST_CARRIER);
                     }

                     /* Check message posted */
          /* 20-Jan-94 10:11:31 Msg #27950 entered (Area 1) */
                     if(strstr(str, "entered (Area "))
                     {
                         ptr = strstr(str, "(Area ");
                         sscanf(ptr, "(Area %d", &areanum);
                         return(MSG_WRITE);
                     }

                     /* Check message read */
         /*   20-Jan-94 10:11:22 Message #27949 read (area 1)  */
                     if(strstr(str, "ead (area "))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "(area ");
                         sscanf(ptr, "(area %d", &areanum);
                         return(MSG_READING);
                     }
                     break;

            case SBBS_L: /* Check new user */
                /* 07-Sep-93 16:18  Newuser questions completed. */
                     if(strstr(str, "Newuser questions completed."))
                     {
                         return(NEW_USER);
                     }

                     if(strstr(str, "Cmd line") || strstr(str, "at errorlevel"))
                     {
                         return(DOORS);
                     }

                     /* Check downloads */
        /* 07-Sep-93 19:51  Download-Z D:\FILES\TEXT\NHT_BBS.ARJ */
                     if(strstr(str, "Download-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Download-");
                         ptr = strstr(ptr, "-");
                         ptr += 2;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(DOWNLOAD);
                     }

                     /* Check uploads */
        /* 07-Sep-93 19:51  Upload-Z D:\FILES\TEXT\NHT_BBS.ARJ */
                     if(strstr(str, "Upload-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Upload-");
                         ptr = strstr(ptr, "-");
                         ptr += 2;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(UPLOAD);
                     }

                     /* Check user logging on */
        /* 07-Sep-93 16:15  Jeff Mitchell online at 2400 bps */
                     if(strstr(str, "online"))
                     {
                         /* Extract the BPS rate */
                         strcpy(tmpstr, str);
                         ptr = strstr(tmpstr, "online at");
                         sscanf(ptr, "online at %d", &bpsrate);

                         ptr = strstr(str, "online");
                         ptr--;
                         *ptr = NULL;

                         /* Extract the name by reversing the string, then
                            copying each character until a digit is found.
                            When a digit is found, that denotes part of the
                            'time' field in the logfile.
                         */
                         strrev(str);
                         ptr = str;
                         ptr2 = username;
                         while(!isdigit(*ptr))
                         {
                             *ptr2 = *ptr;
                             ptr++;
                             ptr2++;
                         }
                         *ptr2 = NULL;
                         strrev(username);
                         return(USER_NAME);
                     }

                     /* Check Lost Carrier */
        /* 07-Sep-93 16:20  Carrier lost, user offline */
                     if(strstr(str, "Carrier lost"))
                     {
                         return(LOST_CARRIER);
                     }

                     /* Check message posted */
                      /* Msg #1 entered (Area 1) */
                     if(strstr(str, "entered (Area "))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "(Area ");
                         sscanf(ptr, "(Area %d", &areanum);
                         return(MSG_WRITE);
                     }

                     /* Check message read */
                     /* Message #1 read (area 1) */

                         /* None for SuperBBS */
                     break;

            case QBBS_L: /* Check new user */
                /* 07-Sep-93 16:18  Name not in user file! */
                     if(strstr(str, "Name not in user"))
                     {
                         return(NEW_USER);
                     }

                     if(strstr(str, "Command Line") || strstr(str, "DOS Exit"))
                     {
                         return(DOORS);
                     }

                     /* Check downloads */
        /* 29-Jul-93 22:35  Download-Z C:\GAMES\ARCHERY.ZIP */
                     if(strstr(str, "Download-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Download-");
                         ptr = strstr(ptr, "-");
                         ptr += 2;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", drive, dir, fname, ext);
                         strupr(filename);
                         return(DOWNLOAD);
                     }

                     /* Check uploads */
        /* 07-Sep-93 19:51  Upload-Z D:\FILES\TEXT\NHT_BBS.ARJ */
                     if(strstr(str, "Upload-"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Upload-");
                         ptr = strstr(ptr, "-");
                         ptr += 2;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(UPLOAD);
                     }

                     /* Check user logging on */
        /* 07-Sep-93 16:15  Jeff Mitchell on-line at 2400 bps */
                     if(strstr(str, "on-line at "))
                     {
                         /* Extract the BPS rate */
                         if(strstr(str, "locally") || strstr(str, "from console"))
                         {
                             bpsrate = 0;
                         }
                         else
                         {
                             strcpy(tmpstr, str);
                             ptr = strstr(tmpstr, "on-line at");
                             sscanf(ptr, "on-line at %d", &bpsrate);
                         }

                         ptr = strstr(str, "on-line at");
                         ptr--;
                         *ptr = NULL;

                         /* Extract the name by reversing the string, then
                            copying each character until a digit is found.
                            When a digit is found, that denotes part of the
                            'time' field in the logfile.
                         */
                         strrev(str);
                         ptr = str;
                         ptr2 = username;
                         while(!isdigit(*ptr))
                         {
                             *ptr2 = *ptr;
                             ptr++;
                             ptr2++;
                         }
                         *ptr2 = NULL;
                         strrev(username);
                         return(USER_NAME);
                     }

                     /* Check Lost Carrier */
        /* 07-Sep-93 16:20  Carrier lost, user off-line */
                     if(strstr(str, "Lost carrier")  ||  strstr(str, "ACF Terminate: Carrier Dropped"))
                     {
                         if(!strstr(str, "Lost carrier in external program"))
                         {
                             return(LOST_CARRIER);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                     }

                     /* Check message posted */
    /* 29-Jul-93 23:15  Message #88 entered in Msg Area #6: Retreif's Korner */
                     if(strstr(str, "entered in Msg Area #"))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "Msg Area #");
                         ptr = strchr(ptr, '#');
                         sscanf(ptr, "#%d", &areanum);
                         return(MSG_WRITE);
                     }

                     /* Check message read */
                       /* None for QuickBBS */
                     break;

                        /* # 15:38.00  New user */
            case CONCORD_L: /* Check new user */
                     if(strstr(str, "New user"))
                     {
                         return(NEW_USER);
                     }

                     if(strstr(str, "Start exec"))
                     {
                         return(DOORS);
                     }

                     /* Check uploads */
        /* # 13:37.00  Upload D:\FILES\UPLOADS\ALLFILES.ZIP */
                     if(strstr(str, "Upload "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Upload ");
                         ptr = strchr(ptr, ' ');
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(UPLOAD);
                     }

                     /* Check downloads */
          /* > 00:44:58  Download C:\FILES\BBSLIST\GOVBBS.ZIP */
                     if(strstr(str, "Download "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Download ");
                         ptr = strchr(ptr, ' ');
                         ptr++;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         return(DOWNLOAD);
                     }

                     /* Check user logging on */
                /* # 13:36.00  Eric Chew online at 14400 bps. */
                     if(strstr(str, "online at "))
                     {
                         /* Extract the BPS rate */
                         strcpy(tmpstr, str);
                         ptr = strstr(tmpstr, "online at ");
                         sscanf(ptr, "online at %d", &bpsrate);

                         ptr = strstr(str, "online");
                         ptr--;
                         *ptr = NULL;

                         /* Extract the name by reversing the string, then
                            copying each character until a digit is found.
                            When a digit is found, that denotes part of the
                            'time' field in the logfile.
                         */
                         strrev(str);
                         ptr = str;
                         ptr2 = username;
                         while(!isdigit(*ptr))
                         {
                             *ptr2 = *ptr;
                             ptr++;
                             ptr2++;
                         }
                         *ptr2 = NULL;
                         strrev(username);
                         return(USER_NAME);
                     }

                     /* Check Lost Carrier */
                /*  # 13:39.00  User offline (No Carrier) */
                     if(strstr(str, "User offline (No Carrier)"))
                     {
                         return(LOST_CARRIER);
                     }

                     /* Check message posted */
 /* # 23:48.00  Message entered on area #1 General Message Base       (L) */
                     if(strstr(str, "Message entered"))
                     {
                         /* Extract the area number */
                         ptr = strstr(str, "Message entered ");
                         ptr = strchr(ptr, '#');
                         if(ptr)
                         {
                             sscanf(ptr, "#%d", &areanum);
                             return(MSG_WRITE);
                         }
                     }

/* Currently, Concord doesn't log this information for message reads */


            /* 08/13/93 00:21  Z32-S: 50021451.PKT, 584b, 00:03 */
            case DB_L: if(strstr(str, "-S:"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "-S:");
                         ptr += 4;
                         ptr2 = strstr(ptr, ", ");
                         *ptr2 = NULL;
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);

                          /* Throw out the next line */
                         fgets(str, sizeof(str)-2, logfile);
                         if(filename_ok())
                         {
                             return(DOWNLOAD);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                      }
                     break;

            /*   0:28:16  Sent D:\FD\PACKETS\FE41043F.MO2; */
            case FD_L:
            case IM_L:
            case MD_L:
                     if(strstr(str, "Sent "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, ";");
                         if(ptr)
                         {
                             *ptr = NULL;
                         }
                         ptr = strstr(str, "Sent");
                         ptr = strstr(ptr, " ");
                         ptr++;
                         ptr2 = strchr(ptr, ' ');
                         if(ptr2)
                         {
                             *ptr2 = NULL;
                         }
                         ptr2 = strchr(ptr, ';');
                         if(ptr2)
                         {
                             *ptr2 = NULL;
                         }
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         if(filename_ok())
                         {
                             return(DOWNLOAD);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                     }
                     break;

   /* + 09 Feb 06:02:18 PORTAL Sent-J/32 E:\FILES\PROG\CPROG\BASTOC.ZIP */
        /* # 09 Aug 20:17:42 BINK Sent-Z/32 D:\Info\ZEN-INET.ZIP */
            case POP_L:
            case MCMAIL_L:
            case XENIA_L:
            case BT_L: if(strstr(str, " Sent"))
                     {
                         /* Get the filename */
                         Amustr_obj.strip_n(str);
                         ptr = strstr(str, "Sent");
                         ptr = strstr(ptr, " ");
                         ptr++;
                         ptr2 = strchr(ptr, ' ');
                         if(ptr2)
                         {
                             *ptr2 = NULL;
                         }
                         _splitpath(ptr, drive, dir, fname, ext);
                         sprintf(filename, "%s%s", fname, ext);
                         strupr(filename);
                         if(filename_ok())
                         {
                             return(DOWNLOAD);
                         }
                         else
                         {
                             return(NOTHING);
                         }
                     }
                     break;

     /* ^ 03 Apr 09:36:06 SXH1  Area  91 (  U.S. Robotics   ) -  312 A */
            case SX_L: if(strstr(str, "Area "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Area ");
                         ptr = strchr(ptr, ' ');
                         Amustr_obj.trimlead(ptr);
                         sscanf(ptr, "%d", &areanum);
                         return(MSG_READING);
                     }

/* # 23 Mar 12:59:42 SXH1 NEW MSG#   345 AREA 49/Commercial */
                     if(strstr(str, "NEW MSG"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "AREA ");
                         if(ptr)
                         {
                             ptr = strchr(ptr, ' ');
                             Amustr_obj.trimlead(ptr);
                             sscanf(ptr, "%d", &areanum);
                             return(MSG_WRITE);
                         }
                     }
                     break;

    /*> 04-Aug 05:53:27 QD01 Packed    3 in area    3 - SysOp Comments */
            case OLMS_L: if(strstr(str, "Packed"))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Packed");
                         ptr = strstr(ptr, "area ");
                         if(ptr)
                         {
                             ptr = strchr(ptr, ' ');
                             Amustr_obj.trimlead(ptr);
                             sscanf(ptr, "%d", &areanum);
                             return(MSG_READING);
                         }
                     }

  /* > 04-Aug 05:55:30 QD01 Posted in 1014 - AUTORACE - AUTORACE ECHO */
                     if(strstr(str, "Posted in "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Posted in ");
                         ptr = strstr(ptr, "in ");
                         ptr = strchr(ptr, ' ');
                         Amustr_obj.trimlead(ptr);
                         sscanf(ptr, "%d", &areanum);
                         return(MSG_WRITE);
                     }
                     break;


/* + 03 Apr  7:01:12 BWRA Bundled  109 messages in area FrontDoor Help  [3] */
            case BW_L: if(strstr(str, "BWRA Bundled"))
                       {
                                 /* Get the filename */
                           ptr = strstr(str, "Bundled ");
                           ptr = strstr(ptr, "  [");
                           if(ptr)
                           {
                               ptr = strchr(ptr, '[');
                               sscanf(ptr, "[%d]", &areanum);
                               return(MSG_READING);
                           }
                       }

/* + 31 May 13:55:57 BWQB Bundled    6 messages in area Hub 900 Sysop's (FidoNet) */
                     if(strstr(str, "BWQB Bundled "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Bundled ");
                         ptr = strchr(ptr, ' ');
                         Amustr_obj.trimlead(ptr);
                         sscanf(ptr, "%d", &areanum);
                         if(areanum > 0)
                         {
                             ptr = strstr(ptr, "messages in area ");
                             if(ptr)
                             {
                                 ptr = strstr(ptr, "area ");
                                 ptr = strchr(ptr, ' ');
                                 Amustr_obj.trimlead(ptr);
                                 Amustr_obj.trimend(ptr);
                                 strupr(ptr);
                                 Amustr_obj.spaces_to_us(ptr);
                                 Config_obj.open_config(MSGAREA_RECORD);
                                 for(areanum = 1; areanum <= Config_obj.num_msgarea; areanum++)
                                 {
                                     Config_obj.read_record(MSGAREA_RECORD, areanum);
                                     strcpy(tmpstr, Config_obj.msgareavar.areaname);
                                     strupr(tmpstr);
                                     Amustr_obj.spaces_to_us(tmpstr);
                                     if(strstr(tmpstr, ptr))
                                     {
                                         break;
                                     }
                                 }
                                 Config_obj.close_config(MSGAREA_RECORD);
                                 if(areanum <= Config_obj.num_msgarea)
                                 {
                                     return(MSG_READING);
                                 }
                             }
                         }
                         return(NOTHING);
                     }

/* + 23:07:25  Bundled    0 messages in area   3  [Inbound GOFER Files   (Local)] */
                     if(strstr(str, "Bundled "))
                     {
                         ptr = strstr(str, "messages in area ");
                         if(ptr)
                         {
                             ptr = strstr(ptr, "area ");
                             ptr = strchr(ptr, ' ');
                             Amustr_obj.trimlead(ptr);
                             sscanf(ptr, "%d", &areanum);
                             return(MSG_READING);
                         }
                     }


        /* @ 03 Apr 10:41:24 BWRA NEW message in area 20 [Sysop 261] */
                     if(strstr(str, "NEW message in area "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "in area ");
                         ptr = strstr(ptr, "area ");
                         sscanf(ptr, "area %d", &areanum);
                         return(MSG_WRITE);
                     }
                     break;

/*  > 20-May 20:32:40 RA02 JC-QWK Area     2 (ALGEMEEN            ) -    3 E */
            case JC_L: if(strstr(str, "Area "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "Area ");
                         ptr = strchr(ptr, ' ');
                         Amustr_obj.trimlead(ptr);
                         sscanf(ptr, "%d", &areanum);
                         return(MSG_READING);
                     }

/* > 20-May 20:55:14 RA02 Message #10391 posted in EchoMail area #2 : PRIVATE */
                     if(strstr(str, "posted in "))
                     {
                         /* Get the filename */
                         ptr = strstr(str, "area #");
                         if(ptr)
                         {
                             sscanf(ptr, "area #%d", &areanum);
                             return(MSG_WRITE);
                         }
                     }
                     break;
    }
    return(NOTHING);
}

/************************************************************************/
/* Checks to see if the filename is most likely a mail packet */
int Logs::filename_ok(void)
{
    int status;

    status = TRUE;

    /* Check to see if the filename may in fact be a mail packet.  If it is,
       we don't want to waste time trying to process it.
    */
    if(strstr(filename, ".MO"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".TU"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".WE"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".TH"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".FR"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".SA"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".SU"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".PKT"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".REQ"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".TIC"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".FLO"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".REP"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".QWK"))
    {
        status = FALSE;
    }
    if(strstr(filename, ".(I)"))
    {
        status = FALSE;
    }
    if(!status)
    {
        bpsrate = 0;
    }
    return(status);
}

/*************************************************************************/
/* Return whether or not the given log is a BBS, Mailer, or QWK log */
int Logs::get_logtype(void)
{
    int log_type;

    switch(Config_obj.logsvar.type)
    {
        case FD_L     :
        case IM_L     :
        case DB_L     :
        case BT_L     :
        case POP_L    :
//      case LORA_L   :
        case MD_L     :
        case XENIA_L  :
        case MCMAIL_L : log_type = MAILER_LOG;
                        break;
        case RA_L     :
        case QBBS_L   :
        case SBBS_L   :
        case PB_L     :
        case CONCORD_L:
        case MAX_L    :
        case LORA_L   :
        case TG_L     :
        case EZ_L     : log_type = BBS_LOG;
                        break;
        case SX_L     :
        case BW_L     :
        case JC_L     :
        case OLMS_L   : log_type = QWK_LOG;
                        break;
    }
    return(log_type);
}

/***********************************************************************/
/* Makes sure the username is ok */
int Logs::username_ok(void)
{
    char tmpname[51];

    Amustr_obj.trimlead(username);
    Amustr_obj.trimend(username);
    strcpy(tmpname, username);
    strupr(tmpname);
    if(strstr(tmpname, "ATDT") || strstr(tmpname, "+++"))
    {
        return(FALSE);
    }
    return(TRUE);
}

/************************************************************************/
/* Set the current position in the logfile */
int Logs::set_position(long *last_crc, long *last_offset)
{
    int type;
    long crc;
    char LOG_STR[151];

    type = OLD_LOG;

    /* See if this is a new logfile or not by comparing the CRC-32
       of the first non-blank line against the one stored.  If it is
       the same, seek to the last offset.  Otherwise, calculate a new
       CRC-32.
    */
    do
    {
        fgets(LOG_STR, sizeof(LOG_STR) - 2, logfile);
        Amustr_obj.trimlead(LOG_STR);
        Amustr_obj.strip_n(LOG_STR);
    }while(!feof(logfile) && LOG_STR[0] == NULL);

    crc = Crc_obj.crc32(LOG_STR);
    if(crc == *last_crc  &&  *last_offset <= filelength(fileno(logfile)))
    {
        /* If the CRC is the same, this is the same logfile so we just need
           to seek to the last_offset.
        */
        fseek(logfile, *last_offset, SEEK_SET);
    }
    else
    {
        /* If they're different, this is a new log */
        *last_crc = crc;
        fseek(logfile, 0, SEEK_SET);
        type = NEW_LOG;
    }

    /* At any rate, the new offset for the next time AMU runs will be the
       current filelength, so we may as well set that up while we're here.
    */
    *last_offset = filelength(fileno(logfile));
    return(type);
}

/* See if a string in the CARRIER.CTL file matches 's'  Return TRUE if
   's' is really a dropped carrier, FALSE if it is not */
int Logs::dropped_carrier(char *s)
{
    FILE *ctlfile;
    char str[101];

    if(*s == NULL)
    {
        return(FALSE);
    }
    strupr(s);
    sprintf(str, "%s%s", Config_obj.amu_cfgvar.AMUpath, CARRIER_CTL);
    ctlfile = fopen(str, "rt");
    if(ctlfile)
    {
        while(fgets(str, sizeof(str)-2, ctlfile))
        {
            Amustr_obj.strip_n(str);
            strupr(str);
            if(str[0] != NULL && strstr(s, str))
            {
                fclose(ctlfile);
                return(FALSE);
            }
        }
        fclose(ctlfile);
    }
    return(TRUE);
}

/************************************************************************/
/* EOF LOGS.CPP */
