/* Functions for the Language menu */
/* Last updated 07 February 1996   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include <conio.h>
#include "menus.h"
#include "lngmenu.h"
#include "sysinfo.h"
#include "utility2.h"
#include "crc.h"
#include "areasbox.h"

class LanguageScrollBox LanguageScrollBox_obj;

/* external objects */
extern class Utility2 Utility2_obj;
extern class Sysinfo Sysinfo_obj;
extern class Crc Crc_obj;

/* external variables */
extern struct amucfg amu_cfgvar;
extern struct amuhdr amu_hdrvar;


/**************************************************************************/

int Language::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 6;
    cvar.width = 60;
    cvar.left = 10;
    cvar.top = 9;
    cvar.position = 2;
    cvar.high_num = 15;
    do
    {
	Menu_obj.help("Language configuration; F3 - Copy");
	if(index > amu_hdrvar.num_language)
	{
	    index = 1;
	}
	if(index < 1)
	{
	    index = amu_hdrvar.num_language;
	}
	Sysinfo_obj.read_language_record(index);
	sprintf(str, "Languages - Record %d/%d", index, amu_hdrvar.num_language);
	if(Sysinfo_obj.languagevar.deleted)
	{
	    strcat(str, " [Deleted]");
	}
	cvar.title = str;
	cvar.options = options();
	i = Menu_obj.dialog(&cvar, ENTER);
	switch(i)
        {
            case LEFT: index--;
                       break;
	    case RIGHT: index++;
			break;
	    case ENTER: cvar.position = 2;
			break;
	    case HOME: index = 1;
		       break;
	    case END: index = amu_hdrvar.num_language;
		      break;
	    case DEL: Utility2_obj.toggle(&Sysinfo_obj.languagevar.deleted);
		      Sysinfo_obj.update_language_record(index);
		      break;
	    case INS: setmem(&Sysinfo_obj.languagevar, LOG_SIZE, NULL);
		      Sysinfo_obj.add_language_record();
		      index = amu_hdrvar.num_language;
		      break;
	    case F3: Sysinfo_obj.add_language_record();
		     index = amu_hdrvar.num_language;
		     break;
            case ESC: return(i);
        }
        if(i == ENTER)
        {
            crc = Crc_obj.struct_crc((char *) &Sysinfo_obj.languagevar, LANGUAGE_SIZE);
            strcpy(str, "Languages configuration");
            cvar.title = str;
	    Menu_obj.set_help(LANGUAGE_HELP);
            do
            {
                cvar.options = options();
                i = Menu_obj.listbox_1(&cvar);
                switch(i)
                {
                    case ENTER: action(cvar.position);
                                break;
                }
            }while(i != ESC);
            if(crc != Crc_obj.struct_crc((char *) &Sysinfo_obj.languagevar, LANGUAGE_SIZE)  &&  Menu_obj.prompt(0))
            {
		Sysinfo_obj.update_language_record(index);
            }
            i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
        }
    }while(i != ESC);
    return(i);
}

char *Language::options(void)
{
    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Language name   : ");
    strcat(optionsstr, Sysinfo_obj.languagevar.name);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Filename        : ");
    strcat(optionsstr, Sysinfo_obj.languagevar.fname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Language text;");

    strcat(optionsstr, "Available       : ");
    strcat(optionsstr, Utility2_obj.YN(Sysinfo_obj.languagevar.enabled));

    strcat(optionsstr, "   ;");
    return(optionsstr);
}

void Language::action(int position)
{
    char *tmpbuf;
    int offset;
    class Menus Menus_obj;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
        case 2: Menus_obj.set_validtype(SPACES_OK);
                strcpy(Sysinfo_obj.languagevar.name, Menus_obj.getfield(Sysinfo_obj.languagevar.name, cvar.left + offset, cvar.top + 2, 20));
                break;
        case 3: Menus_obj.set_validtype(NO_EXT);
		strcpy(Sysinfo_obj.languagevar.fname, Menus_obj.getfield(Sysinfo_obj.languagevar.fname, cvar.left + offset, cvar.top + 3, 40));
                break;
	case 4: LanguageScrollBox_obj.menu();
		break;
        case 5: Utility2_obj.toggle(&Sysinfo_obj.languagevar.enabled);
                break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/************************************************************************/
/* EOF - LNGMENU.CPP */