// Class specification for a templated double-link list
// Created 19 June 1998
// Revised 08 August 1998

#ifndef __LISTS_H__
#define __LISTS_H__

template <class TYPE>
class Double_List
{
    private:
    int True;                          // True value = 1
    int False;                         // False value = 0
    int Num_Elements;                  // Number of elements in the list
    struct item
    {
      TYPE *Element;                   // Pointer to the element
      struct item *Next;               // Next element
      struct item *Previous;           // Previous element
    };
    struct item *Top;                  // Pointer to the first element
    struct item *End;                  // Pointer to the last element
    struct item *Current;              // Pointer to the current element

    public:
    Double_List(void);                 // Default constructor
    ~Double_List(void);                // Destructor
    int insertElement(TYPE *element);  // Add an element to the list
    int deleteElement(TYPE *element);  // Delete an element from the list
    TYPE *getNext(void);               // Return the next element
    TYPE *getPrevious(void);           // Return the previous element
    int getNumElements(void);          // Return the number of elements
    void resetList(void);              // Reset 'current' to top of the list
    TYPE *getTop(void);                // Return the top element
    TYPE *getEnd(void);                // Return the last element
    TYPE *getCurrent(void);            // Return the current element
};

#endif
// EOF - LISTS.H