// Implementation for the templated double_list class
// Created 20 June 1998
// Revised 08 August 1998

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <mem.h>
#include "lists.h"

// Default constructor for a Double_List object
template<class TYPE>
Double_List<TYPE>::Double_List(void)
{
    Top = NULL;
    End = NULL;
    Current = NULL;
    Num_Elements = 0;
    True = 1;
    False = 0;
}

// Destructor for a Double_List object
template<class TYPE>
Double_List<TYPE>::~Double_List(void)
{
    struct item *Temp;

    // De-allocate the elements of the list
    Current = Top;
    while(Current != NULL)
    {
	Temp = Current -> Next;
	delete(Current->Element);
	delete(Current);
	Current = Temp;
    }
}

// Return the number of elements in the list
template<class TYPE>
int Double_List<TYPE>::getNumElements(void)
{
    return(Num_Elements);
}


// Insert 'element' into the list.
template<class TYPE>
int Double_List<TYPE>::insertElement(TYPE *element)
{
    int status;
    TYPE *new_element;
    struct item *new_item;

    // Attempt to allocate a new element
    new_item = new(struct item);
    new_element = new(TYPE);
    if(new_item == NULL || new_element == NULL)
    {
	if(new_item != NULL)
	{
	    delete(new_item);
	}
	if(new_element != NULL)
	{
	    delete(new_element);
	}
	status = False;
    }
    else
    {
	// Copy the contents of the incoming element into the newly allocated
	// element
	status = True;
	memcpy(new_element, element, sizeof(TYPE));
	new_item->Element = new_element;

	// See if the list is currently empty
	if(Top == NULL)
	{
	    new_item->Next = NULL;
	    new_item->Previous = NULL;
	    Top = new_item;
	    End = new_item;
	    Current = new_item;
	}
	else
	{
	    // Otherwise, add this element to the end of the list
	    End->Next = new_item;
	    new_item->Previous = End;
	    new_item->Next = NULL;
	    End = new_item;
	}
	Num_Elements++;
    }
    return(status);
}

// Remove 'element' from the list
template <class TYPE>
int Double_List<TYPE>::deleteElement(TYPE *element)
{
    int status;
    int found;
    int deleting_current;
    struct item *ptr;
    struct item *prev;
    struct item *next;

    found = False;
    deleting_current = False;

    // First check to see if the Current element matches element
    if(Current != NULL)
    {
	if(Current->Element == element)
	{
	    found = True;
	    ptr = Current;
	    deleting_current = True;
	}
    }

    // The current element wasn't it, so search the list
    if(found == False)
    {
	ptr = Top;
	while(ptr != NULL)
	{
	    if(ptr->Element == element)
	    {
		found = True;
	    }
	    else
	    {
		ptr = ptr->Next;
	    }
	}
    }

    if(found == True)
    {
	status = True;

	// If we're deleting the current element, reset Current to the next
	// element.  If we're at the end of the list, set it to the Top
	if(deleting_current == True)
	{
	    if(Current == End)
	    {
		Current = Top;
	    }
	    else
	    {
		Current = Current->Next;
	    }
	}

	// See if we're deleting the Top or End element
	if(Top == ptr)
	{
	  Top = Top->Next;
	}
	if(End == ptr)
	{
	  End = End->Previous;
	}

	//
	// Now remove the element and free it
	//

	// Save the next and previous pointers
	next = ptr->Next;
	prev = ptr->Previous;

	if(prev != NULL)
	{
	    prev->Next = next;
	}
	if(next != NULL)
	{
	    next->Previous = prev;
	}

	// Get rid of the element
	delete(ptr->Element);
	delete(ptr);
	Num_Elements--;
    }
    else
    {
	status = False;
    }
    return(status);
}


// Return the Next element in the list
template <class TYPE>
TYPE *Double_List<TYPE>::getNext(void)
{
    if(Current == NULL)
    {
	return(NULL);
    }
    Current = Current->Next;
    return(getCurrent());
}

// Return the previous element in the list
template <class TYPE>
TYPE *Double_List<TYPE>::getPrevious(void)
{
    if(Current == NULL)
    {
	return(NULL);
    }
    Current = Current->Previous;
    return(getCurrent());
}

// Reset the 'current' pointer to the top of the list
template <class TYPE>
void Double_List<TYPE>::resetList(void)
{
    Current = Top;
}

// Return the current element
template <class TYPE>
TYPE *Double_List<TYPE>::getCurrent(void)
{
    if(Current == NULL)
    {
	return(NULL);
    }
    return(Current->Element);
}

// Return the first element
template <class TYPE>
TYPE *Double_List<TYPE>::getTop(void)
{
    Current = Top;
    return(getCurrent());
}


// Return the last element
template <class TYPE>
TYPE *Double_List<TYPE>::getEnd(void)
{
    Current = End;
    return(getCurrent());
}


//************************************************************************


struct test_item
{
  int field1;
  int field2;
};

void main(void)
{
    struct test_item item, *ptr;
    class Double_List<struct test_item> list;

    item.field1 = 10;
    item.field2 = 11;
    list.insertElement(&item);

    item.field1 = 20;
    item.field2 = 21;
    list.insertElement(&item);

    item.field1 = 30;
    item.field2 = 31;
    list.insertElement(&item);

    printf("List of %d elements:\n", list.getNumElements());

    ptr = list.getTop();
    while(ptr != NULL)
    {
	printf("field1 = %d\n", ptr->field1);
	printf("field2 = %d\n\n", ptr->field2);
	ptr = list.getNext();
    }

    item.field1 = 40;
    item.field2 = 41;
    printf("Removing second element\n");
    ptr = list.getTop();
    ptr = list.getNext();
    list.deleteElement(ptr);
    list.insertElement(&item);
    ptr = list.getTop();
    while(ptr != NULL)
    {
	printf("field1 = %d\n", ptr->field1);
	printf("field2 = %d\n\n", ptr->field2);
	ptr = list.getNext();
    }

}



// EOF - LISTS.CPP


