// Functions for the Allfiles/Newfiles menu
// Created 05 January 1996
// Revised 26 November 1997

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include "extern.h"
#include "menus.h"
#include "ListMenu.h"
#include "utility2.h"
#include "crc.h"
#include "listbox.h"
#include "config.h"
#include "amuidx.h"

/* external objects */
extern class Utility2 Utility2_obj;
extern class Config Config_obj;
extern class AreasBox AreasBox_obj;
extern class Crc Crc_obj;
extern class Menus Menus_obj;
extern listbox *filelistbox;
extern int check_bbsfiles(int force_import);

/**************************************************************************/

int ListMenu::menu(void)
{
    long crc, crc2;
    int i, index;
    char str[41];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 18;
    cvar.width = 71;
    cvar.left = 3;
    cvar.top = 4;
    cvar.position = 2;
    cvar.high_num = 16;
    Config_obj.open_config(ALLFILE_RECORD);
    do
    {
        Menus_obj.help("Allfiles/Newfiles options - F3 Copy");
        Menus_obj.set_help(ALLNEW_HELP);
        if(index > Config_obj.num_lists)
        {
            index = 1;
        }
        if(index < 1)
        {
            index = Config_obj.num_lists;
        }
        Config_obj.read_record(ALLFILE_RECORD, index);
        sprintf(str, "Listings - Record %d/%d", index, Config_obj.num_lists);
        if(Config_obj.allnewvar.deleted)
        {
	    strcat(str, " [Deleted]");
        }
        cvar.title = str;
        cvar.options = options();
        i = Menus_obj.dialog(&cvar, ENTER, 1);
        switch(i)
        {
            case LEFT: index--;
                       break;
            case RIGHT: index++;
                        break;
                 case ENTER: cvar.position = 2;
                        break;
                 case HOME: index = 1;
                                 break;
                 case END: index = Config_obj.num_lists;
                                break;
                 case DEL: Utility2_obj.toggle(&Config_obj.allnewvar.deleted);
                                Config_obj.update_record(ALLFILE_RECORD, index);
                                break;
                 case INS: Config_obj.add_record(ALLFILE_RECORD, ADD_NEW_RECORD);
			   index = Config_obj.num_lists;
                           break;
                 case F1   : Menus_obj.online_help(FILELIST_MANAGER);
                             break;
                 case F3: Config_obj.add_record(ALLFILE_RECORD, COPY_CUR_RECORD);
                          index = Config_obj.num_lists;
                          break;
            case ESC: Config_obj.close_config(ALLFILE_RECORD);
                      return(i);
        }
        if(i == ENTER)
        {
            crc = Crc_obj.struct_crc((char *) &Config_obj.allnewvar, ALLNEW_SIZE);
            crc2 = Crc_obj.struct_crc((char *) &Config_obj.areasvar, AREAS_SIZE);
            strcpy(str, "Allfiles/Newfiles options");
            cvar.title = str;
            do
            {
                cvar.options = options();
                Menus_obj.set_help(ALLNEW_HELP);
		i = Menus_obj.display_menu(&cvar, 1);
		switch(i)
                {
                    case ENTER: action(cvar.position);
                                break;
                    case F1   : Menus_obj.online_help(FILELIST_MANAGER);
                                break;
                }
            }while(i != ESC);
            if((crc != Crc_obj.struct_crc((char *) &Config_obj.allnewvar, sizeof(Config_obj.allnewvar))
                ||  crc2 != Crc_obj.struct_crc((char *) &Config_obj.areasvar, sizeof(Config_obj.areasvar)))
                &&  Menus_obj.prompt(0))
            {
                Config_obj.update_record(ALLFILE_RECORD, index);
            }
            i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
        }
    }while(i != ESC);
    Config_obj.close_config(ALLFILE_RECORD);
    return(i);
}

char *ListMenu::options(void)
{
    char tmpstr[11];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Listing type    : ");
    if(Config_obj.allnewvar.type == 0)
    {
        strcat(optionsstr, "Allfiles;");
    }
    else
    {
        strcat(optionsstr, "Newfiles;");
    }

    strcat(optionsstr, "Text version    : ");
    strcat(optionsstr, Config_obj.allnewvar.txtname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Archive version : ");
    strcat(optionsstr, Config_obj.allnewvar.arcname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Main header     : ");
    strcat(optionsstr, Config_obj.allnewvar.main_hdr);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Main footer     : ");
    strcat(optionsstr, Config_obj.allnewvar.main_ftr);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Area header     : ");
         strcat(optionsstr, Config_obj.allnewvar.area_hdr);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Area footer     : ");
    strcat(optionsstr, Config_obj.allnewvar.area_ftr);
    strcat(optionsstr, ";");

    strcat(optionsstr, "List format     : ");
    strcat(optionsstr, Config_obj.allnewvar.list_format);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Include comments: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.allnewvar.add_comments));

    strcat(optionsstr, "Compress        : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.allnewvar.compress));

    strcat(optionsstr, " Format        : ");
    strcat(optionsstr, Utility2_obj.arctype_str(Config_obj.allnewvar.arctype));
    strcat(optionsstr, ";");

    strcat(optionsstr, "Delete          : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.allnewvar.erase));

    strcat(optionsstr, "Age             : ");

    if(Config_obj.allnewvar.type == 0)
    {
        strcat(optionsstr, "n/a;");
    }
	 else
    {
	itoa(Config_obj.allnewvar.age, tmpstr, 10);
        strcat(optionsstr, tmpstr);
        strcat(optionsstr, ";");
    }

    strcat(optionsstr, "Date to use     : ");
    if((Config_obj.allnewvar.type == 1)  &&  (Config_obj.amu_cfgvar.BBStype == RA2  || Config_obj.amu_cfgvar.BBStype == RA250 ||
	Config_obj.amu_cfgvar.BBStype == LORA3 || Config_obj.amu_cfgvar.BBStype == TG310 || Config_obj.amu_cfgvar.BBStype == TG3 ||
	Config_obj.amu_cfgvar.BBStype == EZ))
    {
	switch(Config_obj.allnewvar.ulordos)
	{
	    case USE_ULDATE: strcat(optionsstr, "Upload date;");
			     break;
	    case USE_FILEDATE: strcat(optionsstr, "File date;");
			       break;
		 default: strcat(optionsstr, "Unknown;");
		     break;
	}
    }
    else
    {
	strcat(optionsstr, "n/a;");
    }


    strcat(optionsstr, "Areas ---->       ;");

    strcat(optionsstr, "Enabled         : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.allnewvar.enabled));

         strcat(optionsstr, "   ;");
         return(optionsstr);
}

void ListMenu::action(int position)
{
    char *tmpbuf, tmpstr[11], str[81];
    struct coordinates c;
    int offset, x;

    offset = 20;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    x = 0;
    switch(position)
    {
        case 2: Utility2_obj.toggle(&Config_obj.allnewvar.type);
                break;
        case 3: Menus_obj.set_validtype(FILENM);
                strcpy(Config_obj.allnewvar.txtname, Menus_obj.getfield(Config_obj.allnewvar.txtname, cvar.left + offset, cvar.top + 3, 40));
                x = 3;
                break;
        case 4: Menus_obj.set_validtype(FILENM);
                strcpy(Config_obj.allnewvar.arcname, Menus_obj.getfield(Config_obj.allnewvar.arcname, cvar.left + offset, cvar.top + 4, 40));
                x = 4;
                break;
        case 5: Menus_obj.set_validtype(FILENM);
                strcpy(Config_obj.allnewvar.main_hdr, Menus_obj.getfield(Config_obj.allnewvar.main_hdr, cvar.left + offset, cvar.top + 5, 40));
                break;
        case 6: Menus_obj.set_validtype(FILENM);
                strcpy(Config_obj.allnewvar.main_ftr, Menus_obj.getfield(Config_obj.allnewvar.main_ftr, cvar.left + offset, cvar.top + 6, 40));
                break;
	case 7: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.allnewvar.area_hdr, Menus_obj.getfield(Config_obj.allnewvar.area_hdr, cvar.left + offset, cvar.top + 7, 40));
		break;
	case 8: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.allnewvar.area_ftr, Menus_obj.getfield(Config_obj.allnewvar.area_ftr, cvar.left + offset, cvar.top + 8, 40));
		break;
	case 9: Menus_obj.set_validtype(SPACES_OK);
		strcpy(Config_obj.allnewvar.list_format, Menus_obj.getfield(Config_obj.allnewvar.list_format, cvar.left + offset, cvar.top + 9, 54));
		break;
	case 10: Utility2_obj.toggle(&Config_obj.allnewvar.add_comments);
		 break;
	case 11: Utility2_obj.toggle(&Config_obj.allnewvar.compress);
		 break;
	case 12: Menus_obj.arctype_toggle(&Config_obj.allnewvar.arctype);
		 break;
	case 13: Utility2_obj.toggle(&Config_obj.allnewvar.erase);
		 break;
	case 14: if(Config_obj.allnewvar.type == 1)
		 {
			  Menus_obj.set_validtype(RANGE_3);
			  itoa(Config_obj.allnewvar.age, tmpstr, 10);
			  strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + 14, 5));
			  Config_obj.allnewvar.age = atoi(tmpstr);
                 }
                 break;
        case 15: Utility2_obj.toggle(&Config_obj.allnewvar.ulordos);
                 break;
	case 16: AreasBox_obj.display_listbox(filelistbox, "Select file areas", 50);
                 break;
        case 17: Utility2_obj.toggle(&Config_obj.allnewvar.enabled);
                 break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);

    c.uses_blanks = FALSE;
    c.top = 10;
    c.high_num = 0;
    c.title = NULL;
    c.options = str;
    c.left = 20;
    c.width = 45;
    c.items = 3;
    sprintf(str, "  ;Text name and Arc name can't be the same;  ;");
    tmpbuf = (char *) malloc(4000);

    if(strcmp(Config_obj.allnewvar.arcname, Config_obj.allnewvar.txtname) == 0 && x != 0)
    {
        gettext(1, 1, 80, 25, tmpbuf);
	Menus_obj.dialog(&c, ' ', 1);
        puttext(1, 1, 80, 25, tmpbuf);
        action(x);
    }
    free(tmpbuf);
}


/**************************************************************************/
/* EOF LISTMENU.CPP */
