/* Include file for ListBox class */
/* Created 14 April 1996          */
/* Last updated 22 July 1997      */

#if !defined (__LISTBOX_H__)

#define __LISTBOX_H__

#define OTHER   0
#define MSGBOX  1
#define FILEBOX 2

// The number of file/message areas to read at a time
#define NUM_AREAS_TO_READ 50

struct listarray
{
    char itemname[81];
    short itemnum;
    struct listarray *nextrec;
};

typedef struct listarray listbox;

class ListBox
{
    protected:
    char optionsstr[2000];
    int Num_Items, Max_Options, Position, Begin_Area, End_Area;
    int Width, Left, Top, Return_Item;
    listbox *currec, *prevrec, *tmprec;

    public:
    listbox *create_listbox(void);
    int additem(listbox *newitem, listbox **listptr);
    int display_listbox(listbox *listptr, char *title, int width);
    void destroy_listbox(listbox **listptr);
    int item_count(listbox *listptr);
    listbox *get_item(listbox *listptr, int item_num);
    int item_exists(listbox *listptr, char *str);

    private:
    virtual void handle_ENTER_SPACE(void);
    virtual void format_itemname(char *item, int x);
    virtual void handle_F4(listbox *listptr);
    virtual void handle_F5(listbox *listptr);

    protected:
    void Display_Help(void);
    void makestr(int begin, int end, listbox *listptr);
    void handle_F2(void);
    void handle_F3(void);
    void handle_UP(void);
    void handle_DOWN(void);
    void handle_HOME(void);
    void handle_END(void);
    void handle_PGDN(void);
    void handle_PGUP(void);
};

class AreasBox : public ListBox
{
    private:
    void handle_F4(listbox *listptr);
    void handle_F5(listbox *listptr);
    void format_itemname(char *item, int x);
    void handle_ENTER_SPACE(void);
};

class OnlineBox : public ListBox
{
    private:
    void format_itemname(char *item, int x);
};

#endif

/**********************************************************************/

/* EOF - LISTBOX.H */
