// Functions for displaying a scroll-box for file/message areas
// Created 24 August 1996
// Updated 18 March 1998

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <share.h>
#include "menus.h"
#include "amustr.h"
#include "listbox.h"
#include "config.h"
#include "crc.h"
#include "extern.h"

extern class Crc Crc_obj;
extern class Menus Menus_obj;
extern class Amustr Amustr_obj;
extern class Config Config_obj;

extern int read_msgarray(int begin);
extern int read_filearray(int begin);

/* external variables */
#if defined(AMUCFG)
extern listbox *filelistbox, *msglistbox;
#endif

/************************************************************************/
/* Create a new ListBox.  Copy the contents of listinfoptr to infovar   */
listbox *ListBox::create_listbox(void)
{
    currec = prevrec = NULL;
    Num_Items = 0;
    return(NULL);
}

/**************************************************************************/
/* Add 'newitem' to the list.  Return TRUE if successful, FALSE otherwise */
int ListBox::additem(listbox *newitem, listbox **listptr)
{
    currec = (listbox *)calloc(1, sizeof(listbox));
    if(!currec)
    {
	printf("\nOut of memory!\n");
	exit(255);
    }
    if(!*listptr)
    {
	*listptr = currec;
    }
    if(prevrec)
    {
	prevrec -> nextrec = currec;
    }
    prevrec = currec;
    strcpy(currec -> itemname, newitem -> itemname);
    currec -> itemnum = newitem -> itemnum;
    Num_Items++;
    return(TRUE);
}


/***********************************************************************/
/* Free the listbox */
void ListBox::destroy_listbox(listbox **listptr)
{
    currec = *listptr;
    while(currec)
    {
	tmprec = currec;
	currec = currec -> nextrec;
	free(tmprec);
    }
    *listptr = NULL;
}

/************************************************************************/
/* Display the listbox, return the number of the item selected, or -1
   if ESCape was pressed */
int ListBox::display_listbox(listbox *listptr, char *title, int width)
{
    int key_pressed, type, loaded_beginning, loaded_end;
    char *tmpbuf;


    // Save the screen and restore it when the routine finishes */
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);

    type = OTHER;
    item_count(listptr);
    loaded_beginning = 1;
    loaded_end = NUM_AREAS_TO_READ;

#if defined(AMUCFG)
    if(listptr == filelistbox)
    {
	if(Config_obj.num_filearea > Num_Items)
	{
	    Num_Items = Config_obj.num_filearea;
	}
	type = FILEBOX;
    }
    if(listptr == msglistbox)
    {
	if(Config_obj.num_msgarea > Num_Items)
	{
	    Num_Items = Config_obj.num_msgarea;
	}
	type = MSGBOX;
    }
#endif

    Position = Begin_Area = 1;
    Max_Options = End_Area = 15;
    Width = width;
    Left = (80 - width) / 2;
    Top = 6;
    Return_Item = -1;

    if(Max_Options > Num_Items)
    {
	Max_Options = End_Area = Num_Items;
    }

    do
    {
	if(type != OTHER && (loaded_beginning > Begin_Area ||
	   loaded_end < End_Area))
	{
	    loaded_beginning = Begin_Area;
	    loaded_end = loaded_beginning + NUM_AREAS_TO_READ;
#if defined(AMUCFG)
	    switch(type)
	    {
		case FILEBOX: read_filearray(Begin_Area);
			      listptr = filelistbox;
			      if(Config_obj.num_filearea > Num_Items)
			      {
				  Num_Items = Config_obj.num_filearea;
			      }
			      break;
		case MSGBOX : read_msgarray(Begin_Area);
			      listptr = msglistbox;
			      if(Config_obj.num_msgarea > Num_Items)
			      {
				  Num_Items = Config_obj.num_msgarea;
			      }
			      break;
	    }
#endif
	}

	Display_Help();
	makestr(Begin_Area, End_Area, listptr);
	Menus_obj.writemenu(optionsstr, title, Left, Top, Width, 1, Max_Options, Position, 0);
	key_pressed = getch();
	if(key_pressed == 0)
	{
	    key_pressed = getch();
	    switch(key_pressed)
	    {
		case F2  : handle_F2();
			   break;
		case F3  : handle_F3();
			   break;
		case F4  : handle_F4(listptr);
			   break;
		case F5  : handle_F5(listptr);
			   break;
		case UP  : handle_UP();
			   break;
		case DOWN: handle_DOWN();
			   break;
		case HOME: handle_HOME();
			   break;
		case END : handle_END();
			   break;
		case PGDN: handle_PGDN();
			   break;
		case PGUP: handle_PGUP();
			   break;
	    }
	}
	else
	{
	    if(key_pressed == ENTER  ||  key_pressed == SPACE)
	    {
		handle_ENTER_SPACE();
		if(Return_Item != -1)
		{
//		    return(Return_Item);
		    break;
		}
	    }
	}
    } while(key_pressed != ESC);
#if defined(AMUCFG)
    switch(type)
    {
	case FILEBOX: destroy_listbox(&filelistbox);
		      read_filearray(1);
		      break;
	case MSGBOX : destroy_listbox(&msglistbox);
		      read_msgarray(1);
		      break;
    }
#endif
    puttext(1, 1, 80, 25, tmpbuf);
    return(Return_Item);
}

/**********************************************************************/
/* Generate a string with all of the areas between 'begin' and 'end' */
void ListBox::makestr(int begin, int end, listbox *listptr)
{
    char itemname[81];
    int x;

    currec = listptr;
    while(currec && currec -> itemnum != begin)
    {
	currec = currec -> nextrec;
    }

    memset(optionsstr, NULL, sizeof(optionsstr));
    for(x = begin; x <= end; x++)
    {
	if(!currec)
	{
	    break;
	}
	strcpy(itemname, currec -> itemname);
	format_itemname(itemname, x);
	strcat(optionsstr, itemname);
	strcat(optionsstr, ";");
	currec = currec -> nextrec;
    }
}

/************************************************************************/
/* Format the itemname properly for a box where one item is selected */
void ListBox::format_itemname(char *item, int x)
{
    char tmpnum[5], tmpstr[65];

    sprintf(tmpnum, "%d", x);
    Amustr_obj.lpad(tmpnum, 4);
    if(*item == NULL)
    {
	sprintf(tmpstr, "   %s  [Unused]", tmpnum);
    }
    else
    {
	sprintf(tmpstr, "   %s  %s", tmpnum, item);
    }
    Amustr_obj.pad(tmpstr, 45);
    strcpy(item, tmpstr);
}

/************************************************************************/
/* Find out how many items are in this list box                         */
/************************************************************************/
int ListBox::item_count(listbox *listptr)
{
    Num_Items = 0;
    while(listptr)
    {
	Num_Items++;
	listptr = listptr -> nextrec;
    }
    return(Num_Items);
}

/************************************************************************/
/* Return the given item from the listbox                               */
/************************************************************************/
listbox *ListBox::get_item(listbox *listptr, int item_num)
{
    while(listptr)
    {
	if(item_num == listptr -> itemnum)
	{
	    return(listptr);
	}
	listptr = listptr -> nextrec;
    }
    return(NULL);
}

/************************************************************************/
/* See if the given string exists in the listbox or if the input string */
/* is blank.                                                            */
/************************************************************************/
int ListBox::item_exists(listbox *listptr, char *str)
{
    if(*str == NULL)
    {
	return(TRUE);
    }

    while(listptr)
    {
	if(strstr(listptr -> itemname, str))
	{
	    return(TRUE);
	}
	listptr = listptr -> nextrec;
    }
    return(FALSE);
}


/************************************************************************/
/* Handle an F2 key pressed */
/************************************************************************/
void ListBox::handle_F2(void)
{
    memset(&Config_obj.areasvar, 0xFF, AREAS_SIZE);
}

/************************************************************************/
/* Handle an F3 key pressed                                             */
/************************************************************************/
void ListBox::handle_F3(void)
{
    memset(&Config_obj.areasvar, 0, AREAS_SIZE);
}

/************************************************************************/
/* Handle an F4 key pressed                                             */
/************************************************************************/
#pragma argsused
void ListBox::handle_F4(listbox *listptr)
{
}

/************************************************************************/
/* Handle an F5 key pressed                                             */
/************************************************************************/
#pragma argsused
void ListBox::handle_F5(listbox *listptr)
{
}

/************************************************************************/
/* Handle an UP arrow key pressed                                       */
/************************************************************************/
void ListBox::handle_UP(void)
{
    if(Position == 1)
    {
	/* If we're already at the Top,
	   we need to get a little fancy... */
	if(Begin_Area-1 > 0)
	{
	    Begin_Area--;
	    End_Area--;
	}
    }
    else
    {
	Position--;
    }
}

/************************************************************************/
/* Handle a DOWN arrow key pressed                                      */
/************************************************************************/
void ListBox::handle_DOWN(void)
{
    if(Position == Max_Options)
    {
	/* If we're already at the bottom,
	   we need to get a little fancy...*/
	if(End_Area + 1 <= Num_Items)
	{
	    Begin_Area++;
	    End_Area++;
	}
    }
    else
    {
	Position++;
    }
}

/************************************************************************/
/* Handle a HOME key pressed                                            */
/************************************************************************/
void ListBox::handle_HOME(void)
{
    Position = 1;
    Begin_Area = 1;
    End_Area = Max_Options;
}

/************************************************************************/
/* Handle an END key pressed                                            */
/************************************************************************/
void ListBox::handle_END(void)
{
    Position = Max_Options;
    Begin_Area = Num_Items - Max_Options + 1;
    End_Area = Num_Items;
}

/************************************************************************/
/* Handle a PGDN key pressed                                            */
/************************************************************************/
void ListBox::handle_PGDN(void)
{
    Position = 1;
    Begin_Area += Max_Options;
    End_Area += Max_Options;
    if(End_Area >= Num_Items)
    {
	Begin_Area = (Num_Items - Max_Options) + 1;
	End_Area = Begin_Area + Max_Options - 1;
	Position = Max_Options;
    }
}

/************************************************************************/
/* Handle a PGUP key pressed                                            */
/************************************************************************/
void ListBox::handle_PGUP(void)
{
    Position = 1;
    Begin_Area -= Max_Options;
    End_Area -= Max_Options;
    if(Begin_Area < 1)
    {
	Begin_Area = 1;
	End_Area = Max_Options;
    }
}

/************************************************************************/
/* Handle a ENTER/SPACE key pressed                                     */
/************************************************************************/
void ListBox::handle_ENTER_SPACE(void)
{
    Return_Item = Begin_Area + Position - 1;
}

/************************************************************************/
/* Display the appropriate help line for this class                     */
/************************************************************************/
void ListBox::Display_Help(void)
{
    Menus_obj.help("F2 - Global ON; F3 - Global OFF; F4 Range of areas ON; F5 Range of areas OFF");
}


/*************************************************************************/


     /******************************************************************/
     /*                         AreasBox class                          */
     /******************************************************************/


/************************************************************************/
/* Format the itemname properly for a box where multiple items are picked */
/************************************************************************/
void AreasBox::format_itemname(char *item, int x)
{
    char tmpstr[65], tmpnum[5];

    sprintf(tmpnum, "%d", x);
    Amustr_obj.lpad(tmpnum, 4);
    if(*item == NULL)
    {
	/* If this is an unused area and it's active, turn it off */
	sprintf(tmpstr, "   %s  [Unused]", tmpnum);
	if(Config_obj.active(x))
	{
	    Config_obj.togglearea(x);
	}
    }
    else
    {
	sprintf(tmpstr, "   %s  %s", tmpnum, item);
    }
    Amustr_obj.pad(tmpstr, 45);
    if(Config_obj.active(x))
    {
	tmpstr[1] = '';
    }
    strcpy(item, tmpstr);
}

/************************************************************************/
/* Handle an F4 key pressed                                             */
/************************************************************************/
void AreasBox::handle_F4(listbox *listptr)
{
    int start_point, end_point, x;
    class ListBox ListBox_obj;

    start_point = ListBox_obj.display_listbox(listptr, "Start area", 50);
    end_point = ListBox_obj.display_listbox(listptr, "End area", 50);
    if(start_point > 0  &&  end_point > 0)
    {
	for(x = start_point; x <= end_point; x++)
	{
	    if(!Config_obj.active(x))
	    {
		Config_obj.togglearea(x);
	    }
	}
    }
}

/************************************************************************/
/* Handle an F5 key pressed                                             */
/************************************************************************/
void AreasBox::handle_F5(listbox *listptr)
{
    int start_point, end_point, x;
    class ListBox ListBox_obj;

    start_point = ListBox_obj.display_listbox(listptr, "Start area", 50);
    end_point = ListBox_obj.display_listbox(listptr, "End area", 50);
    if(start_point > 0  &&  end_point > 0)
    {
	for(x = start_point; x <= end_point; x++)
	{
	    if(Config_obj.active(x))
	    {
		Config_obj.togglearea(x);
	    }
	}
    }
}

/************************************************************************/
/* Handle a ENTER/SPACE key pressed                                     */
/************************************************************************/
void AreasBox::handle_ENTER_SPACE(void)
{
    Config_obj.togglearea(Begin_Area + Position - 1);
}

/************************************************************************/
/* Format the itemname properly for a box where one item is selected */
#pragma argsused
void OnlineBox::format_itemname(char *item, int x)
{
//    strcpy(item, tmpstr);
}

/*************************************************************************/
/* EOF - LISTBOX.CPP */
