#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <conio.h>
#include <share.h>
#include <direct.h>
#include <dos.h>
#include <dir.h>
#include "bbsinfo.h"
#include "menus.h"
#include "amustr.h"
#include "utility2.h"
#include "utility2.h"
#include "crc.h"
#include "screen.h"
#include "config.h"
#include "install.h"

class BBSInfo BBSInfo_obj;
class Screen Screen_obj;
class Utility2 Utility2_obj;
class Menus Menus_obj;
class Config Config_obj;
class Amustr Amustr_obj;
class Utility Utility_obj;
class Crc Crc_obj;

int use_mono = FALSE;

void installexe(char *exename);
void main_menu(void);
void welcome(void);
void color(int back, int fore);
void get_installpath(void);
void ask_install(void);

#pragma argsused
void main(int argc, char *argv[])
{
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

    _splitpath(argv[0], drive, dir, fname, ext);
    sprintf(curdir, "%s%s", drive, dir);
    window(1, 1, 80, 25);
    clrscr();
    _setcursortype(_NOCURSOR);
    installexe(argv[0]);
    _setcursortype(_NORMALCURSOR);
}

void installexe(char *exename)
{
    class Menus Menu_obj;
    struct ftime t;
    FILE *exefile, *outfile;
    long num_to_read, left_over;
    short index, ok = 0, bad = 0;
    char fn[81], str[71], *tmpbuf;
    struct coordinates cvar;

    main_menu();
    welcome();
    get_installpath();

    exefile = _fsopen(exename, "rb", SH_DENYWR);
    if(!exefile)
    {
	sprintf(str, "Unable to open %s", exename);
	Menu_obj.help(str);
	return;
    }
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);

    cvar.uses_blanks = TRUE;
    cvar.items = 10;
    cvar.width = 45;
    cvar.left = 16;
    cvar.top = 7;
    cvar.position = 4;
    cvar.high_num = 0;
    cvar.title = NULL;
    strcpy(str, " ; ; ; ; ; ; ; ; ; ;");
    cvar.options = str;
    Menus_obj.dialog(&cvar, DEL, 1);
    window(cvar.left + 2, cvar.top + 1, cvar.left + cvar.width - 2, cvar.top + cvar.items - 1);
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
    clrscr();

    fseek(exefile, filelength(fileno(exefile)) - sizeof(struct data_rec) * MAX_FILES, SEEK_SET);
    fread(&datavar[0], sizeof(struct data_rec), MAX_FILES, exefile);
    fseek(exefile, datavar[0].exefilesize, SEEK_SET);
    for(index = 0; index < MAX_FILES; index++)
    {
	if(!datavar[index].filename[0])
	{
	    break;
	}

	sprintf(fn, "%s%s", installpath, datavar[index].filename);
	outfile = _fsopen(fn, "w+b", SH_DENYRW);
	if(!outfile)
	{
	    textcolor(LIGHTRED);
	    sprintf(str, "! Unable to create %s", fn);
	    cprintf("%s\r\n", fn);
	    bad++;
	}
	else
	{
	    textcolor(LIGHTGREEN);
	    sprintf(str, "Installing %s", fn);
	    cprintf("%s\r\n", str);
	    ok++;
	    num_to_read = datavar[index].filesize / sizeof(buffer);
	    left_over = datavar[index].filesize % sizeof(buffer);
	    if(num_to_read != 0)
	    {
		do
		{
		    _read(fileno(exefile), buffer, sizeof(buffer));
		    _write(fileno(outfile), buffer, sizeof(buffer));
		    num_to_read--;
		}while(num_to_read > 0);
	    }
	    _read(fileno(exefile), buffer, left_over);
	    _write(fileno(outfile), buffer, left_over);
	    t.ft_year = 1998 - 1980;
	    t.ft_month = 6;
	    t.ft_day = 14;
	    t.ft_hour = 3;
	    t.ft_min = 16;
	    t.ft_tsec = 0;
	    setftime(fileno(outfile), &t);
	    fclose(outfile);
	}
    }
    fclose(exefile);
    textcolor(CYAN);
    cprintf("Installed: %d; Not installed: %d", ok, bad);

    cprintf("\r\n\r\n      Press any key to continue");
    getch();
    window(1, 1, 80, 25);
    #ifdef __OS2__
    puttext(1, 1, 80, 25, tmpbuf);
    ask_install();
    #else
    clrscr();
    printf("\n\n\n\n\n\n\n\n\n\n");
    printf("\t\t\tInstallation complete.\n");
/*
    printf("\tInstallation complete.  If you are running OS/2 and would like\n");
    printf("\tAMU installed on your desktop, open an OS/2 window and execute\n");
    printf("\tINSTALL.CMD which has been placed in your AMU directory.\n\n");
*/
    printf("\n\n\n\n\n\n\n\n");
    #endif

    free(tmpbuf);
}

/**************************************************************************/

void main_menu(void)
{
    int i;
    char ar[81];

    gotoxy(1, 1);
    for(i = 0; i < 80; i++)
      ar[i] = '';
    ar[80] = NULL;

    color(BLACK, LIGHTGRAY);
    for(i = 0; i < 25; i++)
    {
	gotoxy(1, i+1);
	cprintf("%s", ar);
    }
    gotoxy(1,1);
    color(BLACK, CYAN);
    sprintf(ar, "AMU %s - Installation", VERSION);
    Amustr_obj.center(ar);
    cprintf(" %s ", ar);
    gotoxy(1, 2);
    color(BLACK, BLUE);
    for(i = 0; i < 80; i++)
    {
	cprintf("");
    }

    gotoxy(1, 24);
    color(BLACK, BLUE);
    for(i = 0; i < 80; i++)
    {
        cprintf("");
    }
    Utility2_obj.get_screen();
}

void color(int back, int fore)
{
    textcolor(fore);
    textbackground(back);
}


/* Welcome screen */
void welcome(void)
{
    class Menus Menus_obj;
    char *dispstr, *tmpbuf;
    struct coordinates cvar;
    int i;

    cvar.uses_blanks = FALSE;
    dispstr = (char *) malloc(500);
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);

    sprintf(dispstr, " ;                    Welcome to AMU %s!;  ;  This program will install AMU onto your harddisk, or update  ;", VERSION);
    strcat(dispstr, "  the appropriate files if you are using an older version ;");
    strcat(dispstr, "  If you have not already done so, it is highly recommended ;");
    strcat(dispstr, "  that you make a backup of all vital data on your harddisk.  ;");
    strcat(dispstr, " ;         Press ESC to abort, or any other key to continue ; ;");

    cvar.options = dispstr;
    cvar.left = 9;
    cvar.width = 65;
    cvar.items = 10;
    cvar.top = 7;
    cvar.high_num = 0;
    cvar.title = NULL;
    i = Menus_obj.dialog(&cvar, ' ', 1);
    if(i == ESC)
    {
	clrscr();
	exit(0);
    }
    puttext(1, 1, 80, 25, tmpbuf);
}

void get_installpath(void)
{
    char *tmpbuf, str[400];
    class Menus Menus_obj;
    struct coordinates cvar;

    cvar.uses_blanks = TRUE;
    cvar.items = 5;
    cvar.width = 55;
    cvar.left = 12;
    cvar.top = 8;
    cvar.position = 4;
    cvar.high_num = 0;
    cvar.title = NULL;
    strcpy(str, " ;     Enter the directory to install AMU into: ; ; ; ;");

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    cvar.options = str;
    Menus_obj.dialog(&cvar, DEL, 1);
    Menus_obj.set_validtype(PATH);
    strcpy(installpath, Menus_obj.getfield(installpath, cvar.left + 7, cvar.top + 4, 40));
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}


/* Welcome screen */
void ask_install(void)
{
    class Menus Menus_obj;
    char *dispstr;
    struct coordinates cvar;
    int i, cur_disk;
    char disk;

    cvar.uses_blanks = FALSE;
    dispstr = (char *) malloc(500);
    strcpy(dispstr, " ;   Create folder for AMU on your desktop? (Y/n); ;");
    cvar.options = dispstr;
    cvar.left = 15;
    cvar.width = 51;
    cvar.items = 3;
    cvar.top = 10;
    cvar.high_num = 0;
    cvar.title = NULL;
    i = Menus_obj.dialog(&cvar, 'Y', 1);
    if(i == 'Y')
    {
	clrscr();
	if(installpath[0] != '\\')
	{
	    cur_disk = _getdrive();
	    disk = installpath[0];
	    _chdrive(disk-'A'+1);
	}
	Amustr_obj.noslash(installpath);
	chdir(installpath);
	system("INSTALL2.CMD");
	Amustr_obj.noslash(curdir);
	chdir(curdir);
	if(installpath[0] != '\\')
	{
	    _chdrive(cur_disk-'A'+1);
	}
    }
    else
    {
	clrscr();
    }
    free(dispstr);
}


/* EOF - INSTALL.CPP */
