/* Functions for the Information menu */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include "execute.h"
#include "infomenu.h"
#include "menus.h"
#include "sysinfo.h"
#include "utility2.h"

extern Utility2 Utility2_obj;
extern Sysinfo Sysinfo_obj;

int InfoMenu::menu(void)
{
    int i;
    class Menus Menu_obj;
    struct coordinates cvar;

    Menu_obj.set_help(I_HELP);
    cvar.uses_blanks = FALSE;
    cvar.position = 1;
    cvar.left = 5;
    cvar.width = 10;
    cvar.items = 4;
    cvar.top = 2;
    cvar.high_num = 0;
    cvar.title = NULL;
    cvar.options = options();
    Utility2_obj.put_screen();
    do
    {
        Menu_obj.help("General information");
        i = Menu_obj.listbox_1(&cvar);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1: f1help(cvar.position);
                     break;
        }
    }while(i != RIGHT  &&  i != LEFT  && i != ESC);
    switch(i)
    {
	case RIGHT: i = SYSTEM_M;
                    break;

        case LEFT: i = GENERAL_M;
                   break;

        case ESC: i = EXIT_M;
                  break;
    }
    return(i);
}

void InfoMenu::f1help(int position)
{
    /* Display the help window depending on which option is highlighted */
    switch(position)
    {
        case 1: Utility2_obj.read_help("Info->Product");
                break;
        case 2: Utility2_obj.read_help("Info->Switches");
                break;
        case 3: Utility2_obj.read_help("Info->Shell");
                break;
        case 4: Utility2_obj.read_help("Info->Exit");
                break;
   }
}

void InfoMenu::action(int position)
{
    class Execute Execute_obj;
    class Menus Menus_obj;
    char dispstr[251], *tmpbuf;
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
        case 1: sprintf(dispstr, "             %s;  ;   Copyright 1994 by David Hickey;  ;          All rights reserved;", Sysinfo_obj.get_version());
                strcat(dispstr, "  ;       Original visual interface;designed by Joaquim H. Homrighausen;  ;         Used with permission;  ;");
                cvar.options = dispstr;
		cvar.left = 23;
                cvar.width = 38;
                cvar.items = 11;
                cvar.top = 6;
                cvar.high_num = 0;
                cvar.title = NULL;
                Menus_obj.dialog(&cvar, ' ');
                break;
        case 2: sprintf(dispstr, "UPDATE - Update external programs;");
                strcat(dispstr, "EXPORT - Dump config to AMUCFG.TXT;");
                cvar.options = dispstr;
                cvar.left = 24;
                cvar.width = 38;
                cvar.items = 2;
                cvar.top = 10;
                cvar.high_num = 0;
                cvar.title = NULL;
                Menus_obj.dialog(&cvar, ' ');
                break;
        case 3: clrscr();
                _setcursortype(_NORMALCURSOR);
                Execute_obj.general_exec("", "");
                window(1, 1, 80, 25);
                _setcursortype(_NOCURSOR);
                chdir(Sysinfo_obj.get_curdir());
                break;
        case 4: free(tmpbuf);
                Utility2_obj.terminate();
                break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

char *InfoMenu::options(void)
{
    static char str[31];

    strcpy(str, "Product;Switches;Shell;Exit;");
    return(str);
}

/* EOF - INFOMENU.CPP */
