/* Functions to add file headers/footers to the file listings */
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include <share.h>
#include <dos.h>
#include <ctype.h>
#include <stdlib.h>
#include "amustr.h"
#include "sysinfo.h"
#include "utility.h"
#include "screen.h"
#include "files.h"
#include "datetime.h"
#include "headers.h"

/* external objects */
extern Sysinfo Sysinfo_obj;
extern Files Files_obj;
extern Amustr Amustr_obj;
extern Utility Utility_obj;
extern Screen Screen_obj;
extern DateTime DateTime_obj;

/* external variables */
extern struct amucfg amu_cfgvar;

/***************************************************************************/

Headers::Headers(void)
{
    HDR_DELIMATER[0] = 0XFF;
    HDR_DELIMATER[1] = NULL;
}


void Headers::addhead(void)
{
    char filename[81];
    FILE *hdrtxtfile;
    static long area;
    struct screeninfo *s;
    char *desc;

    s = (struct screeninfo *) calloc(1, sizeof(struct screeninfo));

    strcpy(s->internal, "Adding headers to file listings");
    strcpy(Utility_obj.LOGSTR, s->internal);
    Utility_obj.logentry();
    Screen_obj.display(s);

    if(!Sysinfo_obj.read_areas_record(ADDHDR)  ||  !Sysinfo_obj.read_files(0))
    {
        Utility_obj.logentry();
        free(s);
        Screen_obj.display_shutdown();
        return;
    }

    hdrtmpstr[0] = NULL;
    s->num_areas = Sysinfo_obj.FILE_SIZE;
    desc = (char *) malloc(DESC_LEN);
    for(area = 1; area <= Sysinfo_obj.FILE_SIZE; area++)
    {
        s->cur_area = area;
        Screen_obj.display(s);
        if(!Sysinfo_obj.read_files(area - 1))
        {
            Utility_obj.logentry();
        }
        else
        {
            if(Sysinfo_obj.active(area)  &&  Sysinfo_obj.farea_used())
            {
                s->length = Files_obj.get_length();
                strcpy(s->name, Sysinfo_obj.get_fname());
                Screen_obj.display(s);

                /* Try to open the file area */
                if(!Files_obj.open_f(area)  ||  !Files_obj.open_tmp(area))
                {
                    Utility_obj.logentry();
                }
                else
		{
		    topfilesize = topfiledls = totaldls = 0;
                    totalfiles = totalbytes = 0;
                    topfilename[0] = NULL;
                    Files_obj.read_f(-1, TRUE);
                    while(!Files_obj._EOF)
                    {
                        if(!Files_obj.is_comment())
                        {
			    if(!topfilename[0])
			    {
				strcpy(topfilename, Files_obj.get_fname());
				topfilesize = Files_obj.get_fsize();
				topfiledls = Files_obj.get_dls();
			    }
			    totalfiles++;
			    totalbytes += Files_obj.get_fsize();
			    totaldls += Files_obj.get_dls();
			    if(Files_obj.get_dls() > topfiledls)
			    {
				strcpy(topfilename, Files_obj.get_fname());
				topfilesize = Files_obj.get_fsize();
				topfiledls = Files_obj.get_dls();
			    }
			}
                        Files_obj.read_f(-1, TRUE);
                    }
                    Files_obj.rewind_f();

                /* Read from the header text file, process, then write to
                   the file area.  First check to see if the user has
                        defined a custom header for this area.
                */
                    sprintf(filename, "%sAMU%ld.HDR", amu_cfgvar.AMUpath, area);
                    hdrtxtfile = fopen(filename, "rt");
                    if(!hdrtxtfile)
                    {
                        sprintf(filename, "%sAMU.HDR", amu_cfgvar.AMUpath);
                        hdrtxtfile = fopen(filename, "rt");
                    }
                    if(!hdrtxtfile)
                    {
                        sprintf(Utility_obj.LOGSTR, "Could not open '%s' - (%s), no header added to area %ld", filename, _strerror(""), area);
                        Utility_obj.logentry();
                    }
                    else
                    {
                            /* Read the file area until no commented lines are found.
                               This prevents ADDHDR from adding an extra header each
                                         time it is run
                            */

                        fgets(hdrtmpstr, HDR_LEN, hdrtxtfile);
                        while(!feof(hdrtxtfile))
                        {
                            /* Make sure the user doesn't exceed 80 columns */
                            hdrtmpstr[HDR_LEN] = NULL;
                            Amustr_obj.strip_n(hdrtmpstr);

                            /* Get the header */
                            return_str(area);

                            /* Put a space on the front of the string so it shows up as a comment */
                            strrev(hdrtmpstr);
                            strncat(hdrtmpstr, " ", sizeof(hdrtmpstr) - strlen(hdrtmpstr));
                            strrev(hdrtmpstr);

                                 /* We have to make sure that blank lines in the
                               header don't get the space stripped */
                            if(strlen(hdrtmpstr) > 1)
                            {
                                Amustr_obj.trimend(hdrtmpstr);
                            }
                            strcat(hdrtmpstr, HDR_DELIMATER);
                            Files_obj.replace_desc(hdrtmpstr);

                            Files_obj.blank_FDB();
                            Files_obj.write_f();
                            fgets(hdrtmpstr, HDR_LEN, hdrtxtfile);
                        }
                        fclose(hdrtxtfile);
                    }

                    /* Copy the rest of the file listing to the temp files */
                    Files_obj.read_f(-1, FALSE);
                    while(!Files_obj._EOF)
                    {
                        s->cur_offset = Files_obj.get_curpos();
                        /* Prevent old headers from being copied into the new file list */
                        strcpy(desc, Files_obj.get_description());
                        Amustr_obj.strip_n(desc);
                        strrev(desc);
                        if(*desc != 0xFF)
                        {
                            Files_obj.write_f();
                        }
                        Files_obj.read_f(-1, FALSE);
                    }
                }
                Files_obj.close_f();
                Files_obj.rename_f(area);
            }
        }
    } /* End for loop */
    Screen_obj.display_shutdown();
    free(desc);
    free(s);
}


void Headers::return_str(long area)
{
    char str[151], *ptr, tmp[81], first, last;
    int i, length, _highascii;

     /* If the line read from the header file was blank, just get out
        of here
     */
    if(hdrtmpstr[0] == '\n')
    {
        hdrtmpstr[0] = NULL;
    }
    if(hdrtmpstr[0] == NULL  ||  strchr(hdrtmpstr, '%') == NULL)
    {
        Amustr_obj.trimlead(hdrtmpstr);
        if(hdrtmpstr[0] < 128  &&  hdrtmpstr[0] == '|'  &&  hdrtmpstr[0] == '+'
           &&  hdrtmpstr[0] == '-'  &&  hdrtmpstr[0] != NULL)
        {
            Amustr_obj.center(hdrtmpstr);
        }
        return;
    }
/* */
    strcpy(str, hdrtmpstr);  // Make a copy of the header string
    Amustr_obj.trimlead(str);
    Amustr_obj.trimend(str);
    if(str[0] > 127  ||  str[0] == '|'  ||  str[0] == '+'  ||  str[0] == '-')
    {
        /* If this is a line with a border... */
        Amustr_obj.trimlead(hdrtmpstr);
        Amustr_obj.trimend(hdrtmpstr);
        length = strlen(hdrtmpstr);
        first = hdrtmpstr[0];
        hdrtmpstr[0] = ' ';
        if(str[length-1] > 127  ||  str[length-1] == '|'  ||  str[length-1] == '+'  ||  str[length-1] == '-')
        {
            last = hdrtmpstr[length-1];
            hdrtmpstr[length-1] = ' ';
        }
        else
        {
            /* If there is no border around the right side but there is around
               the left, set last to NULL and look for this later.
            */
            last = NULL;
        }
        _highascii = TRUE;
    }
    else
    {
        /* If this is NOT one with a border */
        _highascii = FALSE;
    }

    str[0] = NULL;
    ptr = hdrtmpstr;
    while(*ptr)
    {
         /* If the current character isn't a '%', copy it to str */
        if(*ptr != '%')
        {
            i = strlen(str);
            str[i] = *ptr;
            str[i+1] = NULL;
            ptr++;
        }
         /* Otherwise, replace it */
        else
        {
            sscanf(ptr, "%[%a-zA-Z#_]", tmp);
            if(stricmp(tmp, "%PRODUCT_ID") == 0)
            {
                strncat(str, Sysinfo_obj.get_version(), sizeof(str) - strlen(str) - 1);
                ptr += 10;
            }
            if(stricmp(tmp, "%SYSOP") == 0)
            {
                strncat(str, amu_cfgvar.sysop, sizeof(str) - strlen(str) - 1);
                ptr += 5;
            }
            if(stricmp(tmp, "%BBS") == 0)
            {
                strncat(str, amu_cfgvar.bbsname, sizeof(str) - strlen(str) - 1);
                ptr += 3;
            }
            if(stricmp(tmp, "%FILES") == 0)
            {
                ltoa(totalfiles, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 5;
            }
            if(stricmp(tmp, "%BYTES") == 0)
            {
                ltoa(totalbytes, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 5;
            }
            if(stricmp(tmp, "%BYTESK") == 0)
            {
                ltoa(totalbytes / 1024, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 6;
            }
            if(stricmp(tmp, "%DLS") == 0)
            {
                ltoa(totaldls, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 3;
            }
            if(stricmp(tmp, "%TOPFILE") == 0)
            {
                strncat(str, topfilename, sizeof(str) - strlen(str) - 1);
                ptr += 7;
            }
            if(stricmp(tmp, "%TOPDLS") == 0)
            {
                ltoa(topfiledls, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 6;
            }
            if(stricmp(tmp, "%TOPSIZEB") == 0)
            {
                ltoa(topfilesize, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 8;
            }
            if(stricmp(tmp, "%TOPSIZEK") == 0)
            {
                ltoa(topfilesize / 1024, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 8;
            }
            if(stricmp(tmp, "%AREA#") == 0)
            {
                ltoa(area, tmp, 10);
                strncat(str, tmp, sizeof(str) - strlen(str) - 1);
                ptr += 5;
            }
            if(stricmp(tmp, "%AREA") == 0)
            {
                strncat(str, Sysinfo_obj.get_fname(), sizeof(str) - strlen(str) - 1);
                ptr += 4;
            }
            if(stricmp(tmp, "%DATE") == 0)
            {
                strncat(str, DateTime_obj.curdate(amu_cfgvar.date_format),
                        sizeof(str) - strlen(str) - 1);
                ptr += 4;
            }
            if(stricmp(tmp, "%TIME") == 0)
            {
                strncat(str, DateTime_obj.curtime(), sizeof(str) - strlen(str) - 1);
                ptr += 4;
            }
            ptr++;
        }
    }
    strncpy(hdrtmpstr, str, sizeof(hdrtmpstr) - 1);
    hdrtmpstr[80] = NULL;
    Amustr_obj.center(hdrtmpstr);
    if(_highascii)
    {
        hdrtmpstr[0] = first;
        if(last)
        {
            hdrtmpstr[length-1] = last;
        }
    }
}

/* EOF Headers.cpp */
